(* Content-type: application/vnd.wolfram.mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 12.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       158,          7]
NotebookDataLength[     29972,        808]
NotebookOptionsPosition[     23044,        662]
NotebookOutlinePosition[     25730,        725]
CellTagsIndexPosition[     25645,        720]
WindowTitle->DecomposeSnProduct
WindowFrame->Normal*)

(* Beginning of Notebook Content *)
Notebook[{
Cell[BoxData[GridBox[{
   {Cell["GROUP MATH SYMBOL", "PacletNameCell",ExpressionUUID->
     "dd3248f1-efbd-42a1-b5c7-436ab4966491"], Cell[TextData[{
     Cell[BoxData[
      ActionMenuBox[
       FrameBox[
        InterpretationBox[Cell[TextData[{
          "Tutorials",
          StyleBox[" \[FilledDownTriangle]", "AnchorBarArrow",
           StripOnInput->False]
         }],ExpressionUUID->"af2f8644-93e4-4076-adc5-88ad42d9c7da"],
         TextCell[
          Row[{"Tutorials", 
            Style[" \[FilledDownTriangle]", "AnchorBarArrow"]}]]],
        StripOnInput->False], {"\<\"GroupMath Tutorial\"\>":>
       Documentation`HelpLookup["paclet:GroupMath/tutorial/GroupMathDoc"]},
       Appearance->None,
       MenuAppearance->Automatic,
       MenuStyle->"Tutorials"]],
      LineSpacing->{1.4, 0},ExpressionUUID->
      "289a05ce-56a8-43aa-b7ed-3b30afad9a9d"],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      ActionMenuBox[
       FrameBox[
        InterpretationBox[Cell[TextData[{
          "See Also",
          StyleBox[" \[FilledDownTriangle]", "AnchorBarArrow",
           StripOnInput->False]
         }],ExpressionUUID->"1a7c0fd5-c3d5-4311-a1cd-80f54b6eddc2"],
         TextCell[
          Row[{"See Also", 
            Style[" \[FilledDownTriangle]", "AnchorBarArrow"]}]]],
        StripOnInput->False], {"\<\"HookContentFormula\"\>":>
       Documentation`HelpLookup[
       "paclet:GroupMath/ref/HookContentFormula"], "\<\"SnClassCharacter\"\>":>
       Documentation`HelpLookup[
       "paclet:GroupMath/ref/SnClassCharacter"], "\<\"SnClassOrder\"\>":>
       Documentation`HelpLookup[
       "paclet:GroupMath/ref/SnClassOrder"], "\<\"SnIrrepDim\"\>":>
       Documentation`HelpLookup[
       "paclet:GroupMath/ref/SnIrrepDim"], "\<\"SnIrrepGenerators\"\>":>
       Documentation`HelpLookup["paclet:GroupMath/ref/SnIrrepGenerators"]},
       Appearance->None,
       MenuAppearance->Automatic,
       MenuStyle->"SeeAlso"]],
      LineSpacing->{1.4, 0},ExpressionUUID->
      "cf93488f-d5bc-47ab-9383-d62fcad4baf3"],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      ActionMenuBox[
       FrameBox[
        InterpretationBox[Cell[TextData[{
          "URL",
          StyleBox[" \[FilledDownTriangle]", "AnchorBarArrow",
           StripOnInput->False]
         }],ExpressionUUID->"e18738b8-8366-4891-a496-b2a7df23794f"],
         TextCell[
          Row[{"URL", 
            Style[" \[FilledDownTriangle]", "AnchorBarArrow"]}]]],
        StripOnInput->False], {"\<\"GroupMath/ref/DecomposeSnProduct\"\>":>
       None, "\<\"Copy Wolfram Documentation Center URL\"\>":>
       Module[{DocumentationSearch`Private`nb$}, 
        DocumentationSearch`Private`nb$ = NotebookPut[
           Notebook[{
             Cell["GroupMath/ref/DecomposeSnProduct"]}, Visible -> False]]; 
        SelectionMove[DocumentationSearch`Private`nb$, All, Notebook]; 
        FrontEndTokenExecute[DocumentationSearch`Private`nb$, "Copy"]; 
        NotebookClose[DocumentationSearch`Private`nb$]; Null], 
       Delimiter, "\<\"Copy web URL\"\>":>
       Module[{DocumentationSearch`Private`nb$}, 
        DocumentationSearch`Private`nb$ = NotebookPut[
           Notebook[{
             Cell[
              BoxData[
               MakeBoxes[
                Hyperlink[
                "http://reference.wolfram.com/language/GroupMath/ref/\
DecomposeSnProduct.html"], StandardForm]], "Input", TextClipboardType -> 
              "PlainText"]}, Visible -> False]]; 
        SelectionMove[DocumentationSearch`Private`nb$, All, Notebook]; 
        FrontEndTokenExecute[DocumentationSearch`Private`nb$, "Copy"]; 
        NotebookClose[DocumentationSearch`Private`nb$]; 
        Null], "\<\"Go to web URL\"\>":>FrontEndExecute[{
         NotebookLocate[{
           URL[
            StringJoin[
             If[
              TrueQ[DocumentationBuild`Make`Private`wsmlinkQ$13932], 
              "http://reference.wolfram.com/system-modeler/", 
              "http://reference.wolfram.com/language/"], 
             "GroupMath/ref/DecomposeSnProduct", ".html"]], None}]}]},
       Appearance->None,
       MenuAppearance->Automatic,
       MenuStyle->"URLMenu"]],
      LineSpacing->{1.4, 0},ExpressionUUID->
      "5eed2702-c89e-4e57-a834-b56e40f67e0e"]
    }], "AnchorBar",ExpressionUUID->"21516eb4-1324-4f5c-9a64-bc0b5b104781"]}
  }]], "AnchorBarGrid",
 CellID->1,ExpressionUUID->"10197eef-7d97-4f4e-98e1-510e16e05e99"],

Cell[CellGroupData[{

Cell[TextData[{
 Cell["DecomposeSnProduct", "ObjectName",ExpressionUUID->
  "30807103-224c-4bb1-9ba5-3894daa3034d"],
 Cell[BoxData[
  TemplateBox[{8},
   "Spacer1"]],ExpressionUUID->"379642c3-959b-4a4c-9168-bdc050cc769e"],
 Cell[BoxData[
 ""], "ObjectNameTranslation",ExpressionUUID->
  "0324fe2d-a526-4cc4-a7d9-5244efc3ce9a"]
}], "ObjectNameGrid",ExpressionUUID->"aa12f2b1-f124-4747-8602-7619742786ab"],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{"DecomposeSnProduct", "[", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"rep1", " ", "of", " ", "Sn"}], " ", ",", 
         RowBox[{"rep2", " ", "of", " ", "Sn"}], " ", ",", " ", "..."}], 
        "}"}], "]"}]], "InlineFormula",ExpressionUUID->
      "ef754b12-468b-4fcf-972b-3a7ee67e0c22"],
     " \[LineSeparator]Decomposes the product of representations of the \
permutation group ",
     Cell[BoxData[
      SubscriptBox["S", "n"]], "InlineFormula",ExpressionUUID->
      "0d6f1b9d-2cd5-4ecd-8f91-6d3994ef9df9"],
     " in irreducible parts"
    }],ExpressionUUID->"0d4b1f3c-77c1-4101-9f33-e087b4f00277"]},
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{"DecomposeSnProduct", "[", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"rep1", " ", "of", " ", "Sn", " ", "x", " ", 
          RowBox[{"Sn", "'"}], " ", "x", " ", 
          RowBox[{"Sn", "''"}]}], ",", 
         RowBox[{"rep2", " ", "of", " ", "Sn", " ", "x", " ", 
          RowBox[{"Sn", "'"}], " ", "x", " ", 
          RowBox[{"Sn", "''"}]}], ",", " ", "..."}], "}"}], "]"}]], 
      "InlineFormula",ExpressionUUID->"1903a604-1f00-4294-bfa1-02116daf1b7d"],
     "\[LineSeparator]Decomposes the product of representations of the \
permutation group ",
     Cell[BoxData[
      RowBox[{
       RowBox[{
        SubscriptBox["S", "n"], "x", " ", 
        SubscriptBox["S", 
         RowBox[{"n", "'"}]], "x", " ", 
        SubscriptBox["S", 
         RowBox[{"n", "''"}]], "x"}], " ", "..."}]], "InlineFormula",
      ExpressionUUID->"8893d632-f5ba-46a1-bfc0-b41b05dc3162"],
     " in irreducible parts"
    }],ExpressionUUID->"096b5c4c-a10e-4aec-b5bc-05e779345123"]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{"Columns" -> {{None}}, "Rows" -> {None, {None}}}},
 CellID->982511436,ExpressionUUID->"14288d50-8f02-438d-a9cf-eb0048bd937e"]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[Cell[TextData[{
   Cell[BoxData[
    TemplateBox[{6},
     "Spacer1"]],ExpressionUUID->"a3a61079-96d2-4d08-956a-41f0d920db09"],
   "Details"
  }], "NotesFrameText",ExpressionUUID->"a5bb23ed-db93-4138-9bfe-794e04e9c77e"],
  Appearance->{Automatic, None, "Normal", Automatic},
  BaseStyle->None,
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"], 
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], After, CellContents]}]& ),
  Evaluator->None,
  Method->
   "Preemptive"]],ExpressionUUID->"39e07ed4-70b1-412e-8004-b4014ab614cf"]], \
"NotesSection",
 WholeCellGroupOpener->True,
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->165518728,ExpressionUUID->"8726a96f-9242-453d-8614-50aec5b471eb"],

Cell["", "SectionHeaderSpacer",ExpressionUUID->"1c6c14c6-22fa-4858-9f8a-b5fd3e4a8904"],

Cell[TextData[{
 "The irreducible representations of the permutation group ",
 Cell[BoxData[
  SubscriptBox["S", "n"]], "InlineFormula",ExpressionUUID->
  "dd63f42a-37e5-4cb1-9103-ea961d80f045"],
 " can be identified with the partitions of the integer number ",
 Cell[BoxData[
 "n"], "InlineFormula",ExpressionUUID->"baa669bb-b116-4f5a-963f-ee399f57b59e"],
 ": they can be computed using ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 "'s built-in function ",
 Cell[BoxData[
  TemplateBox[{Cell[
     TextData["IntegerPartitions"]],"paclet:ref/IntegerPartitions"},
   "RefLink",
   BaseStyle->{"InlineFormula"}]], "InlineFormula",ExpressionUUID->
  "fcbc6727-3616-43b9-93fc-112c9af60e42"],
 "."
}], "Notes",
 CellID->1067943069,ExpressionUUID->"9b5e63c6-673a-4d0a-8d25-132bd4ec8823"],

Cell[TextData[{
 "Therefore, given a list of partitions {",
 Cell[BoxData[
 "\[Lambda]"], "InlineFormula",ExpressionUUID->
  "e5686614-a214-47ad-b37c-f0417ac4eba2"],
 ",",
 Cell[BoxData[
  RowBox[{"\[Lambda]", "'"}]], "InlineFormula",ExpressionUUID->
  "dbdf5dd1-18ac-4929-85e1-fbe4e86f263b"],
 ",...}, ",
 Cell[BoxData[
 "DecomposeSnProduct"], "InlineFormula",ExpressionUUID->
  "65fed809-0b9d-43de-98e9-353ed2b74e68"],
 " will output the irreducible representations of the group ",
 Cell[BoxData[
  SubscriptBox["S", "n"]], "InlineFormula",ExpressionUUID->
  "5b69dc42-2f43-4489-a487-f8d5778aab8a"],
 " (which are partitions of ",
 Cell[BoxData[
 "n"], "InlineFormula",ExpressionUUID->"b317bb59-f5aa-49b3-a02e-a0f3b00ad68c"],
 ") in the product ",
 Cell[BoxData[
 "\[Lambda]"], "InlineFormula",ExpressionUUID->
  "62483045-1a30-4b1b-ae26-6fab741b0bbb"],
 "\[Times]",
 Cell[BoxData[
  RowBox[{"\[Lambda]", "'"}]], "InlineFormula",ExpressionUUID->
  "e7e9c678-3bf2-4544-a235-1b040aa23e0d"],
 "\[Times]\[CenterEllipsis]. The output is a list with elements \
{\[Mu],multiplicity of \[Mu]}."
}], "Notes",
 CellID->259324716,ExpressionUUID->"4e8269c1-7e88-4dad-875c-86aaa4158e4d"],

Cell[TextData[{
 Cell[BoxData[
 "DecomposeSnProduct"], "InlineFormula",ExpressionUUID->
  "ae350567-4b60-4df3-a457-2f7bfce56cf7"],
 " will also work decompose a product of irreducible representations of ",
 Cell[BoxData[
  RowBox[{
   RowBox[{
    SubscriptBox["S", "n"], "x", " ", 
    SubscriptBox["S", 
     RowBox[{"n", "'"}]], "x", " ", 
    SubscriptBox["S", 
     RowBox[{"n", "''"}]], "x"}], " ", "..."}]], "InlineFormula",
  ExpressionUUID->"84fd0862-6e42-4707-8a0e-ed8d293e3b16"],
 ". In this case the input is a list of representations of this group, which \
must be of the form ",
 Cell[BoxData[
  RowBox[{"{", 
   RowBox[{
    RowBox[{"partition", " ", "of", " ", "n"}], ",", " ", 
    RowBox[{"partition", " ", "of", " ", 
     RowBox[{"n", "'"}]}], ",", " ", 
    RowBox[{"partition", " ", "of", " ", 
     RowBox[{"n", "''"}]}], ",", " ", "..."}], "}"}]], "InlineFormula",
  ExpressionUUID->"9b333ff1-b0be-4599-b404-e852ae0a8a05"],
 "."
}], "Notes",
 CellID->91461634,ExpressionUUID->"641e1d79-9f72-4ba7-a92b-a85cdb864b35"],

Cell["", "SectionFooterSpacer",ExpressionUUID->"8b38ca1b-e122-4744-b93f-88c05e89c80f"]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[{
 Cell[BoxData[
  TemplateBox[{6},
   "Spacer1"]],ExpressionUUID->"2ff5cb65-9fa1-4901-8b2d-d22b80e784b0"],
 "Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(2)", "ExampleCount",ExpressionUUID->
  "851d160f-51d9-4af0-a8f7-a6e8d67d0487"]
}], "PrimaryExamplesSection",
 WholeCellGroupOpener->True,
 CellTags->"PrimaryExamplesSection",
 CellID->39291251,ExpressionUUID->"f34e47fd-43d9-4f52-b71f-b33d03d8c0ea"],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(2)", "ExampleCount",ExpressionUUID->
  "2a351581-64de-479b-9b9d-ecf4324fb57a"]
}], "ExampleSection", "ExampleSection",
 WholeCellGroupOpener->True,
 CellID->9732062,ExpressionUUID->"acf5124b-acd4-4e5c-9ef6-d1852d303346"],

Cell[TextData[{
 "Consider ",
 Cell[BoxData[
  SubscriptBox["S", "6"]], "InlineFormula",ExpressionUUID->
  "01add513-becc-4f33-80da-6cb4513e9510"],
 ", the permutation group of 6 elements. Its irreducible representations are \
identified with the partitions of 6:"
}], "ExampleText",
 CellID->32979335,ExpressionUUID->"4277de05-0171-43df-8810-dfab62869f2d"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"IntegerPartitions", "[", "6", "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->474503469,ExpressionUUID->"97d1e1ae-76c1-4bd4-a130-0e22ade4e479"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", "6", "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"5", ",", "1"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"4", ",", "2"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"4", ",", "1", ",", "1"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"3", ",", "3"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"3", ",", "2", ",", "1"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"3", ",", "1", ",", "1", ",", "1"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"2", ",", "2", ",", "2"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"2", ",", "2", ",", "1", ",", "1"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"2", ",", "1", ",", "1", ",", "1", ",", "1"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"1", ",", "1", ",", "1", ",", "1", ",", "1", ",", "1"}], "}"}]}], 
  "}"}]], "Output",
 CellLabel->"Out[1]=",
 CellID->142322846,ExpressionUUID->"d156e5ec-564f-4c47-8f94-4af8351392fe"]
}, Open  ]],

Cell[TextData[{
 "So, there are 11 different irreducible representations of  ",
 Cell[BoxData[
  SubscriptBox["S", "6"]], "InlineFormula",ExpressionUUID->
  "e7e70bf0-ca9f-48e9-8916-8fdaeba8c4e5"],
 ". The product {4, 2}\[Times]{3, 2, 1}\[Times]{3, 2, 1} decomposes as \
follows:"
}], "ExampleText",
 CellID->763521970,ExpressionUUID->"dc435687-6169-4fda-95cf-923f66591927"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"decomposition", "=", 
  RowBox[{"DecomposeSnProduct", "[", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"4", ",", "2"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"3", ",", "2", ",", "1"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"3", ",", "2", ",", "1"}], "}"}]}], "}"}], "]"}]}]], "Input",
 CellLabel->"In[2]:=",
 CellID->280814282,ExpressionUUID->"beb87986-d4d1-4f0d-b793-9ae560bb9f18"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", "6", "}"}], ",", "3"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"5", ",", "1"}], "}"}], ",", "16"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"4", ",", "2"}], "}"}], ",", "29"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"4", ",", "1", ",", "1"}], "}"}], ",", "32"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"3", ",", "3"}], "}"}], ",", "16"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"3", ",", "2", ",", "1"}], "}"}], ",", "51"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"3", ",", "1", ",", "1", ",", "1"}], "}"}], ",", "32"}], "}"}], 
   ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"2", ",", "2", ",", "2"}], "}"}], ",", "16"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"2", ",", "2", ",", "1", ",", "1"}], "}"}], ",", "29"}], "}"}], 
   ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"2", ",", "1", ",", "1", ",", "1", ",", "1"}], "}"}], ",", 
     "16"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"1", ",", "1", ",", "1", ",", "1", ",", "1", ",", "1"}], "}"}], 
     ",", "3"}], "}"}]}], "}"}]], "Output",
 CellLabel->"Out[2]=",
 CellID->16950541,ExpressionUUID->"ad3e6a24-9dbb-4ae6-b8c5-d9af6b8d2051"]
}, Open  ]],

Cell[TextData[{
 "The output states that there are 3 times the {6} irrep in the product; 16 \
times the {5,10}; 29 the {4,2}, and so on. For example, the completely \
anti-symmetric representation of ",
 Cell[BoxData[
  SubscriptBox["S", "6"]], "InlineFormula",ExpressionUUID->
  "3f0edab8-e43f-4f7b-81c4-a5127b8cfcad"],
 ", {1,1,1,1,1,1}, appears 3 times in the product decomposition."
}], "ExampleText",
 CellID->153651282,ExpressionUUID->"61fd51d9-dfb9-432d-b5dd-88bddc9d8152"],

Cell["We can check that the number of components matches:", "ExampleText",
 CellID->25343743,ExpressionUUID->"e35369fe-733a-4866-b5b4-156295710a34"],

Cell[CellGroupData[{

Cell["\<\
SnIrrepDim[{4,2}]SnIrrepDim[{3,2,1}]SnIrrepDim[{3,2,1}]
Total[SnIrrepDim[#[[1]]] #[[2]] & /@ decomposition]\
\>", "Input",
 CellLabel->"In[3]:=",
 CellID->129123507,ExpressionUUID->"cc322fdb-b510-4972-aadd-207f1c4ffe3a"],

Cell[BoxData["2304"], "Output",
 CellLabel->"Out[3]=",
 CellID->47715118,ExpressionUUID->"38889cc7-88d2-44cc-b10f-7f7b933d928e"],

Cell[BoxData["2304"], "Output",
 CellLabel->"Out[3]=",
 CellID->284429425,ExpressionUUID->"6603034a-e01d-47cb-9c24-5754b4648743"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[
  "\t", "ExampleDelimiter",ExpressionUUID->
   "f2e73788-1eb0-44dd-96bb-701478cc5e51"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->342413690,ExpressionUUID->"e8d2e93b-b3be-49ff-ae44-d05d1f7c79b4"],

Cell[TextData[{
 "Consider now the permutation group  ",
 Cell[BoxData[
  RowBox[{
   SubscriptBox["S", "3"], 
   SubscriptBox["xS", "2"]}]], "InlineFormula",ExpressionUUID->
  "10e2257b-33c0-4eaa-bfe7-11d17ebe2a6d"],
 ", which is a subgroup of ",
 Cell[BoxData[
  SubscriptBox["S", "5"]], "InlineFormula",ExpressionUUID->
  "3c7f1b32-fd5f-4a45-9ded-5e57c05db009"],
 ". We may decompose the product {{3},{1,1}} x {{2,1},{1,1}} x {{2,1},{1,1}} \
as follows"
}], "ExampleText",
 CellID->166364087,ExpressionUUID->"5f638f6f-c29a-41aa-987b-72866b3f5512"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"DecomposeSnProduct", "[", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{
      RowBox[{"{", "3", "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"1", ",", "1"}], "}"}]}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"2", ",", "1"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"1", ",", "1"}], "}"}]}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"2", ",", "1"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"1", ",", "1"}], "}"}]}], "}"}]}], "}"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->305351537,ExpressionUUID->"90e21abf-c8fd-4bf5-b14d-ac32279f5117"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", "3", "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"1", ",", "1"}], "}"}]}], "}"}], ",", "1"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"2", ",", "1"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"1", ",", "1"}], "}"}]}], "}"}], ",", "1"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"1", ",", "1", ",", "1"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"1", ",", "1"}], "}"}]}], "}"}], ",", "1"}], "}"}]}], 
  "}"}]], "Output",
 CellLabel->"Out[1]=",
 CellID->798351219,ExpressionUUID->"a79e2bd1-6842-4bbe-b2d5-d18bd04c2529"]
}, Open  ]],

Cell["\<\
The output states that the product breaks down into the irreducible \
representations 1 x {{{3},{1,1}} + 1 x {{2,1},{1,1}} + 1 x {{1,1,1},{1,1}}.\
\>", "ExampleText",
 CellID->93063960,ExpressionUUID->"52e01777-1ab3-49c7-a947-31ef7d5e886b"]
}, Open  ]]
}, Open  ]],

Cell["", "SectionFooterSpacer",ExpressionUUID->"2efd2b6b-bc58-4cd3-8542-fe689df8eee9"]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[{
 Cell[BoxData[
  TemplateBox[{6},
   "Spacer1"]],ExpressionUUID->"f101dc0c-d1eb-41b4-ab80-42934a989fe1"],
 "See Also"
}], "SeeAlsoSection",
 WholeCellGroupOpener->True,
 CellID->1255426704,ExpressionUUID->"d1c9abe0-57ce-4a8a-8fd3-e75f78327b53"],

Cell[TextData[{
 Cell[BoxData[
  TemplateBox[{Cell[
     TextData["HookContentFormula"]],
    "paclet:GroupMath/ref/HookContentFormula"},
   "RefLink",
   BaseStyle->{"InlineFormula", FontFamily -> "Verdana"}]], "InlineFormula",
  ExpressionUUID->"9444e119-bddc-4e77-a29d-8071f4dc5943"],
 "\[NonBreakingSpace]",
 StyleBox["\[MediumSpace]\[FilledVerySmallSquare]\[MediumSpace]", 
  "InlineSeparator"],
 " ",
 Cell[BoxData[
  TemplateBox[{Cell[
     TextData["SnClassCharacter"]],"paclet:GroupMath/ref/SnClassCharacter"},
   "RefLink",
   BaseStyle->{"InlineFormula", FontFamily -> "Verdana"}]], "InlineFormula",
  ExpressionUUID->"16628ecf-e799-459d-bba5-bc4df738d06f"],
 "\[NonBreakingSpace]",
 StyleBox["\[MediumSpace]\[FilledVerySmallSquare]\[MediumSpace]", 
  "InlineSeparator"],
 " ",
 Cell[BoxData[
  TemplateBox[{Cell[
     TextData["SnClassOrder"]],"paclet:GroupMath/ref/SnClassOrder"},
   "RefLink",
   BaseStyle->{"InlineFormula", FontFamily -> "Verdana"}]], "InlineFormula",
  ExpressionUUID->"11cdccb0-87ac-44a9-93a5-e0b21a8f82bb"],
 "\[NonBreakingSpace]",
 StyleBox["\[MediumSpace]\[FilledVerySmallSquare]\[MediumSpace]", 
  "InlineSeparator"],
 " ",
 Cell[BoxData[
  TemplateBox[{Cell[
     TextData["SnIrrepDim"]],"paclet:GroupMath/ref/SnIrrepDim"},
   "RefLink",
   BaseStyle->{"InlineFormula", FontFamily -> "Verdana"}]], "InlineFormula",
  ExpressionUUID->"c745c08f-6c9a-48f6-b9bf-32a6a5f53647"],
 "\[NonBreakingSpace]",
 StyleBox["\[MediumSpace]\[FilledVerySmallSquare]\[MediumSpace]", 
  "InlineSeparator"],
 " ",
 Cell[BoxData[
  TemplateBox[{Cell[
     TextData["SnIrrepGenerators"]],"paclet:GroupMath/ref/SnIrrepGenerators"},
   "RefLink",
   BaseStyle->{"InlineFormula", FontFamily -> "Verdana"}]], "InlineFormula",
  ExpressionUUID->"c39b4ded-9553-4fc3-a2d2-88bf305b3737"]
}], "SeeAlso",
 CellID->929782353,ExpressionUUID->"bbe8542b-4de9-4b37-becf-552a76336e95"]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[{
 Cell[BoxData[
  TemplateBox[{6},
   "Spacer1"]],ExpressionUUID->"eeb275b2-3bf1-47a8-b25e-2e7efaf683d2"],
 "Tutorials"
}], "TutorialsSection",
 WholeCellGroupOpener->True,
 CellID->250839057,ExpressionUUID->"161356e6-cb58-484c-9328-c098b8e30119"],

Cell["", "SectionHeaderSpacer",ExpressionUUID->"d775c938-73f0-4ccd-9e9b-61f403d2924f"],

Cell[BoxData[
 TemplateBox[{Cell[
    TextData["GroupMath Tutorial"]],"paclet:GroupMath/tutorial/GroupMathDoc"},
  "RefLink",
  BaseStyle->"Tutorials"]], "Tutorials",
 CellID->341631938,ExpressionUUID->"9ed2dad7-5213-42ad-bc31-54949f2b298a"]
}, Open  ]],

Cell[" ", "FooterCell",ExpressionUUID->"a7873a30-5730-48e1-b6f7-292504a4159d"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"DecomposeSnProduct",
TaggingRules->{
 "ModificationHighlight" -> False, "ColorType" -> "SymbolColor", "LinkTrails" -> 
  GridBox[{{
      RowBox[{
        ButtonBox[
        "Mathematica", ButtonData -> "paclet:GroupMath/guide/GroupMath", 
         BaseStyle -> {"Link", "DockedLinkTrail"}]}]}}, ColumnAlignments -> 
    Left], "HasOptions" -> False, "ExampleCounter" -> 1, "NeedPlatMsgIn" -> 
  None, "RootCaptions" -> "", 
  "Metadata" -> {
   "built" -> "{2020, 10, 29, 13, 13, 5.9054471}", 
    "history" -> {"1.0", "", "", ""}, "context" -> "GroupMath`", 
    "keywords" -> {}, "specialkeywords" -> {}, 
    "tutorialcollectionlinks" -> {}, "index" -> True, "label" -> 
    "Group Math Symbol", "language" -> "en", "paclet" -> "GroupMath", 
    "status" -> "None", "summary" -> 
    "DecomposeSnProduct[{rep1 of Sn , rep2 of Sn , ...}] Decomposes the \
product of representations of the permutation group Sn in irreducible parts \
DecomposeSnProduct[{rep1 of Sn x Sn' x Sn'', rep2 of Sn x Sn' x Sn'', ...}] \
Decomposes the product of representations of the permutation group Sn x S n' \
x S n'' x ... in irreducible parts", "synonyms" -> {}, "tabletags" -> {}, 
    "title" -> "DecomposeSnProduct", "titlemodifier" -> "", "windowtitle" -> 
    "DecomposeSnProduct", "type" -> "Symbol", "uri" -> 
    "GroupMath/ref/DecomposeSnProduct", "WorkflowDockedCell" -> ""}, 
  "SearchTextTranslated" -> "", "NewStyles" -> False},
CellContext->"Global`",
FrontEndVersion->"12.0 for Microsoft Windows (64-bit) (April 8, 2019)",
StyleDefinitions->Notebook[{
   Cell[
    StyleData[
    StyleDefinitions -> FrontEnd`FileName[{"Wolfram"}, "Reference.nb"]]], 
   Cell[
    StyleData["Input"], CellContext -> "Global`"], 
   Cell[
    StyleData["Output"], CellContext -> "Global`"]}, Visible -> False, 
  TaggingRules -> {"NewStyles" -> False}, FrontEndVersion -> 
  "12.0 for Microsoft Windows (64-bit) (April 8, 2019)", StyleDefinitions -> 
  FrontEnd`FileName[{$RootDirectory, "C:", "Program Files", 
     "Wolfram Research", "Mathematica", "12.0", "AddOns", "Applications"}, 
    "Default_Style_MyVersion9.nb", CharacterEncoding -> "UTF-8"]]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[11611, 301, 434, 11, 35, "PrimaryExamplesSection",ExpressionUUID->"f34e47fd-43d9-4f52-b71f-b33d03d8c0ea",
   CellTags->"PrimaryExamplesSection",
   CellID->39291251]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 25447, 713}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[590, 21, 4548, 101, 53, "AnchorBarGrid",ExpressionUUID->"10197eef-7d97-4f4e-98e1-510e16e05e99",
 CellID->1],
Cell[CellGroupData[{
Cell[5163, 126, 403, 9, 52, "ObjectNameGrid",ExpressionUUID->"aa12f2b1-f124-4747-8602-7619742786ab"],
Cell[5569, 137, 1922, 45, 204, "Usage",ExpressionUUID->"14288d50-8f02-438d-a9cf-eb0048bd937e",
 CellID->982511436]
}, Open  ]],
Cell[CellGroupData[{
Cell[7528, 187, 855, 21, 37, "NotesSection",ExpressionUUID->"8726a96f-9242-453d-8614-50aec5b471eb",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->165518728],
Cell[8386, 210, 86, 0, 70, "SectionHeaderSpacer",ExpressionUUID->"1c6c14c6-22fa-4858-9f8a-b5fd3e4a8904"],
Cell[8475, 212, 789, 20, 70, "Notes",ExpressionUUID->"9b5e63c6-673a-4d0a-8d25-132bd4ec8823",
 CellID->1067943069],
Cell[9267, 234, 1176, 31, 70, "Notes",ExpressionUUID->"4e8269c1-7e88-4dad-875c-86aaa4158e4d",
 CellID->259324716],
Cell[10446, 267, 1039, 27, 70, "Notes",ExpressionUUID->"641e1d79-9f72-4ba7-a92b-a85cdb864b35",
 CellID->91461634],
Cell[11488, 296, 86, 0, 70, "SectionFooterSpacer",ExpressionUUID->"8b38ca1b-e122-4744-b93f-88c05e89c80f"]
}, Closed]],
Cell[CellGroupData[{
Cell[11611, 301, 434, 11, 35, "PrimaryExamplesSection",ExpressionUUID->"f34e47fd-43d9-4f52-b71f-b33d03d8c0ea",
 CellTags->"PrimaryExamplesSection",
 CellID->39291251],
Cell[CellGroupData[{
Cell[12070, 316, 306, 7, 29, "ExampleSection",ExpressionUUID->"acf5124b-acd4-4e5c-9ef6-d1852d303346",
 CellID->9732062],
Cell[12379, 325, 357, 8, 57, "ExampleText",ExpressionUUID->"4277de05-0171-43df-8810-dfab62869f2d",
 CellID->32979335],
Cell[CellGroupData[{
Cell[12761, 337, 168, 3, 26, "Input",ExpressionUUID->"97d1e1ae-76c1-4bd4-a130-0e22ade4e479",
 CellID->474503469],
Cell[12932, 342, 918, 26, 52, "Output",ExpressionUUID->"d156e5ec-564f-4c47-8f94-4af8351392fe",
 CellID->142322846]
}, Open  ]],
Cell[13865, 371, 374, 8, 57, "ExampleText",ExpressionUUID->"dc435687-6169-4fda-95cf-923f66591927",
 CellID->763521970],
Cell[CellGroupData[{
Cell[14264, 383, 442, 12, 26, "Input",ExpressionUUID->"beb87986-d4d1-4f0d-b793-9ae560bb9f18",
 CellID->280814282],
Cell[14709, 397, 1524, 51, 68, "Output",ExpressionUUID->"ad3e6a24-9dbb-4ae6-b8c5-d9af6b8d2051",
 CellID->16950541]
}, Open  ]],
Cell[16248, 451, 480, 9, 76, "ExampleText",ExpressionUUID->"61fd51d9-dfb9-432d-b5dd-88bddc9d8152",
 CellID->153651282],
Cell[16731, 462, 148, 1, 70, "ExampleText",ExpressionUUID->"e35369fe-733a-4866-b5b4-156295710a34",
 CellID->25343743],
Cell[CellGroupData[{
Cell[16904, 467, 230, 5, 70, "Input",ExpressionUUID->"cc322fdb-b510-4972-aadd-207f1c4ffe3a",
 CellID->129123507],
Cell[17137, 474, 128, 2, 35, "Output",ExpressionUUID->"38889cc7-88d2-44cc-b10f-7f7b933d928e",
 CellID->47715118],
Cell[17268, 478, 129, 2, 35, "Output",ExpressionUUID->"6603034a-e01d-47cb-9c24-5754b4648743",
 CellID->284429425]
}, Open  ]],
Cell[CellGroupData[{
Cell[17434, 485, 242, 5, 70, "ExampleDelimiter",ExpressionUUID->"e8d2e93b-b3be-49ff-ae44-d05d1f7c79b4",
 CellID->342413690],
Cell[17679, 492, 550, 14, 70, "ExampleText",ExpressionUUID->"5f638f6f-c29a-41aa-987b-72866b3f5512",
 CellID->166364087],
Cell[CellGroupData[{
Cell[18254, 510, 681, 22, 70, "Input",ExpressionUUID->"90e21abf-c8fd-4bf5-b14d-ac32279f5117",
 CellID->305351537],
Cell[18938, 534, 813, 28, 35, "Output",ExpressionUUID->"a79e2bd1-6842-4bbe-b2d5-d18bd04c2529",
 CellID->798351219]
}, Open  ]],
Cell[19766, 565, 250, 4, 70, "ExampleText",ExpressionUUID->"52e01777-1ab3-49c7-a947-31ef7d5e886b",
 CellID->93063960]
}, Open  ]]
}, Open  ]],
Cell[20043, 573, 86, 0, 70, "SectionFooterSpacer",ExpressionUUID->"2efd2b6b-bc58-4cd3-8542-fe689df8eee9"]
}, Open  ]],
Cell[CellGroupData[{
Cell[20166, 578, 260, 7, 70, "SeeAlsoSection",ExpressionUUID->"d1c9abe0-57ce-4a8a-8fd3-e75f78327b53",
 CellID->1255426704],
Cell[20429, 587, 1886, 49, 70, "SeeAlso",ExpressionUUID->"bbe8542b-4de9-4b37-becf-552a76336e95",
 CellID->929782353]
}, Open  ]],
Cell[CellGroupData[{
Cell[22352, 641, 262, 7, 70, "TutorialsSection",ExpressionUUID->"161356e6-cb58-484c-9328-c098b8e30119",
 CellID->250839057],
Cell[22617, 650, 86, 0, 70, "SectionHeaderSpacer",ExpressionUUID->"d775c938-73f0-4ccd-9e9b-61f403d2924f"],
Cell[22706, 652, 241, 5, 70, "Tutorials",ExpressionUUID->"9ed2dad7-5213-42ad-bc31-54949f2b298a",
 CellID->341631938]
}, Open  ]],
Cell[22962, 660, 78, 0, 70, "FooterCell",ExpressionUUID->"a7873a30-5730-48e1-b6f7-292504a4159d"]
}
]
*)

(* End of internal cache information *)

