(* Content-type: application/vnd.wolfram.mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 12.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       158,          7]
NotebookDataLength[     28107,        732]
NotebookOptionsPosition[     19844,        558]
NotebookOutlinePosition[     22388,        619]
CellTagsIndexPosition[     22303,        614]
WindowTitle->ConvertPartitionToDynkinCoef
WindowFrame->Normal*)

(* Beginning of Notebook Content *)
Notebook[{
Cell[BoxData[GridBox[{
   {Cell["GROUP MATH SYMBOL", "PacletNameCell",ExpressionUUID->
     "f248dde2-ab4a-4c97-be3d-e7aea853b9b4"], Cell[TextData[{
     Cell[BoxData[
      ActionMenuBox[
       FrameBox[
        InterpretationBox[Cell[TextData[{
          "Tutorials",
          StyleBox[" \[FilledDownTriangle]", "AnchorBarArrow",
           StripOnInput->False]
         }],ExpressionUUID->"edbce8b8-4e82-454c-841e-fd0596aed23b"],
         TextCell[
          Row[{"Tutorials", 
            Style[" \[FilledDownTriangle]", "AnchorBarArrow"]}]]],
        StripOnInput->False], {"\<\"GroupMath Tutorial\"\>":>
       Documentation`HelpLookup["paclet:GroupMath/tutorial/GroupMathDoc"]},
       Appearance->None,
       MenuAppearance->Automatic,
       MenuStyle->"Tutorials"]],
      LineSpacing->{1.4, 0},ExpressionUUID->
      "7faad0b3-85e9-40a2-b6f4-abbb85484160"],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      ActionMenuBox[
       FrameBox[
        InterpretationBox[Cell[TextData[{
          "See Also",
          StyleBox[" \[FilledDownTriangle]", "AnchorBarArrow",
           StripOnInput->False]
         }],ExpressionUUID->"68295175-2aa5-424b-a8ea-cd80a37f2898"],
         TextCell[
          Row[{"See Also", 
            Style[" \[FilledDownTriangle]", "AnchorBarArrow"]}]]],
        StripOnInput->False], {"\<\"ConvertToPartitionNotation\"\>":>
       Documentation`HelpLookup[
       "paclet:GroupMath/ref/ConvertToPartitionNotation"]},
       Appearance->None,
       MenuAppearance->Automatic,
       MenuStyle->"SeeAlso"]],
      LineSpacing->{1.4, 0},ExpressionUUID->
      "83c074ef-de79-48af-94ce-a4508e4ac430"],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      ActionMenuBox[
       FrameBox[
        InterpretationBox[Cell[TextData[{
          "URL",
          StyleBox[" \[FilledDownTriangle]", "AnchorBarArrow",
           StripOnInput->False]
         }],ExpressionUUID->"b4559931-ac29-42b6-9b8b-c08ebba37f11"],
         TextCell[
          Row[{"URL", 
            Style[" \[FilledDownTriangle]", "AnchorBarArrow"]}]]],
        StripOnInput->
         False], {"\<\"GroupMath/ref/ConvertPartitionToDynkinCoef\"\>":>
       None, "\<\"Copy Wolfram Documentation Center URL\"\>":>
       Module[{DocumentationSearch`Private`nb$}, 
        DocumentationSearch`Private`nb$ = NotebookPut[
           Notebook[{
             Cell["GroupMath/ref/ConvertPartitionToDynkinCoef"]}, Visible -> 
            False]]; SelectionMove[
         DocumentationSearch`Private`nb$, All, Notebook]; 
        FrontEndTokenExecute[DocumentationSearch`Private`nb$, "Copy"]; 
        NotebookClose[DocumentationSearch`Private`nb$]; Null], 
       Delimiter, "\<\"Copy web URL\"\>":>
       Module[{DocumentationSearch`Private`nb$}, 
        DocumentationSearch`Private`nb$ = NotebookPut[
           Notebook[{
             Cell[
              BoxData[
               MakeBoxes[
                Hyperlink[
                "http://reference.wolfram.com/language/GroupMath/ref/\
ConvertPartitionToDynkinCoef.html"], StandardForm]], "Input", 
              TextClipboardType -> "PlainText"]}, Visible -> False]]; 
        SelectionMove[DocumentationSearch`Private`nb$, All, Notebook]; 
        FrontEndTokenExecute[DocumentationSearch`Private`nb$, "Copy"]; 
        NotebookClose[DocumentationSearch`Private`nb$]; 
        Null], "\<\"Go to web URL\"\>":>FrontEndExecute[{
         NotebookLocate[{
           URL[
            StringJoin[
             If[
              TrueQ[DocumentationBuild`Make`Private`wsmlinkQ$12189], 
              "http://reference.wolfram.com/system-modeler/", 
              "http://reference.wolfram.com/language/"], 
             "GroupMath/ref/ConvertPartitionToDynkinCoef", ".html"]], 
           None}]}]},
       Appearance->None,
       MenuAppearance->Automatic,
       MenuStyle->"URLMenu"]],
      LineSpacing->{1.4, 0},ExpressionUUID->
      "4f4cf7ee-6df2-4d30-b9c6-c0205495308c"]
    }], "AnchorBar",ExpressionUUID->"071f43bd-70f3-4488-b36a-e39861db7e8d"]}
  }]], "AnchorBarGrid",
 CellID->1,ExpressionUUID->"27e89d16-60fd-46af-bbac-88ef7992b1a0"],

Cell[CellGroupData[{

Cell[TextData[{
 Cell["ConvertPartitionToDynkinCoef", "ObjectName",ExpressionUUID->
  "e5e33640-0e91-42e1-838d-a1135bb8c913"],
 Cell[BoxData[
  TemplateBox[{8},
   "Spacer1"]],ExpressionUUID->"94dc4af7-0eb8-4394-940d-f3809a40da3c"],
 Cell[BoxData[
 ""], "ObjectNameTranslation",ExpressionUUID->
  "a7201a01-a4ec-4b16-ad1f-46400a3ae5ab"]
}], "ObjectNameGrid",ExpressionUUID->"f2063844-c3f6-475f-ab9b-571d80b765c3"],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{"ConvertPartitionToDynkinCoef", "[", 
       RowBox[{"n", ",", "partition"}], "]"}]], "InlineFormula",
      ExpressionUUID->"a201610c-46e8-4a7c-8fa1-6e04bbcfc208"],
     " \[LineSeparator]Converts the ",
     Cell[BoxData[
     "partition"], "InlineFormula",ExpressionUUID->
      "8f6380a0-a400-476b-95fd-1d4a5e3b7557"],
     " to the Dynkin coefficients of the SU(",
     Cell[BoxData[
     "n"], "InlineFormula",ExpressionUUID->
      "67591b61-1ecb-47c8-990b-b195c3e42049"],
     ") representation with the same Young diagram"
    }],ExpressionUUID->"1e920646-4c31-47be-a772-1e2f1c3c2c48"]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{"Columns" -> {{None}}, "Rows" -> {{None}}}},
 CellID->982511436,ExpressionUUID->"0749f76c-e1f3-40d1-8d03-0d7f50207aea"]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[Cell[TextData[{
   Cell[BoxData[
    TemplateBox[{6},
     "Spacer1"]],ExpressionUUID->"859d7212-700a-4cbe-abe3-e713a674f4b2"],
   "Details"
  }], "NotesFrameText",ExpressionUUID->"38f0c709-7f36-43e2-9362-a9d4f8fafc44"],
  Appearance->{Automatic, None, "Normal", Automatic},
  BaseStyle->None,
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"], 
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], After, CellContents]}]& ),
  Evaluator->None,
  Method->
   "Preemptive"]],ExpressionUUID->"698af92e-13cc-431c-8799-9b896cb3b749"]], \
"NotesSection",
 WholeCellGroupOpener->True,
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->91197383,ExpressionUUID->"42103e41-d51c-4fc0-8977-c181eafd5246"],

Cell["", "SectionHeaderSpacer",ExpressionUUID->"a374331c-e102-4668-b9e9-97a11b1b45d4"],

Cell[TextData[{
 "If ",
 Cell[BoxData[
 "partition"], "InlineFormula",ExpressionUUID->
  "98640d89-c9a9-45dc-9770-62360615ccc3"],
 "={\[Lambda]1,\[Lambda]2,\[Lambda]3,...,\[Lambda]m}, then its Young diagram \
has m rows, and therefore n cannot be smaller than m, otherwise this function \
returns {}."
}], "Notes",
 CellID->396044797,ExpressionUUID->"d9d680c3-b8fa-4f50-8df4-8a4d0c123bc2"],

Cell[TextData[{
 Cell[BoxData[
  TemplateBox[{Cell[
     TextData["ConvertToPartitionNotation"]],
    "paclet:GroupMath/ref/ConvertToPartitionNotation"},
   "RefLink",
   BaseStyle->{"InlineFormula"}]], "InlineFormula",ExpressionUUID->
  "b470f113-e514-4f64-bd99-2f61fb4d5a08"],
 " does the inverse calculation of ",
 Cell[BoxData[
 "ConvertPartitionToDynkinCoef"], "InlineFormula",ExpressionUUID->
  "62085256-34df-4a76-b9e8-905a2f30e171"],
 ": it converts the Dynkin coefficients of an SU(n) representation into a \
partition."
}], "Notes",
 CellID->1067943069,ExpressionUUID->"7466dd7d-d72b-4175-87bf-ab1717c0716a"],

Cell[TextData[{
 "So ",
 Cell[BoxData[
  RowBox[{"ConvertToPartitionNotation", "[", 
   RowBox[{"ConvertPartitionToDynkinCoef", "[", 
    RowBox[{"n", ",", "partition"}], "]"}], "]"}]], "InlineFormula",
  ExpressionUUID->"daeef807-3fba-4588-848e-b75a062b229a"],
 " = ",
 Cell[BoxData[
 "partition"], "InlineFormula",ExpressionUUID->
  "d0c341d5-a5dc-455b-b9d9-ce8caaf40a24"],
 ", for any sufficiently large n. If ",
 Cell[BoxData[
 "partition"], "InlineFormula",ExpressionUUID->
  "fb9a627d-5177-4d55-9847-59e0c6794673"],
 "={\[Lambda]1,\[Lambda]2,\[Lambda]3,...,\[Lambda]m}, n>=m in all cases, but \
if n=m, then the columns of the Young diagram of  ",
 Cell[BoxData[
 "partition"], "InlineFormula",ExpressionUUID->
  "194de9c5-8878-4e84-9b4e-dc3e422ae763"],
 " with m rows can be crossed out. So the above identity is only valid if n>m."
}], "Notes",
 CellID->711633375,ExpressionUUID->"8f928a43-111d-47ea-85e6-11c1cdacd92d"],

Cell["", "SectionFooterSpacer",ExpressionUUID->"0069fbe5-9542-4ca2-b5e2-7b7172772640"]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[{
 Cell[BoxData[
  TemplateBox[{6},
   "Spacer1"]],ExpressionUUID->"960c0c49-84ae-40a0-8277-e137526b279d"],
 "Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(2)", "ExampleCount",ExpressionUUID->
  "ef1f6f39-b124-4c40-a75f-81b113b51db5"]
}], "PrimaryExamplesSection",
 WholeCellGroupOpener->True,
 CellTags->"PrimaryExamplesSection",
 CellID->266466160,ExpressionUUID->"6f4ffb8a-11cc-41aa-9de9-8509ad1b858b"],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(2)", "ExampleCount",ExpressionUUID->
  "976d457b-0254-4f7d-9668-664c5874d5b7"]
}], "ExampleSection", "ExampleSection",
 WholeCellGroupOpener->True,
 CellID->45951088,ExpressionUUID->"b4c37357-f38f-4066-8310-7a3bf3739e93"],

Cell["\<\
Consider the fundamental/triplet representation of SU(3). It is usually \
represented as a single-box Young diagram, so it is associated to the \
partition {1}:\
\>", "ExampleText",
 CellID->508965647,ExpressionUUID->"2f2fd874-24dd-4acf-b7ae-6f022dffbc75"],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"partition", "=", 
   RowBox[{"{", "1", "}"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{"YoungDiagram", "[", "partition", "]"}]}], "Input",
 CellLabel->"In[1]:=",
 CellID->121974385,ExpressionUUID->"569f97fd-7124-4081-86b1-458decfeb50d"],

Cell[BoxData[
 GraphicsBox[{LineBox[{{0, 0}, {1, 0}}], LineBox[{{0, -1}, {1, -1}}], 
   LineBox[{{0, 0}, {0, -1}}], LineBox[{{1, 0}, {1, -1}}]},
  ImageMargins->0,
  ImagePadding->None,
  ImageSize->20,
  PlotRange->{{0, 1.2}, {-1.2, 0}}]], "Output",
 CellLabel->"Out[1]=",
 CellID->50351503,ExpressionUUID->"072674c1-607f-4143-b412-5ff6e0e4caae"]
}, Open  ]],

Cell["\<\
The Dynkin coefficients associated to the triplet (which are necessary to do \
calculations with it in GroupMath functions), are therefore\
\>", "ExampleText",
 CellID->389364534,ExpressionUUID->"f534b639-20f7-4829-968c-c50ae039b4c2"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ConvertPartitionToDynkinCoef", "[", 
  RowBox[{"3", ",", "partition"}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->197979858,ExpressionUUID->"3f0b05a6-4b52-45d5-b90e-d228ec08db84"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"1", ",", "0"}], "}"}]], "Output",
 CellLabel->"Out[2]=",
 CellID->272878531,ExpressionUUID->"88afdf71-3bd7-4d74-98b0-34e07e8b7c6c"]
}, Open  ]],

Cell["\<\
The anti-triplet of SU(3) is given by two boxes on top of each other:\
\>", "ExampleText",
 CellID->250798557,ExpressionUUID->"dc0bdd79-5438-40a2-8395-156fe01ccb06"],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"partition", "=", 
   RowBox[{"{", 
    RowBox[{"1", ",", "1"}], "}"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{"YoungDiagram", "[", "partition", "]"}], "\[IndentingNewLine]", 
 RowBox[{"ConvertPartitionToDynkinCoef", "[", 
  RowBox[{"3", ",", "partition"}], "]"}]}], "Input",
 CellLabel->"In[3]:=",
 CellID->287314498,ExpressionUUID->"e3847501-a98f-4e6d-a894-5d47b55b8fa4"],

Cell[BoxData[
 GraphicsBox[{LineBox[{{0, 0}, {1, 0}}], LineBox[{{0, -1}, {1, -1}}], 
   LineBox[{{0, -2}, {1, -2}}], LineBox[{{0, 0}, {0, -2}}], 
   LineBox[{{1, 0}, {1, -2}}]},
  ImageMargins->0,
  ImagePadding->None,
  ImageSize->20,
  PlotRange->{{0, 1.2}, {-2.2, 0}}]], "Output",
 CellLabel->"Out[3]=",
 CellID->230203224,ExpressionUUID->"0eaccba1-8647-4c55-998f-4b0e6916d2c5"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"0", ",", "1"}], "}"}]], "Output",
 CellLabel->"Out[3]=",
 CellID->431797382,ExpressionUUID->"4c5a82a0-6408-4137-8111-cea866aad3ce"]
}, Open  ]],

Cell[TextData[{
 Cell[BoxData[
  TemplateBox[{Cell[
     TextData["ConvertToPartitionNotation"]],
    "paclet:GroupMath/ref/ConvertToPartitionNotation"},
   "RefLink",
   BaseStyle->{"InlineFormula"}]], "InlineFormula",ExpressionUUID->
  "b399397c-44b6-4890-b538-ef60d57cd10a"],
 " performs the inverse computation:"
}], "ExampleText",
 CellID->458547945,ExpressionUUID->"c375b70b-b1dc-4d61-8678-1f7216aca488"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ConvertToPartitionNotation", "[", 
  RowBox[{"{", 
   RowBox[{"0", ",", "1"}], "}"}], "]"}]], "Input",
 CellLabel->"In[4]:=",
 CellID->123499176,ExpressionUUID->"c663494b-51c7-4fe5-a7c8-d96c6387e515"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"1", ",", "1"}], "}"}]], "Output",
 CellLabel->"Out[4]=",
 CellID->347281504,ExpressionUUID->"df8b0327-9f2d-48ed-bc28-a6dc12d3ed54"]
}, Open  ]],

Cell["is the same as the partition={1,1} we started with.", "ExampleText",
 CellID->160158747,ExpressionUUID->"fc4e8128-d02c-49b1-8c0c-97e5a6d7719d"],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[
  "\t", "ExampleDelimiter",ExpressionUUID->
   "a326d8eb-6fef-40c2-99a0-df59afebfb2a"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->301562825,ExpressionUUID->"4650ecab-1fd3-48bc-97b4-e3273c6f1b71"],

Cell["Another example:", "ExampleText",
 CellID->164283295,ExpressionUUID->"a8bb6491-0b87-4152-a565-311e5f9ad676"],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"partition", "=", 
   RowBox[{"{", 
    RowBox[{"10", ",", "3", ",", "3", ",", "3", ",", "1"}], "}"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{"YoungDiagram", "[", "partition", "]"}], "\[IndentingNewLine]", 
 RowBox[{"ConvertPartitionToDynkinCoef", "[", 
  RowBox[{"6", ",", "partition"}], "]"}], "\[IndentingNewLine]", 
 RowBox[{"ConvertToPartitionNotation", "[", "%", "]"}]}], "Input",
 CellLabel->"In[1]:=",
 CellID->224462142,ExpressionUUID->"087d7351-72ae-465c-a019-928277493bc0"],

Cell[BoxData[
 GraphicsBox[{LineBox[{{0, 0}, {10, 0}}], LineBox[{{0, -1}, {10, -1}}], 
   LineBox[{{0, -2}, {3, -2}}], LineBox[{{0, -3}, {3, -3}}], 
   LineBox[{{0, -4}, {3, -4}}], LineBox[{{0, -5}, {1, -5}}], 
   LineBox[{{0, 0}, {0, -5}}], LineBox[{{1, 0}, {1, -5}}], 
   LineBox[{{2, 0}, {2, -4}}], LineBox[{{3, 0}, {3, -4}}], 
   LineBox[{{4, 0}, {4, -1}}], LineBox[{{5, 0}, {5, -1}}], 
   LineBox[{{6, 0}, {6, -1}}], LineBox[{{7, 0}, {7, -1}}], 
   LineBox[{{8, 0}, {8, -1}}], LineBox[{{9, 0}, {9, -1}}], 
   LineBox[{{10, 0}, {10, -1}}]},
  ImageMargins->0,
  ImagePadding->None,
  ImageSize->200,
  PlotRange->{{0, 10.2}, {-5.2, 0}}]], "Output",
 CellLabel->"Out[1]=",
 CellID->435503115,ExpressionUUID->"b4281e6d-703e-4be3-8e12-785f3aaf8ad5"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"7", ",", "0", ",", "0", ",", "2", ",", "1"}], "}"}]], "Output",
 CellLabel->"Out[1]=",
 CellID->203443406,ExpressionUUID->"e080966e-5f53-4089-99a7-26031e4eb640"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"10", ",", "3", ",", "3", ",", "3", ",", "1"}], "}"}]], "Output",
 CellLabel->"Out[1]=",
 CellID->723905989,ExpressionUUID->"adaf998d-88f9-465e-83b9-87baeec9a158"]
}, Open  ]],

Cell["\<\
The partition has 5 rows, so if we consider now the group SU(5), the first \
column can be crossed out, so \
ConvertToPartitionNotation[ConvertPartitionToDynkinCoef[5,partition]] is not \
the same as partition:\
\>", "ExampleText",
 CellID->619523943,ExpressionUUID->"1d9dad59-80e4-4156-9b8c-482976eb510d"],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{"ConvertPartitionToDynkinCoef", "[", 
  RowBox[{"5", ",", "partition"}], "]"}], "\[IndentingNewLine]", 
 RowBox[{"partition2", "=", 
  RowBox[{
  "ConvertToPartitionNotation", "[", "%", "]"}]}], "\[IndentingNewLine]", 
 RowBox[{"YoungDiagram", "[", "partition2", "]"}]}], "Input",
 CellLabel->"In[2]:=",
 CellID->144565193,ExpressionUUID->"c01daeee-6df5-41f4-b879-feb122a6db19"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"7", ",", "0", ",", "0", ",", "2"}], "}"}]], "Output",
 CellLabel->"Out[2]=",
 CellID->549471015,ExpressionUUID->"fed24287-6d58-405b-bd8a-4cc42742b586"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"9", ",", "2", ",", "2", ",", "2"}], "}"}]], "Output",
 CellLabel->"Out[2]=",
 CellID->442994926,ExpressionUUID->"d6d62ab2-6acf-49e0-a69b-69b2ecbad690"],

Cell[BoxData[
 GraphicsBox[{LineBox[{{0, 0}, {9, 0}}], LineBox[{{0, -1}, {9, -1}}], 
   LineBox[{{0, -2}, {2, -2}}], LineBox[{{0, -3}, {2, -3}}], 
   LineBox[{{0, -4}, {2, -4}}], LineBox[{{0, 0}, {0, -4}}], 
   LineBox[{{1, 0}, {1, -4}}], LineBox[{{2, 0}, {2, -4}}], 
   LineBox[{{3, 0}, {3, -1}}], LineBox[{{4, 0}, {4, -1}}], 
   LineBox[{{5, 0}, {5, -1}}], LineBox[{{6, 0}, {6, -1}}], 
   LineBox[{{7, 0}, {7, -1}}], LineBox[{{8, 0}, {8, -1}}], 
   LineBox[{{9, 0}, {9, -1}}]},
  ImageMargins->0,
  ImagePadding->None,
  ImageSize->180,
  PlotRange->{{0, 9.2}, {-4.2, 0}}]], "Output",
 CellLabel->"Out[2]=",
 CellID->25308339,ExpressionUUID->"8dc70bd2-4b9f-4698-b537-a9f8154950c8"]
}, Open  ]],

Cell["\<\
If we reduce further the size of the special unitary group, to SU(4) for \
example, then it is impossible to anti-symmetrize the 5 boxes in the first \
column:\
\>", "ExampleText",
 CellID->10335410,ExpressionUUID->"a3ecea56-4300-4772-b6be-62b4e964e0bd"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ConvertPartitionToDynkinCoef", "[", 
  RowBox[{"4", ",", "partition"}], "]"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->11781245,ExpressionUUID->"ccec4c93-114e-4f67-9723-a68a2f8eb1af"],

Cell[BoxData[
 RowBox[{"{", "}"}]], "Output",
 CellLabel->"Out[3]=",
 CellID->50206683,ExpressionUUID->"3b18dee2-8566-47e5-b464-77fdb395bb3d"]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell["", "SectionFooterSpacer",ExpressionUUID->"493996cd-3b11-4873-b45d-541a7a8b1b11"]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[{
 Cell[BoxData[
  TemplateBox[{6},
   "Spacer1"]],ExpressionUUID->"503dcc58-50a6-40e7-a8f6-128304173f9a"],
 "See Also"
}], "SeeAlsoSection",
 WholeCellGroupOpener->True,
 CellID->1255426704,ExpressionUUID->"ed0b8eba-7ec2-4521-a664-09d6e5a68ba2"],

Cell[TextData[Cell[BoxData[
 TemplateBox[{Cell[
    TextData["ConvertToPartitionNotation"]],
   "paclet:GroupMath/ref/ConvertToPartitionNotation"},
  "RefLink",
  BaseStyle->{
   "InlineFormula", FontFamily -> 
    "Verdana"}]], \
"InlineFormula",ExpressionUUID->"a0d61171-0091-4ce2-a317-92dc4d2fc6c6"]], \
"SeeAlso",
 CellID->1038487239,ExpressionUUID->"d37d4fcc-2f4d-4527-b9bb-f15192a0170c"]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[{
 Cell[BoxData[
  TemplateBox[{6},
   "Spacer1"]],ExpressionUUID->"47393dff-dc35-49db-9c4c-1a2fab031c49"],
 "Tutorials"
}], "TutorialsSection",
 WholeCellGroupOpener->True,
 CellID->250839057,ExpressionUUID->"1310f07f-e686-47fb-a0e0-8a4d9fcfbe3a"],

Cell["", "SectionHeaderSpacer",ExpressionUUID->"234d6f96-7963-408f-96c5-00a92feee5c7"],

Cell[BoxData[
 TemplateBox[{Cell[
    TextData["GroupMath Tutorial"]],"paclet:GroupMath/tutorial/GroupMathDoc"},
  "RefLink",
  BaseStyle->"Tutorials"]], "Tutorials",
 CellID->341631938,ExpressionUUID->"26c3ac17-09d4-44a4-bb69-53a82299e33f"]
}, Open  ]],

Cell[" ", "FooterCell",ExpressionUUID->"f9288d6f-7556-42e5-9d27-2d5f789d65d2"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"ConvertPartitionToDynkinCoef",
TaggingRules->{
 "ModificationHighlight" -> False, "ColorType" -> "SymbolColor", "LinkTrails" -> 
  GridBox[{{
      RowBox[{
        ButtonBox[
        "Mathematica", ButtonData -> "paclet:GroupMath/guide/GroupMath", 
         BaseStyle -> {"Link", "DockedLinkTrail"}]}]}}, ColumnAlignments -> 
    Left], "HasOptions" -> False, "ExampleCounter" -> 1, "NeedPlatMsgIn" -> 
  None, "RootCaptions" -> "", 
  "Metadata" -> {
   "built" -> "{2020, 10, 29, 13, 12, 57.4538269}", 
    "history" -> {"1.0", "", "", ""}, "context" -> "GroupMath`", 
    "keywords" -> {}, "specialkeywords" -> {}, 
    "tutorialcollectionlinks" -> {}, "index" -> True, "label" -> 
    "Group Math Symbol", "language" -> "en", "paclet" -> "GroupMath", 
    "status" -> "None", "summary" -> 
    "ConvertPartitionToDynkinCoef[n, partition] Converts the partition to the \
Dynkin coefficients of the SU(n) representation with the same Young diagram", 
    "synonyms" -> {}, "tabletags" -> {}, "title" -> 
    "ConvertPartitionToDynkinCoef", "titlemodifier" -> "", "windowtitle" -> 
    "ConvertPartitionToDynkinCoef", "type" -> "Symbol", "uri" -> 
    "GroupMath/ref/ConvertPartitionToDynkinCoef", "WorkflowDockedCell" -> ""},
   "SearchTextTranslated" -> "", "NewStyles" -> False},
CellContext->"Global`",
FrontEndVersion->"12.0 for Microsoft Windows (64-bit) (April 8, 2019)",
StyleDefinitions->Notebook[{
   Cell[
    StyleData[
    StyleDefinitions -> FrontEnd`FileName[{"Wolfram"}, "Reference.nb"]]], 
   Cell[
    StyleData["Input"], CellContext -> "Global`"], 
   Cell[
    StyleData["Output"], CellContext -> "Global`"]}, Visible -> False, 
  TaggingRules -> {"NewStyles" -> False}, FrontEndVersion -> 
  "12.0 for Microsoft Windows (64-bit) (April 8, 2019)", StyleDefinitions -> 
  FrontEnd`FileName[{$RootDirectory, "C:", "Program Files", 
     "Wolfram Research", "Mathematica", "12.0", "AddOns", "Applications"}, 
    "Default_Style_MyVersion9.nb", CharacterEncoding -> "UTF-8"]]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[9163, 239, 435, 11, 35, "PrimaryExamplesSection",ExpressionUUID->"6f4ffb8a-11cc-41aa-9de9-8509ad1b858b",
   CellTags->"PrimaryExamplesSection",
   CellID->266466160]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 22105, 607}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[600, 21, 4222, 97, 53, "AnchorBarGrid",ExpressionUUID->"27e89d16-60fd-46af-bbac-88ef7992b1a0",
 CellID->1],
Cell[CellGroupData[{
Cell[4847, 122, 413, 9, 52, "ObjectNameGrid",ExpressionUUID->"f2063844-c3f6-475f-ab9b-571d80b765c3"],
Cell[5263, 133, 851, 19, 131, "Usage",ExpressionUUID->"0749f76c-e1f3-40d1-8d03-0d7f50207aea",
 CellID->982511436]
}, Open  ]],
Cell[CellGroupData[{
Cell[6151, 157, 854, 21, 37, "NotesSection",ExpressionUUID->"42103e41-d51c-4fc0-8977-c181eafd5246",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->91197383],
Cell[7008, 180, 86, 0, 70, "SectionHeaderSpacer",ExpressionUUID->"a374331c-e102-4668-b9e9-97a11b1b45d4"],
Cell[7097, 182, 389, 9, 70, "Notes",ExpressionUUID->"d9d680c3-b8fa-4f50-8df4-8a4d0c123bc2",
 CellID->396044797],
Cell[7489, 193, 618, 15, 70, "Notes",ExpressionUUID->"7466dd7d-d72b-4175-87bf-ab1717c0716a",
 CellID->1067943069],
Cell[8110, 210, 927, 22, 70, "Notes",ExpressionUUID->"8f928a43-111d-47ea-85e6-11c1cdacd92d",
 CellID->711633375],
Cell[9040, 234, 86, 0, 70, "SectionFooterSpacer",ExpressionUUID->"0069fbe5-9542-4ca2-b5e2-7b7172772640"]
}, Closed]],
Cell[CellGroupData[{
Cell[9163, 239, 435, 11, 35, "PrimaryExamplesSection",ExpressionUUID->"6f4ffb8a-11cc-41aa-9de9-8509ad1b858b",
 CellTags->"PrimaryExamplesSection",
 CellID->266466160],
Cell[CellGroupData[{
Cell[9623, 254, 307, 7, 29, "ExampleSection",ExpressionUUID->"b4c37357-f38f-4066-8310-7a3bf3739e93",
 CellID->45951088],
Cell[9933, 263, 266, 5, 57, "ExampleText",ExpressionUUID->"2f2fd874-24dd-4acf-b7ae-6f022dffbc75",
 CellID->508965647],
Cell[CellGroupData[{
Cell[10224, 272, 273, 6, 43, "Input",ExpressionUUID->"569f97fd-7124-4081-86b1-458decfeb50d",
 CellID->121974385],
Cell[10500, 280, 347, 8, 41, "Output",ExpressionUUID->"072674c1-607f-4143-b412-5ff6e0e4caae",
 CellID->50351503]
}, Open  ]],
Cell[10862, 291, 244, 4, 57, "ExampleText",ExpressionUUID->"f534b639-20f7-4829-968c-c50ae039b4c2",
 CellID->389364534],
Cell[CellGroupData[{
Cell[11131, 299, 210, 4, 26, "Input",ExpressionUUID->"3f0b05a6-4b52-45d5-b90e-d228ec08db84",
 CellID->197979858],
Cell[11344, 305, 171, 4, 35, "Output",ExpressionUUID->"88afdf71-3bd7-4d74-98b0-34e07e8b7c6c",
 CellID->272878531]
}, Open  ]],
Cell[11530, 312, 175, 3, 38, "ExampleText",ExpressionUUID->"dc0bdd79-5438-40a2-8395-156fe01ccb06",
 CellID->250798557],
Cell[CellGroupData[{
Cell[11730, 319, 411, 9, 59, "Input",ExpressionUUID->"e3847501-a98f-4e6d-a894-5d47b55b8fa4",
 CellID->287314498],
Cell[12144, 330, 381, 9, 58, "Output",ExpressionUUID->"0eaccba1-8647-4c55-998f-4b0e6916d2c5",
 CellID->230203224],
Cell[12528, 341, 171, 4, 35, "Output",ExpressionUUID->"4c5a82a0-6408-4137-8111-cea866aad3ce",
 CellID->431797382]
}, Open  ]],
Cell[12714, 348, 410, 10, 70, "ExampleText",ExpressionUUID->"c375b70b-b1dc-4d61-8678-1f7216aca488",
 CellID->458547945],
Cell[CellGroupData[{
Cell[13149, 362, 224, 5, 70, "Input",ExpressionUUID->"c663494b-51c7-4fe5-a7c8-d96c6387e515",
 CellID->123499176],
Cell[13376, 369, 171, 4, 35, "Output",ExpressionUUID->"df8b0327-9f2d-48ed-bc28-a6dc12d3ed54",
 CellID->347281504]
}, Open  ]],
Cell[13562, 376, 149, 1, 70, "ExampleText",ExpressionUUID->"fc4e8128-d02c-49b1-8c0c-97e5a6d7719d",
 CellID->160158747],
Cell[CellGroupData[{
Cell[13736, 381, 242, 5, 70, "ExampleDelimiter",ExpressionUUID->"4650ecab-1fd3-48bc-97b4-e3273c6f1b71",
 CellID->301562825],
Cell[13981, 388, 114, 1, 70, "ExampleText",ExpressionUUID->"a8bb6491-0b87-4152-a565-311e5f9ad676",
 CellID->164283295],
Cell[CellGroupData[{
Cell[14120, 393, 525, 11, 70, "Input",ExpressionUUID->"087d7351-72ae-465c-a019-928277493bc0",
 CellID->224462142],
Cell[14648, 406, 750, 15, 123, "Output",ExpressionUUID->"b4281e6d-703e-4be3-8e12-785f3aaf8ad5",
 CellID->435503115],
Cell[15401, 423, 201, 4, 35, "Output",ExpressionUUID->"e080966e-5f53-4089-99a7-26031e4eb640",
 CellID->203443406],
Cell[15605, 429, 202, 4, 35, "Output",ExpressionUUID->"adaf998d-88f9-465e-83b9-87baeec9a158",
 CellID->723905989]
}, Open  ]],
Cell[15822, 436, 316, 6, 70, "ExampleText",ExpressionUUID->"1d9dad59-80e4-4156-9b8c-482976eb510d",
 CellID->619523943],
Cell[CellGroupData[{
Cell[16163, 446, 402, 8, 70, "Input",ExpressionUUID->"c01daeee-6df5-41f4-b879-feb122a6db19",
 CellID->144565193],
Cell[16568, 456, 191, 4, 35, "Output",ExpressionUUID->"fed24287-6d58-405b-bd8a-4cc42742b586",
 CellID->549471015],
Cell[16762, 462, 191, 4, 35, "Output",ExpressionUUID->"d6d62ab2-6acf-49e0-a69b-69b2ecbad690",
 CellID->442994926],
Cell[16956, 468, 683, 14, 103, "Output",ExpressionUUID->"8dc70bd2-4b9f-4698-b537-a9f8154950c8",
 CellID->25308339]
}, Open  ]],
Cell[17654, 485, 264, 5, 70, "ExampleText",ExpressionUUID->"a3ecea56-4300-4772-b6be-62b4e964e0bd",
 CellID->10335410],
Cell[CellGroupData[{
Cell[17943, 494, 209, 4, 70, "Input",ExpressionUUID->"ccec4c93-114e-4f67-9723-a68a2f8eb1af",
 CellID->11781245],
Cell[18155, 500, 142, 3, 35, "Output",ExpressionUUID->"3b18dee2-8566-47e5-b464-77fdb395bb3d",
 CellID->50206683]
}, Open  ]]
}, Open  ]]
}, Open  ]],
Cell[18336, 508, 86, 0, 70, "SectionFooterSpacer",ExpressionUUID->"493996cd-3b11-4873-b45d-541a7a8b1b11"]
}, Open  ]],
Cell[CellGroupData[{
Cell[18459, 513, 260, 7, 70, "SeeAlsoSection",ExpressionUUID->"ed0b8eba-7ec2-4521-a664-09d6e5a68ba2",
 CellID->1255426704],
Cell[18722, 522, 393, 10, 70, "SeeAlso",ExpressionUUID->"d37d4fcc-2f4d-4527-b9bb-f15192a0170c",
 CellID->1038487239]
}, Open  ]],
Cell[CellGroupData[{
Cell[19152, 537, 262, 7, 70, "TutorialsSection",ExpressionUUID->"1310f07f-e686-47fb-a0e0-8a4d9fcfbe3a",
 CellID->250839057],
Cell[19417, 546, 86, 0, 70, "SectionHeaderSpacer",ExpressionUUID->"234d6f96-7963-408f-96c5-00a92feee5c7"],
Cell[19506, 548, 241, 5, 70, "Tutorials",ExpressionUUID->"26c3ac17-09d4-44a4-bb69-53a82299e33f",
 CellID->341631938]
}, Open  ]],
Cell[19762, 556, 78, 0, 70, "FooterCell",ExpressionUUID->"f9288d6f-7556-42e5-9d27-2d5f789d65d2"]
}
]
*)

(* End of internal cache information *)

