(* Content-type: application/vnd.wolfram.mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 12.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       158,          7]
NotebookDataLength[     25311,        691]
NotebookOptionsPosition[     17815,        528]
NotebookOutlinePosition[     20243,        588]
CellTagsIndexPosition[     20158,        583]
WindowTitle->ConjugateIrrep
WindowFrame->Normal*)

(* Beginning of Notebook Content *)
Notebook[{
Cell[BoxData[GridBox[{
   {Cell["GROUP MATH SYMBOL", "PacletNameCell",ExpressionUUID->
     "dc70131b-c2b7-4dcd-aa1e-42747b839633"], Cell[TextData[{
     Cell[BoxData[
      ActionMenuBox[
       FrameBox[
        InterpretationBox[Cell[TextData[{
          "Tutorials",
          StyleBox[" \[FilledDownTriangle]", "AnchorBarArrow",
           StripOnInput->False]
         }],ExpressionUUID->"140a079b-58ff-4ef5-a5b1-2539ab33a206"],
         TextCell[
          Row[{"Tutorials", 
            Style[" \[FilledDownTriangle]", "AnchorBarArrow"]}]]],
        StripOnInput->False], {"\<\"GroupMath Tutorial\"\>":>
       Documentation`HelpLookup["paclet:GroupMath/tutorial/GroupMathDoc"]},
       Appearance->None,
       MenuAppearance->Automatic,
       MenuStyle->"Tutorials"]],
      LineSpacing->{1.4, 0},ExpressionUUID->
      "8862a9c8-63bb-44b0-a293-f250c4ca0b2d"],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      ActionMenuBox[
       FrameBox[
        InterpretationBox[Cell[TextData[{
          "See Also",
          StyleBox[" \[FilledDownTriangle]", "AnchorBarArrow",
           StripOnInput->False]
         }],ExpressionUUID->"0c353c8f-a65d-4c4b-85db-ac4f8cc4acfc"],
         TextCell[
          Row[{"See Also", 
            Style[" \[FilledDownTriangle]", "AnchorBarArrow"]}]]],
        StripOnInput->False], {"\<\"CartanMatrix\"\>":>
       Documentation`HelpLookup[
       "paclet:GroupMath/ref/CartanMatrix"], "\<\"TypeOfRepresentation\"\>":>
       Documentation`HelpLookup[
       "paclet:GroupMath/ref/TypeOfRepresentation"], "\<\"RepName\"\>":>
       Documentation`HelpLookup["paclet:GroupMath/ref/RepName"]},
       Appearance->None,
       MenuAppearance->Automatic,
       MenuStyle->"SeeAlso"]],
      LineSpacing->{1.4, 0},ExpressionUUID->
      "fe4e8060-07c8-421e-be5f-f87116c3d57b"],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      ActionMenuBox[
       FrameBox[
        InterpretationBox[Cell[TextData[{
          "URL",
          StyleBox[" \[FilledDownTriangle]", "AnchorBarArrow",
           StripOnInput->False]
         }],ExpressionUUID->"173d8158-866b-49fb-beb6-88b5d77c16e1"],
         TextCell[
          Row[{"URL", 
            Style[" \[FilledDownTriangle]", "AnchorBarArrow"]}]]],
        StripOnInput->False], {"\<\"GroupMath/ref/ConjugateIrrep\"\>":>
       None, "\<\"Copy Wolfram Documentation Center URL\"\>":>
       Module[{DocumentationSearch`Private`nb$}, 
        DocumentationSearch`Private`nb$ = NotebookPut[
           Notebook[{
             Cell["GroupMath/ref/ConjugateIrrep"]}, Visible -> False]]; 
        SelectionMove[DocumentationSearch`Private`nb$, All, Notebook]; 
        FrontEndTokenExecute[DocumentationSearch`Private`nb$, "Copy"]; 
        NotebookClose[DocumentationSearch`Private`nb$]; Null], 
       Delimiter, "\<\"Copy web URL\"\>":>
       Module[{DocumentationSearch`Private`nb$}, 
        DocumentationSearch`Private`nb$ = NotebookPut[
           Notebook[{
             Cell[
              BoxData[
               MakeBoxes[
                Hyperlink[
                "http://reference.wolfram.com/language/GroupMath/ref/\
ConjugateIrrep.html"], StandardForm]], "Input", TextClipboardType -> 
              "PlainText"]}, Visible -> False]]; 
        SelectionMove[DocumentationSearch`Private`nb$, All, Notebook]; 
        FrontEndTokenExecute[DocumentationSearch`Private`nb$, "Copy"]; 
        NotebookClose[DocumentationSearch`Private`nb$]; 
        Null], "\<\"Go to web URL\"\>":>FrontEndExecute[{
         NotebookLocate[{
           URL[
            StringJoin[
             If[
              TrueQ[DocumentationBuild`Make`Private`wsmlinkQ$11657], 
              "http://reference.wolfram.com/system-modeler/", 
              "http://reference.wolfram.com/language/"], 
             "GroupMath/ref/ConjugateIrrep", ".html"]], None}]}]},
       Appearance->None,
       MenuAppearance->Automatic,
       MenuStyle->"URLMenu"]],
      LineSpacing->{1.4, 0},ExpressionUUID->
      "26f392a4-9896-44a0-9a6b-3a02f4487a34"]
    }], "AnchorBar",ExpressionUUID->"204a5418-7c53-4102-b3ed-68654a865daf"]}
  }]], "AnchorBarGrid",
 CellID->1,ExpressionUUID->"4181dff6-c52c-48b3-868f-d30598f86246"],

Cell[CellGroupData[{

Cell[TextData[{
 Cell["ConjugateIrrep", "ObjectName",ExpressionUUID->
  "c97b46bc-d415-4c4d-99f9-a2647f7b7638"],
 Cell[BoxData[
  TemplateBox[{8},
   "Spacer1"]],ExpressionUUID->"4f8442f4-9071-4824-ace3-a3fee721d2a5"],
 Cell[BoxData[
 ""], "ObjectNameTranslation",ExpressionUUID->
  "8a0989e0-95b2-4964-a773-c07a9a0e6963"]
}], "ObjectNameGrid",ExpressionUUID->"d66cf839-5b2e-4597-9873-7c79845ff583"],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{"ConjugateIrrep", "[", 
       RowBox[{"group", ",", "rep"}], "]"}]], "InlineFormula",ExpressionUUID->
      "2e57560d-d017-4936-9f22-e7f610c8a943"],
     " \[LineSeparator]Computes the Dynkin indices of the representation \
conjugate to ",
     Cell[BoxData[
     "rep"], "InlineFormula",ExpressionUUID->
      "98c4359d-fac7-4623-92fb-9210039296bc"]
    }],ExpressionUUID->"4320e7cd-c295-41ba-b5f9-7b2704ff2913"]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{"Columns" -> {{None}}, "Rows" -> {{None}}}},
 CellID->982511436,ExpressionUUID->"33bc8c86-3859-450f-91f7-b9747c6c80e7"]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[Cell[TextData[{
   Cell[BoxData[
    TemplateBox[{6},
     "Spacer1"]],ExpressionUUID->"82efdf94-d18d-4aaf-9e66-79b166e88d45"],
   "Details"
  }], "NotesFrameText",ExpressionUUID->"76106fb5-d95f-4bbd-8252-88a8e6e7c42e"],
  Appearance->{Automatic, None, "Normal", Automatic},
  BaseStyle->None,
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"], 
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], After, CellContents]}]& ),
  Evaluator->None,
  Method->
   "Preemptive"]],ExpressionUUID->"472c0f86-e940-437b-ab11-84324531e892"]], \
"NotesSection",
 WholeCellGroupOpener->True,
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->49587927,ExpressionUUID->"1f6da9d7-fdef-413b-a675-bad0859f942f"],

Cell["", "SectionHeaderSpacer",ExpressionUUID->"4d154c1a-c3c3-4c18-81ab-7fe8a79fa181"],

Cell[TextData[{
 Cell[BoxData[
 "group"], "InlineFormula",ExpressionUUID->
  "be1de5aa-1de1-460e-8190-b972a21eb7d5"],
 " should be a ",
 ButtonBox["Cartan matrix",
  BaseStyle->"Link",
  ButtonData->"paclet:GroupMath/ref/CartanMatrix"],
 " of a simple group. ",
 Cell[BoxData[
 "ConjugateIrrep"], "InlineFormula",ExpressionUUID->
  "f6a6eb1d-c6a2-4fa3-a9f5-3694a5d15004"],
 " also works for semi-simple groups."
}], "Notes",
 CellID->1067943069,ExpressionUUID->"f6358b64-1beb-4b54-9d37-1209907ade73"],

Cell[TextData[{
 Cell[BoxData[
 "rep"], "InlineFormula",ExpressionUUID->
  "f067edc8-f001-4b99-95ac-57fc9901436e"],
 " should be a list of non-negative integers (Dynkin coefficients) for each \
simple group. It is also possible to use the simplified input format for \
representations (see the ",
 ButtonBox["GroupMath tutorial",
  BaseStyle->"Link",
  ButtonData->"paclet:GroupMath/tutorial/GroupMathDoc"],
 " page)."
}], "Notes",
 CellID->460490513,ExpressionUUID->"bddbcf4f-93cf-4089-9b03-aaa0377db7f5"],

Cell["", "SectionFooterSpacer",ExpressionUUID->"a8a0f37c-25ec-4775-b150-a9b245ecce0f"]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[{
 Cell[BoxData[
  TemplateBox[{6},
   "Spacer1"]],ExpressionUUID->"505daea8-cad3-4403-b18a-c4719f9ee696"],
 "Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(4)", "ExampleCount",ExpressionUUID->
  "948b1309-366f-4ccf-94ed-8dcbfb68909d"]
}], "PrimaryExamplesSection",
 WholeCellGroupOpener->True,
 CellTags->"PrimaryExamplesSection",
 CellID->298089322,ExpressionUUID->"e360909e-ef07-4df1-914f-22e65456156a"],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(4)", "ExampleCount",ExpressionUUID->
  "2130700e-4f6a-470e-b70f-0be2207809b7"]
}], "ExampleSection", "ExampleSection",
 WholeCellGroupOpener->True,
 CellID->4398045,ExpressionUUID->"9b00d68d-35ca-48bd-a0c9-c14609686bd6"],

Cell["\<\
Compute the conjugate representation to {1, 0, 2, 0} of the SU(5) group:\
\>", "ExampleText",
 CellID->39218397,ExpressionUUID->"e293becd-ca9d-4d69-99ed-dfb30e72dfca"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ConjugateIrrep", "[", 
  RowBox[{"SU5", ",", 
   RowBox[{"{", 
    RowBox[{"1", ",", "0", ",", "2", ",", "0"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->19417005,ExpressionUUID->"214bc638-4310-4865-802b-a9368a5b678d"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"0", ",", "2", ",", "0", ",", "1"}], "}"}]], "Output",
 CellLabel->"Out[1]=",
 CellID->26810808,ExpressionUUID->"a6649ad5-43e0-414e-a52d-dfc9bf057922"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[
  "\t", "ExampleDelimiter",ExpressionUUID->
   "08b5a079-300b-4583-ad24-377e5d4c967e"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->292157722,ExpressionUUID->"d67c27a0-95ef-4a5a-8f5e-095b15c5fbad"],

Cell["The Dynkin coefficients can be symbolic:", "ExampleText",
 CellID->572805721,ExpressionUUID->"50e1800e-e216-430e-87f0-589177f4280e"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ConjugateIrrep", "[", 
  RowBox[{"SO10", ",", 
   RowBox[{"{", 
    RowBox[{"x1", ",", "x2", ",", "x3", ",", "x4", ",", "x5"}], "}"}]}], 
  "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->294332555,ExpressionUUID->"98416a9c-c582-4a31-bf33-c5cba0c5c68d"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"x1", ",", "x2", ",", "x3", ",", "x5", ",", "x4"}], "}"}]], "Output",
 CellLabel->"Out[1]=",
 CellID->533233048,ExpressionUUID->"b030198a-0905-4ce4-ab56-b029c8491fa2"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[
  "\t", "ExampleDelimiter",ExpressionUUID->
   "f1275db2-0a8d-4abc-a328-9911c0643c78"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->283956642,ExpressionUUID->"4c04cfc2-ef37-4ec1-bbc5-10ff36bda1c6"],

Cell["\<\
The representation {1,0,0,0,1} is real, so {1,0,0,0,1}*={1,0,0,0,1}:\
\>", "ExampleText",
 CellID->226049820,ExpressionUUID->"b4caf02b-5e71-4e59-87f1-8e271d6f7304"],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{"TypeOfRepresentation", "[", 
  RowBox[{"SU5", ",", 
   RowBox[{"{", 
    RowBox[{"1", ",", "0", ",", "0", ",", "1"}], "}"}]}], 
  "]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"ConjugateIrrep", "[", 
   RowBox[{"SU5", ",", 
    RowBox[{"{", 
     RowBox[{"1", ",", "0", ",", "0", ",", "1"}], "}"}]}], "]"}], "==", 
  RowBox[{"{", 
   RowBox[{"1", ",", "0", ",", "0", ",", "1"}], "}"}]}]}], "Input",
 CellLabel->"In[1]:=",
 CellID->371169931,ExpressionUUID->"6d48bfb2-3d9c-4aa6-91d8-3c408faceafc"],

Cell[BoxData["\<\"R\"\>"], "Output",
 CellLabel->"Out[1]=",
 CellID->245723555,ExpressionUUID->"09978d15-f835-4223-8830-0d1cbe58c13f"],

Cell[BoxData["True"], "Output",
 CellLabel->"Out[1]=",
 CellID->207517379,ExpressionUUID->"27fe33b5-1d4b-4a87-b50d-7f8b6bf26533"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[
  "\t", "ExampleDelimiter",ExpressionUUID->
   "15a80f4c-937e-4e1b-823f-c8bcee98417e"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->384787306,ExpressionUUID->"1a63cae5-0318-437c-8c6f-fb8a52745da4"],

Cell["ConjugateIrrep also works for semi-simple groups.", "ExampleText",
 CellID->412374836,ExpressionUUID->"afdcaf1a-cef9-4dee-9114-8605ee2feb63"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ConjugateIrrep", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"SU5", ",", "SU3", ",", "U1"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"1", ",", "0", ",", "2", ",", "0"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"1", ",", "0"}], "}"}], ",", "10"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->348911795,ExpressionUUID->"03b1581b-a2a0-4f4b-be62-34c7b3d0af16"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"0", ",", "2", ",", "0", ",", "1"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0", ",", "1"}], "}"}], ",", 
   RowBox[{"-", "10"}]}], "}"}]], "Output",
 CellLabel->"Out[1]=",
 CellID->329186302,ExpressionUUID->"ca678748-64f1-4c38-96de-9d3f08d3fca2"]
}, Open  ]],

Cell["\<\
ConjugateIrrep accepts the simplified input format for representations, so \
the last line of code is the same as the following one:\
\>", "ExampleText",
 CellID->314819053,ExpressionUUID->"9159be25-8bd9-4a5d-8fd6-f74e1ceb157e"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ConjugateIrrep", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"SU5", ",", "SU3", ",", "U1"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"210", ",", "3", ",", "10"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->384910379,ExpressionUUID->"c702f11d-94a9-4f23-8916-47752844a555"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"0", ",", "2", ",", "0", ",", "1"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0", ",", "1"}], "}"}], ",", 
   RowBox[{"-", "10"}]}], "}"}]], "Output",
 CellLabel->"Out[2]=",
 CellID->492771168,ExpressionUUID->"58c88a55-2a67-4a34-bb43-6345749a7aaf"]
}, Open  ]],

Cell["Using RepName we can verify that the output makes sense:", "ExampleText",
 CellID->162702768,ExpressionUUID->"4ab4e6d1-1083-4c90-b3b0-12e17b400ba7"],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{"RepName", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"SU5", ",", "SU3", ",", "U1"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"210", ",", "3", ",", "10"}], "}"}]}], 
  "]"}], "\[IndentingNewLine]", 
 RowBox[{"RepName", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"SU5", ",", "SU3", ",", "U1"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"0", ",", "2", ",", "0", ",", "1"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0", ",", "1"}], "}"}], ",", 
     RowBox[{"-", "10"}]}], "}"}]}], "]"}]}], "Input",
 CellLabel->"In[3]:=",
 CellID->912405450,ExpressionUUID->"182b01f5-7de6-47b4-b632-04888c006fab"],

Cell[BoxData[
 RowBox[{
  StyleBox["\<\"210\"\>",
   StripOnInput->False,
   FontWeight->Bold], "\[CircleTimes]", 
  StyleBox["\<\"3\"\>",
   StripOnInput->False,
   FontWeight->Bold], 
  "\[CircleTimes]", "\<\"\\!\\(\\*RowBox[{\\\"10\\\"}]\\)\"\>"}]], "Output",
 CellLabel->"Out[3]=",
 CellID->270394163,ExpressionUUID->"f18367b4-52b2-4612-976c-8867f4b33143"],

Cell[BoxData[
 RowBox[{
  OverscriptBox[
   StyleBox["\<\"210\"\>",
    StripOnInput->False,
    FontWeight->Bold], "_"], "\[CircleTimes]", 
  OverscriptBox[
   StyleBox["\<\"3\"\>",
    StripOnInput->False,
    FontWeight->Bold], "_"], 
  "\[CircleTimes]", "\<\"\\!\\(\\*RowBox[{\\\"-\\\", \\\"10\\\"}]\\)\"\>"}]], \
"Output",
 CellLabel->"Out[3]=",
 CellID->169444707,ExpressionUUID->"b4236ceb-1586-475b-a77a-d3a4ec2a1c58"]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell["", "SectionFooterSpacer",ExpressionUUID->"f2fa4146-f0a1-47ef-bebd-cfe28a8ec47a"]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[{
 Cell[BoxData[
  TemplateBox[{6},
   "Spacer1"]],ExpressionUUID->"87af9ba9-1f6a-41a2-9ec6-e742f024af29"],
 "See Also"
}], "SeeAlsoSection",
 WholeCellGroupOpener->True,
 CellID->1255426704,ExpressionUUID->"6db84318-31ca-4ddc-bcc6-7948c5abedeb"],

Cell[TextData[{
 Cell[BoxData[
  TemplateBox[{Cell[
     TextData["CartanMatrix"]],"paclet:GroupMath/ref/CartanMatrix"},
   "RefLink",
   BaseStyle->{"InlineFormula", FontFamily -> "Verdana"}]], "InlineFormula",
  ExpressionUUID->"1350c459-9bbf-4dbd-ac48-290acef325ba"],
 "\[NonBreakingSpace]",
 StyleBox["\[MediumSpace]\[FilledVerySmallSquare]\[MediumSpace]", 
  "InlineSeparator"],
 " ",
 Cell[BoxData[
  TemplateBox[{Cell[
     TextData["TypeOfRepresentation"]],
    "paclet:GroupMath/ref/TypeOfRepresentation"},
   "RefLink",
   BaseStyle->{"InlineFormula", FontFamily -> "Verdana"}]], "InlineFormula",
  ExpressionUUID->"c2938a93-9c11-4601-a3b9-f90fbf7286a3"],
 "\[NonBreakingSpace]",
 StyleBox["\[MediumSpace]\[FilledVerySmallSquare]\[MediumSpace]", 
  "InlineSeparator"],
 " ",
 Cell[BoxData[
  TemplateBox[{Cell[
     TextData["RepName"]],"paclet:GroupMath/ref/RepName"},
   "RefLink",
   BaseStyle->{"InlineFormula", FontFamily -> "Verdana"}]], "InlineFormula",
  ExpressionUUID->"f439f0f3-142c-4f31-a17c-c5bf172214d3"]
}], "SeeAlso",
 CellID->1038487239,ExpressionUUID->"49655636-e876-4583-b805-d91ce806d7de"]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[{
 Cell[BoxData[
  TemplateBox[{6},
   "Spacer1"]],ExpressionUUID->"d81998d4-c967-47bd-8a9b-2b2f203439c7"],
 "Tutorials"
}], "TutorialsSection",
 WholeCellGroupOpener->True,
 CellID->250839057,ExpressionUUID->"0b374cec-173b-49c8-b773-9204df58c63b"],

Cell["", "SectionHeaderSpacer",ExpressionUUID->"dedae063-849b-440a-a1db-40d129f136b3"],

Cell[BoxData[
 TemplateBox[{Cell[
    TextData["GroupMath Tutorial"]],"paclet:GroupMath/tutorial/GroupMathDoc"},
  "RefLink",
  BaseStyle->"Tutorials"]], "Tutorials",
 CellID->341631938,ExpressionUUID->"92aafc64-9c04-4270-a5d9-8cf6b1f9d262"]
}, Open  ]],

Cell[" ", "FooterCell",ExpressionUUID->"2fb3d196-5b7e-47fb-9bd1-21bfc3bf375a"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"ConjugateIrrep",
TaggingRules->{
 "ModificationHighlight" -> False, "ColorType" -> "SymbolColor", "LinkTrails" -> 
  GridBox[{{
      RowBox[{
        ButtonBox[
        "Mathematica", ButtonData -> "paclet:GroupMath/guide/GroupMath", 
         BaseStyle -> {"Link", "DockedLinkTrail"}]}]}}, ColumnAlignments -> 
    Left], "HasOptions" -> False, "ExampleCounter" -> 1, "NeedPlatMsgIn" -> 
  None, "RootCaptions" -> "", 
  "Metadata" -> {
   "built" -> "{2020, 10, 29, 13, 12, 55.1776914}", 
    "history" -> {"1.0", "", "", ""}, "context" -> "GroupMath`", 
    "keywords" -> {}, "specialkeywords" -> {}, 
    "tutorialcollectionlinks" -> {}, "index" -> True, "label" -> 
    "Group Math Symbol", "language" -> "en", "paclet" -> "GroupMath", 
    "status" -> "None", "summary" -> 
    "ConjugateIrrep[group, rep] Computes the Dynkin indices of the \
representation conjugate to rep", "synonyms" -> {}, "tabletags" -> {}, 
    "title" -> "ConjugateIrrep", "titlemodifier" -> "", "windowtitle" -> 
    "ConjugateIrrep", "type" -> "Symbol", "uri" -> 
    "GroupMath/ref/ConjugateIrrep", "WorkflowDockedCell" -> ""}, 
  "SearchTextTranslated" -> "", "NewStyles" -> False},
CellContext->"Global`",
FrontEndVersion->"12.0 for Microsoft Windows (64-bit) (April 8, 2019)",
StyleDefinitions->Notebook[{
   Cell[
    StyleData[
    StyleDefinitions -> FrontEnd`FileName[{"Wolfram"}, "Reference.nb"]]], 
   Cell[
    StyleData["Input"], CellContext -> "Global`"], 
   Cell[
    StyleData["Output"], CellContext -> "Global`"]}, Visible -> False, 
  TaggingRules -> {"NewStyles" -> False}, FrontEndVersion -> 
  "12.0 for Microsoft Windows (64-bit) (April 8, 2019)", StyleDefinitions -> 
  FrontEnd`FileName[{$RootDirectory, "C:", "Program Files", 
     "Wolfram Research", "Mathematica", "12.0", "AddOns", "Applications"}, 
    "Default_Style_MyVersion9.nb", CharacterEncoding -> "UTF-8"]]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[8108, 213, 435, 11, 35, "PrimaryExamplesSection",ExpressionUUID->"e360909e-ef07-4df1-914f-22e65456156a",
   CellTags->"PrimaryExamplesSection",
   CellID->298089322]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 19960, 576}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[586, 21, 4306, 97, 53, "AnchorBarGrid",ExpressionUUID->"4181dff6-c52c-48b3-868f-d30598f86246",
 CellID->1],
Cell[CellGroupData[{
Cell[4917, 122, 399, 9, 52, "ObjectNameGrid",ExpressionUUID->"d66cf839-5b2e-4597-9873-7c79845ff583"],
Cell[5319, 133, 671, 15, 110, "Usage",ExpressionUUID->"33bc8c86-3859-450f-91f7-b9747c6c80e7",
 CellID->982511436]
}, Open  ]],
Cell[CellGroupData[{
Cell[6027, 153, 854, 21, 37, "NotesSection",ExpressionUUID->"1f6da9d7-fdef-413b-a675-bad0859f942f",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->49587927],
Cell[6884, 176, 86, 0, 70, "SectionHeaderSpacer",ExpressionUUID->"4d154c1a-c3c3-4c18-81ab-7fe8a79fa181"],
Cell[6973, 178, 500, 14, 70, "Notes",ExpressionUUID->"f6358b64-1beb-4b54-9d37-1209907ade73",
 CellID->1067943069],
Cell[7476, 194, 506, 12, 70, "Notes",ExpressionUUID->"bddbcf4f-93cf-4089-9b03-aaa0377db7f5",
 CellID->460490513],
Cell[7985, 208, 86, 0, 70, "SectionFooterSpacer",ExpressionUUID->"a8a0f37c-25ec-4775-b150-a9b245ecce0f"]
}, Closed]],
Cell[CellGroupData[{
Cell[8108, 213, 435, 11, 35, "PrimaryExamplesSection",ExpressionUUID->"e360909e-ef07-4df1-914f-22e65456156a",
 CellTags->"PrimaryExamplesSection",
 CellID->298089322],
Cell[CellGroupData[{
Cell[8568, 228, 306, 7, 29, "ExampleSection",ExpressionUUID->"9b00d68d-35ca-48bd-a0c9-c14609686bd6",
 CellID->4398045],
Cell[8877, 237, 177, 3, 38, "ExampleText",ExpressionUUID->"e293becd-ca9d-4d69-99ed-dfb30e72dfca",
 CellID->39218397],
Cell[CellGroupData[{
Cell[9079, 244, 258, 6, 26, "Input",ExpressionUUID->"214bc638-4310-4865-802b-a9368a5b678d",
 CellID->19417005],
Cell[9340, 252, 190, 4, 35, "Output",ExpressionUUID->"a6649ad5-43e0-414e-a52d-dfc9bf057922",
 CellID->26810808]
}, Open  ]],
Cell[CellGroupData[{
Cell[9567, 261, 242, 5, 8, "ExampleDelimiter",ExpressionUUID->"d67c27a0-95ef-4a5a-8f5e-095b15c5fbad",
 CellID->292157722],
Cell[9812, 268, 138, 1, 38, "ExampleText",ExpressionUUID->"50e1800e-e216-430e-87f0-589177f4280e",
 CellID->572805721],
Cell[CellGroupData[{
Cell[9975, 273, 278, 7, 26, "Input",ExpressionUUID->"98416a9c-c582-4a31-bf33-c5cba0c5c68d",
 CellID->294332555],
Cell[10256, 282, 206, 4, 35, "Output",ExpressionUUID->"b030198a-0905-4ce4-ab56-b029c8491fa2",
 CellID->533233048]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[10511, 292, 242, 5, 8, "ExampleDelimiter",ExpressionUUID->"4c04cfc2-ef37-4ec1-bbc5-10ff36bda1c6",
 CellID->283956642],
Cell[10756, 299, 174, 3, 38, "ExampleText",ExpressionUUID->"b4caf02b-5e71-4e59-87f1-8e271d6f7304",
 CellID->226049820],
Cell[CellGroupData[{
Cell[10955, 306, 526, 14, 43, "Input",ExpressionUUID->"6d48bfb2-3d9c-4aa6-91d8-3c408faceafc",
 CellID->371169931],
Cell[11484, 322, 134, 2, 35, "Output",ExpressionUUID->"09978d15-f835-4223-8830-0d1cbe58c13f",
 CellID->245723555],
Cell[11621, 326, 129, 2, 35, "Output",ExpressionUUID->"27fe33b5-1d4b-4a87-b50d-7f8b6bf26533",
 CellID->207517379]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[11799, 334, 242, 5, 8, "ExampleDelimiter",ExpressionUUID->"1a63cae5-0318-437c-8c6f-fb8a52745da4",
 CellID->384787306],
Cell[12044, 341, 147, 1, 38, "ExampleText",ExpressionUUID->"afdcaf1a-cef9-4dee-9114-8605ee2feb63",
 CellID->412374836],
Cell[CellGroupData[{
Cell[12216, 346, 438, 12, 70, "Input",ExpressionUUID->"03b1581b-a2a0-4f4b-be62-34c7b3d0af16",
 CellID->348911795],
Cell[12657, 360, 319, 9, 35, "Output",ExpressionUUID->"ca678748-64f1-4c38-96de-9d3f08d3fca2",
 CellID->329186302]
}, Open  ]],
Cell[12991, 372, 238, 4, 70, "ExampleText",ExpressionUUID->"9159be25-8bd9-4a5d-8fd6-f74e1ceb157e",
 CellID->314819053],
Cell[CellGroupData[{
Cell[13254, 380, 314, 8, 70, "Input",ExpressionUUID->"c702f11d-94a9-4f23-8916-47752844a555",
 CellID->384910379],
Cell[13571, 390, 319, 9, 35, "Output",ExpressionUUID->"58c88a55-2a67-4a34-bb43-6345749a7aaf",
 CellID->492771168]
}, Open  ]],
Cell[13905, 402, 154, 1, 70, "ExampleText",ExpressionUUID->"4ab4e6d1-1083-4c90-b3b0-12e17b400ba7",
 CellID->162702768],
Cell[CellGroupData[{
Cell[14084, 407, 667, 20, 70, "Input",ExpressionUUID->"182b01f5-7de6-47b4-b632-04888c006fab",
 CellID->912405450],
Cell[14754, 429, 360, 10, 35, "Output",ExpressionUUID->"f18367b4-52b2-4612-976c-8867f4b33143",
 CellID->270394163],
Cell[15117, 441, 425, 13, 35, "Output",ExpressionUUID->"b4236ceb-1586-475b-a77a-d3a4ec2a1c58",
 CellID->169444707]
}, Open  ]]
}, Open  ]]
}, Open  ]],
Cell[15581, 459, 86, 0, 70, "SectionFooterSpacer",ExpressionUUID->"f2fa4146-f0a1-47ef-bebd-cfe28a8ec47a"]
}, Open  ]],
Cell[CellGroupData[{
Cell[15704, 464, 260, 7, 70, "SeeAlsoSection",ExpressionUUID->"6db84318-31ca-4ddc-bcc6-7948c5abedeb",
 CellID->1255426704],
Cell[15967, 473, 1119, 29, 70, "SeeAlso",ExpressionUUID->"49655636-e876-4583-b805-d91ce806d7de",
 CellID->1038487239]
}, Open  ]],
Cell[CellGroupData[{
Cell[17123, 507, 262, 7, 70, "TutorialsSection",ExpressionUUID->"0b374cec-173b-49c8-b773-9204df58c63b",
 CellID->250839057],
Cell[17388, 516, 86, 0, 70, "SectionHeaderSpacer",ExpressionUUID->"dedae063-849b-440a-a1db-40d129f136b3"],
Cell[17477, 518, 241, 5, 70, "Tutorials",ExpressionUUID->"92aafc64-9c04-4270-a5d9-8cf6b1f9d262",
 CellID->341631938]
}, Open  ]],
Cell[17733, 526, 78, 0, 70, "FooterCell",ExpressionUUID->"2fb3d196-5b7e-47fb-9bd1-21bfc3bf375a"]
}
]
*)

(* End of internal cache information *)

