(* Content-type: application/vnd.wolfram.mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 12.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       158,          7]
NotebookDataLength[     28650,        788]
NotebookOptionsPosition[     20109,        606]
NotebookOutlinePosition[     22644,        667]
CellTagsIndexPosition[     22559,        662]
WindowTitle->ConjugacyClassGroupModIndices
WindowFrame->Normal*)

(* Beginning of Notebook Content *)
Notebook[{
Cell[BoxData[GridBox[{
   {Cell["GROUP MATH SYMBOL", "PacletNameCell",ExpressionUUID->
     "03cf22fc-d4da-4f8c-91e6-5792f68d52f2"], Cell[TextData[{
     Cell[BoxData[
      ActionMenuBox[
       FrameBox[
        InterpretationBox[Cell[TextData[{
          "Tutorials",
          StyleBox[" \[FilledDownTriangle]", "AnchorBarArrow",
           StripOnInput->False]
         }],ExpressionUUID->"42d24ab0-ba1b-42d4-bda6-f844277d6008"],
         TextCell[
          Row[{"Tutorials", 
            Style[" \[FilledDownTriangle]", "AnchorBarArrow"]}]]],
        StripOnInput->False], {"\<\"GroupMath Tutorial\"\>":>
       Documentation`HelpLookup["paclet:GroupMath/tutorial/GroupMathDoc"]},
       Appearance->None,
       MenuAppearance->Automatic,
       MenuStyle->"Tutorials"]],
      LineSpacing->{1.4, 0},ExpressionUUID->
      "1b8f331a-55c9-419d-8380-a429aa318963"],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      ActionMenuBox[
       FrameBox[
        InterpretationBox[Cell[TextData[{
          "See Also",
          StyleBox[" \[FilledDownTriangle]", "AnchorBarArrow",
           StripOnInput->False]
         }],ExpressionUUID->"10026a31-781e-4168-9ecf-56f972ae80f9"],
         TextCell[
          Row[{"See Also", 
            Style[" \[FilledDownTriangle]", "AnchorBarArrow"]}]]],
        StripOnInput->False], {"\<\"ConjugacyClass\"\>":>
       Documentation`HelpLookup[
       "paclet:GroupMath/ref/ConjugacyClass"], "\<\"CartanMatrix\"\>":>
       Documentation`HelpLookup[
       "paclet:GroupMath/ref/CartanMatrix"], "\<\"ReduceRepProduct\"\>":>
       Documentation`HelpLookup["paclet:GroupMath/ref/ReduceRepProduct"]},
       Appearance->None,
       MenuAppearance->Automatic,
       MenuStyle->"SeeAlso"]],
      LineSpacing->{1.4, 0},ExpressionUUID->
      "402b3495-c0a7-4d81-8ac3-59cb86fff016"],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      ActionMenuBox[
       FrameBox[
        InterpretationBox[Cell[TextData[{
          "URL",
          StyleBox[" \[FilledDownTriangle]", "AnchorBarArrow",
           StripOnInput->False]
         }],ExpressionUUID->"cc1173ca-b8f4-4f51-a394-884ab933e4be"],
         TextCell[
          Row[{"URL", 
            Style[" \[FilledDownTriangle]", "AnchorBarArrow"]}]]],
        StripOnInput->
         False], {"\<\"GroupMath/ref/ConjugacyClassGroupModIndices\"\>":>
       None, "\<\"Copy Wolfram Documentation Center URL\"\>":>
       Module[{DocumentationSearch`Private`nb$}, 
        DocumentationSearch`Private`nb$ = NotebookPut[
           Notebook[{
             Cell["GroupMath/ref/ConjugacyClassGroupModIndices"]}, Visible -> 
            False]]; SelectionMove[
         DocumentationSearch`Private`nb$, All, Notebook]; 
        FrontEndTokenExecute[DocumentationSearch`Private`nb$, "Copy"]; 
        NotebookClose[DocumentationSearch`Private`nb$]; Null], 
       Delimiter, "\<\"Copy web URL\"\>":>
       Module[{DocumentationSearch`Private`nb$}, 
        DocumentationSearch`Private`nb$ = NotebookPut[
           Notebook[{
             Cell[
              BoxData[
               MakeBoxes[
                Hyperlink[
                "http://reference.wolfram.com/language/GroupMath/ref/\
ConjugacyClassGroupModIndices.html"], StandardForm]], "Input", 
              TextClipboardType -> "PlainText"]}, Visible -> False]]; 
        SelectionMove[DocumentationSearch`Private`nb$, All, Notebook]; 
        FrontEndTokenExecute[DocumentationSearch`Private`nb$, "Copy"]; 
        NotebookClose[DocumentationSearch`Private`nb$]; 
        Null], "\<\"Go to web URL\"\>":>FrontEndExecute[{
         NotebookLocate[{
           URL[
            StringJoin[
             If[
              TrueQ[DocumentationBuild`Make`Private`wsmlinkQ$10574], 
              "http://reference.wolfram.com/system-modeler/", 
              "http://reference.wolfram.com/language/"], 
             "GroupMath/ref/ConjugacyClassGroupModIndices", ".html"]], 
           None}]}]},
       Appearance->None,
       MenuAppearance->Automatic,
       MenuStyle->"URLMenu"]],
      LineSpacing->{1.4, 0},ExpressionUUID->
      "873b8f8c-5f71-4a1d-8bbd-ef5400361b4b"]
    }], "AnchorBar",ExpressionUUID->"aae3f3c6-c3ea-4fe4-91ee-0d8c8ab6b849"]}
  }]], "AnchorBarGrid",
 CellID->1,ExpressionUUID->"40d66614-b43b-4715-9f51-e6168d90b84e"],

Cell[CellGroupData[{

Cell[TextData[{
 Cell["ConjugacyClassGroupModIndices", "ObjectName",ExpressionUUID->
  "b0fd5407-c64c-4d6d-9805-4f4c4116c657"],
 Cell[BoxData[
  TemplateBox[{8},
   "Spacer1"]],ExpressionUUID->"93ff5306-3e58-4f82-9017-25326757602c"],
 Cell[BoxData[
 ""], "ObjectNameTranslation",ExpressionUUID->
  "782bc400-58d5-4a2e-b68b-f0c2a7c75a19"]
}], "ObjectNameGrid",ExpressionUUID->"6a0ecbed-f371-4260-a260-dc9ecc41f35d"],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{"ConjugacyClassGroupModIndices", "[", "group", "]"}]], 
      "InlineFormula",ExpressionUUID->"16ec310d-ef10-496f-bc11-33f7e2e3d9fb"],
     " \[LineSeparator]Returns the natural numbers which are need to compare \
conjugacy classes, with modular arithmetics"
    }],ExpressionUUID->"9c31df04-7777-4a31-9c8b-93824c9a200f"]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{"Columns" -> {{None}}, "Rows" -> {{None}}}},
 CellID->982511436,ExpressionUUID->"cc28acc2-5c25-430d-a57b-82539616b785"]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[Cell[TextData[{
   Cell[BoxData[
    TemplateBox[{6},
     "Spacer1"]],ExpressionUUID->"214b80a1-9e05-4877-a6f3-62552466a1c0"],
   "Details"
  }], "NotesFrameText",ExpressionUUID->"2c5f75e8-27b9-4058-8a1b-91e4c504e4c5"],
  Appearance->{Automatic, None, "Normal", Automatic},
  BaseStyle->None,
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"], 
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], After, CellContents]}]& ),
  Evaluator->None,
  Method->
   "Preemptive"]],ExpressionUUID->"35211ed8-7bca-4099-b8df-6a78312dba26"]], \
"NotesSection",
 WholeCellGroupOpener->True,
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->298292925,ExpressionUUID->"7aac0759-ca2c-471f-8961-a326fcef0d88"],

Cell["", "SectionHeaderSpacer",ExpressionUUID->"daf4dd56-e84e-4d8f-be8c-7ab231a885df"],

Cell[TextData[{
 Cell[BoxData[
 "group"], "InlineFormula",ExpressionUUID->
  "93de4a29-3154-4fff-a167-b073683a4ab2"],
 " should a ",
 ButtonBox["Cartan matrix",
  BaseStyle->"Link",
  ButtonData->"paclet:GroupMath/ref/CartanMatrix"],
 ButtonBox[".",
  BaseStyle->"Link",
  ButtonData->"paclet:Susyno/ref/CartanMatrix"]
}], "Notes",
 CellID->1067943069,ExpressionUUID->"e0b1d7aa-5595-48ac-a165-b4548a4b9d85"],

Cell[TextData[{
 "Conjugacy classes are given by a list of one or two natural numbers (see ",
 Cell[BoxData[
  TemplateBox[{Cell[
     TextData["ConjugacyClass"]],"paclet:GroupMath/ref/ConjugacyClass"},
   "RefLink",
   BaseStyle->{"InlineFormula"}]], "InlineFormula",ExpressionUUID->
  "d88d6096-208f-4151-82d4-0f2a722ceae5"],
 "). Nevertheless, to compare classes one must do modular arithmetic: classes \
C1 and C2 are the same if and only if C1 = C2 mod N, where the number(s) N \
is(are) given by ",
 Cell[BoxData[
 "ConjugacyClassGroupModIndices"], "InlineFormula",ExpressionUUID->
  "aec82691-9645-4451-a3d5-c921def56ca3"],
 "."
}], "Notes",
 CellID->66919531,ExpressionUUID->"d1ac8762-71e0-4e5d-81b5-515401356d6e"],

Cell["", "SectionFooterSpacer",ExpressionUUID->"d35d9f8e-6567-42f1-8849-9d8efaac663f"]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[{
 Cell[BoxData[
  TemplateBox[{6},
   "Spacer1"]],ExpressionUUID->"4e25e4f9-0d73-497b-8385-90b53ffe4486"],
 "Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(2)", "ExampleCount",ExpressionUUID->
  "40229253-ea4d-4ffc-8889-a4fc6fc1141b"]
}], "PrimaryExamplesSection",
 WholeCellGroupOpener->True,
 CellTags->"PrimaryExamplesSection",
 CellID->82794787,ExpressionUUID->"f955b453-27fc-496c-bcb6-514b5ac8c4da"],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(2)", "ExampleCount",ExpressionUUID->
  "d4829c12-5931-45cf-8e2a-87138dbfcd76"]
}], "ExampleSection", "ExampleSection",
 WholeCellGroupOpener->True,
 CellID->223659247,ExpressionUUID->"10da511c-afaf-4135-ad3a-885d1b060732"],

Cell["\<\
SU(3) representation can be in on of three classes (the group has a \
'triality' property):\
\>", "ExampleText",
 CellID->14658346,ExpressionUUID->"1ccab025-a268-49b2-8ccc-4d693900ae50"],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{"ConjugacyClass", "[", 
  RowBox[{"SU3", ",", 
   RowBox[{"{", 
    RowBox[{"0", ",", "1"}], "}"}]}], "]"}], "\[IndentingNewLine]", 
 RowBox[{"ConjugacyClass", "[", 
  RowBox[{"SU3", ",", 
   RowBox[{"{", 
    RowBox[{"1", ",", "0"}], "}"}]}], "]"}], "\[IndentingNewLine]", 
 RowBox[{"ConjugacyClass", "[", 
  RowBox[{"SU3", ",", 
   RowBox[{"{", 
    RowBox[{"1", ",", "1"}], "}"}]}], "]"}]}], "Input",
 CellLabel->"In[1]:=",
 CellID->430153659,ExpressionUUID->"f2c45290-622d-4194-a852-28cd8beee700"],

Cell[BoxData[
 RowBox[{"{", "2", "}"}]], "Output",
 CellLabel->"Out[1]=",
 CellID->665334569,ExpressionUUID->"0be26205-db75-48be-bcca-413cd6081775"],

Cell[BoxData[
 RowBox[{"{", "1", "}"}]], "Output",
 CellLabel->"Out[1]=",
 CellID->559229537,ExpressionUUID->"35e7efe0-f9dc-405f-ba28-2e9112ae68ac"],

Cell[BoxData[
 RowBox[{"{", "0", "}"}]], "Output",
 CellLabel->"Out[1]=",
 CellID->20905493,ExpressionUUID->"7ea8a994-d74e-4ef4-bc0b-78c3bb8843ed"]
}, Open  ]],

Cell["\<\
The product of the representations {0,1} x {0,1} x {1,0} is in the class\
\>", "ExampleText",
 CellID->14832221,ExpressionUUID->"c7641fe3-ec9b-480c-946e-f2a88774e903"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"ConjugacyClass", "[", 
   RowBox[{"SU3", ",", 
    RowBox[{"{", 
     RowBox[{"0", ",", "1"}], "}"}]}], "]"}], "+", 
  RowBox[{"ConjugacyClass", "[", 
   RowBox[{"SU3", ",", 
    RowBox[{"{", 
     RowBox[{"0", ",", "1"}], "}"}]}], "]"}], "+", 
  RowBox[{"ConjugacyClass", "[", 
   RowBox[{"SU3", ",", 
    RowBox[{"{", 
     RowBox[{"1", ",", "0"}], "}"}]}], "]"}]}]], "Input",
 CellLabel->"In[2]:=",
 CellID->493228872,ExpressionUUID->"13e44172-b0fa-4b4e-afcd-5647b3d3e0ee"],

Cell[BoxData[
 RowBox[{"{", "5", "}"}]], "Output",
 CellLabel->"Out[2]=",
 CellID->38859239,ExpressionUUID->"26865742-c9b4-418f-85cb-c53412ffcd1a"]
}, Open  ]],

Cell["On the other hand,...", "ExampleText",
 CellID->246113678,ExpressionUUID->"afdd52e4-535b-43f9-82fe-b4032af93be2"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ReduceRepProduct", "[", 
  RowBox[{"SU3", ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"0", ",", "1"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0", ",", "1"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"1", ",", "0"}], "}"}]}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->567799115,ExpressionUUID->"43ea664c-1e54-45a4-8184-3c44bffde8d8"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"1", ",", "2"}], "}"}], ",", "1"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"0", ",", "1"}], "}"}], ",", "2"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"2", ",", "0"}], "}"}], ",", "1"}], "}"}]}], "}"}]], "Output",
 CellLabel->"Out[3]=",
 CellID->55526912,ExpressionUUID->"34b5e320-0284-480a-a7ad-0601ed5483b5"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{"ConjugacyClass", "[", 
  RowBox[{"SU3", ",", 
   RowBox[{"{", 
    RowBox[{"1", ",", "2"}], "}"}]}], "]"}], "\[IndentingNewLine]", 
 RowBox[{"ConjugacyClass", "[", 
  RowBox[{"SU3", ",", 
   RowBox[{"{", 
    RowBox[{"0", ",", "1"}], "}"}]}], "]"}], "\[IndentingNewLine]", 
 RowBox[{"ConjugacyClass", "[", 
  RowBox[{"SU3", ",", 
   RowBox[{"{", 
    RowBox[{"2", ",", "0"}], "}"}]}], "]"}]}], "Input",
 CellLabel->"In[4]:=",
 CellID->446960385,ExpressionUUID->"072aee7f-1c69-4150-8159-338c0c74126c"],

Cell[BoxData[
 RowBox[{"{", "2", "}"}]], "Output",
 CellLabel->"Out[4]=",
 CellID->283646812,ExpressionUUID->"e47d3e33-a95a-442e-a031-15fe215fb71f"],

Cell[BoxData[
 RowBox[{"{", "2", "}"}]], "Output",
 CellLabel->"Out[4]=",
 CellID->136288012,ExpressionUUID->"935ed3c4-10c7-4690-bbbc-130b58ed0160"],

Cell[BoxData[
 RowBox[{"{", "2", "}"}]], "Output",
 CellLabel->"Out[4]=",
 CellID->115667193,ExpressionUUID->"5ea4e6f4-b29e-42b8-b0fd-a661225a983d"]
}, Open  ]],

Cell[TextData[{
 "However, the classes {5} and {2} are the same, mod 3. This number 3 is \
given by ",
 Cell[BoxData[
 "ConjugacyClassGroupModIndices"], "InlineFormula",ExpressionUUID->
  "14a18819-1add-4e35-9673-1c36658ba1c6"],
 ":"
}], "ExampleText",
 CellID->52707123,ExpressionUUID->"7ba472b6-bc35-4773-8a9b-5fa676b23961"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ConjugacyClassGroupModIndices", "[", "SU3", "]"}]], "Input",
 CellLabel->"In[5]:=",
 CellID->108473077,ExpressionUUID->"33ddfac5-efe4-42d3-ba43-e965be15805f"],

Cell[BoxData[
 RowBox[{"{", "3", "}"}]], "Output",
 CellLabel->"Out[5]=",
 CellID->104648334,ExpressionUUID->"602adf04-5979-44e2-b9f7-5ceda263948d"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"ConjugacyClass", "[", 
   RowBox[{"SU3", ",", 
    RowBox[{"{", 
     RowBox[{"1", ",", "2"}], "}"}]}], "]"}], "==", 
  RowBox[{"ConjugacyClass", "[", 
   RowBox[{"SU3", ",", 
    RowBox[{"{", 
     RowBox[{"0", ",", "1"}], "}"}]}], "]"}], "==", 
  RowBox[{"ConjugacyClass", "[", 
   RowBox[{"SU3", ",", 
    RowBox[{"{", 
     RowBox[{"2", ",", "0"}], "}"}]}], "]"}], "==", 
  RowBox[{"Mod", "[", 
   RowBox[{
    RowBox[{
     RowBox[{"ConjugacyClass", "[", 
      RowBox[{"SU3", ",", 
       RowBox[{"{", 
        RowBox[{"0", ",", "1"}], "}"}]}], "]"}], "+", 
     RowBox[{"ConjugacyClass", "[", 
      RowBox[{"SU3", ",", 
       RowBox[{"{", 
        RowBox[{"0", ",", "1"}], "}"}]}], "]"}], "+", 
     RowBox[{"ConjugacyClass", "[", 
      RowBox[{"SU3", ",", 
       RowBox[{"{", 
        RowBox[{"1", ",", "0"}], "}"}]}], "]"}]}], ",", 
    RowBox[{"ConjugacyClassGroupModIndices", "[", "SU3", "]"}]}], 
   "]"}]}]], "Input",
 CellLabel->"In[6]:=",
 CellID->324130005,ExpressionUUID->"145c0203-121c-41bb-9b91-96d00d3f1875"],

Cell[BoxData["True"], "Output",
 CellLabel->"Out[6]=",
 CellID->400119083,ExpressionUUID->"8928957a-68b9-48b7-b9ba-3a78cf717404"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[
  "\t", "ExampleDelimiter",ExpressionUUID->
   "defb065a-1ee3-47d3-b4f2-34606cdf95e4"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->745304506,ExpressionUUID->"565bb694-7691-4ce2-b5d9-8177099b815b"],

Cell[TextData[{
 "The conjugacy classes of SO(2m) groups are identified with two numbers, \
hence ",
 Cell[BoxData[
 "ConjugacyClassGroupModIndices"], "InlineFormula",ExpressionUUID->
  "9b630a5d-2ca7-4b3d-976b-21cfc640a475"],
 " provides two numbers as well:"
}], "ExampleText",
 CellID->534548180,ExpressionUUID->"264f14f7-00d3-4dd0-92a2-5772d280e08f"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ConjugacyClassGroupModIndices", "[", "SO10", "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->11503332,ExpressionUUID->"a5edd4bf-2776-4825-8bcc-90bd5e4a8048"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"2", ",", "4"}], "}"}]], "Output",
 CellLabel->"Out[1]=",
 CellID->205088904,ExpressionUUID->"239b20d0-9ae9-4ef8-a7c4-9af4b5006c32"]
}, Open  ]],

Cell["\<\
So for example, the product of two spinor representations will have a \
conjugacy class\
\>", "ExampleText",
 CellID->7780329,ExpressionUUID->"6ab1c941-3bd8-4669-89ba-ad5da6eeb2db"],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{"2", 
  RowBox[{"ConjugacyClass", "[", 
   RowBox[{"SO10", ",", 
    RowBox[{"{", 
     RowBox[{"0", ",", "0", ",", "0", ",", "0", ",", "1"}], "}"}]}], 
   "]"}]}], "\[IndentingNewLine]", 
 RowBox[{"Mod", "[", 
  RowBox[{"%", ",", 
   RowBox[{"ConjugacyClassGroupModIndices", "[", "SO10", "]"}]}], 
  "]"}]}], "Input",
 CellLabel->"In[2]:=",
 CellID->189479435,ExpressionUUID->"1bf89c75-514f-4087-a212-52ac11999628"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"2", ",", "2"}], "}"}]], "Output",
 CellLabel->"Out[2]=",
 CellID->402051951,ExpressionUUID->"8c356c61-9ef0-4a4e-8d21-6e6c6293eaf9"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"0", ",", "2"}], "}"}]], "Output",
 CellLabel->"Out[2]=",
 CellID->313953897,ExpressionUUID->"18fd2bc1-6a72-4784-ab63-e042fc375f42"]
}, Open  ]],

Cell["\<\
so it cannot contain a singlet since that would require a conjugacy class \
{0,0}:\
\>", "ExampleText",
 CellID->40073819,ExpressionUUID->"b21418db-6c4e-4123-b5fb-26ecf9cd19cd"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ConjugacyClass", "[", 
  RowBox[{"SO10", ",", 
   RowBox[{"{", 
    RowBox[{"0", ",", "0", ",", "0", ",", "0", ",", "0"}], "}"}]}], 
  "]"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->241888989,ExpressionUUID->"741cf9b6-c215-424c-a9d1-695c26c919de"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"0", ",", "0"}], "}"}]], "Output",
 CellLabel->"Out[3]=",
 CellID->379053747,ExpressionUUID->"dace2d63-2e71-4cda-99ed-8af8c6d730d0"]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell["", "SectionFooterSpacer",ExpressionUUID->"2b45a1b9-677c-4bda-aab6-d5ef1d77f981"]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[{
 Cell[BoxData[
  TemplateBox[{6},
   "Spacer1"]],ExpressionUUID->"6d508b7c-819a-4e5f-b2be-045a07363afb"],
 "See Also"
}], "SeeAlsoSection",
 WholeCellGroupOpener->True,
 CellID->1255426704,ExpressionUUID->"5380b191-8d8e-4144-9ca8-5dfd7cdaf5c2"],

Cell[TextData[{
 Cell[BoxData[
  TemplateBox[{Cell[
     TextData["ConjugacyClass"]],"paclet:GroupMath/ref/ConjugacyClass"},
   "RefLink",
   BaseStyle->{"InlineFormula", FontFamily -> "Verdana"}]], "InlineFormula",
  ExpressionUUID->"7330ef2c-5cde-43a9-b0eb-09e25f796c91"],
 "\[NonBreakingSpace]",
 StyleBox["\[MediumSpace]\[FilledVerySmallSquare]\[MediumSpace]", 
  "InlineSeparator"],
 " ",
 Cell[BoxData[
  TemplateBox[{Cell[
     TextData["CartanMatrix"]],"paclet:GroupMath/ref/CartanMatrix"},
   "RefLink",
   BaseStyle->{"InlineFormula", FontFamily -> "Verdana"}]], "InlineFormula",
  ExpressionUUID->"e779edd9-a4c7-46a0-bcd1-15d582bc98f8"],
 "\[NonBreakingSpace]",
 StyleBox["\[MediumSpace]\[FilledVerySmallSquare]\[MediumSpace]", 
  "InlineSeparator"],
 " ",
 Cell[BoxData[
  TemplateBox[{Cell[
     TextData["ReduceRepProduct"]],"paclet:GroupMath/ref/ReduceRepProduct"},
   "RefLink",
   BaseStyle->{"InlineFormula", FontFamily -> "Verdana"}]], "InlineFormula",
  ExpressionUUID->"8be28e6b-331f-4431-ab65-2bd36641be92"]
}], "SeeAlso",
 CellID->1038487239,ExpressionUUID->"63049e8b-66c3-4d85-8efc-cb62a59d2adc"]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[{
 Cell[BoxData[
  TemplateBox[{6},
   "Spacer1"]],ExpressionUUID->"aa10bf31-946a-4251-9efd-8cb18829d625"],
 "Tutorials"
}], "TutorialsSection",
 WholeCellGroupOpener->True,
 CellID->250839057,ExpressionUUID->"2bffa525-31be-4e1c-9a1e-0f396aaab2e9"],

Cell["", "SectionHeaderSpacer",ExpressionUUID->"7d117a27-f6a4-4a2f-afde-d4f0b5d626e9"],

Cell[BoxData[
 TemplateBox[{Cell[
    TextData["GroupMath Tutorial"]],"paclet:GroupMath/tutorial/GroupMathDoc"},
  "RefLink",
  BaseStyle->"Tutorials"]], "Tutorials",
 CellID->341631938,ExpressionUUID->"b4f8a458-25e9-41a1-b3a4-55b0f5dd0624"]
}, Open  ]],

Cell[" ", "FooterCell",ExpressionUUID->"2cc3f215-aa60-415a-a946-b7486cdf6fd4"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"ConjugacyClassGroupModIndices",
TaggingRules->{
 "ModificationHighlight" -> False, "ColorType" -> "SymbolColor", "LinkTrails" -> 
  GridBox[{{
      RowBox[{
        ButtonBox[
        "Mathematica", ButtonData -> "paclet:GroupMath/guide/GroupMath", 
         BaseStyle -> {"Link", "DockedLinkTrail"}]}]}}, ColumnAlignments -> 
    Left], "HasOptions" -> False, "ExampleCounter" -> 1, "NeedPlatMsgIn" -> 
  None, "RootCaptions" -> "", 
  "Metadata" -> {
   "built" -> "{2020, 10, 29, 13, 12, 50.0717618}", 
    "history" -> {"1.0", "", "", ""}, "context" -> "GroupMath`", 
    "keywords" -> {}, "specialkeywords" -> {}, 
    "tutorialcollectionlinks" -> {}, "index" -> True, "label" -> 
    "Group Math Symbol", "language" -> "en", "paclet" -> "GroupMath", 
    "status" -> "None", "summary" -> 
    "ConjugacyClassGroupModIndices[group] Returns the natural numbers which \
are need to compare conjugacy classes, with modular arithmetics", 
    "synonyms" -> {}, "tabletags" -> {}, "title" -> 
    "ConjugacyClassGroupModIndices", "titlemodifier" -> "", "windowtitle" -> 
    "ConjugacyClassGroupModIndices", "type" -> "Symbol", "uri" -> 
    "GroupMath/ref/ConjugacyClassGroupModIndices", "WorkflowDockedCell" -> 
    ""}, "SearchTextTranslated" -> "", "NewStyles" -> False},
CellContext->"Global`",
FrontEndVersion->"12.0 for Microsoft Windows (64-bit) (April 8, 2019)",
StyleDefinitions->Notebook[{
   Cell[
    StyleData[
    StyleDefinitions -> FrontEnd`FileName[{"Wolfram"}, "Reference.nb"]]], 
   Cell[
    StyleData["Input"], CellContext -> "Global`"], 
   Cell[
    StyleData["Output"], CellContext -> "Global`"]}, Visible -> False, 
  TaggingRules -> {"NewStyles" -> False}, FrontEndVersion -> 
  "12.0 for Microsoft Windows (64-bit) (April 8, 2019)", StyleDefinitions -> 
  FrontEnd`FileName[{$RootDirectory, "C:", "Program Files", 
     "Wolfram Research", "Mathematica", "12.0", "AddOns", "Applications"}, 
    "Default_Style_MyVersion9.nb", CharacterEncoding -> "UTF-8"]]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[8271, 214, 434, 11, 35, "PrimaryExamplesSection",ExpressionUUID->"f955b453-27fc-496c-bcb6-514b5ac8c4da",
   CellTags->"PrimaryExamplesSection",
   CellID->82794787]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 22362, 655}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[601, 21, 4408, 100, 53, "AnchorBarGrid",ExpressionUUID->"40d66614-b43b-4715-9f51-e6168d90b84e",
 CellID->1],
Cell[CellGroupData[{
Cell[5034, 125, 414, 9, 52, "ObjectNameGrid",ExpressionUUID->"6a0ecbed-f371-4260-a260-dc9ecc41f35d"],
Cell[5451, 136, 578, 11, 110, "Usage",ExpressionUUID->"cc28acc2-5c25-430d-a57b-82539616b785",
 CellID->982511436]
}, Open  ]],
Cell[CellGroupData[{
Cell[6066, 152, 855, 21, 37, "NotesSection",ExpressionUUID->"7aac0759-ca2c-471f-8961-a326fcef0d88",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->298292925],
Cell[6924, 175, 86, 0, 70, "SectionHeaderSpacer",ExpressionUUID->"daf4dd56-e84e-4d8f-be8c-7ab231a885df"],
Cell[7013, 177, 407, 12, 70, "Notes",ExpressionUUID->"e0b1d7aa-5595-48ac-a165-b4548a4b9d85",
 CellID->1067943069],
Cell[7423, 191, 722, 16, 70, "Notes",ExpressionUUID->"d1ac8762-71e0-4e5d-81b5-515401356d6e",
 CellID->66919531],
Cell[8148, 209, 86, 0, 70, "SectionFooterSpacer",ExpressionUUID->"d35d9f8e-6567-42f1-8849-9d8efaac663f"]
}, Closed]],
Cell[CellGroupData[{
Cell[8271, 214, 434, 11, 35, "PrimaryExamplesSection",ExpressionUUID->"f955b453-27fc-496c-bcb6-514b5ac8c4da",
 CellTags->"PrimaryExamplesSection",
 CellID->82794787],
Cell[CellGroupData[{
Cell[8730, 229, 308, 7, 29, "ExampleSection",ExpressionUUID->"10da511c-afaf-4135-ad3a-885d1b060732",
 CellID->223659247],
Cell[9041, 238, 196, 4, 38, "ExampleText",ExpressionUUID->"1ccab025-a268-49b2-8ccc-4d693900ae50",
 CellID->14658346],
Cell[CellGroupData[{
Cell[9262, 246, 525, 14, 59, "Input",ExpressionUUID->"f2c45290-622d-4194-a852-28cd8beee700",
 CellID->430153659],
Cell[9790, 262, 148, 3, 35, "Output",ExpressionUUID->"0be26205-db75-48be-bcca-413cd6081775",
 CellID->665334569],
Cell[9941, 267, 148, 3, 35, "Output",ExpressionUUID->"35e7efe0-f9dc-405f-ba28-2e9112ae68ac",
 CellID->559229537],
Cell[10092, 272, 147, 3, 35, "Output",ExpressionUUID->"7ea8a994-d74e-4ef4-bc0b-78c3bb8843ed",
 CellID->20905493]
}, Open  ]],
Cell[10254, 278, 177, 3, 38, "ExampleText",ExpressionUUID->"c7641fe3-ec9b-480c-946e-f2a88774e903",
 CellID->14832221],
Cell[CellGroupData[{
Cell[10456, 285, 511, 15, 26, "Input",ExpressionUUID->"13e44172-b0fa-4b4e-afcd-5647b3d3e0ee",
 CellID->493228872],
Cell[10970, 302, 147, 3, 35, "Output",ExpressionUUID->"26865742-c9b4-418f-85cb-c53412ffcd1a",
 CellID->38859239]
}, Open  ]],
Cell[11132, 308, 119, 1, 38, "ExampleText",ExpressionUUID->"afdd52e4-535b-43f9-82fe-b4032af93be2",
 CellID->246113678],
Cell[CellGroupData[{
Cell[11276, 313, 410, 12, 26, "Input",ExpressionUUID->"43ea664c-1e54-45a4-8184-3c44bffde8d8",
 CellID->567799115],
Cell[11689, 327, 486, 16, 35, "Output",ExpressionUUID->"34b5e320-0284-480a-a7ad-0601ed5483b5",
 CellID->55526912]
}, Open  ]],
Cell[CellGroupData[{
Cell[12212, 348, 525, 14, 59, "Input",ExpressionUUID->"072aee7f-1c69-4150-8159-338c0c74126c",
 CellID->446960385],
Cell[12740, 364, 148, 3, 35, "Output",ExpressionUUID->"e47d3e33-a95a-442e-a031-15fe215fb71f",
 CellID->283646812],
Cell[12891, 369, 148, 3, 35, "Output",ExpressionUUID->"935ed3c4-10c7-4690-bbbc-130b58ed0160",
 CellID->136288012],
Cell[13042, 374, 148, 3, 35, "Output",ExpressionUUID->"5ea4e6f4-b29e-42b8-b0fd-a661225a983d",
 CellID->115667193]
}, Open  ]],
Cell[13205, 380, 326, 8, 70, "ExampleText",ExpressionUUID->"7ba472b6-bc35-4773-8a9b-5fa676b23961",
 CellID->52707123],
Cell[CellGroupData[{
Cell[13556, 392, 182, 3, 70, "Input",ExpressionUUID->"33ddfac5-efe4-42d3-ba43-e965be15805f",
 CellID->108473077],
Cell[13741, 397, 148, 3, 35, "Output",ExpressionUUID->"602adf04-5979-44e2-b9f7-5ceda263948d",
 CellID->104648334]
}, Open  ]],
Cell[CellGroupData[{
Cell[13926, 405, 1067, 32, 70, "Input",ExpressionUUID->"145c0203-121c-41bb-9b91-96d00d3f1875",
 CellID->324130005],
Cell[14996, 439, 129, 2, 35, "Output",ExpressionUUID->"8928957a-68b9-48b7-b9ba-3a78cf717404",
 CellID->400119083]
}, Open  ]],
Cell[CellGroupData[{
Cell[15162, 446, 242, 5, 70, "ExampleDelimiter",ExpressionUUID->"565bb694-7691-4ce2-b5d9-8177099b815b",
 CellID->745304506],
Cell[15407, 453, 354, 8, 70, "ExampleText",ExpressionUUID->"264f14f7-00d3-4dd0-92a2-5772d280e08f",
 CellID->534548180],
Cell[CellGroupData[{
Cell[15786, 465, 182, 3, 70, "Input",ExpressionUUID->"a5edd4bf-2776-4825-8bcc-90bd5e4a8048",
 CellID->11503332],
Cell[15971, 470, 171, 4, 35, "Output",ExpressionUUID->"239b20d0-9ae9-4ef8-a7c4-9af4b5006c32",
 CellID->205088904]
}, Open  ]],
Cell[16157, 477, 191, 4, 70, "ExampleText",ExpressionUUID->"6ab1c941-3bd8-4669-89ba-ad5da6eeb2db",
 CellID->7780329],
Cell[CellGroupData[{
Cell[16373, 485, 440, 12, 70, "Input",ExpressionUUID->"1bf89c75-514f-4087-a212-52ac11999628",
 CellID->189479435],
Cell[16816, 499, 171, 4, 35, "Output",ExpressionUUID->"8c356c61-9ef0-4a4e-8d21-6e6c6293eaf9",
 CellID->402051951],
Cell[16990, 505, 171, 4, 35, "Output",ExpressionUUID->"18fd2bc1-6a72-4784-ab63-e042fc375f42",
 CellID->313953897]
}, Open  ]],
Cell[17176, 512, 187, 4, 70, "ExampleText",ExpressionUUID->"b21418db-6c4e-4123-b5fb-26ecf9cd19cd",
 CellID->40073819],
Cell[CellGroupData[{
Cell[17388, 520, 273, 7, 70, "Input",ExpressionUUID->"741cf9b6-c215-424c-a9d1-695c26c919de",
 CellID->241888989],
Cell[17664, 529, 171, 4, 35, "Output",ExpressionUUID->"dace2d63-2e71-4cda-99ed-8af8c6d730d0",
 CellID->379053747]
}, Open  ]]
}, Open  ]]
}, Open  ]],
Cell[17874, 538, 86, 0, 70, "SectionFooterSpacer",ExpressionUUID->"2b45a1b9-677c-4bda-aab6-d5ef1d77f981"]
}, Open  ]],
Cell[CellGroupData[{
Cell[17997, 543, 260, 7, 70, "SeeAlsoSection",ExpressionUUID->"5380b191-8d8e-4144-9ca8-5dfd7cdaf5c2",
 CellID->1255426704],
Cell[18260, 552, 1120, 28, 70, "SeeAlso",ExpressionUUID->"63049e8b-66c3-4d85-8efc-cb62a59d2adc",
 CellID->1038487239]
}, Open  ]],
Cell[CellGroupData[{
Cell[19417, 585, 262, 7, 70, "TutorialsSection",ExpressionUUID->"2bffa525-31be-4e1c-9a1e-0f396aaab2e9",
 CellID->250839057],
Cell[19682, 594, 86, 0, 70, "SectionHeaderSpacer",ExpressionUUID->"7d117a27-f6a4-4a2f-afde-d4f0b5d626e9"],
Cell[19771, 596, 241, 5, 70, "Tutorials",ExpressionUUID->"b4f8a458-25e9-41a1-b3a4-55b0f5dd0624",
 CellID->341631938]
}, Open  ]],
Cell[20027, 604, 78, 0, 70, "FooterCell",ExpressionUUID->"2cc3f215-aa60-415a-a946-b7486cdf6fd4"]
}
]
*)

(* End of internal cache information *)

