(* Content-type: application/vnd.wolfram.mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 12.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       158,          7]
NotebookDataLength[     25608,        694]
NotebookOptionsPosition[     18081,        533]
NotebookOutlinePosition[     20522,        593]
CellTagsIndexPosition[     20437,        588]
WindowTitle->ConjugacyClass
WindowFrame->Normal*)

(* Beginning of Notebook Content *)
Notebook[{
Cell[BoxData[GridBox[{
   {Cell["GROUP MATH SYMBOL", "PacletNameCell",ExpressionUUID->
     "17b162dd-5264-4276-af25-05e944b0af26"], Cell[TextData[{
     Cell[BoxData[
      ActionMenuBox[
       FrameBox[
        InterpretationBox[Cell[TextData[{
          "Tutorials",
          StyleBox[" \[FilledDownTriangle]", "AnchorBarArrow",
           StripOnInput->False]
         }],ExpressionUUID->"34f1a16b-8adf-4c31-9afa-c93251f03486"],
         TextCell[
          Row[{"Tutorials", 
            Style[" \[FilledDownTriangle]", "AnchorBarArrow"]}]]],
        StripOnInput->False], {"\<\"GroupMath Tutorial\"\>":>
       Documentation`HelpLookup["paclet:GroupMath/tutorial/GroupMathDoc"]},
       Appearance->None,
       MenuAppearance->Automatic,
       MenuStyle->"Tutorials"]],
      LineSpacing->{1.4, 0},ExpressionUUID->
      "050447c6-2d85-4100-b251-b74bbcf745af"],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      ActionMenuBox[
       FrameBox[
        InterpretationBox[Cell[TextData[{
          "See Also",
          StyleBox[" \[FilledDownTriangle]", "AnchorBarArrow",
           StripOnInput->False]
         }],ExpressionUUID->"51885606-9bed-49a2-bbf5-0f5769c3cd35"],
         TextCell[
          Row[{"See Also", 
            Style[" \[FilledDownTriangle]", "AnchorBarArrow"]}]]],
        StripOnInput->False], {"\<\"ConjugacyClassGroupModIndices\"\>":>
       Documentation`HelpLookup[
       "paclet:GroupMath/ref/ConjugacyClassGroupModIndices"], \
"\<\"CartanMatrix\"\>":>Documentation`HelpLookup[
       "paclet:GroupMath/ref/CartanMatrix"], "\<\"ReduceRepProduct\"\>":>
       Documentation`HelpLookup["paclet:GroupMath/ref/ReduceRepProduct"]},
       Appearance->None,
       MenuAppearance->Automatic,
       MenuStyle->"SeeAlso"]],
      LineSpacing->{1.4, 0},ExpressionUUID->
      "1e5c389f-bb84-470e-8f0e-b9b785eaf46f"],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      ActionMenuBox[
       FrameBox[
        InterpretationBox[Cell[TextData[{
          "URL",
          StyleBox[" \[FilledDownTriangle]", "AnchorBarArrow",
           StripOnInput->False]
         }],ExpressionUUID->"1179a626-cfb9-4779-8841-c5e7f7417dc6"],
         TextCell[
          Row[{"URL", 
            Style[" \[FilledDownTriangle]", "AnchorBarArrow"]}]]],
        StripOnInput->False], {"\<\"GroupMath/ref/ConjugacyClass\"\>":>
       None, "\<\"Copy Wolfram Documentation Center URL\"\>":>
       Module[{DocumentationSearch`Private`nb$}, 
        DocumentationSearch`Private`nb$ = NotebookPut[
           Notebook[{
             Cell["GroupMath/ref/ConjugacyClass"]}, Visible -> False]]; 
        SelectionMove[DocumentationSearch`Private`nb$, All, Notebook]; 
        FrontEndTokenExecute[DocumentationSearch`Private`nb$, "Copy"]; 
        NotebookClose[DocumentationSearch`Private`nb$]; Null], 
       Delimiter, "\<\"Copy web URL\"\>":>
       Module[{DocumentationSearch`Private`nb$}, 
        DocumentationSearch`Private`nb$ = NotebookPut[
           Notebook[{
             Cell[
              BoxData[
               MakeBoxes[
                Hyperlink[
                "http://reference.wolfram.com/language/GroupMath/ref/\
ConjugacyClass.html"], StandardForm]], "Input", TextClipboardType -> 
              "PlainText"]}, Visible -> False]]; 
        SelectionMove[DocumentationSearch`Private`nb$, All, Notebook]; 
        FrontEndTokenExecute[DocumentationSearch`Private`nb$, "Copy"]; 
        NotebookClose[DocumentationSearch`Private`nb$]; 
        Null], "\<\"Go to web URL\"\>":>FrontEndExecute[{
         NotebookLocate[{
           URL[
            StringJoin[
             If[
              TrueQ[DocumentationBuild`Make`Private`wsmlinkQ$11108], 
              "http://reference.wolfram.com/system-modeler/", 
              "http://reference.wolfram.com/language/"], 
             "GroupMath/ref/ConjugacyClass", ".html"]], None}]}]},
       Appearance->None,
       MenuAppearance->Automatic,
       MenuStyle->"URLMenu"]],
      LineSpacing->{1.4, 0},ExpressionUUID->
      "6df4cee1-0593-45e4-901b-8e380921fac2"]
    }], "AnchorBar",ExpressionUUID->"a66a97b9-8839-435e-955e-beb452f987a3"]}
  }]], "AnchorBarGrid",
 CellID->1,ExpressionUUID->"4f9f6d03-6c7a-4c42-b67d-23bdb5a383db"],

Cell[CellGroupData[{

Cell[TextData[{
 Cell["ConjugacyClass", "ObjectName",ExpressionUUID->
  "970c5238-1263-49a8-b6ba-1859704411cf"],
 Cell[BoxData[
  TemplateBox[{8},
   "Spacer1"]],ExpressionUUID->"f226bee5-8235-448c-8cca-fd9b3d4a0a7b"],
 Cell[BoxData[
 ""], "ObjectNameTranslation",ExpressionUUID->
  "e68e911b-1c76-479d-9c1a-b3249b6537ca"]
}], "ObjectNameGrid",ExpressionUUID->"d7a0e68c-b4d0-4505-895b-0637e30438a3"],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{"ConjugacyClass", "[", 
       RowBox[{"group", ",", "represention"}], "]"}]], "InlineFormula",
      ExpressionUUID->"4ebcc30c-58c0-458b-8fd4-69c7f4b20b39"],
     " \[LineSeparator]Computes the conjugacy class of a representation of a \
simple Lie group"
    }],ExpressionUUID->"aff8ac0f-0b02-4b63-990b-7ec39e4f600b"]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{"Columns" -> {{None}}, "Rows" -> {{None}}}},
 CellID->982511436,ExpressionUUID->"ba4993d9-ee00-47cf-af8d-73ed5ecd2361"]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[Cell[TextData[{
   Cell[BoxData[
    TemplateBox[{6},
     "Spacer1"]],ExpressionUUID->"497012d2-b1c4-4f48-8173-d833f11eeb2c"],
   "Details"
  }], "NotesFrameText",ExpressionUUID->"a0362728-955b-4617-b82b-e20cc2626b23"],
  Appearance->{Automatic, None, "Normal", Automatic},
  BaseStyle->None,
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"], 
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], After, CellContents]}]& ),
  Evaluator->None,
  Method->
   "Preemptive"]],ExpressionUUID->"02e71be3-0106-4e00-ae74-2b4455bfb9ca"]], \
"NotesSection",
 WholeCellGroupOpener->True,
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->132806099,ExpressionUUID->"a4d8120d-c538-4c88-9cc0-057743213388"],

Cell["", "SectionHeaderSpacer",ExpressionUUID->"93d44710-6a00-4ee8-b5c0-6576eda16699"],

Cell[TextData[{
 Cell[BoxData[
 "group"], "InlineFormula",ExpressionUUID->
  "06670010-03fa-48d3-8ddb-1435f3af55e5"],
 " should a ",
 ButtonBox["Cartan matrix",
  BaseStyle->"Link",
  ButtonData->"paclet:GroupMath/ref/CartanMatrix"],
 ButtonBox[".",
  BaseStyle->"Link",
  ButtonData->"paclet:Susyno/ref/CartanMatrix"]
}], "Notes",
 CellID->1067943069,ExpressionUUID->"9054a685-da39-4305-958f-2a3aea807a35"],

Cell[TextData[{
 Cell[BoxData[
 "representation"], "InlineFormula",ExpressionUUID->
  "f49d0dcf-ec9b-48f6-84ab-d9cf3e565fe4"],
 " should be a list of non-negative integers (Dynkin coefficients). It is \
also possible to use the simplified input format for representations (see the \
",
 ButtonBox["GroupMath tutorial",
  BaseStyle->"Link",
  ButtonData->"paclet:GroupMath/tutorial/GroupMathDoc"],
 " page)."
}], "Notes",
 CellID->322001788,ExpressionUUID->"225dbd8c-cef0-46df-b8b4-09eeac092a44"],

Cell["\<\
The output is a list of natural numbers which uniquely identify the conjugacy \
class. In fact for almost all groups, the result consists of a list with a \
single number, except for the SO(2m) groups for which two integers are given.\
\>", "Notes",
 CellID->66919531,ExpressionUUID->"32b4797f-62ca-41bd-8852-fdf3b5b64053"],

Cell["", "SectionFooterSpacer",ExpressionUUID->"19d3d821-d02d-4345-9295-30a4a961e4f5"]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[{
 Cell[BoxData[
  TemplateBox[{6},
   "Spacer1"]],ExpressionUUID->"0fbc137a-0f8e-4fdd-91de-7339ad997d6f"],
 "Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(2)", "ExampleCount",ExpressionUUID->
  "f8f7a2ab-278b-44cd-8436-f53eb94dd6ef"]
}], "PrimaryExamplesSection",
 WholeCellGroupOpener->True,
 CellTags->"PrimaryExamplesSection",
 CellID->189901540,ExpressionUUID->"628adafd-3084-43a5-92ac-30526840a116"],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(2)", "ExampleCount",ExpressionUUID->
  "aa70d8ba-7092-4561-9e91-a187d17bfb4d"]
}], "ExampleSection", "ExampleSection",
 WholeCellGroupOpener->True,
 CellID->6134952,ExpressionUUID->"8a7751b7-b8be-436f-89a6-f4b7b40ae8fc"],

Cell["\<\
SU(3) representation can be in on of three classes (the group has a \
'triality' property):\
\>", "ExampleText",
 CellID->14658346,ExpressionUUID->"0db0ecbb-4257-4fd1-9efd-957d67eff458"],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{"ConjugacyClass", "[", 
  RowBox[{"SU3", ",", 
   RowBox[{"{", 
    RowBox[{"0", ",", "1"}], "}"}]}], "]"}], "\[IndentingNewLine]", 
 RowBox[{"ConjugacyClass", "[", 
  RowBox[{"SU3", ",", 
   RowBox[{"{", 
    RowBox[{"1", ",", "0"}], "}"}]}], "]"}], "\[IndentingNewLine]", 
 RowBox[{"ConjugacyClass", "[", 
  RowBox[{"SU3", ",", 
   RowBox[{"{", 
    RowBox[{"1", ",", "1"}], "}"}]}], "]"}]}], "Input",
 CellLabel->"In[1]:=",
 CellID->430153659,ExpressionUUID->"9fe45566-5ab1-4613-af5a-7d35c8ffbca8"],

Cell[BoxData[
 RowBox[{"{", "2", "}"}]], "Output",
 CellLabel->"Out[1]=",
 CellID->60234413,ExpressionUUID->"e63204b2-9ef8-497f-b04f-e35ffabda198"],

Cell[BoxData[
 RowBox[{"{", "1", "}"}]], "Output",
 CellLabel->"Out[1]=",
 CellID->64438071,ExpressionUUID->"dc3f1dac-f049-49a5-b48f-3e69071cfb80"],

Cell[BoxData[
 RowBox[{"{", "0", "}"}]], "Output",
 CellLabel->"Out[1]=",
 CellID->747613126,ExpressionUUID->"778f8cc6-5279-49d0-9960-3c00b199e0b8"]
}, Open  ]],

Cell[TextData[{
 "Why is this useful? For example, the product of SU(3) representations are \
the class given by the sum of the classes of the factors, modulus 3 (this \
number is given by the function ",
 Cell[BoxData[
  TemplateBox[{Cell[
     TextData["ConjugacyClassGroupModIndices"]],
    "paclet:GroupMath/ref/ConjugacyClassGroupModIndices"},
   "RefLink",
   BaseStyle->{"InlineFormula"}]], "InlineFormula",ExpressionUUID->
  "8b0dfb47-be7a-4cda-8187-2cdbdae00827"],
 ")."
}], "ExampleText",
 CellID->94118532,ExpressionUUID->"f51a767d-7471-4a7b-8e04-8c677b72363d"],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"sumOfClasses", "=", 
   RowBox[{
    RowBox[{"ConjugacyClass", "[", 
     RowBox[{"SU3", ",", 
      RowBox[{"{", 
       RowBox[{"0", ",", "1"}], "}"}]}], "]"}], "+", 
    RowBox[{"ConjugacyClass", "[", 
     RowBox[{"SU3", ",", 
      RowBox[{"{", 
       RowBox[{"0", ",", "1"}], "}"}]}], "]"}], "+", 
    RowBox[{"ConjugacyClass", "[", 
     RowBox[{"SU3", ",", 
      RowBox[{"{", 
       RowBox[{"1", ",", "0"}], "}"}]}], "]"}]}]}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{"sumOfClassesMod3", "=", 
  RowBox[{"Mod", "[", 
   RowBox[{"sumOfClasses", ",", "3"}], "]"}]}]}], "Input",
 CellLabel->"In[2]:=",
 CellID->582423663,ExpressionUUID->"2eed6043-bffe-4346-9642-33e68b50d428"],

Cell[BoxData[
 RowBox[{"{", "5", "}"}]], "Output",
 CellLabel->"Out[2]=",
 CellID->46161651,ExpressionUUID->"2bb63ce7-8c0f-4719-bbef-fb662debd0da"],

Cell[BoxData[
 RowBox[{"{", "2", "}"}]], "Output",
 CellLabel->"Out[2]=",
 CellID->425888645,ExpressionUUID->"abd9c66b-150c-426b-a67e-98a0a45d8748"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ReduceRepProduct", "[", 
  RowBox[{"SU3", ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"0", ",", "1"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0", ",", "1"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"1", ",", "0"}], "}"}]}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->211409023,ExpressionUUID->"1656e2ba-f63e-4631-bcd9-b3be9a848345"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"1", ",", "2"}], "}"}], ",", "1"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"0", ",", "1"}], "}"}], ",", "2"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"2", ",", "0"}], "}"}], ",", "1"}], "}"}]}], "}"}]], "Output",
 CellLabel->"Out[3]=",
 CellID->258597991,ExpressionUUID->"a73c803f-9def-4dbf-ac02-e40337cf4623"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{"ConjugacyClass", "[", 
  RowBox[{"SU3", ",", 
   RowBox[{"{", 
    RowBox[{"1", ",", "2"}], "}"}]}], "]"}], "\[IndentingNewLine]", 
 RowBox[{"ConjugacyClass", "[", 
  RowBox[{"SU3", ",", 
   RowBox[{"{", 
    RowBox[{"0", ",", "1"}], "}"}]}], "]"}], "\[IndentingNewLine]", 
 RowBox[{"ConjugacyClass", "[", 
  RowBox[{"SU3", ",", 
   RowBox[{"{", 
    RowBox[{"2", ",", "0"}], "}"}]}], "]"}]}], "Input",
 CellLabel->"In[4]:=",
 CellID->85662895,ExpressionUUID->"f3f61c58-11c9-41ce-bc16-333f365ddc71"],

Cell[BoxData[
 RowBox[{"{", "2", "}"}]], "Output",
 CellLabel->"Out[4]=",
 CellID->139249860,ExpressionUUID->"ef3953b4-0830-4013-9394-cf894240c468"],

Cell[BoxData[
 RowBox[{"{", "2", "}"}]], "Output",
 CellLabel->"Out[4]=",
 CellID->145956518,ExpressionUUID->"45f66d79-d04f-435f-959d-86490ef930d8"],

Cell[BoxData[
 RowBox[{"{", "2", "}"}]], "Output",
 CellLabel->"Out[4]=",
 CellID->356607885,ExpressionUUID->"4f3e66fb-918b-48b4-ad58-61d71384feef"]
}, Open  ]],

Cell["\<\
Why is this useful? The product of SU(3) representations are the class given \
by the sum of the classes of the factors, modulus 3.\
\>", "ExampleText",
 CellID->203409556,ExpressionUUID->"f13606b0-33ff-4b72-8277-f14209ac9588"],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[
  "\t", "ExampleDelimiter",ExpressionUUID->
   "6b0c0579-c957-4f20-8b15-92cde4608a69"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->95221561,ExpressionUUID->"0fa1de32-dac0-4e5e-a6a0-29e1d96090c6"],

Cell["\<\
The conjugacy classes of SO(2m) groups are identified with 2 integers:\
\>", "ExampleText",
 CellID->83403055,ExpressionUUID->"68e086e2-e785-429d-a2c7-234e6de9e159"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ConjugacyClass", "[", 
  RowBox[{"SO10", ",", 
   RowBox[{"{", 
    RowBox[{"0", ",", "0", ",", "0", ",", "0", ",", "1"}], "}"}]}], 
  "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->79005579,ExpressionUUID->"03960a6f-ee0d-4b63-a22c-536f5b7e12e2"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"1", ",", "1"}], "}"}]], "Output",
 CellLabel->"Out[1]=",
 CellID->4230287,ExpressionUUID->"a23bb300-ecc4-4b87-801a-094bcb2a2ae2"]
}, Open  ]],

Cell[TextData[{
 "Note that ",
 Cell[BoxData[
 "ConjugacyClass"], "InlineFormula",ExpressionUUID->
  "f9ac255d-8b11-4a3d-8490-0f061f96e55e"],
 " accepts the simplified input format for representations, so the last line \
of code is the same as the following one:"
}], "ExampleText",
 CellID->54771557,ExpressionUUID->"8d2a8ea3-32ac-462d-aeed-fa594c99ae09"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ConjugacyClass", "[", 
  RowBox[{"SO10", ",", "16"}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->69899422,ExpressionUUID->"bbf64d02-e64b-4164-80cb-05d21c12a483"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"1", ",", "1"}], "}"}]], "Output",
 CellLabel->"Out[2]=",
 CellID->199585351,ExpressionUUID->"bc282313-31ba-47b1-945e-7f263c973ada"]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell["", "SectionFooterSpacer",ExpressionUUID->"24c64937-1304-4df0-b3fe-4077ddc4378d"]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[{
 Cell[BoxData[
  TemplateBox[{6},
   "Spacer1"]],ExpressionUUID->"21dc331c-7992-42f5-94e1-6d28ad0905bd"],
 "See Also"
}], "SeeAlsoSection",
 WholeCellGroupOpener->True,
 CellID->1255426704,ExpressionUUID->"49d010a6-6991-4ba9-a5ff-398e25da0496"],

Cell[TextData[{
 Cell[BoxData[
  TemplateBox[{Cell[
     TextData["ConjugacyClassGroupModIndices"]],
    "paclet:GroupMath/ref/ConjugacyClassGroupModIndices"},
   "RefLink",
   BaseStyle->{"InlineFormula", FontFamily -> "Verdana"}]], "InlineFormula",
  ExpressionUUID->"d8058f65-dcbb-4cb3-bdfd-af27f293d0ea"],
 "\[NonBreakingSpace]",
 StyleBox["\[MediumSpace]\[FilledVerySmallSquare]\[MediumSpace]", 
  "InlineSeparator"],
 " ",
 Cell[BoxData[
  TemplateBox[{Cell[
     TextData["CartanMatrix"]],"paclet:GroupMath/ref/CartanMatrix"},
   "RefLink",
   BaseStyle->{"InlineFormula", FontFamily -> "Verdana"}]], "InlineFormula",
  ExpressionUUID->"102b02b9-ad3b-4a64-be95-54f1ca154502"],
 "\[NonBreakingSpace]",
 StyleBox["\[MediumSpace]\[FilledVerySmallSquare]\[MediumSpace]", 
  "InlineSeparator"],
 " ",
 Cell[BoxData[
  TemplateBox[{Cell[
     TextData["ReduceRepProduct"]],"paclet:GroupMath/ref/ReduceRepProduct"},
   "RefLink",
   BaseStyle->{"InlineFormula", FontFamily -> "Verdana"}]], "InlineFormula",
  ExpressionUUID->"b18f4619-582c-4316-9536-62d2f14a6eb4"]
}], "SeeAlso",
 CellID->1038487239,ExpressionUUID->"b27d6b9c-b33f-442c-b6e0-6b8c2d94d4e5"]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[{
 Cell[BoxData[
  TemplateBox[{6},
   "Spacer1"]],ExpressionUUID->"e298f862-bc68-4bbf-8886-1093a4090f5e"],
 "Tutorials"
}], "TutorialsSection",
 WholeCellGroupOpener->True,
 CellID->250839057,ExpressionUUID->"ae803604-e4a2-4046-ab73-9c4be8a57f57"],

Cell["", "SectionHeaderSpacer",ExpressionUUID->"d717d050-73c7-4c13-9e3f-7b8181492982"],

Cell[BoxData[
 TemplateBox[{Cell[
    TextData["GroupMath Tutorial"]],"paclet:GroupMath/tutorial/GroupMathDoc"},
  "RefLink",
  BaseStyle->"Tutorials"]], "Tutorials",
 CellID->341631938,ExpressionUUID->"6f84c236-26c5-4994-a655-5a349058373b"]
}, Open  ]],

Cell[" ", "FooterCell",ExpressionUUID->"40ad95c3-3169-40b3-a71b-32c7a5979aae"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"ConjugacyClass",
TaggingRules->{
 "ModificationHighlight" -> False, "ColorType" -> "SymbolColor", "LinkTrails" -> 
  GridBox[{{
      RowBox[{
        ButtonBox[
        "Mathematica", ButtonData -> "paclet:GroupMath/guide/GroupMath", 
         BaseStyle -> {"Link", "DockedLinkTrail"}]}]}}, ColumnAlignments -> 
    Left], "HasOptions" -> False, "ExampleCounter" -> 1, "NeedPlatMsgIn" -> 
  None, "RootCaptions" -> "", 
  "Metadata" -> {
   "built" -> "{2020, 10, 29, 13, 12, 52.4678796}", 
    "history" -> {"1.0", "", "", ""}, "context" -> "GroupMath`", 
    "keywords" -> {}, "specialkeywords" -> {}, 
    "tutorialcollectionlinks" -> {}, "index" -> True, "label" -> 
    "Group Math Symbol", "language" -> "en", "paclet" -> "GroupMath", 
    "status" -> "None", "summary" -> 
    "ConjugacyClass[group, represention] Computes the conjugacy class of a \
representation of a simple Lie group", "synonyms" -> {}, "tabletags" -> {}, 
    "title" -> "ConjugacyClass", "titlemodifier" -> "", "windowtitle" -> 
    "ConjugacyClass", "type" -> "Symbol", "uri" -> 
    "GroupMath/ref/ConjugacyClass", "WorkflowDockedCell" -> ""}, 
  "SearchTextTranslated" -> "", "NewStyles" -> False},
CellContext->"Global`",
FrontEndVersion->"12.0 for Microsoft Windows (64-bit) (April 8, 2019)",
StyleDefinitions->Notebook[{
   Cell[
    StyleData[
    StyleDefinitions -> FrontEnd`FileName[{"Wolfram"}, "Reference.nb"]]], 
   Cell[
    StyleData["Input"], CellContext -> "Global`"], 
   Cell[
    StyleData["Output"], CellContext -> "Global`"]}, Visible -> False, 
  TaggingRules -> {"NewStyles" -> False}, FrontEndVersion -> 
  "12.0 for Microsoft Windows (64-bit) (April 8, 2019)", StyleDefinitions -> 
  FrontEnd`FileName[{$RootDirectory, "C:", "Program Files", 
     "Wolfram Research", "Mathematica", "12.0", "AddOns", "Applications"}, 
    "Default_Style_MyVersion9.nb", CharacterEncoding -> "UTF-8"]]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[8275, 215, 435, 11, 35, "PrimaryExamplesSection",ExpressionUUID->"628adafd-3084-43a5-92ac-30526840a116",
   CellTags->"PrimaryExamplesSection",
   CellID->189901540]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 20239, 581}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[586, 21, 4336, 97, 53, "AnchorBarGrid",ExpressionUUID->"4f9f6d03-6c7a-4c42-b67d-23bdb5a383db",
 CellID->1],
Cell[CellGroupData[{
Cell[4947, 122, 399, 9, 52, "ObjectNameGrid",ExpressionUUID->"d7a0e68c-b4d0-4505-895b-0637e30438a3"],
Cell[5349, 133, 575, 12, 110, "Usage",ExpressionUUID->"ba4993d9-ee00-47cf-af8d-73ed5ecd2361",
 CellID->982511436]
}, Open  ]],
Cell[CellGroupData[{
Cell[5961, 150, 855, 21, 37, "NotesSection",ExpressionUUID->"a4d8120d-c538-4c88-9cc0-057743213388",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->132806099],
Cell[6819, 173, 86, 0, 70, "SectionHeaderSpacer",ExpressionUUID->"93d44710-6a00-4ee8-b5c0-6576eda16699"],
Cell[6908, 175, 407, 12, 70, "Notes",ExpressionUUID->"9054a685-da39-4305-958f-2a3aea807a35",
 CellID->1067943069],
Cell[7318, 189, 495, 12, 70, "Notes",ExpressionUUID->"225dbd8c-cef0-46df-b8b4-09eeac092a44",
 CellID->322001788],
Cell[7816, 203, 333, 5, 70, "Notes",ExpressionUUID->"32b4797f-62ca-41bd-8852-fdf3b5b64053",
 CellID->66919531],
Cell[8152, 210, 86, 0, 70, "SectionFooterSpacer",ExpressionUUID->"19d3d821-d02d-4345-9295-30a4a961e4f5"]
}, Closed]],
Cell[CellGroupData[{
Cell[8275, 215, 435, 11, 35, "PrimaryExamplesSection",ExpressionUUID->"628adafd-3084-43a5-92ac-30526840a116",
 CellTags->"PrimaryExamplesSection",
 CellID->189901540],
Cell[CellGroupData[{
Cell[8735, 230, 306, 7, 29, "ExampleSection",ExpressionUUID->"8a7751b7-b8be-436f-89a6-f4b7b40ae8fc",
 CellID->6134952],
Cell[9044, 239, 196, 4, 38, "ExampleText",ExpressionUUID->"0db0ecbb-4257-4fd1-9efd-957d67eff458",
 CellID->14658346],
Cell[CellGroupData[{
Cell[9265, 247, 525, 14, 59, "Input",ExpressionUUID->"9fe45566-5ab1-4613-af5a-7d35c8ffbca8",
 CellID->430153659],
Cell[9793, 263, 147, 3, 35, "Output",ExpressionUUID->"e63204b2-9ef8-497f-b04f-e35ffabda198",
 CellID->60234413],
Cell[9943, 268, 147, 3, 35, "Output",ExpressionUUID->"dc3f1dac-f049-49a5-b48f-3e69071cfb80",
 CellID->64438071],
Cell[10093, 273, 148, 3, 35, "Output",ExpressionUUID->"778f8cc6-5279-49d0-9960-3c00b199e0b8",
 CellID->747613126]
}, Open  ]],
Cell[10256, 279, 572, 13, 77, "ExampleText",ExpressionUUID->"f51a767d-7471-4a7b-8e04-8c677b72363d",
 CellID->94118532],
Cell[CellGroupData[{
Cell[10853, 296, 741, 21, 75, "Input",ExpressionUUID->"2eed6043-bffe-4346-9642-33e68b50d428",
 CellID->582423663],
Cell[11597, 319, 147, 3, 35, "Output",ExpressionUUID->"2bb63ce7-8c0f-4719-bbef-fb662debd0da",
 CellID->46161651],
Cell[11747, 324, 148, 3, 35, "Output",ExpressionUUID->"abd9c66b-150c-426b-a67e-98a0a45d8748",
 CellID->425888645]
}, Open  ]],
Cell[CellGroupData[{
Cell[11932, 332, 410, 12, 70, "Input",ExpressionUUID->"1656e2ba-f63e-4631-bcd9-b3be9a848345",
 CellID->211409023],
Cell[12345, 346, 487, 16, 35, "Output",ExpressionUUID->"a73c803f-9def-4dbf-ac02-e40337cf4623",
 CellID->258597991]
}, Open  ]],
Cell[CellGroupData[{
Cell[12869, 367, 524, 14, 70, "Input",ExpressionUUID->"f3f61c58-11c9-41ce-bc16-333f365ddc71",
 CellID->85662895],
Cell[13396, 383, 148, 3, 35, "Output",ExpressionUUID->"ef3953b4-0830-4013-9394-cf894240c468",
 CellID->139249860],
Cell[13547, 388, 148, 3, 35, "Output",ExpressionUUID->"45f66d79-d04f-435f-959d-86490ef930d8",
 CellID->145956518],
Cell[13698, 393, 148, 3, 35, "Output",ExpressionUUID->"4f3e66fb-918b-48b4-ad58-61d71384feef",
 CellID->356607885]
}, Open  ]],
Cell[13861, 399, 237, 4, 70, "ExampleText",ExpressionUUID->"f13606b0-33ff-4b72-8277-f14209ac9588",
 CellID->203409556],
Cell[CellGroupData[{
Cell[14123, 407, 241, 5, 70, "ExampleDelimiter",ExpressionUUID->"0fa1de32-dac0-4e5e-a6a0-29e1d96090c6",
 CellID->95221561],
Cell[14367, 414, 175, 3, 70, "ExampleText",ExpressionUUID->"68e086e2-e785-429d-a2c7-234e6de9e159",
 CellID->83403055],
Cell[CellGroupData[{
Cell[14567, 421, 272, 7, 70, "Input",ExpressionUUID->"03960a6f-ee0d-4b63-a22c-536f5b7e12e2",
 CellID->79005579],
Cell[14842, 430, 169, 4, 35, "Output",ExpressionUUID->"a23bb300-ecc4-4b87-801a-094bcb2a2ae2",
 CellID->4230287]
}, Open  ]],
Cell[15026, 437, 356, 8, 70, "ExampleText",ExpressionUUID->"8d2a8ea3-32ac-462d-aeed-fa594c99ae09",
 CellID->54771557],
Cell[CellGroupData[{
Cell[15407, 449, 191, 4, 70, "Input",ExpressionUUID->"bbf64d02-e64b-4164-80cb-05d21c12a483",
 CellID->69899422],
Cell[15601, 455, 171, 4, 35, "Output",ExpressionUUID->"bc282313-31ba-47b1-945e-7f263c973ada",
 CellID->199585351]
}, Open  ]]
}, Open  ]]
}, Open  ]],
Cell[15811, 464, 86, 0, 70, "SectionFooterSpacer",ExpressionUUID->"24c64937-1304-4df0-b3fe-4077ddc4378d"]
}, Open  ]],
Cell[CellGroupData[{
Cell[15934, 469, 260, 7, 70, "SeeAlsoSection",ExpressionUUID->"49d010a6-6991-4ba9-a5ff-398e25da0496",
 CellID->1255426704],
Cell[16197, 478, 1155, 29, 70, "SeeAlso",ExpressionUUID->"b27d6b9c-b33f-442c-b6e0-6b8c2d94d4e5",
 CellID->1038487239]
}, Open  ]],
Cell[CellGroupData[{
Cell[17389, 512, 262, 7, 70, "TutorialsSection",ExpressionUUID->"ae803604-e4a2-4046-ab73-9c4be8a57f57",
 CellID->250839057],
Cell[17654, 521, 86, 0, 70, "SectionHeaderSpacer",ExpressionUUID->"d717d050-73c7-4c13-9e3f-7b8181492982"],
Cell[17743, 523, 241, 5, 70, "Tutorials",ExpressionUUID->"6f84c236-26c5-4994-a655-5a349058373b",
 CellID->341631938]
}, Open  ]],
Cell[17999, 531, 78, 0, 70, "FooterCell",ExpressionUUID->"40ad95c3-3169-40b3-a71b-32c7a5979aae"]
}
]
*)

(* End of internal cache information *)

