(* Content-type: application/vnd.wolfram.mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 12.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       158,          7]
NotebookDataLength[     20360,        546]
NotebookOptionsPosition[     14345,        416]
NotebookOutlinePosition[     16875,        477]
CellTagsIndexPosition[     16790,        472]
WindowTitle->CMtoName
WindowFrame->Normal*)

(* Beginning of Notebook Content *)
Notebook[{
Cell[BoxData[GridBox[{
   {Cell["GROUP MATH SYMBOL", "PacletNameCell",ExpressionUUID->
     "2ee17b65-5832-42ea-868c-b6fc25d4b8b9"], Cell[TextData[{
     Cell[BoxData[
      ActionMenuBox[
       FrameBox[
        InterpretationBox[Cell[TextData[{
          "Tutorials",
          StyleBox[" \[FilledDownTriangle]", "AnchorBarArrow",
           StripOnInput->False]
         }],ExpressionUUID->"dab26959-ce73-462f-883c-ef03e838a0fc"],
         TextCell[
          Row[{"Tutorials", 
            Style[" \[FilledDownTriangle]", "AnchorBarArrow"]}]]],
        StripOnInput->False], {"\<\"GroupMath Tutorial\"\>":>
       Documentation`HelpLookup["paclet:GroupMath/tutorial/GroupMathDoc"]},
       Appearance->None,
       MenuAppearance->Automatic,
       MenuStyle->"Tutorials"]],
      LineSpacing->{1.4, 0},ExpressionUUID->
      "d584bf02-ec61-4cba-b8c4-d7c5d4a1ef33"],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      ActionMenuBox[
       FrameBox[
        InterpretationBox[Cell[TextData[{
          "See Also",
          StyleBox[" \[FilledDownTriangle]", "AnchorBarArrow",
           StripOnInput->False]
         }],ExpressionUUID->"3ae7e39c-941d-4eb0-9189-0d34c6e64247"],
         TextCell[
          Row[{"See Also", 
            Style[" \[FilledDownTriangle]", "AnchorBarArrow"]}]]],
        StripOnInput->False], {"\<\"CartanMatrix\"\>":>
       Documentation`HelpLookup["paclet:GroupMath/ref/CartanMatrix"]},
       Appearance->None,
       MenuAppearance->Automatic,
       MenuStyle->"SeeAlso"]],
      LineSpacing->{1.4, 0},ExpressionUUID->
      "85a16e81-f5cb-4c32-b186-7f13666a9734"],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      ActionMenuBox[
       FrameBox[
        InterpretationBox[Cell[TextData[{
          "URL",
          StyleBox[" \[FilledDownTriangle]", "AnchorBarArrow",
           StripOnInput->False]
         }],ExpressionUUID->"00b985bd-1266-4663-95d2-e8284b4fd477"],
         TextCell[
          Row[{"URL", 
            Style[" \[FilledDownTriangle]", "AnchorBarArrow"]}]]],
        StripOnInput->False], {"\<\"GroupMath/ref/CMtoName\"\>":>
       None, "\<\"Copy Wolfram Documentation Center URL\"\>":>
       Module[{DocumentationSearch`Private`nb$}, 
        DocumentationSearch`Private`nb$ = NotebookPut[
           Notebook[{
             Cell["GroupMath/ref/CMtoName"]}, Visible -> False]]; 
        SelectionMove[DocumentationSearch`Private`nb$, All, Notebook]; 
        FrontEndTokenExecute[DocumentationSearch`Private`nb$, "Copy"]; 
        NotebookClose[DocumentationSearch`Private`nb$]; Null], 
       Delimiter, "\<\"Copy web URL\"\>":>
       Module[{DocumentationSearch`Private`nb$}, 
        DocumentationSearch`Private`nb$ = NotebookPut[
           Notebook[{
             Cell[
              BoxData[
               MakeBoxes[
                Hyperlink[
                "http://reference.wolfram.com/language/GroupMath/ref/CMtoName.\
html"], StandardForm]], "Input", TextClipboardType -> "PlainText"]}, Visible -> 
            False]]; SelectionMove[
         DocumentationSearch`Private`nb$, All, Notebook]; 
        FrontEndTokenExecute[DocumentationSearch`Private`nb$, "Copy"]; 
        NotebookClose[DocumentationSearch`Private`nb$]; 
        Null], "\<\"Go to web URL\"\>":>FrontEndExecute[{
         NotebookLocate[{
           URL[
            StringJoin[
             If[
              TrueQ[DocumentationBuild`Make`Private`wsmlinkQ$10058], 
              "http://reference.wolfram.com/system-modeler/", 
              "http://reference.wolfram.com/language/"], 
             "GroupMath/ref/CMtoName", ".html"]], None}]}]},
       Appearance->None,
       MenuAppearance->Automatic,
       MenuStyle->"URLMenu"]],
      LineSpacing->{1.4, 0},ExpressionUUID->
      "41a56c59-4fef-483d-b1b3-7f2746507827"]
    }], "AnchorBar",ExpressionUUID->"7d67939c-bb07-4734-b5f4-16f8500d0f37"]}
  }]], "AnchorBarGrid",
 CellID->1,ExpressionUUID->"f989b831-3e82-48a2-8539-d7524f82a454"],

Cell[CellGroupData[{

Cell[TextData[{
 Cell["CMtoName", "ObjectName",ExpressionUUID->
  "7af19415-2570-4f19-b6dd-30bd5fb639ed"],
 Cell[BoxData[
  TemplateBox[{8},
   "Spacer1"]],ExpressionUUID->"1f0a39f3-f89e-42f9-b500-96ff2596803f"],
 Cell[BoxData[
 ""], "ObjectNameTranslation",ExpressionUUID->
  "887919a0-5fa9-4b1e-866d-6141fa097a24"]
}], "ObjectNameGrid",ExpressionUUID->"13f84589-2eed-49c9-bd18-0939a2dc087f"],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{"CMtoName", "[", "group", "]"}]], "InlineFormula",
      ExpressionUUID->"4f816fbd-9791-403f-941a-42c39cfd2a42"],
     " \[LineSeparator]Identifies the simple group name from its Cartan matrix"
    }],ExpressionUUID->"c8b5b9ab-af2a-4513-bb12-8978ba1f3c7a"]},
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{"CMtoName", "[", 
       RowBox[{"{", 
        RowBox[{"group1", ",", "group2", ",", "..."}], "}"}], "]"}]], 
      "InlineFormula",ExpressionUUID->"4f639047-df9d-4c1e-9848-45a1edd98838"],
     "\[LineSeparator]Identifies the name of the semi-simple group ",
     Cell[BoxData[
      RowBox[{"{", 
       RowBox[{"group1", ",", "group2", ",", "..."}], "}"}]], "InlineFormula",
      ExpressionUUID->"caeae3b1-9ea0-4751-b5ca-0544b4da358c"],
     " from the Cartan matrices of its simple factors"
    }],ExpressionUUID->"d5b8bc91-d2c7-4289-90be-95f9e17ae7f5"]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{"Columns" -> {{None}}, "Rows" -> {None, {None}}}},
 CellID->982511436,ExpressionUUID->"5a6ea404-ebf8-4c6e-8e6f-40b7dbb48b5c"]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[Cell[TextData[{
   Cell[BoxData[
    TemplateBox[{6},
     "Spacer1"]],ExpressionUUID->"c04e36a1-fd24-4e55-888f-1bfa4bd7f335"],
   "Details"
  }], "NotesFrameText",ExpressionUUID->"a2c6602e-e45a-4e5b-b6c1-e465f2d2c70b"],
  Appearance->{Automatic, None, "Normal", Automatic},
  BaseStyle->None,
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"], 
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], After, CellContents]}]& ),
  Evaluator->None,
  Method->
   "Preemptive"]],ExpressionUUID->"2cf9a36d-1c32-4789-91a4-da63dcf345fe"]], \
"NotesSection",
 WholeCellGroupOpener->True,
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->206369690,ExpressionUUID->"be3290c8-ada5-4f1f-8024-06d1bbc4f01e"],

Cell["", "SectionHeaderSpacer",ExpressionUUID->"f015cb1e-a936-4723-91f9-5df12be553a7"],

Cell[TextData[{
 Cell[BoxData[
 "group"], "InlineFormula",ExpressionUUID->
  "5e505c72-25c2-484b-8980-b9ab078ecc53"],
 " should a ",
 ButtonBox["Cartan matrix",
  BaseStyle->"Link",
  ButtonData->"paclet:GroupMath/ref/CartanMatrix"],
 ButtonBox[".",
  BaseStyle->"Link",
  ButtonData->"paclet:Susyno/ref/CartanMatrix"]
}], "Notes",
 CellID->1067943069,ExpressionUUID->"64a6e038-bc53-4f40-b53f-e8ec63223e60"],

Cell["\<\
The output is a string with the simple group's name. U(1)'s also work.\
\>", "Notes",
 CellID->38413404,ExpressionUUID->"0d91f1c0-ffb7-4778-b5ea-36e36dc136ba"],

Cell[TextData[{
 "A list of Cartan matrices ",
 Cell[BoxData[
  RowBox[{"{", 
   RowBox[{"group1", ",", " ", "group2", ",", "..."}], "}"}]], 
  "InlineFormula",ExpressionUUID->"f785e4ed-d3de-40ef-9f1a-8e81e825c9b4"],
 " can also be used as input, in which case the output is a list of strings."
}], "Notes",
 CellID->33008471,ExpressionUUID->"e99a664a-8bc2-4004-859e-468b02d18f0b"],

Cell["", "SectionFooterSpacer",ExpressionUUID->"abbf6ceb-18c8-4f05-b0df-c945f0034c3d"]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[{
 Cell[BoxData[
  TemplateBox[{6},
   "Spacer1"]],ExpressionUUID->"8321106a-f613-4caf-b075-0f4df1aaa38b"],
 "Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(2)", "ExampleCount",ExpressionUUID->
  "ce942ae0-6496-4d92-be3a-8babd3f28caf"]
}], "PrimaryExamplesSection",
 WholeCellGroupOpener->True,
 CellTags->"PrimaryExamplesSection",
 CellID->430972665,ExpressionUUID->"43e26f9f-6acd-4939-a22f-dea5e4709f42"],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(2)", "ExampleCount",ExpressionUUID->
  "782f9fb1-e078-4ede-a936-e39a2296bd7c"]
}], "ExampleSection", "ExampleSection",
 WholeCellGroupOpener->True,
 CellID->164624721,ExpressionUUID->"09af29e3-2600-471a-b326-afffc6561e8a"],

Cell["The Cartan matrix of SU(3) is {{2,-1},{-1,2}}:", "ExampleText",
 CellID->173216035,ExpressionUUID->"5d765a77-2d40-4b52-a25a-c03d25899225"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"CMtoName", "[", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{"2", ",", 
      RowBox[{"-", "1"}]}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"-", "1"}], ",", "2"}], "}"}]}], "}"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->293722129,ExpressionUUID->"68a7768c-8eab-41e2-a4ec-60ce92e74fd2"],

Cell[BoxData["\<\"SU3\"\>"], "Output",
 CellLabel->"Out[1]=",
 CellID->808203997,ExpressionUUID->"4b5bea94-c3de-4835-9cbe-52ee8a07c152"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[
  "\t", "ExampleDelimiter",ExpressionUUID->
   "b2945bf2-63fe-4340-bbea-90f143a2ff76"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->459538714,ExpressionUUID->"86a9b9e4-a263-4692-adf1-3dd1445edf71"],

Cell["The function also works for semi-simple groups:", "ExampleText",
 CellID->451618593,ExpressionUUID->"ed147e37-380b-4bee-9cac-428bb3dece84"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"CMtoName", "[", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"2", ",", 
        RowBox[{"-", "1"}]}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"-", "1"}], ",", "2"}], "}"}]}], "}"}], ",", 
    RowBox[{"{", "}"}]}], "}"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->5584208,ExpressionUUID->"85f2a486-68f8-4b7c-8ba0-4393f29f5153"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"\<\"SU3\"\>", ",", "\<\"U1\"\>"}], "}"}]], "Output",
 CellLabel->"Out[1]=",
 CellID->44984498,ExpressionUUID->"83869687-e966-49c1-a2cd-dc0ec8564078"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{"cartanMatrices", "=", 
  RowBox[{"{", 
   RowBox[{"SU2", ",", "E6", ",", "SP6"}], "}"}]}], "\[IndentingNewLine]", 
 RowBox[{"groupName", "=", 
  RowBox[{"CMtoName", "[", "cartanMatrices", "]"}]}]}], "Input",
 CellLabel->"In[2]:=",
 CellID->128825400,ExpressionUUID->"d5935350-517c-4499-9848-cc741007a44f"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"{", "2", "}"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"2", ",", 
       RowBox[{"-", "1"}], ",", "0", ",", "0", ",", "0", ",", "0"}], "}"}], 
     ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "1"}], ",", "2", ",", 
       RowBox[{"-", "1"}], ",", "0", ",", "0", ",", "0"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0", ",", 
       RowBox[{"-", "1"}], ",", "2", ",", 
       RowBox[{"-", "1"}], ",", "0", ",", 
       RowBox[{"-", "1"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0", ",", "0", ",", 
       RowBox[{"-", "1"}], ",", "2", ",", 
       RowBox[{"-", "1"}], ",", "0"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0", ",", "0", ",", "0", ",", 
       RowBox[{"-", "1"}], ",", "2", ",", "0"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0", ",", "0", ",", 
       RowBox[{"-", "1"}], ",", "0", ",", "0", ",", "2"}], "}"}]}], "}"}], 
   ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"2", ",", 
       RowBox[{"-", "1"}], ",", "0"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "1"}], ",", "2", ",", 
       RowBox[{"-", "1"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0", ",", 
       RowBox[{"-", "2"}], ",", "2"}], "}"}]}], "}"}]}], "}"}]], "Output",
 CellLabel->"Out[2]=",
 CellID->553877470,ExpressionUUID->"d05b0746-b8a7-404d-a5b0-7985ec890c8a"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"\<\"SU2\"\>", ",", "\<\"E6\"\>", ",", "\<\"SP6\"\>"}], 
  "}"}]], "Output",
 CellLabel->"Out[2]=",
 CellID->237756665,ExpressionUUID->"8b6b13ff-33eb-4679-8a8d-bc5e6d09f248"]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell["", "SectionFooterSpacer",ExpressionUUID->"e588ac01-3bbc-4f2e-9d3a-a0983d07e398"]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[{
 Cell[BoxData[
  TemplateBox[{6},
   "Spacer1"]],ExpressionUUID->"28a7f079-8523-41c7-9039-824d3874b222"],
 "See Also"
}], "SeeAlsoSection",
 WholeCellGroupOpener->True,
 CellID->1255426704,ExpressionUUID->"543be65e-4a70-438c-a4ba-501c789346a5"],

Cell[TextData[Cell[BoxData[
 TemplateBox[{Cell[
    TextData["CartanMatrix"]],"paclet:GroupMath/ref/CartanMatrix"},
  "RefLink",
  BaseStyle->{
   "InlineFormula", FontFamily -> 
    "Verdana"}]], \
"InlineFormula",ExpressionUUID->"6cec054f-5261-43fb-b7fc-62d9e325490e"]], \
"SeeAlso",
 CellID->1038487239,ExpressionUUID->"c300b11c-6f5c-4695-a49c-1252e1ea5b7c"]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[{
 Cell[BoxData[
  TemplateBox[{6},
   "Spacer1"]],ExpressionUUID->"c62e7e2d-420d-4000-88bb-55e314c200e8"],
 "Tutorials"
}], "TutorialsSection",
 WholeCellGroupOpener->True,
 CellID->250839057,ExpressionUUID->"f3388638-0735-4988-b8f7-87f801626a59"],

Cell["", "SectionHeaderSpacer",ExpressionUUID->"ab7d8ee7-23b1-4d28-9498-9f39ee014a6b"],

Cell[BoxData[
 TemplateBox[{Cell[
    TextData["GroupMath Tutorial"]],"paclet:GroupMath/tutorial/GroupMathDoc"},
  "RefLink",
  BaseStyle->"Tutorials"]], "Tutorials",
 CellID->341631938,ExpressionUUID->"28bb20da-cbdd-47e1-b80b-18190816b3ae"]
}, Open  ]],

Cell[" ", "FooterCell",ExpressionUUID->"1d1d8913-54a5-42f2-bd17-01f2e04e0471"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"CMtoName",
TaggingRules->{
 "ModificationHighlight" -> False, "ColorType" -> "SymbolColor", "LinkTrails" -> 
  GridBox[{{
      RowBox[{
        ButtonBox[
        "Mathematica", ButtonData -> "paclet:GroupMath/guide/GroupMath", 
         BaseStyle -> {"Link", "DockedLinkTrail"}]}]}}, ColumnAlignments -> 
    Left], "HasOptions" -> False, "ExampleCounter" -> 1, "NeedPlatMsgIn" -> 
  None, "RootCaptions" -> "", 
  "Metadata" -> {
   "built" -> "{2020, 10, 29, 13, 12, 47.9966325}", 
    "history" -> {"1.0", "", "", ""}, "context" -> "GroupMath`", 
    "keywords" -> {}, "specialkeywords" -> {}, 
    "tutorialcollectionlinks" -> {}, "index" -> True, "label" -> 
    "Group Math Symbol", "language" -> "en", "paclet" -> "GroupMath", 
    "status" -> "None", "summary" -> 
    "CMtoName[group] Identifies the simple group name from its Cartan matrix \
CMtoName[{group1, group2, ...}] Identifies the name of the semi-simple group \
{group1, group2, ...} from the Cartan matrices of its simple factors", 
    "synonyms" -> {}, "tabletags" -> {}, "title" -> "CMtoName", 
    "titlemodifier" -> "", "windowtitle" -> "CMtoName", "type" -> "Symbol", 
    "uri" -> "GroupMath/ref/CMtoName", "WorkflowDockedCell" -> ""}, 
  "SearchTextTranslated" -> "", "NewStyles" -> False},
CellContext->"Global`",
FrontEndVersion->"12.0 for Microsoft Windows (64-bit) (April 8, 2019)",
StyleDefinitions->Notebook[{
   Cell[
    StyleData[
    StyleDefinitions -> FrontEnd`FileName[{"Wolfram"}, "Reference.nb"]]], 
   Cell[
    StyleData["Input"], CellContext -> "Global`"], 
   Cell[
    StyleData["Output"], CellContext -> "Global`"]}, Visible -> False, 
  TaggingRules -> {"NewStyles" -> False}, FrontEndVersion -> 
  "12.0 for Microsoft Windows (64-bit) (April 8, 2019)", StyleDefinitions -> 
  FrontEnd`FileName[{$RootDirectory, "C:", "Program Files", 
     "Wolfram Research", "Mathematica", "12.0", "AddOns", "Applications"}, 
    "Default_Style_MyVersion9.nb", CharacterEncoding -> "UTF-8"]]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[8279, 216, 435, 11, 35, "PrimaryExamplesSection",ExpressionUUID->"43e26f9f-6acd-4939-a22f-dea5e4709f42",
   CellTags->"PrimaryExamplesSection",
   CellID->430972665]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 16592, 465}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[580, 21, 4069, 93, 53, "AnchorBarGrid",ExpressionUUID->"f989b831-3e82-48a2-8539-d7524f82a454",
 CellID->1],
Cell[CellGroupData[{
Cell[4674, 118, 393, 9, 52, "ObjectNameGrid",ExpressionUUID->"13f84589-2eed-49c9-bd18-0939a2dc087f"],
Cell[5070, 129, 1136, 23, 204, "Usage",ExpressionUUID->"5a6ea404-ebf8-4c6e-8e6f-40b7dbb48b5c",
 CellID->982511436]
}, Open  ]],
Cell[CellGroupData[{
Cell[6243, 157, 855, 21, 37, "NotesSection",ExpressionUUID->"be3290c8-ada5-4f1f-8024-06d1bbc4f01e",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->206369690],
Cell[7101, 180, 86, 0, 70, "SectionHeaderSpacer",ExpressionUUID->"f015cb1e-a936-4723-91f9-5df12be553a7"],
Cell[7190, 182, 407, 12, 70, "Notes",ExpressionUUID->"64a6e038-bc53-4f40-b53f-e8ec63223e60",
 CellID->1067943069],
Cell[7600, 196, 169, 3, 70, "Notes",ExpressionUUID->"0d91f1c0-ffb7-4778-b5ea-36e36dc136ba",
 CellID->38413404],
Cell[7772, 201, 381, 8, 70, "Notes",ExpressionUUID->"e99a664a-8bc2-4004-859e-468b02d18f0b",
 CellID->33008471],
Cell[8156, 211, 86, 0, 70, "SectionFooterSpacer",ExpressionUUID->"abbf6ceb-18c8-4f05-b0df-c945f0034c3d"]
}, Closed]],
Cell[CellGroupData[{
Cell[8279, 216, 435, 11, 35, "PrimaryExamplesSection",ExpressionUUID->"43e26f9f-6acd-4939-a22f-dea5e4709f42",
 CellTags->"PrimaryExamplesSection",
 CellID->430972665],
Cell[CellGroupData[{
Cell[8739, 231, 308, 7, 29, "ExampleSection",ExpressionUUID->"09af29e3-2600-471a-b326-afffc6561e8a",
 CellID->164624721],
Cell[9050, 240, 144, 1, 38, "ExampleText",ExpressionUUID->"5d765a77-2d40-4b52-a25a-c03d25899225",
 CellID->173216035],
Cell[CellGroupData[{
Cell[9219, 245, 352, 11, 26, "Input",ExpressionUUID->"68a7768c-8eab-41e2-a4ec-60ce92e74fd2",
 CellID->293722129],
Cell[9574, 258, 136, 2, 35, "Output",ExpressionUUID->"4b5bea94-c3de-4835-9cbe-52ee8a07c152",
 CellID->808203997]
}, Open  ]],
Cell[CellGroupData[{
Cell[9747, 265, 242, 5, 8, "ExampleDelimiter",ExpressionUUID->"86a9b9e4-a263-4692-adf1-3dd1445edf71",
 CellID->459538714],
Cell[9992, 272, 145, 1, 38, "ExampleText",ExpressionUUID->"ed147e37-380b-4bee-9cac-428bb3dece84",
 CellID->451618593],
Cell[CellGroupData[{
Cell[10162, 277, 433, 14, 26, "Input",ExpressionUUID->"85f2a486-68f8-4b7c-8ba0-4393f29f5153",
 CellID->5584208],
Cell[10598, 293, 189, 4, 35, "Output",ExpressionUUID->"83869687-e966-49c1-a2cd-dc0ec8564078",
 CellID->44984498]
}, Open  ]],
Cell[CellGroupData[{
Cell[10824, 302, 330, 7, 43, "Input",ExpressionUUID->"d5935350-517c-4499-9848-cc741007a44f",
 CellID->128825400],
Cell[11157, 311, 1457, 44, 68, "Output",ExpressionUUID->"d05b0746-b8a7-404d-a5b0-7985ec890c8a",
 CellID->553877470],
Cell[12617, 357, 213, 5, 35, "Output",ExpressionUUID->"8b6b13ff-33eb-4679-8a8d-bc5e6d09f248",
 CellID->237756665]
}, Open  ]]
}, Open  ]]
}, Open  ]],
Cell[12869, 367, 86, 0, 70, "SectionFooterSpacer",ExpressionUUID->"e588ac01-3bbc-4f2e-9d3a-a0983d07e398"]
}, Open  ]],
Cell[CellGroupData[{
Cell[12992, 372, 260, 7, 70, "SeeAlsoSection",ExpressionUUID->"543be65e-4a70-438c-a4ba-501c789346a5",
 CellID->1255426704],
Cell[13255, 381, 361, 9, 70, "SeeAlso",ExpressionUUID->"c300b11c-6f5c-4695-a49c-1252e1ea5b7c",
 CellID->1038487239]
}, Open  ]],
Cell[CellGroupData[{
Cell[13653, 395, 262, 7, 70, "TutorialsSection",ExpressionUUID->"f3388638-0735-4988-b8f7-87f801626a59",
 CellID->250839057],
Cell[13918, 404, 86, 0, 70, "SectionHeaderSpacer",ExpressionUUID->"ab7d8ee7-23b1-4d28-9498-9f39ee014a6b"],
Cell[14007, 406, 241, 5, 70, "Tutorials",ExpressionUUID->"28bb20da-cbdd-47e1-b80b-18190816b3ae",
 CellID->341631938]
}, Open  ]],
Cell[14263, 414, 78, 0, 70, "FooterCell",ExpressionUUID->"1d1d8913-54a5-42f2-bd17-01f2e04e0471"]
}
]
*)

(* End of internal cache information *)

