(* ::Package:: *)

(* Mathematica Init File *)

ClearAll["GroupMath`*"];

SG[text_]:=Style[text,{GrayLevel[0.5]}]

(* Bad installation directory warning *)
goodPaths={DirectoryName[FileNameJoin[{$BaseDirectory,"Applications","A"}]],DirectoryName[FileNameJoin[{$UserBaseDirectory,"Applications","A"}]]};
inGoodPathQ=MemberQ[goodPaths,DirectoryName[$InputFileName,3]];
badInstallationDirectoryWarning=Row[{Style["(*) Warning:",{Darker[Red],Bold}]," The documentation files might not work because the GroupMath directory is neither in "//SG,Style[FileNameJoin[{$BaseDirectory,"Applications"}],{Underlined,GrayLevel[0.5]}]," nor in "//SG,Style[FileNameJoin[{$UserBaseDirectory,"Applications"}],{Underlined,GrayLevel[0.5]}],"."//SG}];

Block[{result},
result={};
AppendTo[result,Row[{SG["XXXXXXXXXXXXXXXXXXXXXXXXXXX "],SG["GroupMath"],SG[" XXXXXXXXXXXXXXXXXXXXXXXXXX"]}]];
AppendTo[result,Row[{"Version: "//SG,"1.1.2 (6/May/2021)"//SG}]];
AppendTo[result,Row[{"Author: "//SG,"Renato Fonseca"//SG}]];
AppendTo[result,Row[{"Reference: "//SG,"2011.01764 [hep-th]"//SG}]];
AppendTo[result,Row[{"Website: "//SG,Hyperlink[Mouseover[SG["renatofonseca.net/groupmath"],Style["renatofonseca.net/groupmath",{Darker[Blue,0.5],Bold}]],"http://renatofonseca.net/groupmath"]}]];
AppendTo[result,Row[{"Built-in documentation: "//SG,Hyperlink[Mouseover[Style["here",{GrayLevel[0.5],Bold,Underlined}],Style["here",{Darker[Blue,0.5],Bold,Underlined}]],"paclet:GroupMath/tutorial/GroupMathDoc"],If[inGoodPathQ,"",Style[" (*)",{Darker[Red],Bold}]]}]];
AppendTo[result,Style["XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX",{GrayLevel[0.5]}]];

groupMathImage=Image[CompressedData["1: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"], "Byte", ColorSpace -> "RGB", ImageSize -> {200., Automatic}, Interleaving -> True];
groupMathImageBlue=Image[0.8 CompressedData["1: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"], "Byte", ColorSpace -> "RGB", ImageSize -> {200., Automatic}, Interleaving -> True];

Print[Grid[{{Hyperlink[Mouseover[Image[groupMathImage,ImageSize->140],Image[groupMathImageBlue,ImageSize->140]],"paclet:GroupMath/tutorial/GroupMathDoc"],Row[result,"\n",BaseStyle->(FontFamily->"Consolas")]}},Alignment->{Left,Center}]];
];


(* Bad installation directory warning *)
If[!inGoodPathQ,
Print[badInstallationDirectoryWarning];
];



Remove[SU2,Su2,su2,SU3,Su3,su3,SU4,Su4,su4,SU5,Su5,su5,SU6,Su6,su6,SU7,Su7,su7,SU8,Su8,su8,SU9,Su9,su9,SU10,Su10,su10,SU11,Su11,su11,SU12,Su12,su12,SU13,Su13,su13,SU14,Su14,su14,SU15,Su15,su15,SU16,Su16,su16,SU17,Su17,su17,SU18,Su18,su18,SU19,Su19,su19,SU20,Su20,su20,SU21,Su21,su21,SU22,Su22,su22,SU23,Su23,su23,SU24,Su24,su24,SU25,Su25,su25,SU26,Su26,su26,SU27,Su27,su27,SU28,Su28,su28,SU29,Su29,su29,SU30,Su30,su30,SU31,Su31,su31,SU32,Su32,su32,SO3,So3,so3,SO5,So5,so5,SO6,So6,so6,SO7,So7,so7,SO8,So8,so8,SO9,So9,so9,SO10,So10,so10,SO11,So11,so11,SO12,So12,so12,SO13,So13,so13,SO14,So14,so14,SO15,So15,so15,SO16,So16,so16,SO17,So17,so17,SO18,So18,so18,SO19,So19,so19,SO20,So20,so20,SO21,So21,so21,SO22,So22,so22,SO23,So23,so23,SO24,So24,so24,SO25,So25,so25,SO26,So26,so26,SO27,So27,so27,SO28,So28,so28,SO29,So29,so29,SO30,So30,so30,SO31,So31,so31,SO32,So32,so32,E6,e6,E7,e7,E8,e8,G2,g2,F4,f4,U1,u1,a,b,c,d,e,f,g,h];


Get["GroupMath`GroupMath`"];

(*
ClearAll["GroupMath`PermutationGroup`*"];
ClearAll["GroupMath`LieAlgebras`*"];
ClearAll["GroupMath`GenericTools`*"];
ClearAll["GroupMath`HEPSpecific`*"];
ClearAll["GroupMath`SpecialUnitaryGroups`*"];

Get["GroupMath`PermutationGroup`"];
Get["GroupMath`LieAlgebras`"];
Get["GroupMath`GenericTools`"];
Get["GroupMath`HEPSpecific`"];
Get["GroupMath`SpecialUnitaryGroups`"];
*)
