(* Content-type: application/vnd.wolfram.mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 12.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       158,          7]
NotebookDataLength[     24844,        675]
NotebookOptionsPosition[     18051,        528]
NotebookOutlinePosition[     20411,        588]
CellTagsIndexPosition[     20326,        583]
WindowTitle->DominantConjugate
WindowFrame->Normal*)

(* Beginning of Notebook Content *)
Notebook[{
Cell[BoxData[GridBox[{
   {Cell["GROUP MATH SYMBOL", "PacletNameCell",ExpressionUUID->
     "fa6dd474-e3ca-4115-8b31-eab0149dc730"], Cell[TextData[{
     Cell[BoxData[
      ActionMenuBox[
       FrameBox[
        InterpretationBox[Cell[TextData[{
          "Tutorials",
          StyleBox[" \[FilledDownTriangle]", "AnchorBarArrow",
           StripOnInput->False]
         }],ExpressionUUID->"ca20bb72-b5e3-4c1b-8d48-6e9d105a5c39"],
         TextCell[
          Row[{"Tutorials", 
            Style[" \[FilledDownTriangle]", "AnchorBarArrow"]}]]],
        StripOnInput->False], {"\<\"GroupMath Tutorial\"\>":>
       Documentation`HelpLookup["paclet:GroupMath/tutorial/GroupMathDoc"]},
       Appearance->None,
       MenuAppearance->Automatic,
       MenuStyle->"Tutorials"]],
      LineSpacing->{1.4, 0},ExpressionUUID->
      "7ce15ae5-9b83-4178-adb3-75057eaac663"],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      ActionMenuBox[
       FrameBox[
        InterpretationBox[Cell[TextData[{
          "See Also",
          StyleBox[" \[FilledDownTriangle]", "AnchorBarArrow",
           StripOnInput->False]
         }],ExpressionUUID->"04212938-5fc0-49ca-b767-9b2273e82539"],
         TextCell[
          Row[{"See Also", 
            Style[" \[FilledDownTriangle]", "AnchorBarArrow"]}]]],
        StripOnInput->False], {"\<\"CartanMatrix\"\>":>
       Documentation`HelpLookup[
       "paclet:GroupMath/ref/CartanMatrix"], "\<\"DominantWeights\"\>":>
       Documentation`HelpLookup[
       "paclet:GroupMath/ref/DominantWeights"], "\<\"ReflectWeights\"\>":>
       Documentation`HelpLookup[
       "paclet:GroupMath/ref/ReflectWeights"], "\<\"WeylOrbit\"\>":>
       Documentation`HelpLookup[
       "paclet:GroupMath/ref/WeylOrbit"], "\<\"Weights\"\>":>
       Documentation`HelpLookup["paclet:GroupMath/ref/Weights"]},
       Appearance->None,
       MenuAppearance->Automatic,
       MenuStyle->"SeeAlso"]],
      LineSpacing->{1.4, 0},ExpressionUUID->
      "fadf31ac-d01b-4f83-afba-bb831140dc19"],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      ActionMenuBox[
       FrameBox[
        InterpretationBox[Cell[TextData[{
          "URL",
          StyleBox[" \[FilledDownTriangle]", "AnchorBarArrow",
           StripOnInput->False]
         }],ExpressionUUID->"d6db9ad5-780f-42a5-a9c5-7444694a52e2"],
         TextCell[
          Row[{"URL", 
            Style[" \[FilledDownTriangle]", "AnchorBarArrow"]}]]],
        StripOnInput->False], {"\<\"GroupMath/ref/DominantConjugate\"\>":>
       None, "\<\"Copy Wolfram Documentation Center URL\"\>":>
       Module[{DocumentationSearch`Private`nb$}, 
        DocumentationSearch`Private`nb$ = NotebookPut[
           Notebook[{
             Cell["GroupMath/ref/DominantConjugate"]}, Visible -> False]]; 
        SelectionMove[DocumentationSearch`Private`nb$, All, Notebook]; 
        FrontEndTokenExecute[DocumentationSearch`Private`nb$, "Copy"]; 
        NotebookClose[DocumentationSearch`Private`nb$]; Null], 
       Delimiter, "\<\"Copy web URL\"\>":>
       Module[{DocumentationSearch`Private`nb$}, 
        DocumentationSearch`Private`nb$ = NotebookPut[
           Notebook[{
             Cell[
              BoxData[
               MakeBoxes[
                Hyperlink[
                "http://reference.wolfram.com/language/GroupMath/ref/\
DominantConjugate.html"], StandardForm]], "Input", TextClipboardType -> 
              "PlainText"]}, Visible -> False]]; 
        SelectionMove[DocumentationSearch`Private`nb$, All, Notebook]; 
        FrontEndTokenExecute[DocumentationSearch`Private`nb$, "Copy"]; 
        NotebookClose[DocumentationSearch`Private`nb$]; 
        Null], "\<\"Go to web URL\"\>":>FrontEndExecute[{
         NotebookLocate[{
           URL[
            StringJoin[
             If[
              TrueQ[DocumentationBuild`Make`Private`wsmlinkQ$14995], 
              "http://reference.wolfram.com/system-modeler/", 
              "http://reference.wolfram.com/language/"], 
             "GroupMath/ref/DominantConjugate", ".html"]], None}]}]},
       Appearance->None,
       MenuAppearance->Automatic,
       MenuStyle->"URLMenu"]],
      LineSpacing->{1.4, 0},ExpressionUUID->
      "4372f888-5f41-486d-8a65-49abea1fae2e"]
    }], "AnchorBar",ExpressionUUID->"f4468806-c5ce-46e1-a13c-35980e824704"]}
  }]], "AnchorBarGrid",
 CellID->1,ExpressionUUID->"81d18fb5-c8e5-434f-b46b-160433257a6a"],

Cell[CellGroupData[{

Cell[TextData[{
 Cell["DominantConjugate", "ObjectName",ExpressionUUID->
  "45273fe6-06a2-4796-8683-1fbadc447570"],
 Cell[BoxData[
  TemplateBox[{8},
   "Spacer1"]],ExpressionUUID->"81bc3fcc-138b-4e18-b3af-05bdadc8d894"],
 Cell[BoxData[
 ""], "ObjectNameTranslation",ExpressionUUID->
  "8be92551-f296-496a-b5f4-89578ae67954"]
}], "ObjectNameGrid",ExpressionUUID->"02204b9c-f304-4505-9d8a-2129cb730a22"],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{"DominantConjugate", "[", 
       RowBox[{"group", ",", " ", "weight"}], "]"}]], "InlineFormula",
      ExpressionUUID->"a907763e-4885-4101-9e82-edb9e691f99d"],
     " \[LineSeparator]Calculates the dominant weight associated with a ",
     Cell[BoxData[
     "weight"], "InlineFormula",ExpressionUUID->
      "7dfe7294-012e-4482-b725-097f76b33f06"],
     " of a simple Lie group representation by Weyl reflections, as well as \
the minimum number of such reflections"
    }],ExpressionUUID->"2737c757-c052-4817-8c82-655d0ac21d98"]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{"Columns" -> {{None}}, "Rows" -> {{None}}}},
 CellID->982511436,ExpressionUUID->"57361aa6-e68e-4124-8da1-85958abdedf7"]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[Cell[TextData[{
   Cell[BoxData[
    TemplateBox[{6},
     "Spacer1"]],ExpressionUUID->"b1123a6c-20fd-4f9f-8bdb-558a6a041dc2"],
   "Details"
  }], "NotesFrameText",ExpressionUUID->"22412335-18ea-4f7f-b959-78c9bb16ad9a"],
  Appearance->{Automatic, None, "Normal", Automatic},
  BaseStyle->None,
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"], 
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], After, CellContents]}]& ),
  Evaluator->None,
  Method->
   "Preemptive"]],ExpressionUUID->"8f7dd3e9-7c11-4915-a465-37fb730f5992"]], \
"NotesSection",
 WholeCellGroupOpener->True,
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->171973117,ExpressionUUID->"8d2a354c-fa8d-46db-8a16-4af54aa2efdb"],

Cell["", "SectionHeaderSpacer",ExpressionUUID->"94512b9a-480e-4084-956a-318502b484fc"],

Cell[TextData[{
 Cell[BoxData[
 "group"], "InlineFormula",ExpressionUUID->
  "9ec5c312-baf1-446f-b641-cfea9b653017"],
 " should a ",
 ButtonBox["Cartan matrix",
  BaseStyle->"Link",
  ButtonData->"paclet:GroupMath/ref/CartanMatrix"],
 ButtonBox[".",
  BaseStyle->"Link",
  ButtonData->"paclet:Susyno/ref/CartanMatrix"]
}], "Notes",
 CellID->1067943069,ExpressionUUID->"8aafacdd-c0fb-4599-bef0-a73dfbe171bb"],

Cell[TextData[{
 "The dominant weights are those whose Dynkin coefficients are all \
non-negative (see ",
 Cell[BoxData[
  TemplateBox[{Cell[
     TextData["DominantWeights"]],"paclet:GroupMath/ref/DominantWeights"},
   "RefLink",
   BaseStyle->{"InlineFormula"}]], "InlineFormula",ExpressionUUID->
  "7f0f51f3-75ff-43b0-9eaa-fc2c8760a99a"],
 ")."
}], "Notes",
 CellID->344864045,ExpressionUUID->"865aaf92-1e2f-456e-a750-94477b8e1d9f"],

Cell[TextData[{
 "Through a sequence of Weyl reflections (see ",
 Cell[BoxData[
  TemplateBox[{Cell[
     TextData["ReflectWeight"]],"paclet:GroupMath/ref/ReflectWeight"},
   "RefLink",
   BaseStyle->{"InlineFormula"}]], "InlineFormula",ExpressionUUID->
  "0b033a00-ac90-4911-8ceb-8b42290530ea"],
 "), it is possible to transform any weight into a dominant one. This \
function returns ",
 Cell[BoxData[
  RowBox[{"{", 
   RowBox[{
    RowBox[{"dominant", " ", "weight"}], ",", " ", "level"}], "}"}]], 
  "InlineFormula",ExpressionUUID->"0055998c-e8ae-4621-87d8-c65a22f20fa3"],
 ", where ",
 Cell[BoxData[
 "level"], "InlineFormula",ExpressionUUID->
  "3cbd9feb-6cea-41c5-8983-0b54cc4e447d"],
 " is the minimum number of reflections required."
}], "Notes",
 CellID->5853894,ExpressionUUID->"97b9add6-93f4-499c-9a33-7c51b3322b7e"],

Cell[TextData[{
 "This function follows the algorithm in \"",
 StyleBox["D. Snow, Weyl group orbits, ACM Trans. Math. Software 16 (1990), \
94-108.", "TI"],
 "\""
}], "Notes",
 CellID->57185730,ExpressionUUID->"4470c551-c262-4e72-b5ac-9973131665b6"],

Cell["", "SectionFooterSpacer",ExpressionUUID->"0ae975b7-faac-4fd3-8539-14629149860b"]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[{
 Cell[BoxData[
  TemplateBox[{6},
   "Spacer1"]],ExpressionUUID->"78184d9b-d9cf-48e9-af1d-23b47c4872f9"],
 "Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(1)", "ExampleCount",ExpressionUUID->
  "11689674-4e7a-476e-aa5e-974200436b27"]
}], "PrimaryExamplesSection",
 WholeCellGroupOpener->True,
 CellTags->"PrimaryExamplesSection",
 CellID->3650558,ExpressionUUID->"d394af94-1eed-4546-b462-40acdcf2de02"],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(1)", "ExampleCount",ExpressionUUID->
  "9fd8cb69-ccaa-498b-9a2f-7f406c90ab56"]
}], "ExampleSection", "ExampleSection",
 WholeCellGroupOpener->True,
 CellID->209924735,ExpressionUUID->"e542be79-cb08-41a2-8f46-adca2ecd6f01"],

Cell["\<\
Consider the non-dominant weight {3,-1}, which is conjugate to the dominant \
weight {1,2}:\
\>", "ExampleText",
 CellID->344054462,ExpressionUUID->"e921d5da-57af-4b64-be82-934c595cc0f6"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"DominantConjugate", "[", 
  RowBox[{"SU3", ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"-", "3"}], ",", "1"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->51795859,ExpressionUUID->"239de1cb-40d1-41f8-b742-f1035828a826"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"1", ",", "2"}], "}"}], ",", "2"}], "}"}]], "Output",
 CellLabel->"Out[1]=",
 CellID->24593025,ExpressionUUID->"3b50ea6b-a8ff-4281-822a-04ba389bba12"]
}, Open  ]],

Cell["\<\
It takes 2 Weyl reflections to get from w={-3,1} to w'={1,2}. Given that the \
rank of SU(3) is 2, we can have two reflections, R1 and R2, so there are 4 \
possibilities: R1(R1(w)), R1(R2(w)), R2(R1(w)) and R2(R2(w)).\
\>", "ExampleText",
 CellID->17175475,ExpressionUUID->"cf8b8fe7-d9f6-47c2-b7a7-83b22bb691f8"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"(*", " ", 
   RowBox[{"possibility", " ", "1"}], " ", "*)"}], "\[IndentingNewLine]", 
  RowBox[{
   RowBox[{"ReflectWeight", "[", 
    RowBox[{"SU3", ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "3"}], ",", "1"}], "}"}], ",", "1"}], "]"}], 
   "\[IndentingNewLine]", 
   RowBox[{"ReflectWeight", "[", 
    RowBox[{"SU3", ",", "%", ",", "1"}], "]"}]}]}]], "Input",
 CellLabel->"In[2]:=",
 CellID->371016001,ExpressionUUID->"7588fb93-8cc0-4d99-9f5b-6c9f82ae31b2"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"3", ",", 
   RowBox[{"-", "2"}]}], "}"}]], "Output",
 CellLabel->"Out[2]=",
 CellID->25362818,ExpressionUUID->"4ab08649-18fd-4062-a189-40b68fbb8f3a"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"-", "3"}], ",", "1"}], "}"}]], "Output",
 CellLabel->"Out[2]=",
 CellID->123667056,ExpressionUUID->"51fc4c07-90f1-4c4e-a158-2f94a9962b20"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"(*", " ", 
   RowBox[{"possibility", " ", "2"}], " ", "*)"}], "\[IndentingNewLine]", 
  RowBox[{
   RowBox[{"ReflectWeight", "[", 
    RowBox[{"SU3", ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "3"}], ",", "1"}], "}"}], ",", "1"}], "]"}], 
   "\[IndentingNewLine]", 
   RowBox[{"ReflectWeight", "[", 
    RowBox[{"SU3", ",", "%", ",", "2"}], "]"}]}]}]], "Input",
 CellLabel->"In[3]:=",
 CellID->489344400,ExpressionUUID->"8d49a972-a460-4f1d-82e4-c9ea7cc19fe3"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"3", ",", 
   RowBox[{"-", "2"}]}], "}"}]], "Output",
 CellLabel->"Out[3]=",
 CellID->221592782,ExpressionUUID->"3b3e271a-ec9b-45e9-820e-3a8985b56ede"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"1", ",", "2"}], "}"}]], "Output",
 CellLabel->"Out[3]=",
 CellID->215537425,ExpressionUUID->"9f9761e0-0071-4cfa-8e20-526488b02f0c"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"\[IndentingNewLine]", 
  RowBox[{"(*", " ", 
   RowBox[{"possibility", " ", "3"}], " ", "*)"}], "\[IndentingNewLine]", 
  RowBox[{
   RowBox[{"ReflectWeight", "[", 
    RowBox[{"SU3", ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "3"}], ",", "1"}], "}"}], ",", "2"}], "]"}], 
   "\[IndentingNewLine]", 
   RowBox[{"ReflectWeight", "[", 
    RowBox[{"SU3", ",", "%", ",", "1"}], "]"}]}]}]], "Input",
 CellLabel->"In[4]:=",
 CellID->37169474,ExpressionUUID->"864db86a-d6f9-4cca-bd83-0b97c91f206c"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"-", "2"}], ",", 
   RowBox[{"-", "1"}]}], "}"}]], "Output",
 CellLabel->"Out[4]=",
 CellID->577413977,ExpressionUUID->"752ee104-7527-4486-95b4-9af9ccccc825"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"2", ",", 
   RowBox[{"-", "3"}]}], "}"}]], "Output",
 CellLabel->"Out[4]=",
 CellID->40667243,ExpressionUUID->"0cdb2dff-c278-4864-841b-f61c8e5e1ab7"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"(*", " ", 
   RowBox[{"possibility", " ", "4"}], " ", "*)"}], "\[IndentingNewLine]", 
  RowBox[{
   RowBox[{"ReflectWeight", "[", 
    RowBox[{"SU3", ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "3"}], ",", "1"}], "}"}], ",", "2"}], "]"}], 
   "\[IndentingNewLine]", 
   RowBox[{"ReflectWeight", "[", 
    RowBox[{"SU3", ",", "%", ",", "2"}], "]"}]}]}]], "Input",
 CellLabel->"In[5]:=",
 CellID->550882064,ExpressionUUID->"2c8a118a-8447-448c-b008-06e50728073f"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"-", "2"}], ",", 
   RowBox[{"-", "1"}]}], "}"}]], "Output",
 CellLabel->"Out[5]=",
 CellID->152410159,ExpressionUUID->"8bac8f78-73ca-4655-a0fb-da9fef3820e8"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"-", "3"}], ",", "1"}], "}"}]], "Output",
 CellLabel->"Out[5]=",
 CellID->636169064,ExpressionUUID->"6cc4647e-1ee1-4525-b30d-d7ed09edd74b"]
}, Open  ]],

Cell["We see that w'=R1(R2(w)).", "ExampleText",
 CellID->807442745,ExpressionUUID->"c0e19098-1222-4c53-a04c-43ceebd42a39"]
}, Open  ]],

Cell["", "SectionFooterSpacer",ExpressionUUID->"8aa0f65a-2abc-4732-9f48-6f9a92278bf4"]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[{
 Cell[BoxData[
  TemplateBox[{6},
   "Spacer1"]],ExpressionUUID->"cf9e278c-2e72-4d7d-93a9-9056af826eb1"],
 "See Also"
}], "SeeAlsoSection",
 WholeCellGroupOpener->True,
 CellID->1255426704,ExpressionUUID->"d1f5273c-e37f-46b7-b8f3-fea75319e348"],

Cell[TextData[{
 Cell[BoxData[
  TemplateBox[{Cell[
     TextData["CartanMatrix"]],"paclet:GroupMath/ref/CartanMatrix"},
   "RefLink",
   BaseStyle->{"InlineFormula", FontFamily -> "Verdana"}]], "InlineFormula",
  ExpressionUUID->"e226476c-53ef-4f36-8648-ae1136369b8a"],
 "\[NonBreakingSpace]",
 StyleBox["\[MediumSpace]\[FilledVerySmallSquare]\[MediumSpace]", 
  "InlineSeparator"],
 " ",
 Cell[BoxData[
  TemplateBox[{Cell[
     TextData["DominantWeights"]],"paclet:GroupMath/ref/DominantWeights"},
   "RefLink",
   BaseStyle->{"InlineFormula", FontFamily -> "Verdana"}]], "InlineFormula",
  ExpressionUUID->"7bdad77d-035a-4494-b860-621b61deaf52"],
 "\[NonBreakingSpace]",
 StyleBox["\[MediumSpace]\[FilledVerySmallSquare]\[MediumSpace]", 
  "InlineSeparator"],
 " ",
 Cell[BoxData[
  TemplateBox[{Cell[
     TextData["ReflectWeights"]],"paclet:GroupMath/ref/ReflectWeights"},
   "RefLink",
   BaseStyle->{"InlineFormula", FontFamily -> "Verdana"}]], "InlineFormula",
  ExpressionUUID->"ad9874d8-dedd-4911-b385-ec4d27aa905e"],
 "\[NonBreakingSpace]",
 StyleBox["\[MediumSpace]\[FilledVerySmallSquare]\[MediumSpace]", 
  "InlineSeparator"],
 " ",
 Cell[BoxData[
  TemplateBox[{Cell[
     TextData["WeylOrbit"]],"paclet:GroupMath/ref/WeylOrbit"},
   "RefLink",
   BaseStyle->{"InlineFormula", FontFamily -> "Verdana"}]], "InlineFormula",
  ExpressionUUID->"a66e1ded-5d7d-4e10-bc0c-95fab9b8d61e"],
 "\[NonBreakingSpace]",
 StyleBox["\[MediumSpace]\[FilledVerySmallSquare]\[MediumSpace]", 
  "InlineSeparator"],
 " ",
 Cell[BoxData[
  TemplateBox[{Cell[
     TextData["Weights"]],"paclet:GroupMath/ref/Weights"},
   "RefLink",
   BaseStyle->{"InlineFormula", FontFamily -> "Verdana"}]], "InlineFormula",
  ExpressionUUID->"56397d1c-a470-40b1-baf6-55725db8a9b7"]
}], "SeeAlso",
 CellID->1038487239,ExpressionUUID->"1c6aa2a3-6e14-4cdb-9358-ee7bff83adcf"]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[{
 Cell[BoxData[
  TemplateBox[{6},
   "Spacer1"]],ExpressionUUID->"ac5d85ea-8d32-4f98-a554-0fb75a1f54d0"],
 "Tutorials"
}], "TutorialsSection",
 WholeCellGroupOpener->True,
 CellID->250839057,ExpressionUUID->"5ee7cf2e-000d-44fe-a2ec-a8f760fd9f41"],

Cell["", "SectionHeaderSpacer",ExpressionUUID->"4314ab90-68c0-4283-b762-8ea4d9961c58"],

Cell[BoxData[
 TemplateBox[{Cell[
    TextData["GroupMath Tutorial"]],"paclet:GroupMath/tutorial/GroupMathDoc"},
  "RefLink",
  BaseStyle->"Tutorials"]], "Tutorials",
 CellID->341631938,ExpressionUUID->"4263e1d0-7a75-4322-811f-36c25f308fc7"]
}, Open  ]],

Cell[" ", "FooterCell",ExpressionUUID->"4763bcf5-6e4a-46f0-95e4-dfb513cb3a44"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"DominantConjugate",
TaggingRules->{
 "ModificationHighlight" -> False, "ColorType" -> "SymbolColor", "LinkTrails" -> 
  GridBox[{{
      RowBox[{
        ButtonBox[
        "Mathematica", ButtonData -> "paclet:GroupMath/guide/GroupMath", 
         BaseStyle -> {"Link", "DockedLinkTrail"}]}]}}, ColumnAlignments -> 
    Left], "HasOptions" -> False, "ExampleCounter" -> 1, "NeedPlatMsgIn" -> 
  None, "RootCaptions" -> "", 
  "Metadata" -> {
   "built" -> "{2020, 11, 4, 11, 38, 55.9146671}", 
    "history" -> {"1.0", "", "", ""}, "context" -> "GroupMath`", 
    "keywords" -> {}, "specialkeywords" -> {}, 
    "tutorialcollectionlinks" -> {}, "index" -> True, "label" -> 
    "Group Math Symbol", "language" -> "en", "paclet" -> "GroupMath", 
    "status" -> "None", "summary" -> 
    "DominantConjugate[group, weight] Calculates the dominant weight \
associated with a weight of a simple Lie group representation by Weyl \
reflections, as well as the minimum number of such reflections", 
    "synonyms" -> {}, "tabletags" -> {}, "title" -> "DominantConjugate", 
    "titlemodifier" -> "", "windowtitle" -> "DominantConjugate", "type" -> 
    "Symbol", "uri" -> "GroupMath/ref/DominantConjugate", 
    "WorkflowDockedCell" -> ""}, "SearchTextTranslated" -> "", "NewStyles" -> 
  False},
CellContext->"Global`",
FrontEndVersion->"12.0 for Microsoft Windows (64-bit) (April 8, 2019)",
StyleDefinitions->Notebook[{
   Cell[
    StyleData[
    StyleDefinitions -> FrontEnd`FileName[{"Wolfram"}, "Reference.nb"]]], 
   Cell[
    StyleData["Input"], CellContext -> "Global`"], 
   Cell[
    StyleData["Output"], CellContext -> "Global`"]}, Visible -> False, 
  TaggingRules -> {"NewStyles" -> False}, FrontEndVersion -> 
  "12.0 for Microsoft Windows (64-bit) (April 8, 2019)", StyleDefinitions -> 
  "Default.nb"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[9358, 246, 433, 11, 35, "PrimaryExamplesSection",ExpressionUUID->"d394af94-1eed-4546-b462-40acdcf2de02",
   CellTags->"PrimaryExamplesSection",
   CellID->3650558]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 20130, 576}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[589, 21, 4512, 101, 53, "AnchorBarGrid",ExpressionUUID->"81d18fb5-c8e5-434f-b46b-160433257a6a",
 CellID->1],
Cell[CellGroupData[{
Cell[5126, 126, 402, 9, 52, "ObjectNameGrid",ExpressionUUID->"02204b9c-f304-4505-9d8a-2129cb730a22"],
Cell[5531, 137, 788, 16, 131, "Usage",ExpressionUUID->"57361aa6-e68e-4124-8da1-85958abdedf7",
 CellID->982511436]
}, Open  ]],
Cell[CellGroupData[{
Cell[6356, 158, 855, 21, 37, "NotesSection",ExpressionUUID->"8d2a354c-fa8d-46db-8a16-4af54aa2efdb",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->171973117],
Cell[7214, 181, 86, 0, 70, "SectionHeaderSpacer",ExpressionUUID->"94512b9a-480e-4084-956a-318502b484fc"],
Cell[7303, 183, 407, 12, 70, "Notes",ExpressionUUID->"8aafacdd-c0fb-4599-bef0-a73dfbe171bb",
 CellID->1067943069],
Cell[7713, 197, 435, 11, 70, "Notes",ExpressionUUID->"865aaf92-1e2f-456e-a750-94477b8e1d9f",
 CellID->344864045],
Cell[8151, 210, 829, 21, 70, "Notes",ExpressionUUID->"97b9add6-93f4-499c-9a33-7c51b3322b7e",
 CellID->5853894],
Cell[8983, 233, 249, 6, 70, "Notes",ExpressionUUID->"4470c551-c262-4e72-b5ac-9973131665b6",
 CellID->57185730],
Cell[9235, 241, 86, 0, 70, "SectionFooterSpacer",ExpressionUUID->"0ae975b7-faac-4fd3-8539-14629149860b"]
}, Closed]],
Cell[CellGroupData[{
Cell[9358, 246, 433, 11, 35, "PrimaryExamplesSection",ExpressionUUID->"d394af94-1eed-4546-b462-40acdcf2de02",
 CellTags->"PrimaryExamplesSection",
 CellID->3650558],
Cell[CellGroupData[{
Cell[9816, 261, 308, 7, 29, "ExampleSection",ExpressionUUID->"e542be79-cb08-41a2-8f46-adca2ecd6f01",
 CellID->209924735],
Cell[10127, 270, 197, 4, 38, "ExampleText",ExpressionUUID->"e921d5da-57af-4b64-be82-934c595cc0f6",
 CellID->344054462],
Cell[CellGroupData[{
Cell[10349, 278, 262, 7, 26, "Input",ExpressionUUID->"239de1cb-40d1-41f8-b742-f1035828a826",
 CellID->51795859],
Cell[10614, 287, 219, 6, 35, "Output",ExpressionUUID->"3b50ea6b-a8ff-4281-822a-04ba389bba12",
 CellID->24593025]
}, Open  ]],
Cell[10848, 296, 322, 5, 76, "ExampleText",ExpressionUUID->"cf8b8fe7-d9f6-47c2-b7a7-83b22bb691f8",
 CellID->17175475],
Cell[CellGroupData[{
Cell[11195, 305, 511, 14, 59, "Input",ExpressionUUID->"7588fb93-8cc0-4d99-9f5b-6c9f82ae31b2",
 CellID->371016001],
Cell[11709, 321, 189, 5, 35, "Output",ExpressionUUID->"4ab08649-18fd-4062-a189-40b68fbb8f3a",
 CellID->25362818],
Cell[11901, 328, 190, 5, 35, "Output",ExpressionUUID->"51fc4c07-90f1-4c4e-a158-2f94a9962b20",
 CellID->123667056]
}, Open  ]],
Cell[CellGroupData[{
Cell[12128, 338, 511, 14, 59, "Input",ExpressionUUID->"8d49a972-a460-4f1d-82e4-c9ea7cc19fe3",
 CellID->489344400],
Cell[12642, 354, 190, 5, 35, "Output",ExpressionUUID->"3b3e271a-ec9b-45e9-820e-3a8985b56ede",
 CellID->221592782],
Cell[12835, 361, 171, 4, 35, "Output",ExpressionUUID->"9f9761e0-0071-4cfa-8e20-526488b02f0c",
 CellID->215537425]
}, Open  ]],
Cell[CellGroupData[{
Cell[13043, 370, 533, 14, 70, "Input",ExpressionUUID->"864db86a-d6f9-4cca-bd83-0b97c91f206c",
 CellID->37169474],
Cell[13579, 386, 209, 6, 35, "Output",ExpressionUUID->"752ee104-7527-4486-95b4-9af9ccccc825",
 CellID->577413977],
Cell[13791, 394, 189, 5, 35, "Output",ExpressionUUID->"0cdb2dff-c278-4864-841b-f61c8e5e1ab7",
 CellID->40667243]
}, Open  ]],
Cell[CellGroupData[{
Cell[14017, 404, 511, 14, 70, "Input",ExpressionUUID->"2c8a118a-8447-448c-b008-06e50728073f",
 CellID->550882064],
Cell[14531, 420, 209, 6, 35, "Output",ExpressionUUID->"8bac8f78-73ca-4655-a0fb-da9fef3820e8",
 CellID->152410159],
Cell[14743, 428, 190, 5, 35, "Output",ExpressionUUID->"6cc4647e-1ee1-4525-b30d-d7ed09edd74b",
 CellID->636169064]
}, Open  ]],
Cell[14948, 436, 123, 1, 70, "ExampleText",ExpressionUUID->"c0e19098-1222-4c53-a04c-43ceebd42a39",
 CellID->807442745]
}, Open  ]],
Cell[15086, 440, 86, 0, 70, "SectionFooterSpacer",ExpressionUUID->"8aa0f65a-2abc-4732-9f48-6f9a92278bf4"]
}, Open  ]],
Cell[CellGroupData[{
Cell[15209, 445, 260, 7, 70, "SeeAlsoSection",ExpressionUUID->"d1f5273c-e37f-46b7-b8f3-fea75319e348",
 CellID->1255426704],
Cell[15472, 454, 1850, 48, 70, "SeeAlso",ExpressionUUID->"1c6aa2a3-6e14-4cdb-9358-ee7bff83adcf",
 CellID->1038487239]
}, Open  ]],
Cell[CellGroupData[{
Cell[17359, 507, 262, 7, 70, "TutorialsSection",ExpressionUUID->"5ee7cf2e-000d-44fe-a2ec-a8f760fd9f41",
 CellID->250839057],
Cell[17624, 516, 86, 0, 70, "SectionHeaderSpacer",ExpressionUUID->"4314ab90-68c0-4283-b762-8ea4d9961c58"],
Cell[17713, 518, 241, 5, 70, "Tutorials",ExpressionUUID->"4263e1d0-7a75-4322-811f-36c25f308fc7",
 CellID->341631938]
}, Open  ]],
Cell[17969, 526, 78, 0, 70, "FooterCell",ExpressionUUID->"4763bcf5-6e4a-46f0-95e4-dfb513cb3a44"]
}
]
*)

(* End of internal cache information *)

