(* Content-type: application/vnd.wolfram.mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 12.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       158,          7]
NotebookDataLength[     25417,        692]
NotebookOptionsPosition[     18080,        533]
NotebookOutlinePosition[     20332,        591]
CellTagsIndexPosition[     20247,        586]
WindowTitle->ConjugacyClass
WindowFrame->Normal*)

(* Beginning of Notebook Content *)
Notebook[{
Cell[BoxData[GridBox[{
   {Cell["GROUP MATH SYMBOL", "PacletNameCell",ExpressionUUID->
     "1ccda642-8eb4-4755-a64f-a4ce6c04023c"], Cell[TextData[{
     Cell[BoxData[
      ActionMenuBox[
       FrameBox[
        InterpretationBox[Cell[TextData[{
          "Tutorials",
          StyleBox[" \[FilledDownTriangle]", "AnchorBarArrow",
           StripOnInput->False]
         }],ExpressionUUID->"af46e93d-8d25-4e2a-b720-f29a3cad33d7"],
         TextCell[
          Row[{"Tutorials", 
            Style[" \[FilledDownTriangle]", "AnchorBarArrow"]}]]],
        StripOnInput->False], {"\<\"GroupMath Tutorial\"\>":>
       Documentation`HelpLookup["paclet:GroupMath/tutorial/GroupMathDoc"]},
       Appearance->None,
       MenuAppearance->Automatic,
       MenuStyle->"Tutorials"]],
      LineSpacing->{1.4, 0},ExpressionUUID->
      "3a75e13e-5bfc-4f91-9951-012499007258"],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      ActionMenuBox[
       FrameBox[
        InterpretationBox[Cell[TextData[{
          "See Also",
          StyleBox[" \[FilledDownTriangle]", "AnchorBarArrow",
           StripOnInput->False]
         }],ExpressionUUID->"5cad946b-2c92-4002-9543-dbf3ebe65708"],
         TextCell[
          Row[{"See Also", 
            Style[" \[FilledDownTriangle]", "AnchorBarArrow"]}]]],
        StripOnInput->False], {"\<\"ConjugacyClassGroupModIndices\"\>":>
       Documentation`HelpLookup[
       "paclet:GroupMath/ref/ConjugacyClassGroupModIndices"], \
"\<\"CartanMatrix\"\>":>Documentation`HelpLookup[
       "paclet:GroupMath/ref/CartanMatrix"], "\<\"ReduceRepProduct\"\>":>
       Documentation`HelpLookup["paclet:GroupMath/ref/ReduceRepProduct"]},
       Appearance->None,
       MenuAppearance->Automatic,
       MenuStyle->"SeeAlso"]],
      LineSpacing->{1.4, 0},ExpressionUUID->
      "f2e2bd7e-99fd-46c1-9120-0e79c0acd15e"],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      ActionMenuBox[
       FrameBox[
        InterpretationBox[Cell[TextData[{
          "URL",
          StyleBox[" \[FilledDownTriangle]", "AnchorBarArrow",
           StripOnInput->False]
         }],ExpressionUUID->"ff42daf3-5f32-4b45-8164-bb6e3e88808a"],
         TextCell[
          Row[{"URL", 
            Style[" \[FilledDownTriangle]", "AnchorBarArrow"]}]]],
        StripOnInput->False], {"\<\"GroupMath/ref/ConjugacyClass\"\>":>
       None, "\<\"Copy Wolfram Documentation Center URL\"\>":>
       Module[{DocumentationSearch`Private`nb$}, 
        DocumentationSearch`Private`nb$ = NotebookPut[
           Notebook[{
             Cell["GroupMath/ref/ConjugacyClass"]}, Visible -> False]]; 
        SelectionMove[DocumentationSearch`Private`nb$, All, Notebook]; 
        FrontEndTokenExecute[DocumentationSearch`Private`nb$, "Copy"]; 
        NotebookClose[DocumentationSearch`Private`nb$]; Null], 
       Delimiter, "\<\"Copy web URL\"\>":>
       Module[{DocumentationSearch`Private`nb$}, 
        DocumentationSearch`Private`nb$ = NotebookPut[
           Notebook[{
             Cell[
              BoxData[
               MakeBoxes[
                Hyperlink[
                "http://reference.wolfram.com/language/GroupMath/ref/\
ConjugacyClass.html"], StandardForm]], "Input", TextClipboardType -> 
              "PlainText"]}, Visible -> False]]; 
        SelectionMove[DocumentationSearch`Private`nb$, All, Notebook]; 
        FrontEndTokenExecute[DocumentationSearch`Private`nb$, "Copy"]; 
        NotebookClose[DocumentationSearch`Private`nb$]; 
        Null], "\<\"Go to web URL\"\>":>FrontEndExecute[{
         NotebookLocate[{
           URL[
            StringJoin[
             If[
              TrueQ[DocumentationBuild`Make`Private`wsmlinkQ$11108], 
              "http://reference.wolfram.com/system-modeler/", 
              "http://reference.wolfram.com/language/"], 
             "GroupMath/ref/ConjugacyClass", ".html"]], None}]}]},
       Appearance->None,
       MenuAppearance->Automatic,
       MenuStyle->"URLMenu"]],
      LineSpacing->{1.4, 0},ExpressionUUID->
      "bc8aaca3-ce5a-4c1a-b28f-651fddd512dd"]
    }], "AnchorBar",ExpressionUUID->"00bfd7bd-2417-42be-929c-239e4aca10c8"]}
  }]], "AnchorBarGrid",
 CellID->1,ExpressionUUID->"158dcbaf-ffb2-4c26-a404-358fe477505b"],

Cell[CellGroupData[{

Cell[TextData[{
 Cell["ConjugacyClass", "ObjectName",ExpressionUUID->
  "666b4cdf-4953-4bdc-9d3a-06d774f580e5"],
 Cell[BoxData[
  TemplateBox[{8},
   "Spacer1"]],ExpressionUUID->"b8dd9e79-d8b7-4802-a3ca-8314c308fd70"],
 Cell[BoxData[
 ""], "ObjectNameTranslation",ExpressionUUID->
  "4a57bc2f-9647-47b5-8d33-d102759050f3"]
}], "ObjectNameGrid",ExpressionUUID->"457fd3a2-5443-4ac2-a66a-aff28c31fc93"],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{"ConjugacyClass", "[", 
       RowBox[{"group", ",", "represention"}], "]"}]], "InlineFormula",
      ExpressionUUID->"4ebcc30c-58c0-458b-8fd4-69c7f4b20b39"],
     " \[LineSeparator]Computes the conjugacy class of a representation of a \
simple Lie group"
    }],ExpressionUUID->"6b25a3a1-b792-4b83-945e-bf3f5741762f"]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{"Columns" -> {{None}}, "Rows" -> {{None}}}},
 CellID->982511436,ExpressionUUID->"ba4993d9-ee00-47cf-af8d-73ed5ecd2361"]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[Cell[TextData[{
   Cell[BoxData[
    TemplateBox[{6},
     "Spacer1"]],ExpressionUUID->"f8c6e366-4ef9-4238-8819-948e6eb661c5"],
   "Details"
  }], "NotesFrameText",ExpressionUUID->"ad57ae34-cb00-4bcf-a2ff-580fd7bf72b9"],
  Appearance->{Automatic, None, "Normal", Automatic},
  BaseStyle->None,
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"], 
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], After, CellContents]}]& ),
  Evaluator->None,
  Method->
   "Preemptive"]],ExpressionUUID->"622910ef-0cba-4d1e-9aca-a16f90109d8a"]], \
"NotesSection",
 WholeCellGroupOpener->True,
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->9481487,ExpressionUUID->"0431a63f-c75d-4b9f-85d6-948ef66eea20"],

Cell["", "SectionHeaderSpacer",ExpressionUUID->"d962749c-099c-478e-ba56-c38dc780bc5b"],

Cell[TextData[{
 Cell[BoxData[
 "group"], "InlineFormula",ExpressionUUID->
  "06670010-03fa-48d3-8ddb-1435f3af55e5"],
 " should a ",
 ButtonBox["Cartan matrix",
  BaseStyle->"Link",
  ButtonData->"paclet:GroupMath/ref/CartanMatrix"],
 ButtonBox[".",
  BaseStyle->"Link",
  ButtonData->"paclet:Susyno/ref/CartanMatrix"]
}], "Notes",
 CellID->1067943069,ExpressionUUID->"9054a685-da39-4305-958f-2a3aea807a35"],

Cell[TextData[{
 Cell[BoxData[
 "representation"], "InlineFormula",ExpressionUUID->
  "f49d0dcf-ec9b-48f6-84ab-d9cf3e565fe4"],
 " should be a list of non-negative integers (Dynkin coefficients). It is \
also possible to use the simplified input format for representations (see the \
",
 ButtonBox["GroupMath tutorial",
  BaseStyle->"Link",
  ButtonData->"paclet:GroupMath/tutorial/GroupMathDoc"],
 " page)."
}], "Notes",
 CellID->322001788,ExpressionUUID->"225dbd8c-cef0-46df-b8b4-09eeac092a44"],

Cell["\<\
The output is a list of natural numbers which uniquely identify the conjugacy \
class. In fact for almost all groups, the result consists of a list with a \
single number, except for the SO(2m) groups for which two integers are given.\
\>", "Notes",
 CellID->66919531,ExpressionUUID->"32b4797f-62ca-41bd-8852-fdf3b5b64053"],

Cell["", "SectionFooterSpacer",ExpressionUUID->"15dad314-7874-4041-bf85-f8f412f0884d"]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[{
 Cell[BoxData[
  TemplateBox[{6},
   "Spacer1"]],ExpressionUUID->"8bca8e0e-51ac-4c12-a920-74c2018dccd5"],
 "Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(2)", "ExampleCount",ExpressionUUID->
  "5ef5c04e-ba11-471f-a7c8-518a833eaa39"]
}], "PrimaryExamplesSection",
 WholeCellGroupOpener->True,
 CellTags->"PrimaryExamplesSection",
 CellID->16080189,ExpressionUUID->"75e0c2c8-0d18-4138-a159-82d9c2faecc1"],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(2)", "ExampleCount",ExpressionUUID->
  "8ab0623e-aa16-42d4-91b6-2ef7c17c7da1"]
}], "ExampleSection", "ExampleSection",
 WholeCellGroupOpener->True,
 CellID->300355269,ExpressionUUID->"5f247e22-c0a8-4f25-a208-61721b4369da"],

Cell["\<\
SU(3) representation can be in on of three classes (the group has a \
'triality' property):\
\>", "ExampleText",
 CellID->14658346,ExpressionUUID->"0db0ecbb-4257-4fd1-9efd-957d67eff458"],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{"ConjugacyClass", "[", 
  RowBox[{"SU3", ",", 
   RowBox[{"{", 
    RowBox[{"0", ",", "1"}], "}"}]}], "]"}], "\[IndentingNewLine]", 
 RowBox[{"ConjugacyClass", "[", 
  RowBox[{"SU3", ",", 
   RowBox[{"{", 
    RowBox[{"1", ",", "0"}], "}"}]}], "]"}], "\[IndentingNewLine]", 
 RowBox[{"ConjugacyClass", "[", 
  RowBox[{"SU3", ",", 
   RowBox[{"{", 
    RowBox[{"1", ",", "1"}], "}"}]}], "]"}]}], "Input",
 CellLabel->"In[1]:=",
 CellID->430153659,ExpressionUUID->"9fe45566-5ab1-4613-af5a-7d35c8ffbca8"],

Cell[BoxData[
 RowBox[{"{", "2", "}"}]], "Output",
 CellLabel->"Out[1]=",
 CellID->60234413,ExpressionUUID->"e63204b2-9ef8-497f-b04f-e35ffabda198"],

Cell[BoxData[
 RowBox[{"{", "1", "}"}]], "Output",
 CellLabel->"Out[1]=",
 CellID->64438071,ExpressionUUID->"dc3f1dac-f049-49a5-b48f-3e69071cfb80"],

Cell[BoxData[
 RowBox[{"{", "0", "}"}]], "Output",
 CellLabel->"Out[1]=",
 CellID->747613126,ExpressionUUID->"778f8cc6-5279-49d0-9960-3c00b199e0b8"]
}, Open  ]],

Cell[TextData[{
 "Why is this useful? For example, the product of SU(3) representations are \
the class given by the sum of the classes of the factors, modulus 3 (this \
number is given by the function ",
 Cell[BoxData[
  TemplateBox[{Cell[
     TextData["ConjugacyClassGroupModIndices"]],
    "paclet:GroupMath/ref/ConjugacyClassGroupModIndices"},
   "RefLink",
   BaseStyle->{"InlineFormula"}]], "InlineFormula",ExpressionUUID->
  "8b0dfb47-be7a-4cda-8187-2cdbdae00827"],
 ")."
}], "ExampleText",
 CellID->94118532,ExpressionUUID->"f51a767d-7471-4a7b-8e04-8c677b72363d"],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"sumOfClasses", "=", 
   RowBox[{
    RowBox[{"ConjugacyClass", "[", 
     RowBox[{"SU3", ",", 
      RowBox[{"{", 
       RowBox[{"0", ",", "1"}], "}"}]}], "]"}], "+", 
    RowBox[{"ConjugacyClass", "[", 
     RowBox[{"SU3", ",", 
      RowBox[{"{", 
       RowBox[{"0", ",", "1"}], "}"}]}], "]"}], "+", 
    RowBox[{"ConjugacyClass", "[", 
     RowBox[{"SU3", ",", 
      RowBox[{"{", 
       RowBox[{"1", ",", "0"}], "}"}]}], "]"}]}]}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{"sumOfClassesMod3", "=", 
  RowBox[{"Mod", "[", 
   RowBox[{"sumOfClasses", ",", "3"}], "]"}]}]}], "Input",
 CellLabel->"In[2]:=",
 CellID->582423663,ExpressionUUID->"2eed6043-bffe-4346-9642-33e68b50d428"],

Cell[BoxData[
 RowBox[{"{", "5", "}"}]], "Output",
 CellLabel->"Out[2]=",
 CellID->46161651,ExpressionUUID->"2bb63ce7-8c0f-4719-bbef-fb662debd0da"],

Cell[BoxData[
 RowBox[{"{", "2", "}"}]], "Output",
 CellLabel->"Out[2]=",
 CellID->425888645,ExpressionUUID->"abd9c66b-150c-426b-a67e-98a0a45d8748"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ReduceRepProduct", "[", 
  RowBox[{"SU3", ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"0", ",", "1"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0", ",", "1"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"1", ",", "0"}], "}"}]}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->211409023,ExpressionUUID->"1656e2ba-f63e-4631-bcd9-b3be9a848345"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"1", ",", "2"}], "}"}], ",", "1"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"0", ",", "1"}], "}"}], ",", "2"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"2", ",", "0"}], "}"}], ",", "1"}], "}"}]}], "}"}]], "Output",
 CellLabel->"Out[3]=",
 CellID->258597991,ExpressionUUID->"a73c803f-9def-4dbf-ac02-e40337cf4623"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{"ConjugacyClass", "[", 
  RowBox[{"SU3", ",", 
   RowBox[{"{", 
    RowBox[{"1", ",", "2"}], "}"}]}], "]"}], "\[IndentingNewLine]", 
 RowBox[{"ConjugacyClass", "[", 
  RowBox[{"SU3", ",", 
   RowBox[{"{", 
    RowBox[{"0", ",", "1"}], "}"}]}], "]"}], "\[IndentingNewLine]", 
 RowBox[{"ConjugacyClass", "[", 
  RowBox[{"SU3", ",", 
   RowBox[{"{", 
    RowBox[{"2", ",", "0"}], "}"}]}], "]"}]}], "Input",
 CellLabel->"In[4]:=",
 CellID->85662895,ExpressionUUID->"f3f61c58-11c9-41ce-bc16-333f365ddc71"],

Cell[BoxData[
 RowBox[{"{", "2", "}"}]], "Output",
 CellLabel->"Out[4]=",
 CellID->139249860,ExpressionUUID->"ef3953b4-0830-4013-9394-cf894240c468"],

Cell[BoxData[
 RowBox[{"{", "2", "}"}]], "Output",
 CellLabel->"Out[4]=",
 CellID->145956518,ExpressionUUID->"45f66d79-d04f-435f-959d-86490ef930d8"],

Cell[BoxData[
 RowBox[{"{", "2", "}"}]], "Output",
 CellLabel->"Out[4]=",
 CellID->356607885,ExpressionUUID->"4f3e66fb-918b-48b4-ad58-61d71384feef"]
}, Open  ]],

Cell["\<\
Why is this useful? The product of SU(3) representations are the class given \
by the sum of the classes of the factors, modulus 3.\
\>", "ExampleText",
 CellID->203409556,ExpressionUUID->"f13606b0-33ff-4b72-8277-f14209ac9588"],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[
  "\t", "ExampleDelimiter",ExpressionUUID->
   "6b0c0579-c957-4f20-8b15-92cde4608a69"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->95221561,ExpressionUUID->"0fa1de32-dac0-4e5e-a6a0-29e1d96090c6"],

Cell["\<\
The conjugacy classes of SO(2m) groups are identified with 2 integers:\
\>", "ExampleText",
 CellID->83403055,ExpressionUUID->"68e086e2-e785-429d-a2c7-234e6de9e159"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ConjugacyClass", "[", 
  RowBox[{"SO10", ",", 
   RowBox[{"{", 
    RowBox[{"0", ",", "0", ",", "0", ",", "0", ",", "1"}], "}"}]}], 
  "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->79005579,ExpressionUUID->"03960a6f-ee0d-4b63-a22c-536f5b7e12e2"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"1", ",", "1"}], "}"}]], "Output",
 CellLabel->"Out[1]=",
 CellID->4230287,ExpressionUUID->"a23bb300-ecc4-4b87-801a-094bcb2a2ae2"]
}, Open  ]],

Cell[TextData[{
 "Note that ",
 Cell[BoxData[
 "ConjugacyClass"], "InlineFormula",ExpressionUUID->
  "f9ac255d-8b11-4a3d-8490-0f061f96e55e"],
 " accepts the simplified input format for representations, so the last line \
of code is the same as the following one:"
}], "ExampleText",
 CellID->54771557,ExpressionUUID->"8d2a8ea3-32ac-462d-aeed-fa594c99ae09"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ConjugacyClass", "[", 
  RowBox[{"SO10", ",", "16"}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->69899422,ExpressionUUID->"bbf64d02-e64b-4164-80cb-05d21c12a483"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"1", ",", "1"}], "}"}]], "Output",
 CellLabel->"Out[2]=",
 CellID->199585351,ExpressionUUID->"bc282313-31ba-47b1-945e-7f263c973ada"]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell["", "SectionFooterSpacer",ExpressionUUID->"172002ad-8337-4b56-a681-f6f7237e401c"]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[{
 Cell[BoxData[
  TemplateBox[{6},
   "Spacer1"]],ExpressionUUID->"b5024e28-433f-4f4c-9758-269976258c6a"],
 "See Also"
}], "SeeAlsoSection",
 WholeCellGroupOpener->True,
 CellID->1255426704,ExpressionUUID->"49d010a6-6991-4ba9-a5ff-398e25da0496"],

Cell[TextData[{
 Cell[BoxData[
  TemplateBox[{Cell[
     TextData["ConjugacyClassGroupModIndices"]],
    "paclet:GroupMath/ref/ConjugacyClassGroupModIndices"},
   "RefLink",
   BaseStyle->{"InlineFormula", FontFamily -> "Verdana"}]], "InlineFormula",
  ExpressionUUID->"d8058f65-dcbb-4cb3-bdfd-af27f293d0ea"],
 "\[NonBreakingSpace]",
 StyleBox["\[MediumSpace]\[FilledVerySmallSquare]\[MediumSpace]", 
  "InlineSeparator"],
 " ",
 Cell[BoxData[
  TemplateBox[{Cell[
     TextData["CartanMatrix"]],"paclet:GroupMath/ref/CartanMatrix"},
   "RefLink",
   BaseStyle->{"InlineFormula", FontFamily -> "Verdana"}]], "InlineFormula",
  ExpressionUUID->"102b02b9-ad3b-4a64-be95-54f1ca154502"],
 "\[NonBreakingSpace]",
 StyleBox["\[MediumSpace]\[FilledVerySmallSquare]\[MediumSpace]", 
  "InlineSeparator"],
 " ",
 Cell[BoxData[
  TemplateBox[{Cell[
     TextData["ReduceRepProduct"]],"paclet:GroupMath/ref/ReduceRepProduct"},
   "RefLink",
   BaseStyle->{"InlineFormula", FontFamily -> "Verdana"}]], "InlineFormula",
  ExpressionUUID->"b18f4619-582c-4316-9536-62d2f14a6eb4"]
}], "SeeAlso",
 CellID->1038487239,ExpressionUUID->"b27d6b9c-b33f-442c-b6e0-6b8c2d94d4e5"]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[{
 Cell[BoxData[
  TemplateBox[{6},
   "Spacer1"]],ExpressionUUID->"8c835f69-4cfb-49da-8204-f1a5da0c86c5"],
 "Tutorials"
}], "TutorialsSection",
 WholeCellGroupOpener->True,
 CellID->250839057,ExpressionUUID->"ae803604-e4a2-4046-ab73-9c4be8a57f57"],

Cell["", "SectionHeaderSpacer",ExpressionUUID->"bea5ff8e-75b4-49bc-87f8-848e68187026"],

Cell[BoxData[
 TemplateBox[{Cell[
    TextData["GroupMath Tutorial"]],"paclet:GroupMath/tutorial/GroupMathDoc"},
  "RefLink",
  BaseStyle->"Tutorials"]], "Tutorials",
 CellID->341631938,ExpressionUUID->"6f84c236-26c5-4994-a655-5a349058373b"]
}, Open  ]],

Cell[" ", "FooterCell",ExpressionUUID->"312e3692-c9c1-4764-9807-f4422a8ff132"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"ConjugacyClass",
TaggingRules->{
 "ModificationHighlight" -> False, "ColorType" -> "SymbolColor", "LinkTrails" -> 
  GridBox[{{
      RowBox[{
        ButtonBox[
        "Mathematica", ButtonData -> "paclet:GroupMath/guide/GroupMath", 
         BaseStyle -> {"Link", "DockedLinkTrail"}]}]}}, ColumnAlignments -> 
    Left], "HasOptions" -> False, "ExampleCounter" -> 1, "NeedPlatMsgIn" -> 
  None, "RootCaptions" -> "", 
  "Metadata" -> {
   "built" -> "{2020, 11, 4, 11, 38, 27.1986855}", 
    "history" -> {"1.0", "", "", ""}, "context" -> "GroupMath`", 
    "keywords" -> {}, "specialkeywords" -> {}, 
    "tutorialcollectionlinks" -> {}, "index" -> True, "label" -> 
    "Group Math Symbol", "language" -> "en", "paclet" -> "GroupMath", 
    "status" -> "None", "summary" -> 
    "ConjugacyClass[group, represention] Computes the conjugacy class of a \
representation of a simple Lie group", "synonyms" -> {}, "tabletags" -> {}, 
    "title" -> "ConjugacyClass", "titlemodifier" -> "", "windowtitle" -> 
    "ConjugacyClass", "type" -> "Symbol", "uri" -> 
    "GroupMath/ref/ConjugacyClass", "WorkflowDockedCell" -> ""}, 
  "SearchTextTranslated" -> "", "NewStyles" -> False},
CellContext->"Global`",
FrontEndVersion->"12.0 for Microsoft Windows (64-bit) (April 8, 2019)",
StyleDefinitions->Notebook[{
   Cell[
    StyleData[
    StyleDefinitions -> FrontEnd`FileName[{"Wolfram"}, "Reference.nb"]]], 
   Cell[
    StyleData["Input"], CellContext -> "Global`"], 
   Cell[
    StyleData["Output"], CellContext -> "Global`"]}, Visible -> False, 
  TaggingRules -> {"NewStyles" -> False}, FrontEndVersion -> 
  "12.0 for Microsoft Windows (64-bit) (April 8, 2019)", StyleDefinitions -> 
  "Default.nb"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[8273, 215, 434, 11, 35, "PrimaryExamplesSection",ExpressionUUID->"75e0c2c8-0d18-4138-a159-82d9c2faecc1",
   CellTags->"PrimaryExamplesSection",
   CellID->16080189]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 20050, 579}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[586, 21, 4336, 97, 53, "AnchorBarGrid",ExpressionUUID->"158dcbaf-ffb2-4c26-a404-358fe477505b",
 CellID->1],
Cell[CellGroupData[{
Cell[4947, 122, 399, 9, 52, "ObjectNameGrid",ExpressionUUID->"457fd3a2-5443-4ac2-a66a-aff28c31fc93"],
Cell[5349, 133, 575, 12, 110, "Usage",ExpressionUUID->"ba4993d9-ee00-47cf-af8d-73ed5ecd2361",
 CellID->982511436]
}, Open  ]],
Cell[CellGroupData[{
Cell[5961, 150, 853, 21, 37, "NotesSection",ExpressionUUID->"0431a63f-c75d-4b9f-85d6-948ef66eea20",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->9481487],
Cell[6817, 173, 86, 0, 70, "SectionHeaderSpacer",ExpressionUUID->"d962749c-099c-478e-ba56-c38dc780bc5b"],
Cell[6906, 175, 407, 12, 70, "Notes",ExpressionUUID->"9054a685-da39-4305-958f-2a3aea807a35",
 CellID->1067943069],
Cell[7316, 189, 495, 12, 70, "Notes",ExpressionUUID->"225dbd8c-cef0-46df-b8b4-09eeac092a44",
 CellID->322001788],
Cell[7814, 203, 333, 5, 70, "Notes",ExpressionUUID->"32b4797f-62ca-41bd-8852-fdf3b5b64053",
 CellID->66919531],
Cell[8150, 210, 86, 0, 70, "SectionFooterSpacer",ExpressionUUID->"15dad314-7874-4041-bf85-f8f412f0884d"]
}, Closed]],
Cell[CellGroupData[{
Cell[8273, 215, 434, 11, 35, "PrimaryExamplesSection",ExpressionUUID->"75e0c2c8-0d18-4138-a159-82d9c2faecc1",
 CellTags->"PrimaryExamplesSection",
 CellID->16080189],
Cell[CellGroupData[{
Cell[8732, 230, 308, 7, 29, "ExampleSection",ExpressionUUID->"5f247e22-c0a8-4f25-a208-61721b4369da",
 CellID->300355269],
Cell[9043, 239, 196, 4, 38, "ExampleText",ExpressionUUID->"0db0ecbb-4257-4fd1-9efd-957d67eff458",
 CellID->14658346],
Cell[CellGroupData[{
Cell[9264, 247, 525, 14, 59, "Input",ExpressionUUID->"9fe45566-5ab1-4613-af5a-7d35c8ffbca8",
 CellID->430153659],
Cell[9792, 263, 147, 3, 35, "Output",ExpressionUUID->"e63204b2-9ef8-497f-b04f-e35ffabda198",
 CellID->60234413],
Cell[9942, 268, 147, 3, 35, "Output",ExpressionUUID->"dc3f1dac-f049-49a5-b48f-3e69071cfb80",
 CellID->64438071],
Cell[10092, 273, 148, 3, 35, "Output",ExpressionUUID->"778f8cc6-5279-49d0-9960-3c00b199e0b8",
 CellID->747613126]
}, Open  ]],
Cell[10255, 279, 572, 13, 77, "ExampleText",ExpressionUUID->"f51a767d-7471-4a7b-8e04-8c677b72363d",
 CellID->94118532],
Cell[CellGroupData[{
Cell[10852, 296, 741, 21, 75, "Input",ExpressionUUID->"2eed6043-bffe-4346-9642-33e68b50d428",
 CellID->582423663],
Cell[11596, 319, 147, 3, 35, "Output",ExpressionUUID->"2bb63ce7-8c0f-4719-bbef-fb662debd0da",
 CellID->46161651],
Cell[11746, 324, 148, 3, 35, "Output",ExpressionUUID->"abd9c66b-150c-426b-a67e-98a0a45d8748",
 CellID->425888645]
}, Open  ]],
Cell[CellGroupData[{
Cell[11931, 332, 410, 12, 70, "Input",ExpressionUUID->"1656e2ba-f63e-4631-bcd9-b3be9a848345",
 CellID->211409023],
Cell[12344, 346, 487, 16, 35, "Output",ExpressionUUID->"a73c803f-9def-4dbf-ac02-e40337cf4623",
 CellID->258597991]
}, Open  ]],
Cell[CellGroupData[{
Cell[12868, 367, 524, 14, 70, "Input",ExpressionUUID->"f3f61c58-11c9-41ce-bc16-333f365ddc71",
 CellID->85662895],
Cell[13395, 383, 148, 3, 35, "Output",ExpressionUUID->"ef3953b4-0830-4013-9394-cf894240c468",
 CellID->139249860],
Cell[13546, 388, 148, 3, 35, "Output",ExpressionUUID->"45f66d79-d04f-435f-959d-86490ef930d8",
 CellID->145956518],
Cell[13697, 393, 148, 3, 35, "Output",ExpressionUUID->"4f3e66fb-918b-48b4-ad58-61d71384feef",
 CellID->356607885]
}, Open  ]],
Cell[13860, 399, 237, 4, 70, "ExampleText",ExpressionUUID->"f13606b0-33ff-4b72-8277-f14209ac9588",
 CellID->203409556],
Cell[CellGroupData[{
Cell[14122, 407, 241, 5, 70, "ExampleDelimiter",ExpressionUUID->"0fa1de32-dac0-4e5e-a6a0-29e1d96090c6",
 CellID->95221561],
Cell[14366, 414, 175, 3, 70, "ExampleText",ExpressionUUID->"68e086e2-e785-429d-a2c7-234e6de9e159",
 CellID->83403055],
Cell[CellGroupData[{
Cell[14566, 421, 272, 7, 70, "Input",ExpressionUUID->"03960a6f-ee0d-4b63-a22c-536f5b7e12e2",
 CellID->79005579],
Cell[14841, 430, 169, 4, 35, "Output",ExpressionUUID->"a23bb300-ecc4-4b87-801a-094bcb2a2ae2",
 CellID->4230287]
}, Open  ]],
Cell[15025, 437, 356, 8, 70, "ExampleText",ExpressionUUID->"8d2a8ea3-32ac-462d-aeed-fa594c99ae09",
 CellID->54771557],
Cell[CellGroupData[{
Cell[15406, 449, 191, 4, 70, "Input",ExpressionUUID->"bbf64d02-e64b-4164-80cb-05d21c12a483",
 CellID->69899422],
Cell[15600, 455, 171, 4, 35, "Output",ExpressionUUID->"bc282313-31ba-47b1-945e-7f263c973ada",
 CellID->199585351]
}, Open  ]]
}, Open  ]]
}, Open  ]],
Cell[15810, 464, 86, 0, 70, "SectionFooterSpacer",ExpressionUUID->"172002ad-8337-4b56-a681-f6f7237e401c"]
}, Open  ]],
Cell[CellGroupData[{
Cell[15933, 469, 260, 7, 70, "SeeAlsoSection",ExpressionUUID->"49d010a6-6991-4ba9-a5ff-398e25da0496",
 CellID->1255426704],
Cell[16196, 478, 1155, 29, 70, "SeeAlso",ExpressionUUID->"b27d6b9c-b33f-442c-b6e0-6b8c2d94d4e5",
 CellID->1038487239]
}, Open  ]],
Cell[CellGroupData[{
Cell[17388, 512, 262, 7, 70, "TutorialsSection",ExpressionUUID->"ae803604-e4a2-4046-ab73-9c4be8a57f57",
 CellID->250839057],
Cell[17653, 521, 86, 0, 70, "SectionHeaderSpacer",ExpressionUUID->"bea5ff8e-75b4-49bc-87f8-848e68187026"],
Cell[17742, 523, 241, 5, 70, "Tutorials",ExpressionUUID->"6f84c236-26c5-4994-a655-5a349058373b",
 CellID->341631938]
}, Open  ]],
Cell[17998, 531, 78, 0, 70, "FooterCell",ExpressionUUID->"312e3692-c9c1-4764-9807-f4422a8ff132"]
}
]
*)

(* End of internal cache information *)

