(* Content-type: application/vnd.wolfram.mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 11.1' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       158,          7]
NotebookDataLength[    129417,       3238]
NotebookOptionsPosition[     73406,       1957]
NotebookOutlinePosition[    128217,       3213]
CellTagsIndexPosition[    128174,       3210]
WindowFrame->Normal*)

(* Beginning of Notebook Content *)
Notebook[{
Cell["One should first load the data file \
\[OpenCurlyDoubleQuote]dim-9-11-13-data.txt\[CloseCurlyDoubleQuote]", \
"MyStyle - H1 Framed",
 CellChangeTimes->{{3.736059229109367*^9, 3.736059262378896*^9}, 
   3.7360733424892063`*^9},ExpressionUUID->"6380ec97-f160-4009-b377-\
069d23d369f7"],

Cell[BoxData[
 RowBox[{
  RowBox[{"<<", "\"\<dim-9-11-13-data.txt\>\""}], ";"}]], "Input",
 CellChangeTimes->{{3.7360592679589987`*^9, 3.7360592745604844`*^9}, {
   3.7360730659885798`*^9, 3.736073068059081*^9}, 
   3.736073330811922*^9},ExpressionUUID->"3a2b3c0e-dfed-451b-803a-\
a73492d8d8ad"],

Cell["\<\
Topology data is contained in the variables TopologiesDim9, TopologiesDim11 \
and TopologiesDim13. Each topology is specified by its adjacency matrix A, \
where A[[i,j]] contains the number of lines between the vertex i and vertex \
j. Note that what is usually considered as \[OpenCurlyDoubleQuote]external \
lines\[CloseCurlyDoubleQuote] of a diagram are actually connected on both \
ends to vertices (on one of the end there is a vertex with a single \
connection).

One can use the Mathematica built-in function AdjancencyGraph to plot the \
topologies.\
\>", "MyStyle - H1 Framed",
 CellChangeTimes->{{3.736059229109367*^9, 3.736059262378896*^9}, {
  3.7360592938064547`*^9, 
  3.7360595677309976`*^9}},ExpressionUUID->"0432d697-bf63-4b20-af3e-\
8bde967c5b37"],

Cell["Example: First topology with d=9", "MyStyle - H3",
 CellChangeTimes->{{3.736059573716008*^9, 
  3.7360595974019504`*^9}},ExpressionUUID->"21bdad40-4012-464c-95a5-\
7713dd59d54c"],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{"TopologiesDim9", "[", 
  RowBox[{"[", "1", "]"}], "]"}], "\[IndentingNewLine]", 
 RowBox[{"AdjacencyGraph", "[", 
  RowBox[{"TopologiesDim9", "[", 
   RowBox[{"[", "1", "]"}], "]"}], "]"}]}], "Input",
 CellChangeTimes->{{3.7360596016198707`*^9, 
  3.73605961321618*^9}},ExpressionUUID->"a6e2b453-14ba-4cf7-8228-\
1d7e806d67a0"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
    "0", ",", "1", ",", "1", ",", "1", ",", "1", ",", "0", ",", "0", ",", "0",
      ",", "0", ",", "0", ",", "0", ",", "0"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
    "1", ",", "0", ",", "0", ",", "0", ",", "0", ",", "1", ",", "1", ",", "1",
      ",", "0", ",", "0", ",", "0", ",", "0"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
    "1", ",", "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", "0",
      ",", "1", ",", "1", ",", "0", ",", "0"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
    "1", ",", "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", "0",
      ",", "0", ",", "0", ",", "1", ",", "1"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
    "1", ",", "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", "0",
      ",", "0", ",", "0", ",", "0", ",", "0"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
    "0", ",", "1", ",", "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", "0",
      ",", "0", ",", "0", ",", "0", ",", "0"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
    "0", ",", "1", ",", "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", "0",
      ",", "0", ",", "0", ",", "0", ",", "0"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
    "0", ",", "1", ",", "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", "0",
      ",", "0", ",", "0", ",", "0", ",", "0"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
    "0", ",", "0", ",", "1", ",", "0", ",", "0", ",", "0", ",", "0", ",", "0",
      ",", "0", ",", "0", ",", "0", ",", "0"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
    "0", ",", "0", ",", "1", ",", "0", ",", "0", ",", "0", ",", "0", ",", "0",
      ",", "0", ",", "0", ",", "0", ",", "0"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
    "0", ",", "0", ",", "0", ",", "1", ",", "0", ",", "0", ",", "0", ",", "0",
      ",", "0", ",", "0", ",", "0", ",", "0"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
    "0", ",", "0", ",", "0", ",", "1", ",", "0", ",", "0", ",", "0", ",", "0",
      ",", "0", ",", "0", ",", "0", ",", "0"}], "}"}]}], "}"}]], "Output",
 CellChangeTimes->{{3.7360596044979625`*^9, 3.736059613778739*^9}, 
   3.7360733610778465`*^9},ExpressionUUID->"db6dc349-9da1-483d-9239-\
c0c8f4514e25"],

Cell[BoxData[
 GraphicsBox[
  NamespaceBox["NetworkGraphics",
   DynamicModuleBox[{Typeset`graph = HoldComplete[
     Graph[{1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12}, {Null, 
       SparseArray[
       Automatic, {12, 12}, 0, {
        1, {{0, 4, 8, 11, 14, 15, 16, 17, 18, 19, 20, 21, 22}, {{2}, {3}, {
          4}, {5}, {1}, {6}, {7}, {8}, {1}, {9}, {10}, {1}, {11}, {12}, {1}, {
          2}, {2}, {2}, {3}, {3}, {4}, {4}}}, Pattern}]}]]}, 
    TagBox[
     GraphicsGroupBox[
      GraphicsComplexBox[{{2.190093976957833, 1.1680501210441776`}, {
       0.5840250605220888, 0.5840250605220888}, {2.0440877118273106`, 
       0.5840250605220888}, {3.212137832871488, 0.5840250605220888}, {
       3.796162893393577, 0.5840250605220888}, {0., 0.}, {0.5840250605220888, 
       0.}, {1.1680501210441776`, 0.}, {1.7520751815662663`, 0.}, {
       2.336100242088355, 0.}, {2.920125302610444, 0.}, {3.5041503631325326`, 
       0.}}, {
        {Hue[0.6, 0.7, 0.5], Opacity[0.7], 
         {Arrowheads[0.], ArrowBox[{1, 2}, 0.035689221563249995`]}, 
         {Arrowheads[0.], ArrowBox[{1, 3}, 0.035689221563249995`]}, 
         {Arrowheads[0.], ArrowBox[{1, 4}, 0.035689221563249995`]}, 
         {Arrowheads[0.], ArrowBox[{1, 5}, 0.035689221563249995`]}, 
         {Arrowheads[0.], ArrowBox[{2, 6}, 0.035689221563249995`]}, 
         {Arrowheads[0.], ArrowBox[{2, 7}, 0.035689221563249995`]}, 
         {Arrowheads[0.], ArrowBox[{2, 8}, 0.035689221563249995`]}, 
         {Arrowheads[0.], ArrowBox[{3, 9}, 0.035689221563249995`]}, 
         {Arrowheads[0.], ArrowBox[{3, 10}, 0.035689221563249995`]}, 
         {Arrowheads[0.], ArrowBox[{4, 11}, 0.035689221563249995`]}, 
         {Arrowheads[0.], ArrowBox[{4, 12}, 0.035689221563249995`]}}, 
        {Hue[0.6, 0.2, 0.8], EdgeForm[{GrayLevel[0], Opacity[0.7]}], 
         DiskBox[1, 0.035689221563249995], DiskBox[2, 0.035689221563249995], 
         DiskBox[3, 0.035689221563249995], DiskBox[4, 0.035689221563249995], 
         DiskBox[5, 0.035689221563249995], DiskBox[6, 0.035689221563249995], 
         DiskBox[7, 0.035689221563249995], DiskBox[8, 0.035689221563249995], 
         DiskBox[9, 0.035689221563249995], DiskBox[10, 0.035689221563249995], 
         DiskBox[11, 0.035689221563249995], 
         DiskBox[12, 0.035689221563249995]}}]],
     MouseAppearanceTag["NetworkGraphics"]],
    AllowKernelInitialization->False]],
  DefaultBaseStyle->{
   "NetworkGraphics", FrontEnd`GraphicsHighlightColor -> Hue[0.8, 1., 0.6]},
  FormatType->TraditionalForm,
  FrameTicks->None]], "Output",
 CellChangeTimes->{{3.7360596044979625`*^9, 3.736059613778739*^9}, 
   3.736073361178129*^9},ExpressionUUID->"8c0f50c8-03ee-4cc2-98bf-\
aa1a18bea1ec"]
}, Open  ]],

Cell["\<\
Diagram data is contained in the variables DiagramsDim9, DiagramsDim11 and \
DiagramsDim13. These are lists of lists: the entry TopologiesDimN[[x,y]] \
represents the y\[CloseCurlyQuote]th diagram with topology x and dimension \
d=N (the ordering of the topologies is the same as in the file TopologiesDimN).

A diagram is specified by a topology and some labels of the lines (\
\[OpenCurlyDoubleQuote]F\[CloseCurlyDoubleQuote] for fermion or \
\[OpenCurlyDoubleQuote]S\[CloseCurlyDoubleQuote] for scalar). In order to \
give these two pieces of information together, we write each diagram as a \
matrix D such that D[[i,j]] is a list with the connections/lines between the \
vertices i and j. Each connection can be an \[OpenCurlyDoubleQuote]S\
\[CloseCurlyDoubleQuote] or an \[OpenCurlyDoubleQuote]F\
\[CloseCurlyDoubleQuote]. If there is no connection between the vertices i \
and j, D[[i,j]]={}.

We provide the function PaintLabelledDiagram2 which can be used to draw the \
diagrams.\
\>", "MyStyle - H1 Framed",
 CellChangeTimes->{{3.736059229109367*^9, 3.736059262378896*^9}, {
  3.7360592938064547`*^9, 3.7360595677309976`*^9}, {3.736059700437241*^9, 
  3.7360601018887444`*^9}},ExpressionUUID->"9e2d98ee-73f3-47a4-807b-\
af0965eef0ad"],

Cell["\<\
Example: All diagrams with the 16\[CloseCurlyQuote]th topology of the d=11 \
list\
\>", "MyStyle - H3",
 CellChangeTimes->{{3.736059573716008*^9, 3.7360595974019504`*^9}, {
  3.7360601134569283`*^9, 3.7360601300405936`*^9}, {3.7360602001666746`*^9, 
  3.7360602006042194`*^9}},ExpressionUUID->"faa02d1a-a1e8-4a19-9f38-\
19ce878a8070"],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{"MatrixForm", "/@", 
  RowBox[{"DiagramsDim11", "[", 
   RowBox[{"[", "16", "]"}], "]"}]}], "\[IndentingNewLine]", 
 RowBox[{"PaintLabelledDiagram2", "/@", 
  RowBox[{"DiagramsDim11", "[", 
   RowBox[{"[", "16", "]"}], "]"}]}]}], "Input",
 CellChangeTimes->{{3.7360601397140493`*^9, 
  3.736060181160941*^9}},ExpressionUUID->"dbfb5af4-3451-4f15-8af6-\
05df89e1432c"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   TagBox[
    RowBox[{"(", "\[NoBreak]", GridBox[{
       {
        RowBox[{"{", "}"}], 
        RowBox[{"{", "\<\"S\"\>", "}"}], 
        RowBox[{"{", "\<\"S\"\>", "}"}], 
        RowBox[{"{", "\<\"S\"\>", "}"}], 
        RowBox[{"{", "}"}], 
        RowBox[{"{", "}"}], 
        RowBox[{"{", "\<\"S\"\>", "}"}], 
        RowBox[{"{", "}"}], 
        RowBox[{"{", "}"}], 
        RowBox[{"{", "}"}], 
        RowBox[{"{", "}"}], 
        RowBox[{"{", "}"}], 
        RowBox[{"{", "}"}], 
        RowBox[{"{", "}"}], 
        RowBox[{"{", "}"}], 
        RowBox[{"{", "}"}]},
       {
        RowBox[{"{", "\<\"S\"\>", "}"}], 
        RowBox[{"{", "}"}], 
        RowBox[{"{", "}"}], 
        RowBox[{"{", "}"}], 
        RowBox[{"{", "\<\"S\"\>", "}"}], 
        RowBox[{"{", "}"}], 
        RowBox[{"{", "}"}], 
        RowBox[{"{", "\<\"S\"\>", "}"}], 
        RowBox[{"{", "\<\"S\"\>", "}"}], 
        RowBox[{"{", "}"}], 
        RowBox[{"{", "}"}], 
        RowBox[{"{", "}"}], 
        RowBox[{"{", "}"}], 
        RowBox[{"{", "}"}], 
        RowBox[{"{", "}"}], 
        RowBox[{"{", "}"}]},
       {
        RowBox[{"{", "\<\"S\"\>", "}"}], 
        RowBox[{"{", "}"}], 
        RowBox[{"{", "}"}], 
        RowBox[{"{", "}"}], 
        RowBox[{"{", "}"}], 
        RowBox[{"{", "\<\"F\"\>", "}"}], 
        RowBox[{"{", "}"}], 
        RowBox[{"{", "}"}], 
        RowBox[{"{", "}"}], 
        RowBox[{"{", "\<\"F\"\>", "}"}], 
        RowBox[{"{", "}"}], 
        RowBox[{"{", "}"}], 
        RowBox[{"{", "}"}], 
        RowBox[{"{", "}"}], 
        RowBox[{"{", "}"}], 
        RowBox[{"{", "}"}]},
       {
        RowBox[{"{", "\<\"S\"\>", "}"}], 
        RowBox[{"{", "}"}], 
        RowBox[{"{", "}"}], 
        RowBox[{"{", "}"}], 
        RowBox[{"{", "}"}], 
        RowBox[{"{", "}"}], 
        RowBox[{"{", "}"}], 
        RowBox[{"{", "}"}], 
        RowBox[{"{", "}"}], 
        RowBox[{"{", "}"}], 
        RowBox[{"{", "\<\"S\"\>", "}"}], 
        RowBox[{"{", "\<\"S\"\>", "}"}], 
        RowBox[{"{", "}"}], 
        RowBox[{"{", "}"}], 
        RowBox[{"{", "}"}], 
        RowBox[{"{", "}"}]},
       {
        RowBox[{"{", "}"}], 
        RowBox[{"{", "\<\"S\"\>", "}"}], 
        RowBox[{"{", "}"}], 
        RowBox[{"{", "}"}], 
        RowBox[{"{", "}"}], 
        RowBox[{"{", "}"}], 
        RowBox[{"{", "}"}], 
        RowBox[{"{", "}"}], 
        RowBox[{"{", "}"}], 
        RowBox[{"{", "}"}], 
        RowBox[{"{", "}"}], 
        RowBox[{"{", "}"}], 
        RowBox[{"{", "\<\"S\"\>", "}"}], 
        RowBox[{"{", "\<\"S\"\>", "}"}], 
        RowBox[{"{", "}"}], 
        RowBox[{"{", "}"}]},
       {
        RowBox[{"{", "}"}], 
        RowBox[{"{", "}"}], 
        RowBox[{"{", "\<\"F\"\>", "}"}], 
        RowBox[{"{", "}"}], 
        RowBox[{"{", "}"}], 
        RowBox[{"{", "}"}], 
        RowBox[{"{", "}"}], 
        RowBox[{"{", "}"}], 
        RowBox[{"{", "}"}], 
        RowBox[{"{", "}"}], 
        RowBox[{"{", "}"}], 
        RowBox[{"{", "}"}], 
        RowBox[{"{", "}"}], 
        RowBox[{"{", "}"}], 
        RowBox[{"{", "\<\"F\"\>", "}"}], 
        RowBox[{"{", "\<\"S\"\>", "}"}]},
       {
        RowBox[{"{", "\<\"S\"\>", "}"}], 
        RowBox[{"{", "}"}], 
        RowBox[{"{", "}"}], 
        RowBox[{"{", "}"}], 
        RowBox[{"{", "}"}], 
        RowBox[{"{", "}"}], 
        RowBox[{"{", "}"}], 
        RowBox[{"{", "}"}], 
        RowBox[{"{", "}"}], 
        RowBox[{"{", "}"}], 
        RowBox[{"{", "}"}], 
        RowBox[{"{", "}"}], 
        RowBox[{"{", "}"}], 
        RowBox[{"{", "}"}], 
        RowBox[{"{", "}"}], 
        RowBox[{"{", "}"}]},
       {
        RowBox[{"{", "}"}], 
        RowBox[{"{", "\<\"S\"\>", "}"}], 
        RowBox[{"{", "}"}], 
        RowBox[{"{", "}"}], 
        RowBox[{"{", "}"}], 
        RowBox[{"{", "}"}], 
        RowBox[{"{", "}"}], 
        RowBox[{"{", "}"}], 
        RowBox[{"{", "}"}], 
        RowBox[{"{", "}"}], 
        RowBox[{"{", "}"}], 
        RowBox[{"{", "}"}], 
        RowBox[{"{", "}"}], 
        RowBox[{"{", "}"}], 
        RowBox[{"{", "}"}], 
        RowBox[{"{", "}"}]},
       {
        RowBox[{"{", "}"}], 
        RowBox[{"{", "\<\"S\"\>", "}"}], 
        RowBox[{"{", "}"}], 
        RowBox[{"{", "}"}], 
        RowBox[{"{", "}"}], 
        RowBox[{"{", "}"}], 
        RowBox[{"{", "}"}], 
        RowBox[{"{", "}"}], 
        RowBox[{"{", "}"}], 
        RowBox[{"{", "}"}], 
        RowBox[{"{", "}"}], 
        RowBox[{"{", "}"}], 
        RowBox[{"{", "}"}], 
        RowBox[{"{", "}"}], 
        RowBox[{"{", "}"}], 
        RowBox[{"{", "}"}]},
       {
        RowBox[{"{", "}"}], 
        RowBox[{"{", "}"}], 
        RowBox[{"{", "\<\"F\"\>", "}"}], 
        RowBox[{"{", "}"}], 
        RowBox[{"{", "}"}], 
        RowBox[{"{", "}"}], 
        RowBox[{"{", "}"}], 
        RowBox[{"{", "}"}], 
        RowBox[{"{", "}"}], 
        RowBox[{"{", "}"}], 
        RowBox[{"{", "}"}], 
        RowBox[{"{", "}"}], 
        RowBox[{"{", "}"}], 
        RowBox[{"{", "}"}], 
        RowBox[{"{", "}"}], 
        RowBox[{"{", "}"}]},
       {
        RowBox[{"{", "}"}], 
        RowBox[{"{", "}"}], 
        RowBox[{"{", "}"}], 
        RowBox[{"{", "\<\"S\"\>", "}"}], 
        RowBox[{"{", "}"}], 
        RowBox[{"{", "}"}], 
        RowBox[{"{", "}"}], 
        RowBox[{"{", "}"}], 
        RowBox[{"{", "}"}], 
        RowBox[{"{", "}"}], 
        RowBox[{"{", "}"}], 
        RowBox[{"{", "}"}], 
        RowBox[{"{", "}"}], 
        RowBox[{"{", "}"}], 
        RowBox[{"{", "}"}], 
        RowBox[{"{", "}"}]},
       {
        RowBox[{"{", "}"}], 
        RowBox[{"{", "}"}], 
        RowBox[{"{", "}"}], 
        RowBox[{"{", "\<\"S\"\>", "}"}], 
        RowBox[{"{", "}"}], 
        RowBox[{"{", "}"}], 
        RowBox[{"{", "}"}], 
        RowBox[{"{", "}"}], 
        RowBox[{"{", "}"}], 
        RowBox[{"{", "}"}], 
        RowBox[{"{", "}"}], 
        RowBox[{"{", "}"}], 
        RowBox[{"{", "}"}], 
        RowBox[{"{", "}"}], 
        RowBox[{"{", "}"}], 
        RowBox[{"{", "}"}]},
       {
        RowBox[{"{", "}"}], 
        RowBox[{"{", "}"}], 
        RowBox[{"{", "}"}], 
        RowBox[{"{", "}"}], 
        RowBox[{"{", "\<\"S\"\>", "}"}], 
        RowBox[{"{", "}"}], 
        RowBox[{"{", "}"}], 
        RowBox[{"{", "}"}], 
        RowBox[{"{", "}"}], 
        RowBox[{"{", "}"}], 
        RowBox[{"{", "}"}], 
        RowBox[{"{", "}"}], 
        RowBox[{"{", "}"}], 
        RowBox[{"{", "}"}], 
        RowBox[{"{", "}"}], 
        RowBox[{"{", "}"}]},
       {
        RowBox[{"{", "}"}], 
        RowBox[{"{", "}"}], 
        RowBox[{"{", "}"}], 
        RowBox[{"{", "}"}], 
        RowBox[{"{", "\<\"S\"\>", "}"}], 
        RowBox[{"{", "}"}], 
        RowBox[{"{", "}"}], 
        RowBox[{"{", "}"}], 
        RowBox[{"{", "}"}], 
        RowBox[{"{", "}"}], 
        RowBox[{"{", "}"}], 
        RowBox[{"{", "}"}], 
        RowBox[{"{", "}"}], 
        RowBox[{"{", "}"}], 
        RowBox[{"{", "}"}], 
        RowBox[{"{", "}"}]},
       {
        RowBox[{"{", "}"}], 
        RowBox[{"{", "}"}], 
        RowBox[{"{", "}"}], 
        RowBox[{"{", "}"}], 
        RowBox[{"{", "}"}], 
        RowBox[{"{", "\<\"F\"\>", "}"}], 
        RowBox[{"{", "}"}], 
        RowBox[{"{", "}"}], 
        RowBox[{"{", "}"}], 
        RowBox[{"{", "}"}], 
        RowBox[{"{", "}"}], 
        RowBox[{"{", "}"}], 
        RowBox[{"{", "}"}], 
        RowBox[{"{", "}"}], 
        RowBox[{"{", "}"}], 
        RowBox[{"{", "}"}]},
       {
        RowBox[{"{", "}"}], 
        RowBox[{"{", "}"}], 
        RowBox[{"{", "}"}], 
        RowBox[{"{", "}"}], 
        RowBox[{"{", "}"}], 
        RowBox[{"{", "\<\"S\"\>", "}"}], 
        RowBox[{"{", "}"}], 
        RowBox[{"{", "}"}], 
        RowBox[{"{", "}"}], 
        RowBox[{"{", "}"}], 
        RowBox[{"{", "}"}], 
        RowBox[{"{", "}"}], 
        RowBox[{"{", "}"}], 
        RowBox[{"{", "}"}], 
        RowBox[{"{", "}"}], 
        RowBox[{"{", "}"}]}
      },
      GridBoxAlignment->{
       "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
        "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.7]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}], "\[NoBreak]", ")"}],
    Function[BoxForm`e$, 
     MatrixForm[BoxForm`e$]]], ",", 
   TagBox[
    RowBox[{"(", "\[NoBreak]", GridBox[{
       {
        RowBox[{"{", "}"}], 
        RowBox[{"{", "\<\"S\"\>", "}"}], 
        RowBox[{"{", "\<\"S\"\>", "}"}], 
        RowBox[{"{", "\<\"S\"\>", "}"}], 
        RowBox[{"{", "}"}], 
        RowBox[{"{", "}"}], 
        RowBox[{"{", "\<\"S\"\>", "}"}], 
        RowBox[{"{", "}"}], 
        RowBox[{"{", "}"}], 
        RowBox[{"{", "}"}], 
        RowBox[{"{", "}"}], 
        RowBox[{"{", "}"}], 
        RowBox[{"{", "}"}], 
        RowBox[{"{", "}"}], 
        RowBox[{"{", "}"}], 
        RowBox[{"{", "}"}]},
       {
        RowBox[{"{", "\<\"S\"\>", "}"}], 
        RowBox[{"{", "}"}], 
        RowBox[{"{", "}"}], 
        RowBox[{"{", "}"}], 
        RowBox[{"{", "\<\"S\"\>", "}"}], 
        RowBox[{"{", "}"}], 
        RowBox[{"{", "}"}], 
        RowBox[{"{", "\<\"S\"\>", "}"}], 
        RowBox[{"{", "\<\"S\"\>", "}"}], 
        RowBox[{"{", "}"}], 
        RowBox[{"{", "}"}], 
        RowBox[{"{", "}"}], 
        RowBox[{"{", "}"}], 
        RowBox[{"{", "}"}], 
        RowBox[{"{", "}"}], 
        RowBox[{"{", "}"}]},
       {
        RowBox[{"{", "\<\"S\"\>", "}"}], 
        RowBox[{"{", "}"}], 
        RowBox[{"{", "}"}], 
        RowBox[{"{", "}"}], 
        RowBox[{"{", "}"}], 
        RowBox[{"{", "\<\"S\"\>", "}"}], 
        RowBox[{"{", "}"}], 
        RowBox[{"{", "}"}], 
        RowBox[{"{", "}"}], 
        RowBox[{"{", "\<\"S\"\>", "}"}], 
        RowBox[{"{", "}"}], 
        RowBox[{"{", "}"}], 
        RowBox[{"{", "}"}], 
        RowBox[{"{", "}"}], 
        RowBox[{"{", "}"}], 
        RowBox[{"{", "}"}]},
       {
        RowBox[{"{", "\<\"S\"\>", "}"}], 
        RowBox[{"{", "}"}], 
        RowBox[{"{", "}"}], 
        RowBox[{"{", "}"}], 
        RowBox[{"{", "}"}], 
        RowBox[{"{", "}"}], 
        RowBox[{"{", "}"}], 
        RowBox[{"{", "}"}], 
        RowBox[{"{", "}"}], 
        RowBox[{"{", "}"}], 
        RowBox[{"{", "\<\"F\"\>", "}"}], 
        RowBox[{"{", "\<\"F\"\>", "}"}], 
        RowBox[{"{", "}"}], 
        RowBox[{"{", "}"}], 
        RowBox[{"{", "}"}], 
        RowBox[{"{", "}"}]},
       {
        RowBox[{"{", "}"}], 
        RowBox[{"{", "\<\"S\"\>", "}"}], 
        RowBox[{"{", "}"}], 
        RowBox[{"{", "}"}], 
        RowBox[{"{", "}"}], 
        RowBox[{"{", "}"}], 
        RowBox[{"{", "}"}], 
        RowBox[{"{", "}"}], 
        RowBox[{"{", "}"}], 
        RowBox[{"{", "}"}], 
        RowBox[{"{", "}"}], 
        RowBox[{"{", "}"}], 
        RowBox[{"{", "\<\"S\"\>", "}"}], 
        RowBox[{"{", "\<\"S\"\>", "}"}], 
        RowBox[{"{", "}"}], 
        RowBox[{"{", "}"}]},
       {
        RowBox[{"{", "}"}], 
        RowBox[{"{", "}"}], 
        RowBox[{"{", "\<\"S\"\>", "}"}], 
        RowBox[{"{", "}"}], 
        RowBox[{"{", "}"}], 
        RowBox[{"{", "}"}], 
        RowBox[{"{", "}"}], 
        RowBox[{"{", "}"}], 
        RowBox[{"{", "}"}], 
        RowBox[{"{", "}"}], 
        RowBox[{"{", "}"}], 
        RowBox[{"{", "}"}], 
        RowBox[{"{", "}"}], 
        RowBox[{"{", "}"}], 
        RowBox[{"{", "\<\"S\"\>", "}"}], 
        RowBox[{"{", "\<\"S\"\>", "}"}]},
       {
        RowBox[{"{", "\<\"S\"\>", "}"}], 
        RowBox[{"{", "}"}], 
        RowBox[{"{", "}"}], 
        RowBox[{"{", "}"}], 
        RowBox[{"{", "}"}], 
        RowBox[{"{", "}"}], 
        RowBox[{"{", "}"}], 
        RowBox[{"{", "}"}], 
        RowBox[{"{", "}"}], 
        RowBox[{"{", "}"}], 
        RowBox[{"{", "}"}], 
        RowBox[{"{", "}"}], 
        RowBox[{"{", "}"}], 
        RowBox[{"{", "}"}], 
        RowBox[{"{", "}"}], 
        RowBox[{"{", "}"}]},
       {
        RowBox[{"{", "}"}], 
        RowBox[{"{", "\<\"S\"\>", "}"}], 
        RowBox[{"{", "}"}], 
        RowBox[{"{", "}"}], 
        RowBox[{"{", "}"}], 
        RowBox[{"{", "}"}], 
        RowBox[{"{", "}"}], 
        RowBox[{"{", "}"}], 
        RowBox[{"{", "}"}], 
        RowBox[{"{", "}"}], 
        RowBox[{"{", "}"}], 
        RowBox[{"{", "}"}], 
        RowBox[{"{", "}"}], 
        RowBox[{"{", "}"}], 
        RowBox[{"{", "}"}], 
        RowBox[{"{", "}"}]},
       {
        RowBox[{"{", "}"}], 
        RowBox[{"{", "\<\"S\"\>", "}"}], 
        RowBox[{"{", "}"}], 
        RowBox[{"{", "}"}], 
        RowBox[{"{", "}"}], 
        RowBox[{"{", "}"}], 
        RowBox[{"{", "}"}], 
        RowBox[{"{", "}"}], 
        RowBox[{"{", "}"}], 
        RowBox[{"{", "}"}], 
        RowBox[{"{", "}"}], 
        RowBox[{"{", "}"}], 
        RowBox[{"{", "}"}], 
        RowBox[{"{", "}"}], 
        RowBox[{"{", "}"}], 
        RowBox[{"{", "}"}]},
       {
        RowBox[{"{", "}"}], 
        RowBox[{"{", "}"}], 
        RowBox[{"{", "\<\"S\"\>", "}"}], 
        RowBox[{"{", "}"}], 
        RowBox[{"{", "}"}], 
        RowBox[{"{", "}"}], 
        RowBox[{"{", "}"}], 
        RowBox[{"{", "}"}], 
        RowBox[{"{", "}"}], 
        RowBox[{"{", "}"}], 
        RowBox[{"{", "}"}], 
        RowBox[{"{", "}"}], 
        RowBox[{"{", "}"}], 
        RowBox[{"{", "}"}], 
        RowBox[{"{", "}"}], 
        RowBox[{"{", "}"}]},
       {
        RowBox[{"{", "}"}], 
        RowBox[{"{", "}"}], 
        RowBox[{"{", "}"}], 
        RowBox[{"{", "\<\"F\"\>", "}"}], 
        RowBox[{"{", "}"}], 
        RowBox[{"{", "}"}], 
        RowBox[{"{", "}"}], 
        RowBox[{"{", "}"}], 
        RowBox[{"{", "}"}], 
        RowBox[{"{", "}"}], 
        RowBox[{"{", "}"}], 
        RowBox[{"{", "}"}], 
        RowBox[{"{", "}"}], 
        RowBox[{"{", "}"}], 
        RowBox[{"{", "}"}], 
        RowBox[{"{", "}"}]},
       {
        RowBox[{"{", "}"}], 
        RowBox[{"{", "}"}], 
        RowBox[{"{", "}"}], 
        RowBox[{"{", "\<\"F\"\>", "}"}], 
        RowBox[{"{", "}"}], 
        RowBox[{"{", "}"}], 
        RowBox[{"{", "}"}], 
        RowBox[{"{", "}"}], 
        RowBox[{"{", "}"}], 
        RowBox[{"{", "}"}], 
        RowBox[{"{", "}"}], 
        RowBox[{"{", "}"}], 
        RowBox[{"{", "}"}], 
        RowBox[{"{", "}"}], 
        RowBox[{"{", "}"}], 
        RowBox[{"{", "}"}]},
       {
        RowBox[{"{", "}"}], 
        RowBox[{"{", "}"}], 
        RowBox[{"{", "}"}], 
        RowBox[{"{", "}"}], 
        RowBox[{"{", "\<\"S\"\>", "}"}], 
        RowBox[{"{", "}"}], 
        RowBox[{"{", "}"}], 
        RowBox[{"{", "}"}], 
        RowBox[{"{", "}"}], 
        RowBox[{"{", "}"}], 
        RowBox[{"{", "}"}], 
        RowBox[{"{", "}"}], 
        RowBox[{"{", "}"}], 
        RowBox[{"{", "}"}], 
        RowBox[{"{", "}"}], 
        RowBox[{"{", "}"}]},
       {
        RowBox[{"{", "}"}], 
        RowBox[{"{", "}"}], 
        RowBox[{"{", "}"}], 
        RowBox[{"{", "}"}], 
        RowBox[{"{", "\<\"S\"\>", "}"}], 
        RowBox[{"{", "}"}], 
        RowBox[{"{", "}"}], 
        RowBox[{"{", "}"}], 
        RowBox[{"{", "}"}], 
        RowBox[{"{", "}"}], 
        RowBox[{"{", "}"}], 
        RowBox[{"{", "}"}], 
        RowBox[{"{", "}"}], 
        RowBox[{"{", "}"}], 
        RowBox[{"{", "}"}], 
        RowBox[{"{", "}"}]},
       {
        RowBox[{"{", "}"}], 
        RowBox[{"{", "}"}], 
        RowBox[{"{", "}"}], 
        RowBox[{"{", "}"}], 
        RowBox[{"{", "}"}], 
        RowBox[{"{", "\<\"S\"\>", "}"}], 
        RowBox[{"{", "}"}], 
        RowBox[{"{", "}"}], 
        RowBox[{"{", "}"}], 
        RowBox[{"{", "}"}], 
        RowBox[{"{", "}"}], 
        RowBox[{"{", "}"}], 
        RowBox[{"{", "}"}], 
        RowBox[{"{", "}"}], 
        RowBox[{"{", "}"}], 
        RowBox[{"{", "}"}]},
       {
        RowBox[{"{", "}"}], 
        RowBox[{"{", "}"}], 
        RowBox[{"{", "}"}], 
        RowBox[{"{", "}"}], 
        RowBox[{"{", "}"}], 
        RowBox[{"{", "\<\"S\"\>", "}"}], 
        RowBox[{"{", "}"}], 
        RowBox[{"{", "}"}], 
        RowBox[{"{", "}"}], 
        RowBox[{"{", "}"}], 
        RowBox[{"{", "}"}], 
        RowBox[{"{", "}"}], 
        RowBox[{"{", "}"}], 
        RowBox[{"{", "}"}], 
        RowBox[{"{", "}"}], 
        RowBox[{"{", "}"}]}
      },
      GridBoxAlignment->{
       "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
        "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.7]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}], "\[NoBreak]", ")"}],
    Function[BoxForm`e$, 
     MatrixForm[BoxForm`e$]]], ",", 
   TagBox[
    RowBox[{"(", "\[NoBreak]", GridBox[{
       {
        RowBox[{"{", "}"}], 
        RowBox[{"{", "\<\"S\"\>", "}"}], 
        RowBox[{"{", "\<\"S\"\>", "}"}], 
        RowBox[{"{", "\<\"S\"\>", "}"}], 
        RowBox[{"{", "}"}], 
        RowBox[{"{", "}"}], 
        RowBox[{"{", "\<\"S\"\>", "}"}], 
        RowBox[{"{", "}"}], 
        RowBox[{"{", "}"}], 
        RowBox[{"{", "}"}], 
        RowBox[{"{", "}"}], 
        RowBox[{"{", "}"}], 
        RowBox[{"{", "}"}], 
        RowBox[{"{", "}"}], 
        RowBox[{"{", "}"}], 
        RowBox[{"{", "}"}]},
       {
        RowBox[{"{", "\<\"S\"\>", "}"}], 
        RowBox[{"{", "}"}], 
        RowBox[{"{", "}"}], 
        RowBox[{"{", "}"}], 
        RowBox[{"{", "\<\"S\"\>", "}"}], 
        RowBox[{"{", "}"}], 
        RowBox[{"{", "}"}], 
        RowBox[{"{", "\<\"S\"\>", "}"}], 
        RowBox[{"{", "\<\"S\"\>", "}"}], 
        RowBox[{"{", "}"}], 
        RowBox[{"{", "}"}], 
        RowBox[{"{", "}"}], 
        RowBox[{"{", "}"}], 
        RowBox[{"{", "}"}], 
        RowBox[{"{", "}"}], 
        RowBox[{"{", "}"}]},
       {
        RowBox[{"{", "\<\"S\"\>", "}"}], 
        RowBox[{"{", "}"}], 
        RowBox[{"{", "}"}], 
        RowBox[{"{", "}"}], 
        RowBox[{"{", "}"}], 
        RowBox[{"{", "\<\"S\"\>", "}"}], 
        RowBox[{"{", "}"}], 
        RowBox[{"{", "}"}], 
        RowBox[{"{", "}"}], 
        RowBox[{"{", "\<\"S\"\>", "}"}], 
        RowBox[{"{", "}"}], 
        RowBox[{"{", "}"}], 
        RowBox[{"{", "}"}], 
        RowBox[{"{", "}"}], 
        RowBox[{"{", "}"}], 
        RowBox[{"{", "}"}]},
       {
        RowBox[{"{", "\<\"S\"\>", "}"}], 
        RowBox[{"{", "}"}], 
        RowBox[{"{", "}"}], 
        RowBox[{"{", "}"}], 
        RowBox[{"{", "}"}], 
        RowBox[{"{", "}"}], 
        RowBox[{"{", "}"}], 
        RowBox[{"{", "}"}], 
        RowBox[{"{", "}"}], 
        RowBox[{"{", "}"}], 
        RowBox[{"{", "\<\"S\"\>", "}"}], 
        RowBox[{"{", "\<\"S\"\>", "}"}], 
        RowBox[{"{", "}"}], 
        RowBox[{"{", "}"}], 
        RowBox[{"{", "}"}], 
        RowBox[{"{", "}"}]},
       {
        RowBox[{"{", "}"}], 
        RowBox[{"{", "\<\"S\"\>", "}"}], 
        RowBox[{"{", "}"}], 
        RowBox[{"{", "}"}], 
        RowBox[{"{", "}"}], 
        RowBox[{"{", "}"}], 
        RowBox[{"{", "}"}], 
        RowBox[{"{", "}"}], 
        RowBox[{"{", "}"}], 
        RowBox[{"{", "}"}], 
        RowBox[{"{", "}"}], 
        RowBox[{"{", "}"}], 
        RowBox[{"{", "\<\"F\"\>", "}"}], 
        RowBox[{"{", "\<\"F\"\>", "}"}], 
        RowBox[{"{", "}"}], 
        RowBox[{"{", "}"}]},
       {
        RowBox[{"{", "}"}], 
        RowBox[{"{", "}"}], 
        RowBox[{"{", "\<\"S\"\>", "}"}], 
        RowBox[{"{", "}"}], 
        RowBox[{"{", "}"}], 
        RowBox[{"{", "}"}], 
        RowBox[{"{", "}"}], 
        RowBox[{"{", "}"}], 
        RowBox[{"{", "}"}], 
        RowBox[{"{", "}"}], 
        RowBox[{"{", "}"}], 
        RowBox[{"{", "}"}], 
        RowBox[{"{", "}"}], 
        RowBox[{"{", "}"}], 
        RowBox[{"{", "\<\"S\"\>", "}"}], 
        RowBox[{"{", "\<\"S\"\>", "}"}]},
       {
        RowBox[{"{", "\<\"S\"\>", "}"}], 
        RowBox[{"{", "}"}], 
        RowBox[{"{", "}"}], 
        RowBox[{"{", "}"}], 
        RowBox[{"{", "}"}], 
        RowBox[{"{", "}"}], 
        RowBox[{"{", "}"}], 
        RowBox[{"{", "}"}], 
        RowBox[{"{", "}"}], 
        RowBox[{"{", "}"}], 
        RowBox[{"{", "}"}], 
        RowBox[{"{", "}"}], 
        RowBox[{"{", "}"}], 
        RowBox[{"{", "}"}], 
        RowBox[{"{", "}"}], 
        RowBox[{"{", "}"}]},
       {
        RowBox[{"{", "}"}], 
        RowBox[{"{", "\<\"S\"\>", "}"}], 
        RowBox[{"{", "}"}], 
        RowBox[{"{", "}"}], 
        RowBox[{"{", "}"}], 
        RowBox[{"{", "}"}], 
        RowBox[{"{", "}"}], 
        RowBox[{"{", "}"}], 
        RowBox[{"{", "}"}], 
        RowBox[{"{", "}"}], 
        RowBox[{"{", "}"}], 
        RowBox[{"{", "}"}], 
        RowBox[{"{", "}"}], 
        RowBox[{"{", "}"}], 
        RowBox[{"{", "}"}], 
        RowBox[{"{", "}"}]},
       {
        RowBox[{"{", "}"}], 
        RowBox[{"{", "\<\"S\"\>", "}"}], 
        RowBox[{"{", "}"}], 
        RowBox[{"{", "}"}], 
        RowBox[{"{", "}"}], 
        RowBox[{"{", "}"}], 
        RowBox[{"{", "}"}], 
        RowBox[{"{", "}"}], 
        RowBox[{"{", "}"}], 
        RowBox[{"{", "}"}], 
        RowBox[{"{", "}"}], 
        RowBox[{"{", "}"}], 
        RowBox[{"{", "}"}], 
        RowBox[{"{", "}"}], 
        RowBox[{"{", "}"}], 
        RowBox[{"{", "}"}]},
       {
        RowBox[{"{", "}"}], 
        RowBox[{"{", "}"}], 
        RowBox[{"{", "\<\"S\"\>", "}"}], 
        RowBox[{"{", "}"}], 
        RowBox[{"{", "}"}], 
        RowBox[{"{", "}"}], 
        RowBox[{"{", "}"}], 
        RowBox[{"{", "}"}], 
        RowBox[{"{", "}"}], 
        RowBox[{"{", "}"}], 
        RowBox[{"{", "}"}], 
        RowBox[{"{", "}"}], 
        RowBox[{"{", "}"}], 
        RowBox[{"{", "}"}], 
        RowBox[{"{", "}"}], 
        RowBox[{"{", "}"}]},
       {
        RowBox[{"{", "}"}], 
        RowBox[{"{", "}"}], 
        RowBox[{"{", "}"}], 
        RowBox[{"{", "\<\"S\"\>", "}"}], 
        RowBox[{"{", "}"}], 
        RowBox[{"{", "}"}], 
        RowBox[{"{", "}"}], 
        RowBox[{"{", "}"}], 
        RowBox[{"{", "}"}], 
        RowBox[{"{", "}"}], 
        RowBox[{"{", "}"}], 
        RowBox[{"{", "}"}], 
        RowBox[{"{", "}"}], 
        RowBox[{"{", "}"}], 
        RowBox[{"{", "}"}], 
        RowBox[{"{", "}"}]},
       {
        RowBox[{"{", "}"}], 
        RowBox[{"{", "}"}], 
        RowBox[{"{", "}"}], 
        RowBox[{"{", "\<\"S\"\>", "}"}], 
        RowBox[{"{", "}"}], 
        RowBox[{"{", "}"}], 
        RowBox[{"{", "}"}], 
        RowBox[{"{", "}"}], 
        RowBox[{"{", "}"}], 
        RowBox[{"{", "}"}], 
        RowBox[{"{", "}"}], 
        RowBox[{"{", "}"}], 
        RowBox[{"{", "}"}], 
        RowBox[{"{", "}"}], 
        RowBox[{"{", "}"}], 
        RowBox[{"{", "}"}]},
       {
        RowBox[{"{", "}"}], 
        RowBox[{"{", "}"}], 
        RowBox[{"{", "}"}], 
        RowBox[{"{", "}"}], 
        RowBox[{"{", "\<\"F\"\>", "}"}], 
        RowBox[{"{", "}"}], 
        RowBox[{"{", "}"}], 
        RowBox[{"{", "}"}], 
        RowBox[{"{", "}"}], 
        RowBox[{"{", "}"}], 
        RowBox[{"{", "}"}], 
        RowBox[{"{", "}"}], 
        RowBox[{"{", "}"}], 
        RowBox[{"{", "}"}], 
        RowBox[{"{", "}"}], 
        RowBox[{"{", "}"}]},
       {
        RowBox[{"{", "}"}], 
        RowBox[{"{", "}"}], 
        RowBox[{"{", "}"}], 
        RowBox[{"{", "}"}], 
        RowBox[{"{", "\<\"F\"\>", "}"}], 
        RowBox[{"{", "}"}], 
        RowBox[{"{", "}"}], 
        RowBox[{"{", "}"}], 
        RowBox[{"{", "}"}], 
        RowBox[{"{", "}"}], 
        RowBox[{"{", "}"}], 
        RowBox[{"{", "}"}], 
        RowBox[{"{", "}"}], 
        RowBox[{"{", "}"}], 
        RowBox[{"{", "}"}], 
        RowBox[{"{", "}"}]},
       {
        RowBox[{"{", "}"}], 
        RowBox[{"{", "}"}], 
        RowBox[{"{", "}"}], 
        RowBox[{"{", "}"}], 
        RowBox[{"{", "}"}], 
        RowBox[{"{", "\<\"S\"\>", "}"}], 
        RowBox[{"{", "}"}], 
        RowBox[{"{", "}"}], 
        RowBox[{"{", "}"}], 
        RowBox[{"{", "}"}], 
        RowBox[{"{", "}"}], 
        RowBox[{"{", "}"}], 
        RowBox[{"{", "}"}], 
        RowBox[{"{", "}"}], 
        RowBox[{"{", "}"}], 
        RowBox[{"{", "}"}]},
       {
        RowBox[{"{", "}"}], 
        RowBox[{"{", "}"}], 
        RowBox[{"{", "}"}], 
        RowBox[{"{", "}"}], 
        RowBox[{"{", "}"}], 
        RowBox[{"{", "\<\"S\"\>", "}"}], 
        RowBox[{"{", "}"}], 
        RowBox[{"{", "}"}], 
        RowBox[{"{", "}"}], 
        RowBox[{"{", "}"}], 
        RowBox[{"{", "}"}], 
        RowBox[{"{", "}"}], 
        RowBox[{"{", "}"}], 
        RowBox[{"{", "}"}], 
        RowBox[{"{", "}"}], 
        RowBox[{"{", "}"}]}
      },
      GridBoxAlignment->{
       "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
        "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.7]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}], "\[NoBreak]", ")"}],
    Function[BoxForm`e$, 
     MatrixForm[BoxForm`e$]]], ",", 
   TagBox[
    RowBox[{"(", "\[NoBreak]", GridBox[{
       {
        RowBox[{"{", "}"}], 
        RowBox[{"{", "\<\"S\"\>", "}"}], 
        RowBox[{"{", "\<\"S\"\>", "}"}], 
        RowBox[{"{", "\<\"S\"\>", "}"}], 
        RowBox[{"{", "}"}], 
        RowBox[{"{", "}"}], 
        RowBox[{"{", "\<\"S\"\>", "}"}], 
        RowBox[{"{", "}"}], 
        RowBox[{"{", "}"}], 
        RowBox[{"{", "}"}], 
        RowBox[{"{", "}"}], 
        RowBox[{"{", "}"}], 
        RowBox[{"{", "}"}], 
        RowBox[{"{", "}"}], 
        RowBox[{"{", "}"}], 
        RowBox[{"{", "}"}]},
       {
        RowBox[{"{", "\<\"S\"\>", "}"}], 
        RowBox[{"{", "}"}], 
        RowBox[{"{", "}"}], 
        RowBox[{"{", "}"}], 
        RowBox[{"{", "\<\"S\"\>", "}"}], 
        RowBox[{"{", "}"}], 
        RowBox[{"{", "}"}], 
        RowBox[{"{", "\<\"S\"\>", "}"}], 
        RowBox[{"{", "\<\"S\"\>", "}"}], 
        RowBox[{"{", "}"}], 
        RowBox[{"{", "}"}], 
        RowBox[{"{", "}"}], 
        RowBox[{"{", "}"}], 
        RowBox[{"{", "}"}], 
        RowBox[{"{", "}"}], 
        RowBox[{"{", "}"}]},
       {
        RowBox[{"{", "\<\"S\"\>", "}"}], 
        RowBox[{"{", "}"}], 
        RowBox[{"{", "}"}], 
        RowBox[{"{", "}"}], 
        RowBox[{"{", "}"}], 
        RowBox[{"{", "\<\"S\"\>", "}"}], 
        RowBox[{"{", "}"}], 
        RowBox[{"{", "}"}], 
        RowBox[{"{", "}"}], 
        RowBox[{"{", "\<\"S\"\>", "}"}], 
        RowBox[{"{", "}"}], 
        RowBox[{"{", "}"}], 
        RowBox[{"{", "}"}], 
        RowBox[{"{", "}"}], 
        RowBox[{"{", "}"}], 
        RowBox[{"{", "}"}]},
       {
        RowBox[{"{", "\<\"S\"\>", "}"}], 
        RowBox[{"{", "}"}], 
        RowBox[{"{", "}"}], 
        RowBox[{"{", "}"}], 
        RowBox[{"{", "}"}], 
        RowBox[{"{", "}"}], 
        RowBox[{"{", "}"}], 
        RowBox[{"{", "}"}], 
        RowBox[{"{", "}"}], 
        RowBox[{"{", "}"}], 
        RowBox[{"{", "\<\"S\"\>", "}"}], 
        RowBox[{"{", "\<\"S\"\>", "}"}], 
        RowBox[{"{", "}"}], 
        RowBox[{"{", "}"}], 
        RowBox[{"{", "}"}], 
        RowBox[{"{", "}"}]},
       {
        RowBox[{"{", "}"}], 
        RowBox[{"{", "\<\"S\"\>", "}"}], 
        RowBox[{"{", "}"}], 
        RowBox[{"{", "}"}], 
        RowBox[{"{", "}"}], 
        RowBox[{"{", "}"}], 
        RowBox[{"{", "}"}], 
        RowBox[{"{", "}"}], 
        RowBox[{"{", "}"}], 
        RowBox[{"{", "}"}], 
        RowBox[{"{", "}"}], 
        RowBox[{"{", "}"}], 
        RowBox[{"{", "\<\"S\"\>", "}"}], 
        RowBox[{"{", "\<\"S\"\>", "}"}], 
        RowBox[{"{", "}"}], 
        RowBox[{"{", "}"}]},
       {
        RowBox[{"{", "}"}], 
        RowBox[{"{", "}"}], 
        RowBox[{"{", "\<\"S\"\>", "}"}], 
        RowBox[{"{", "}"}], 
        RowBox[{"{", "}"}], 
        RowBox[{"{", "}"}], 
        RowBox[{"{", "}"}], 
        RowBox[{"{", "}"}], 
        RowBox[{"{", "}"}], 
        RowBox[{"{", "}"}], 
        RowBox[{"{", "}"}], 
        RowBox[{"{", "}"}], 
        RowBox[{"{", "}"}], 
        RowBox[{"{", "}"}], 
        RowBox[{"{", "\<\"F\"\>", "}"}], 
        RowBox[{"{", "\<\"F\"\>", "}"}]},
       {
        RowBox[{"{", "\<\"S\"\>", "}"}], 
        RowBox[{"{", "}"}], 
        RowBox[{"{", "}"}], 
        RowBox[{"{", "}"}], 
        RowBox[{"{", "}"}], 
        RowBox[{"{", "}"}], 
        RowBox[{"{", "}"}], 
        RowBox[{"{", "}"}], 
        RowBox[{"{", "}"}], 
        RowBox[{"{", "}"}], 
        RowBox[{"{", "}"}], 
        RowBox[{"{", "}"}], 
        RowBox[{"{", "}"}], 
        RowBox[{"{", "}"}], 
        RowBox[{"{", "}"}], 
        RowBox[{"{", "}"}]},
       {
        RowBox[{"{", "}"}], 
        RowBox[{"{", "\<\"S\"\>", "}"}], 
        RowBox[{"{", "}"}], 
        RowBox[{"{", "}"}], 
        RowBox[{"{", "}"}], 
        RowBox[{"{", "}"}], 
        RowBox[{"{", "}"}], 
        RowBox[{"{", "}"}], 
        RowBox[{"{", "}"}], 
        RowBox[{"{", "}"}], 
        RowBox[{"{", "}"}], 
        RowBox[{"{", "}"}], 
        RowBox[{"{", "}"}], 
        RowBox[{"{", "}"}], 
        RowBox[{"{", "}"}], 
        RowBox[{"{", "}"}]},
       {
        RowBox[{"{", "}"}], 
        RowBox[{"{", "\<\"S\"\>", "}"}], 
        RowBox[{"{", "}"}], 
        RowBox[{"{", "}"}], 
        RowBox[{"{", "}"}], 
        RowBox[{"{", "}"}], 
        RowBox[{"{", "}"}], 
        RowBox[{"{", "}"}], 
        RowBox[{"{", "}"}], 
        RowBox[{"{", "}"}], 
        RowBox[{"{", "}"}], 
        RowBox[{"{", "}"}], 
        RowBox[{"{", "}"}], 
        RowBox[{"{", "}"}], 
        RowBox[{"{", "}"}], 
        RowBox[{"{", "}"}]},
       {
        RowBox[{"{", "}"}], 
        RowBox[{"{", "}"}], 
        RowBox[{"{", "\<\"S\"\>", "}"}], 
        RowBox[{"{", "}"}], 
        RowBox[{"{", "}"}], 
        RowBox[{"{", "}"}], 
        RowBox[{"{", "}"}], 
        RowBox[{"{", "}"}], 
        RowBox[{"{", "}"}], 
        RowBox[{"{", "}"}], 
        RowBox[{"{", "}"}], 
        RowBox[{"{", "}"}], 
        RowBox[{"{", "}"}], 
        RowBox[{"{", "}"}], 
        RowBox[{"{", "}"}], 
        RowBox[{"{", "}"}]},
       {
        RowBox[{"{", "}"}], 
        RowBox[{"{", "}"}], 
        RowBox[{"{", "}"}], 
        RowBox[{"{", "\<\"S\"\>", "}"}], 
        RowBox[{"{", "}"}], 
        RowBox[{"{", "}"}], 
        RowBox[{"{", "}"}], 
        RowBox[{"{", "}"}], 
        RowBox[{"{", "}"}], 
        RowBox[{"{", "}"}], 
        RowBox[{"{", "}"}], 
        RowBox[{"{", "}"}], 
        RowBox[{"{", "}"}], 
        RowBox[{"{", "}"}], 
        RowBox[{"{", "}"}], 
        RowBox[{"{", "}"}]},
       {
        RowBox[{"{", "}"}], 
        RowBox[{"{", "}"}], 
        RowBox[{"{", "}"}], 
        RowBox[{"{", "\<\"S\"\>", "}"}], 
        RowBox[{"{", "}"}], 
        RowBox[{"{", "}"}], 
        RowBox[{"{", "}"}], 
        RowBox[{"{", "}"}], 
        RowBox[{"{", "}"}], 
        RowBox[{"{", "}"}], 
        RowBox[{"{", "}"}], 
        RowBox[{"{", "}"}], 
        RowBox[{"{", "}"}], 
        RowBox[{"{", "}"}], 
        RowBox[{"{", "}"}], 
        RowBox[{"{", "}"}]},
       {
        RowBox[{"{", "}"}], 
        RowBox[{"{", "}"}], 
        RowBox[{"{", "}"}], 
        RowBox[{"{", "}"}], 
        RowBox[{"{", "\<\"S\"\>", "}"}], 
        RowBox[{"{", "}"}], 
        RowBox[{"{", "}"}], 
        RowBox[{"{", "}"}], 
        RowBox[{"{", "}"}], 
        RowBox[{"{", "}"}], 
        RowBox[{"{", "}"}], 
        RowBox[{"{", "}"}], 
        RowBox[{"{", "}"}], 
        RowBox[{"{", "}"}], 
        RowBox[{"{", "}"}], 
        RowBox[{"{", "}"}]},
       {
        RowBox[{"{", "}"}], 
        RowBox[{"{", "}"}], 
        RowBox[{"{", "}"}], 
        RowBox[{"{", "}"}], 
        RowBox[{"{", "\<\"S\"\>", "}"}], 
        RowBox[{"{", "}"}], 
        RowBox[{"{", "}"}], 
        RowBox[{"{", "}"}], 
        RowBox[{"{", "}"}], 
        RowBox[{"{", "}"}], 
        RowBox[{"{", "}"}], 
        RowBox[{"{", "}"}], 
        RowBox[{"{", "}"}], 
        RowBox[{"{", "}"}], 
        RowBox[{"{", "}"}], 
        RowBox[{"{", "}"}]},
       {
        RowBox[{"{", "}"}], 
        RowBox[{"{", "}"}], 
        RowBox[{"{", "}"}], 
        RowBox[{"{", "}"}], 
        RowBox[{"{", "}"}], 
        RowBox[{"{", "\<\"F\"\>", "}"}], 
        RowBox[{"{", "}"}], 
        RowBox[{"{", "}"}], 
        RowBox[{"{", "}"}], 
        RowBox[{"{", "}"}], 
        RowBox[{"{", "}"}], 
        RowBox[{"{", "}"}], 
        RowBox[{"{", "}"}], 
        RowBox[{"{", "}"}], 
        RowBox[{"{", "}"}], 
        RowBox[{"{", "}"}]},
       {
        RowBox[{"{", "}"}], 
        RowBox[{"{", "}"}], 
        RowBox[{"{", "}"}], 
        RowBox[{"{", "}"}], 
        RowBox[{"{", "}"}], 
        RowBox[{"{", "\<\"F\"\>", "}"}], 
        RowBox[{"{", "}"}], 
        RowBox[{"{", "}"}], 
        RowBox[{"{", "}"}], 
        RowBox[{"{", "}"}], 
        RowBox[{"{", "}"}], 
        RowBox[{"{", "}"}], 
        RowBox[{"{", "}"}], 
        RowBox[{"{", "}"}], 
        RowBox[{"{", "}"}], 
        RowBox[{"{", "}"}]}
      },
      GridBoxAlignment->{
       "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
        "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.7]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}], "\[NoBreak]", ")"}],
    Function[BoxForm`e$, 
     MatrixForm[BoxForm`e$]]]}], "}"}]], "Output",
 CellChangeTimes->{{3.736060146080111*^9, 3.7360601824266076`*^9}, 
   3.736073363864558*^9},ExpressionUUID->"5b9c7301-23e6-4d46-b219-\
2ee409017841"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   GraphicsBox[
    NamespaceBox["NetworkGraphics",
     DynamicModuleBox[{Typeset`graph = HoldComplete[
       Graph[{1, 2, 3, 4, 7, 5, 8, 9, 6, 10, 11, 12, 13, 14, 15, 16}, {
        Null, {{1, 2}, {1, 3}, {1, 4}, {1, 5}, {2, 6}, {2, 7}, {2, 8}, {3, 
         9}, {3, 10}, {4, 11}, {4, 12}, {6, 13}, {6, 14}, {9, 15}, {9, 
         16}}}, {EdgeShapeFunction -> {
          UndirectedEdge[1, 2] -> ({Increment[$CellContext`x3$1815]; Append[
               Part[{{
                  Dashing[{Small, Small}]}}, $CellContext`x3$1815], 
               Line[#]]}& ), 
           UndirectedEdge[3, 6] -> ({Increment[$CellContext`x10$1815]; Append[
               Part[{{}}, $CellContext`x10$1815], 
               Line[#]]}& ), 
           UndirectedEdge[4, 12] -> ({Increment[$CellContext`x13$1815]; Append[
               Part[{{
                  Dashing[{Small, Small}]}}, $CellContext`x13$1815], 
               Line[#]]}& ), 
           UndirectedEdge[1, 3] -> ({Increment[$CellContext`x4$1815]; Append[
               Part[{{
                  Dashing[{Small, Small}]}}, $CellContext`x4$1815], 
               Line[#]]}& ), 
           UndirectedEdge[4, 11] -> ({Increment[$CellContext`x12$1815]; Append[
               Part[{{
                  Dashing[{Small, Small}]}}, $CellContext`x12$1815], 
               Line[#]]}& ), 
           UndirectedEdge[6, 16] -> ({Increment[$CellContext`x17$1815]; Append[
               Part[{{
                  Dashing[{Small, Small}]}}, $CellContext`x17$1815], 
               Line[#]]}& ), 
           UndirectedEdge[6, 15] -> ({Increment[$CellContext`x16$1815]; Append[
               Part[{{}}, $CellContext`x16$1815], 
               Line[#]]}& ), 
           UndirectedEdge[3, 10] -> ({Increment[$CellContext`x11$1815]; Append[
               Part[{{}}, $CellContext`x11$1815], 
               Line[#]]}& ), 
           UndirectedEdge[2, 5] -> ({Increment[$CellContext`x7$1815]; Append[
               Part[{{
                  Dashing[{Small, Small}]}}, $CellContext`x7$1815], 
               Line[#]]}& ), 
           UndirectedEdge[1, 4] -> ({Increment[$CellContext`x5$1815]; Append[
               Part[{{
                  Dashing[{Small, Small}]}}, $CellContext`x5$1815], 
               Line[#]]}& ), 
           UndirectedEdge[5, 13] -> ({Increment[$CellContext`x14$1815]; Append[
               Part[{{
                  Dashing[{Small, Small}]}}, $CellContext`x14$1815], 
               Line[#]]}& ), 
           UndirectedEdge[2, 8] -> ({Increment[$CellContext`x8$1815]; Append[
               Part[{{
                  Dashing[{Small, Small}]}}, $CellContext`x8$1815], 
               Line[#]]}& ), 
           UndirectedEdge[1, 7] -> ({Increment[$CellContext`x6$1815]; Append[
               Part[{{
                  Dashing[{Small, Small}]}}, $CellContext`x6$1815], 
               Line[#]]}& ), 
           UndirectedEdge[2, 9] -> ({Increment[$CellContext`x9$1815]; Append[
               Part[{{
                  Dashing[{Small, Small}]}}, $CellContext`x9$1815], 
               Line[#]]}& ), 
           UndirectedEdge[5, 14] -> ({Increment[$CellContext`x15$1815]; Append[
               Part[{{
                  Dashing[{Small, Small}]}}, $CellContext`x15$1815], 
               Line[#]]}& )}, ImageSize -> 300}]]}, 
      TagBox[GraphicsGroupBox[{
         {Hue[0.6, 0.7, 0.5], Opacity[0.7], 
          {Dashing[{Small, Small}], 
           LineBox[{{2.6969408471239977`, 1.9037229509110571`}, {
            0.9518614754555286, 1.2691486339407048`}}]}, 
          {Dashing[{Small, Small}], 
           LineBox[{{2.6969408471239977`, 1.9037229509110571`}, {
            2.5382972678814095`, 1.2691486339407048`}}]}, 
          {Dashing[{Small, Small}], 
           LineBox[{{2.6969408471239977`, 1.9037229509110571`}, {
            3.8074459018221143`, 1.2691486339407048`}}]}, 
          {Dashing[{Small, Small}], 
           LineBox[{{2.6969408471239977`, 1.9037229509110571`}, {
            4.442020218792467, 1.2691486339407048`}}]}, 
          {Dashing[{Small, Small}], 
           LineBox[{{0.9518614754555286, 1.2691486339407048`}, {
            0.3172871584851762, 0.6345743169703524}}]}, 
          {Dashing[{Small, Small}], 
           LineBox[{{0.9518614754555286, 1.2691486339407048`}, {
            0.9518614754555286, 0.6345743169703524}}]}, 
          {Dashing[{Small, Small}], 
           LineBox[{{0.9518614754555286, 1.2691486339407048`}, {
            1.586435792425881, 0.6345743169703524}}]}, 
          LineBox[{{2.5382972678814095`, 1.2691486339407048`}, {
           2.2210101093962336`, 0.6345743169703524}}], 
          LineBox[{{2.5382972678814095`, 1.2691486339407048`}, {
           2.855584426366586, 0.6345743169703524}}], 
          {Dashing[{Small, Small}], 
           LineBox[{{3.8074459018221143`, 1.2691486339407048`}, {
            3.4901587433369383`, 0.6345743169703524}}]}, 
          {Dashing[{Small, Small}], 
           LineBox[{{3.8074459018221143`, 1.2691486339407048`}, {
            4.124733060307291, 0.6345743169703524}}]}, 
          {Dashing[{Small, Small}], 
           LineBox[{{0.3172871584851762, 0.6345743169703524}, {0., 0.}}]}, 
          {Dashing[{Small, Small}], 
           LineBox[{{0.3172871584851762, 0.6345743169703524}, {
            0.6345743169703524, 0.}}]}, 
          LineBox[{{2.2210101093962336`, 0.6345743169703524}, {
           1.9037229509110571`, 0.}}], 
          {Dashing[{Small, Small}], 
           LineBox[{{2.2210101093962336`, 0.6345743169703524}, {
            2.5382972678814095`, 0.}}]}}, 
         {Hue[0.6, 0.2, 0.8], EdgeForm[{GrayLevel[0], Opacity[0.7]}], 
          DiskBox[{2.6969408471239977, 1.9037229509110571}, 
           0.039758694132184136], 
          DiskBox[{0.9518614754555286, 1.2691486339407048}, 
           0.039758694132184136], 
          DiskBox[{2.5382972678814095, 1.2691486339407048}, 
           0.039758694132184136], 
          DiskBox[{3.8074459018221143, 1.2691486339407048}, 
           0.039758694132184136], 
          DiskBox[{4.442020218792467, 1.2691486339407048}, 
           0.039758694132184136], 
          DiskBox[{0.3172871584851762, 0.6345743169703524}, 
           0.039758694132184136], 
          DiskBox[{0.9518614754555286, 0.6345743169703524}, 
           0.039758694132184136], 
          DiskBox[{1.586435792425881, 0.6345743169703524}, 
           0.039758694132184136], 
          DiskBox[{2.2210101093962336, 0.6345743169703524}, 
           0.039758694132184136], 
          DiskBox[{2.855584426366586, 0.6345743169703524}, 
           0.039758694132184136], 
          DiskBox[{3.4901587433369383, 0.6345743169703524}, 
           0.039758694132184136], 
          DiskBox[{4.124733060307291, 0.6345743169703524}, 
           0.039758694132184136], DiskBox[{0., 0.}, 0.039758694132184136], 
          DiskBox[{0.6345743169703524, 0.}, 0.039758694132184136], 
          DiskBox[{1.9037229509110571, 0.}, 0.039758694132184136], 
          DiskBox[{2.5382972678814095, 0.}, 0.039758694132184136]}}],
       MouseAppearanceTag["NetworkGraphics"]],
      AllowKernelInitialization->False]],
    DefaultBaseStyle->{
     "NetworkGraphics", FrontEnd`GraphicsHighlightColor -> Hue[0.8, 1., 0.6]},
    FormatType->TraditionalForm,
    FrameTicks->None,
    ImageSize->300], ",", 
   GraphicsBox[
    NamespaceBox["NetworkGraphics",
     DynamicModuleBox[{Typeset`graph = HoldComplete[
       Graph[{1, 2, 3, 4, 7, 5, 8, 9, 6, 10, 11, 12, 13, 14, 15, 16}, {
        Null, {{1, 2}, {1, 3}, {1, 4}, {1, 5}, {2, 6}, {2, 7}, {2, 8}, {3, 
         9}, {3, 10}, {4, 11}, {4, 12}, {6, 13}, {6, 14}, {9, 15}, {9, 
         16}}}, {EdgeShapeFunction -> {
          UndirectedEdge[1, 2] -> ({Increment[$CellContext`x18$1818]; Append[
               Part[{{
                  Dashing[{Small, Small}]}}, $CellContext`x18$1818], 
               Line[#]]}& ), 
           UndirectedEdge[3, 6] -> ({Increment[$CellContext`x25$1818]; Append[
               Part[{{
                  Dashing[{Small, Small}]}}, $CellContext`x25$1818], 
               Line[#]]}& ), 
           UndirectedEdge[4, 12] -> ({Increment[$CellContext`x28$1818]; Append[
               Part[{{}}, $CellContext`x28$1818], 
               Line[#]]}& ), 
           UndirectedEdge[1, 3] -> ({Increment[$CellContext`x19$1818]; Append[
               Part[{{
                  Dashing[{Small, Small}]}}, $CellContext`x19$1818], 
               Line[#]]}& ), 
           UndirectedEdge[4, 11] -> ({Increment[$CellContext`x27$1818]; Append[
               Part[{{}}, $CellContext`x27$1818], 
               Line[#]]}& ), 
           UndirectedEdge[6, 16] -> ({Increment[$CellContext`x32$1818]; Append[
               Part[{{
                  Dashing[{Small, Small}]}}, $CellContext`x32$1818], 
               Line[#]]}& ), 
           UndirectedEdge[6, 15] -> ({Increment[$CellContext`x31$1818]; Append[
               Part[{{
                  Dashing[{Small, Small}]}}, $CellContext`x31$1818], 
               Line[#]]}& ), 
           UndirectedEdge[3, 10] -> ({Increment[$CellContext`x26$1818]; Append[
               Part[{{
                  Dashing[{Small, Small}]}}, $CellContext`x26$1818], 
               Line[#]]}& ), 
           UndirectedEdge[2, 5] -> ({Increment[$CellContext`x22$1818]; Append[
               Part[{{
                  Dashing[{Small, Small}]}}, $CellContext`x22$1818], 
               Line[#]]}& ), 
           UndirectedEdge[1, 4] -> ({Increment[$CellContext`x20$1818]; Append[
               Part[{{
                  Dashing[{Small, Small}]}}, $CellContext`x20$1818], 
               Line[#]]}& ), 
           UndirectedEdge[5, 13] -> ({Increment[$CellContext`x29$1818]; Append[
               Part[{{
                  Dashing[{Small, Small}]}}, $CellContext`x29$1818], 
               Line[#]]}& ), 
           UndirectedEdge[2, 8] -> ({Increment[$CellContext`x23$1818]; Append[
               Part[{{
                  Dashing[{Small, Small}]}}, $CellContext`x23$1818], 
               Line[#]]}& ), 
           UndirectedEdge[1, 7] -> ({Increment[$CellContext`x21$1818]; Append[
               Part[{{
                  Dashing[{Small, Small}]}}, $CellContext`x21$1818], 
               Line[#]]}& ), 
           UndirectedEdge[2, 9] -> ({Increment[$CellContext`x24$1818]; Append[
               Part[{{
                  Dashing[{Small, Small}]}}, $CellContext`x24$1818], 
               Line[#]]}& ), 
           UndirectedEdge[5, 14] -> ({Increment[$CellContext`x30$1818]; Append[
               Part[{{
                  Dashing[{Small, Small}]}}, $CellContext`x30$1818], 
               Line[#]]}& )}, ImageSize -> 300}]]}, 
      TagBox[GraphicsGroupBox[{
         {Hue[0.6, 0.7, 0.5], Opacity[0.7], 
          {Dashing[{Small, Small}], 
           LineBox[{{2.6969408471239977`, 1.9037229509110571`}, {
            0.9518614754555286, 1.2691486339407048`}}]}, 
          {Dashing[{Small, Small}], 
           LineBox[{{2.6969408471239977`, 1.9037229509110571`}, {
            2.5382972678814095`, 1.2691486339407048`}}]}, 
          {Dashing[{Small, Small}], 
           LineBox[{{2.6969408471239977`, 1.9037229509110571`}, {
            3.8074459018221143`, 1.2691486339407048`}}]}, 
          {Dashing[{Small, Small}], 
           LineBox[{{2.6969408471239977`, 1.9037229509110571`}, {
            4.442020218792467, 1.2691486339407048`}}]}, 
          {Dashing[{Small, Small}], 
           LineBox[{{0.9518614754555286, 1.2691486339407048`}, {
            0.3172871584851762, 0.6345743169703524}}]}, 
          {Dashing[{Small, Small}], 
           LineBox[{{0.9518614754555286, 1.2691486339407048`}, {
            0.9518614754555286, 0.6345743169703524}}]}, 
          {Dashing[{Small, Small}], 
           LineBox[{{0.9518614754555286, 1.2691486339407048`}, {
            1.586435792425881, 0.6345743169703524}}]}, 
          {Dashing[{Small, Small}], 
           LineBox[{{2.5382972678814095`, 1.2691486339407048`}, {
            2.2210101093962336`, 0.6345743169703524}}]}, 
          {Dashing[{Small, Small}], 
           LineBox[{{2.5382972678814095`, 1.2691486339407048`}, {
            2.855584426366586, 0.6345743169703524}}]}, 
          LineBox[{{3.8074459018221143`, 1.2691486339407048`}, {
           3.4901587433369383`, 0.6345743169703524}}], 
          LineBox[{{3.8074459018221143`, 1.2691486339407048`}, {
           4.124733060307291, 0.6345743169703524}}], 
          {Dashing[{Small, Small}], 
           LineBox[{{0.3172871584851762, 0.6345743169703524}, {0., 0.}}]}, 
          {Dashing[{Small, Small}], 
           LineBox[{{0.3172871584851762, 0.6345743169703524}, {
            0.6345743169703524, 0.}}]}, 
          {Dashing[{Small, Small}], 
           LineBox[{{2.2210101093962336`, 0.6345743169703524}, {
            1.9037229509110571`, 0.}}]}, 
          {Dashing[{Small, Small}], 
           LineBox[{{2.2210101093962336`, 0.6345743169703524}, {
            2.5382972678814095`, 0.}}]}}, 
         {Hue[0.6, 0.2, 0.8], EdgeForm[{GrayLevel[0], Opacity[0.7]}], 
          DiskBox[{2.6969408471239977, 1.9037229509110571}, 
           0.039758694132184136], 
          DiskBox[{0.9518614754555286, 1.2691486339407048}, 
           0.039758694132184136], 
          DiskBox[{2.5382972678814095, 1.2691486339407048}, 
           0.039758694132184136], 
          DiskBox[{3.8074459018221143, 1.2691486339407048}, 
           0.039758694132184136], 
          DiskBox[{4.442020218792467, 1.2691486339407048}, 
           0.039758694132184136], 
          DiskBox[{0.3172871584851762, 0.6345743169703524}, 
           0.039758694132184136], 
          DiskBox[{0.9518614754555286, 0.6345743169703524}, 
           0.039758694132184136], 
          DiskBox[{1.586435792425881, 0.6345743169703524}, 
           0.039758694132184136], 
          DiskBox[{2.2210101093962336, 0.6345743169703524}, 
           0.039758694132184136], 
          DiskBox[{2.855584426366586, 0.6345743169703524}, 
           0.039758694132184136], 
          DiskBox[{3.4901587433369383, 0.6345743169703524}, 
           0.039758694132184136], 
          DiskBox[{4.124733060307291, 0.6345743169703524}, 
           0.039758694132184136], DiskBox[{0., 0.}, 0.039758694132184136], 
          DiskBox[{0.6345743169703524, 0.}, 0.039758694132184136], 
          DiskBox[{1.9037229509110571, 0.}, 0.039758694132184136], 
          DiskBox[{2.5382972678814095, 0.}, 0.039758694132184136]}}],
       MouseAppearanceTag["NetworkGraphics"]],
      AllowKernelInitialization->False]],
    DefaultBaseStyle->{
     "NetworkGraphics", FrontEnd`GraphicsHighlightColor -> Hue[0.8, 1., 0.6]},
    FormatType->TraditionalForm,
    FrameTicks->None,
    ImageSize->300], ",", 
   GraphicsBox[
    NamespaceBox["NetworkGraphics",
     DynamicModuleBox[{Typeset`graph = HoldComplete[
       Graph[{1, 2, 3, 4, 7, 5, 8, 9, 6, 10, 11, 12, 13, 14, 15, 16}, {
        Null, {{1, 2}, {1, 3}, {1, 4}, {1, 5}, {2, 6}, {2, 7}, {2, 8}, {3, 
         9}, {3, 10}, {4, 11}, {4, 12}, {6, 13}, {6, 14}, {9, 15}, {9, 
         16}}}, {EdgeShapeFunction -> {
          UndirectedEdge[1, 2] -> ({Increment[$CellContext`x33$1821]; Append[
               Part[{{
                  Dashing[{Small, Small}]}}, $CellContext`x33$1821], 
               Line[#]]}& ), 
           UndirectedEdge[3, 6] -> ({Increment[$CellContext`x40$1821]; Append[
               Part[{{
                  Dashing[{Small, Small}]}}, $CellContext`x40$1821], 
               Line[#]]}& ), 
           UndirectedEdge[4, 12] -> ({Increment[$CellContext`x43$1821]; Append[
               Part[{{
                  Dashing[{Small, Small}]}}, $CellContext`x43$1821], 
               Line[#]]}& ), 
           UndirectedEdge[1, 3] -> ({Increment[$CellContext`x34$1821]; Append[
               Part[{{
                  Dashing[{Small, Small}]}}, $CellContext`x34$1821], 
               Line[#]]}& ), 
           UndirectedEdge[4, 11] -> ({Increment[$CellContext`x42$1821]; Append[
               Part[{{
                  Dashing[{Small, Small}]}}, $CellContext`x42$1821], 
               Line[#]]}& ), 
           UndirectedEdge[6, 16] -> ({Increment[$CellContext`x47$1821]; Append[
               Part[{{
                  Dashing[{Small, Small}]}}, $CellContext`x47$1821], 
               Line[#]]}& ), 
           UndirectedEdge[6, 15] -> ({Increment[$CellContext`x46$1821]; Append[
               Part[{{
                  Dashing[{Small, Small}]}}, $CellContext`x46$1821], 
               Line[#]]}& ), 
           UndirectedEdge[3, 10] -> ({Increment[$CellContext`x41$1821]; Append[
               Part[{{
                  Dashing[{Small, Small}]}}, $CellContext`x41$1821], 
               Line[#]]}& ), 
           UndirectedEdge[2, 5] -> ({Increment[$CellContext`x37$1821]; Append[
               Part[{{
                  Dashing[{Small, Small}]}}, $CellContext`x37$1821], 
               Line[#]]}& ), 
           UndirectedEdge[1, 4] -> ({Increment[$CellContext`x35$1821]; Append[
               Part[{{
                  Dashing[{Small, Small}]}}, $CellContext`x35$1821], 
               Line[#]]}& ), 
           UndirectedEdge[5, 13] -> ({Increment[$CellContext`x44$1821]; Append[
               Part[{{}}, $CellContext`x44$1821], 
               Line[#]]}& ), 
           UndirectedEdge[2, 8] -> ({Increment[$CellContext`x38$1821]; Append[
               Part[{{
                  Dashing[{Small, Small}]}}, $CellContext`x38$1821], 
               Line[#]]}& ), 
           UndirectedEdge[1, 7] -> ({Increment[$CellContext`x36$1821]; Append[
               Part[{{
                  Dashing[{Small, Small}]}}, $CellContext`x36$1821], 
               Line[#]]}& ), 
           UndirectedEdge[2, 9] -> ({Increment[$CellContext`x39$1821]; Append[
               Part[{{
                  Dashing[{Small, Small}]}}, $CellContext`x39$1821], 
               Line[#]]}& ), 
           UndirectedEdge[5, 14] -> ({Increment[$CellContext`x45$1821]; Append[
               Part[{{}}, $CellContext`x45$1821], 
               Line[#]]}& )}, ImageSize -> 300}]]}, 
      TagBox[GraphicsGroupBox[{
         {Hue[0.6, 0.7, 0.5], Opacity[0.7], 
          {Dashing[{Small, Small}], 
           LineBox[{{2.6969408471239977`, 1.9037229509110571`}, {
            0.9518614754555286, 1.2691486339407048`}}]}, 
          {Dashing[{Small, Small}], 
           LineBox[{{2.6969408471239977`, 1.9037229509110571`}, {
            2.5382972678814095`, 1.2691486339407048`}}]}, 
          {Dashing[{Small, Small}], 
           LineBox[{{2.6969408471239977`, 1.9037229509110571`}, {
            3.8074459018221143`, 1.2691486339407048`}}]}, 
          {Dashing[{Small, Small}], 
           LineBox[{{2.6969408471239977`, 1.9037229509110571`}, {
            4.442020218792467, 1.2691486339407048`}}]}, 
          {Dashing[{Small, Small}], 
           LineBox[{{0.9518614754555286, 1.2691486339407048`}, {
            0.3172871584851762, 0.6345743169703524}}]}, 
          {Dashing[{Small, Small}], 
           LineBox[{{0.9518614754555286, 1.2691486339407048`}, {
            0.9518614754555286, 0.6345743169703524}}]}, 
          {Dashing[{Small, Small}], 
           LineBox[{{0.9518614754555286, 1.2691486339407048`}, {
            1.586435792425881, 0.6345743169703524}}]}, 
          {Dashing[{Small, Small}], 
           LineBox[{{2.5382972678814095`, 1.2691486339407048`}, {
            2.2210101093962336`, 0.6345743169703524}}]}, 
          {Dashing[{Small, Small}], 
           LineBox[{{2.5382972678814095`, 1.2691486339407048`}, {
            2.855584426366586, 0.6345743169703524}}]}, 
          {Dashing[{Small, Small}], 
           LineBox[{{3.8074459018221143`, 1.2691486339407048`}, {
            3.4901587433369383`, 0.6345743169703524}}]}, 
          {Dashing[{Small, Small}], 
           LineBox[{{3.8074459018221143`, 1.2691486339407048`}, {
            4.124733060307291, 0.6345743169703524}}]}, 
          LineBox[{{0.3172871584851762, 0.6345743169703524}, {0., 0.}}], 
          LineBox[{{0.3172871584851762, 0.6345743169703524}, {
           0.6345743169703524, 0.}}], 
          {Dashing[{Small, Small}], 
           LineBox[{{2.2210101093962336`, 0.6345743169703524}, {
            1.9037229509110571`, 0.}}]}, 
          {Dashing[{Small, Small}], 
           LineBox[{{2.2210101093962336`, 0.6345743169703524}, {
            2.5382972678814095`, 0.}}]}}, 
         {Hue[0.6, 0.2, 0.8], EdgeForm[{GrayLevel[0], Opacity[0.7]}], 
          DiskBox[{2.6969408471239977, 1.9037229509110571}, 
           0.039758694132184136], 
          DiskBox[{0.9518614754555286, 1.2691486339407048}, 
           0.039758694132184136], 
          DiskBox[{2.5382972678814095, 1.2691486339407048}, 
           0.039758694132184136], 
          DiskBox[{3.8074459018221143, 1.2691486339407048}, 
           0.039758694132184136], 
          DiskBox[{4.442020218792467, 1.2691486339407048}, 
           0.039758694132184136], 
          DiskBox[{0.3172871584851762, 0.6345743169703524}, 
           0.039758694132184136], 
          DiskBox[{0.9518614754555286, 0.6345743169703524}, 
           0.039758694132184136], 
          DiskBox[{1.586435792425881, 0.6345743169703524}, 
           0.039758694132184136], 
          DiskBox[{2.2210101093962336, 0.6345743169703524}, 
           0.039758694132184136], 
          DiskBox[{2.855584426366586, 0.6345743169703524}, 
           0.039758694132184136], 
          DiskBox[{3.4901587433369383, 0.6345743169703524}, 
           0.039758694132184136], 
          DiskBox[{4.124733060307291, 0.6345743169703524}, 
           0.039758694132184136], DiskBox[{0., 0.}, 0.039758694132184136], 
          DiskBox[{0.6345743169703524, 0.}, 0.039758694132184136], 
          DiskBox[{1.9037229509110571, 0.}, 0.039758694132184136], 
          DiskBox[{2.5382972678814095, 0.}, 0.039758694132184136]}}],
       MouseAppearanceTag["NetworkGraphics"]],
      AllowKernelInitialization->False]],
    DefaultBaseStyle->{
     "NetworkGraphics", FrontEnd`GraphicsHighlightColor -> Hue[0.8, 1., 0.6]},
    FormatType->TraditionalForm,
    FrameTicks->None,
    ImageSize->300], ",", 
   GraphicsBox[
    NamespaceBox["NetworkGraphics",
     DynamicModuleBox[{Typeset`graph = HoldComplete[
       Graph[{1, 2, 3, 4, 7, 5, 8, 9, 6, 10, 11, 12, 13, 14, 15, 16}, {
        Null, {{1, 2}, {1, 3}, {1, 4}, {1, 5}, {2, 6}, {2, 7}, {2, 8}, {3, 
         9}, {3, 10}, {4, 11}, {4, 12}, {6, 13}, {6, 14}, {9, 15}, {9, 
         16}}}, {EdgeShapeFunction -> {
          UndirectedEdge[1, 2] -> ({Increment[$CellContext`x48$1824]; Append[
               Part[{{
                  Dashing[{Small, Small}]}}, $CellContext`x48$1824], 
               Line[#]]}& ), 
           UndirectedEdge[3, 6] -> ({Increment[$CellContext`x55$1824]; Append[
               Part[{{
                  Dashing[{Small, Small}]}}, $CellContext`x55$1824], 
               Line[#]]}& ), 
           UndirectedEdge[4, 12] -> ({Increment[$CellContext`x58$1824]; Append[
               Part[{{
                  Dashing[{Small, Small}]}}, $CellContext`x58$1824], 
               Line[#]]}& ), 
           UndirectedEdge[1, 3] -> ({Increment[$CellContext`x49$1824]; Append[
               Part[{{
                  Dashing[{Small, Small}]}}, $CellContext`x49$1824], 
               Line[#]]}& ), 
           UndirectedEdge[4, 11] -> ({Increment[$CellContext`x57$1824]; Append[
               Part[{{
                  Dashing[{Small, Small}]}}, $CellContext`x57$1824], 
               Line[#]]}& ), 
           UndirectedEdge[6, 16] -> ({Increment[$CellContext`x62$1824]; Append[
               Part[{{}}, $CellContext`x62$1824], 
               Line[#]]}& ), 
           UndirectedEdge[6, 15] -> ({Increment[$CellContext`x61$1824]; Append[
               Part[{{}}, $CellContext`x61$1824], 
               Line[#]]}& ), 
           UndirectedEdge[3, 10] -> ({Increment[$CellContext`x56$1824]; Append[
               Part[{{
                  Dashing[{Small, Small}]}}, $CellContext`x56$1824], 
               Line[#]]}& ), 
           UndirectedEdge[2, 5] -> ({Increment[$CellContext`x52$1824]; Append[
               Part[{{
                  Dashing[{Small, Small}]}}, $CellContext`x52$1824], 
               Line[#]]}& ), 
           UndirectedEdge[1, 4] -> ({Increment[$CellContext`x50$1824]; Append[
               Part[{{
                  Dashing[{Small, Small}]}}, $CellContext`x50$1824], 
               Line[#]]}& ), 
           UndirectedEdge[5, 13] -> ({Increment[$CellContext`x59$1824]; Append[
               Part[{{
                  Dashing[{Small, Small}]}}, $CellContext`x59$1824], 
               Line[#]]}& ), 
           UndirectedEdge[2, 8] -> ({Increment[$CellContext`x53$1824]; Append[
               Part[{{
                  Dashing[{Small, Small}]}}, $CellContext`x53$1824], 
               Line[#]]}& ), 
           UndirectedEdge[1, 7] -> ({Increment[$CellContext`x51$1824]; Append[
               Part[{{
                  Dashing[{Small, Small}]}}, $CellContext`x51$1824], 
               Line[#]]}& ), 
           UndirectedEdge[2, 9] -> ({Increment[$CellContext`x54$1824]; Append[
               Part[{{
                  Dashing[{Small, Small}]}}, $CellContext`x54$1824], 
               Line[#]]}& ), 
           UndirectedEdge[5, 14] -> ({Increment[$CellContext`x60$1824]; Append[
               Part[{{
                  Dashing[{Small, Small}]}}, $CellContext`x60$1824], 
               Line[#]]}& )}, ImageSize -> 300}]]}, 
      TagBox[GraphicsGroupBox[{
         {Hue[0.6, 0.7, 0.5], Opacity[0.7], 
          {Dashing[{Small, Small}], 
           LineBox[{{2.6969408471239977`, 1.9037229509110571`}, {
            0.9518614754555286, 1.2691486339407048`}}]}, 
          {Dashing[{Small, Small}], 
           LineBox[{{2.6969408471239977`, 1.9037229509110571`}, {
            2.5382972678814095`, 1.2691486339407048`}}]}, 
          {Dashing[{Small, Small}], 
           LineBox[{{2.6969408471239977`, 1.9037229509110571`}, {
            3.8074459018221143`, 1.2691486339407048`}}]}, 
          {Dashing[{Small, Small}], 
           LineBox[{{2.6969408471239977`, 1.9037229509110571`}, {
            4.442020218792467, 1.2691486339407048`}}]}, 
          {Dashing[{Small, Small}], 
           LineBox[{{0.9518614754555286, 1.2691486339407048`}, {
            0.3172871584851762, 0.6345743169703524}}]}, 
          {Dashing[{Small, Small}], 
           LineBox[{{0.9518614754555286, 1.2691486339407048`}, {
            0.9518614754555286, 0.6345743169703524}}]}, 
          {Dashing[{Small, Small}], 
           LineBox[{{0.9518614754555286, 1.2691486339407048`}, {
            1.586435792425881, 0.6345743169703524}}]}, 
          {Dashing[{Small, Small}], 
           LineBox[{{2.5382972678814095`, 1.2691486339407048`}, {
            2.2210101093962336`, 0.6345743169703524}}]}, 
          {Dashing[{Small, Small}], 
           LineBox[{{2.5382972678814095`, 1.2691486339407048`}, {
            2.855584426366586, 0.6345743169703524}}]}, 
          {Dashing[{Small, Small}], 
           LineBox[{{3.8074459018221143`, 1.2691486339407048`}, {
            3.4901587433369383`, 0.6345743169703524}}]}, 
          {Dashing[{Small, Small}], 
           LineBox[{{3.8074459018221143`, 1.2691486339407048`}, {
            4.124733060307291, 0.6345743169703524}}]}, 
          {Dashing[{Small, Small}], 
           LineBox[{{0.3172871584851762, 0.6345743169703524}, {0., 0.}}]}, 
          {Dashing[{Small, Small}], 
           LineBox[{{0.3172871584851762, 0.6345743169703524}, {
            0.6345743169703524, 0.}}]}, 
          LineBox[{{2.2210101093962336`, 0.6345743169703524}, {
           1.9037229509110571`, 0.}}], 
          LineBox[{{2.2210101093962336`, 0.6345743169703524}, {
           2.5382972678814095`, 0.}}]}, 
         {Hue[0.6, 0.2, 0.8], EdgeForm[{GrayLevel[0], Opacity[0.7]}], 
          DiskBox[{2.6969408471239977, 1.9037229509110571}, 
           0.039758694132184136], 
          DiskBox[{0.9518614754555286, 1.2691486339407048}, 
           0.039758694132184136], 
          DiskBox[{2.5382972678814095, 1.2691486339407048}, 
           0.039758694132184136], 
          DiskBox[{3.8074459018221143, 1.2691486339407048}, 
           0.039758694132184136], 
          DiskBox[{4.442020218792467, 1.2691486339407048}, 
           0.039758694132184136], 
          DiskBox[{0.3172871584851762, 0.6345743169703524}, 
           0.039758694132184136], 
          DiskBox[{0.9518614754555286, 0.6345743169703524}, 
           0.039758694132184136], 
          DiskBox[{1.586435792425881, 0.6345743169703524}, 
           0.039758694132184136], 
          DiskBox[{2.2210101093962336, 0.6345743169703524}, 
           0.039758694132184136], 
          DiskBox[{2.855584426366586, 0.6345743169703524}, 
           0.039758694132184136], 
          DiskBox[{3.4901587433369383, 0.6345743169703524}, 
           0.039758694132184136], 
          DiskBox[{4.124733060307291, 0.6345743169703524}, 
           0.039758694132184136], DiskBox[{0., 0.}, 0.039758694132184136], 
          DiskBox[{0.6345743169703524, 0.}, 0.039758694132184136], 
          DiskBox[{1.9037229509110571, 0.}, 0.039758694132184136], 
          DiskBox[{2.5382972678814095, 0.}, 0.039758694132184136]}}],
       MouseAppearanceTag["NetworkGraphics"]],
      AllowKernelInitialization->False]],
    DefaultBaseStyle->{
     "NetworkGraphics", FrontEnd`GraphicsHighlightColor -> Hue[0.8, 1., 0.6]},
    FormatType->TraditionalForm,
    FrameTicks->None,
    ImageSize->300]}], "}"}]], "Output",
 CellChangeTimes->{{3.736060146080111*^9, 3.7360601824266076`*^9}, 
   3.736073363980011*^9},ExpressionUUID->"040faea9-f012-495c-a342-\
b688bed0347d"]
}, Open  ]]
},
WindowSize->{2560, 1357},
WindowMargins->{{Automatic, -282}, {1144, Automatic}},
FrontEndVersion->"11.1 for Microsoft Windows (64-bit) (April 18, 2017)",
StyleDefinitions->Notebook[{
   Cell[
    StyleData[StyleDefinitions -> "Core.nb"]], 
   Cell[
    StyleData["MyStyle - H1"], CellMargins -> {{66, 10}, {7, 7}}, 
    MenuSortingValue -> 1, FontFamily -> "Consolas", FontSize -> 14, 
    FontColor -> RGBColor[0.5, 0, 0.5], Background -> 
    RGBColor[0.94, 0.88, 0.94]], 
   Cell[
    StyleData["MyStyle - H1 Framed"], CellFrame -> {{0, 0}, {2, 2}}, 
    CellMargins -> {{66, 10}, {7, 7}}, CellFrameColor -> 
    RGBColor[0.5, 0, 0.5], MenuSortingValue -> 2, FontFamily -> "Consolas", 
    FontSize -> 14, FontColor -> RGBColor[0.5, 0, 0.5], Background -> 
    RGBColor[0.94, 0.88, 0.94]], 
   Cell[
    StyleData["MyStyle - H2"], CellMargins -> {{66, 10}, {7, 7}}, 
    MenuSortingValue -> 3, FontFamily -> "Consolas", FontSize -> 14, 
    FontColor -> RGBColor[1, 0.5, 0], Background -> RGBColor[1, 0.9, 0.8]], 
   Cell[
    StyleData["MyStyle - H2 Framed"], CellFrame -> {{0, 0}, {2, 2}}, 
    CellMargins -> {{66, 10}, {7, 7}}, CellFrameColor -> RGBColor[1, 0.5, 0], 
    MenuSortingValue -> 4, FontFamily -> "Consolas", FontSize -> 14, 
    FontColor -> RGBColor[1, 0.5, 0], Background -> RGBColor[1, 0.9, 0.8]], 
   Cell[
    StyleData["MyStyle - H3"], CellMargins -> {{66, 10}, {7, 7}}, 
    MenuSortingValue -> 5, FontFamily -> "Consolas", FontSize -> 14, 
    FontColor -> GrayLevel[0.5], Background -> GrayLevel[0.9]], 
   Cell[
    StyleData["MyStyle - H3 Framed"], CellFrame -> {{0, 0}, {2, 2}}, 
    CellMargins -> {{66, 10}, {7, 7}}, CellFrameColor -> GrayLevel[0.5], 
    MenuSortingValue -> 6, FontFamily -> "Consolas", FontSize -> 14, 
    FontColor -> GrayLevel[0.5], Background -> GrayLevel[0.9]], 
   Cell[
    StyleData["MyStyle - Comments"], CellMargins -> {{66, 10}, {7, 7}}, 
    MenuSortingValue -> 7, FontFamily -> "Consolas", FontSize -> 12, 
    FontColor -> 
    RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255]], 
   Cell[
    StyleData[All, "Working"], $CellContext`CellInsertionPointCell -> 
    FEPrivate`FrontEndResource[
     "FEExpressions", 
      "CellInsertionMenu"], $CellContext`GhostCellInEmptyNotebook -> False], 
   Cell[
    StyleData[
    All, "SlideShow", StyleDefinitions -> StyleData[All, "Presentation"]], 
    PageWidth -> WindowWidth, DockedCells -> 
    FEPrivate`FrontEndResource["FEExpressions", "SlideshowToolbar"], 
    ScrollingOptions -> {
     "PagewiseDisplay" -> True, "VerticalScrollRange" -> Fit}, 
    ShowGroupOpener -> False, MenuSortingValue -> 1300], 
   Cell[
    StyleData[All, "Printout"], Magnification -> 0.72], 
   Cell[
    StyleData[
    All, "PrintoutGray", StyleDefinitions -> StyleData[All, "Printout"]], 
    MenuSortingValue -> 1500], 
   Cell[
    StyleData["Notebook"], PageHeaders -> {{
       Cell[
        TextData[{
          Cell[
           TextData[{
             CounterBox["Page"]}], "PageNumber"], "   ", 
          Cell[
          " ", "Header", CellFrame -> {{0.5, 0}, {0, 0}}, CellFrameMargins -> 
           4], 
          Cell[
           TextData[{
             ValueBox["FileName"]}], "Header"]}], 
        CellMargins -> {{0, Inherited}, {Inherited, Inherited}}], None, 
       None}, {None, None, 
       Cell[
        TextData[{
          Cell[
           TextData[{
             ValueBox["FileName"]}], "Header"], 
          Cell[
          " ", "Header", CellFrame -> {{0, 0.5}, {0, 0}}, CellFrameMargins -> 
           4], "   ", 
          Cell[
           TextData[{
             CounterBox["Page"]}], "PageNumber"]}], 
        CellMargins -> {{Inherited, 0}, {Inherited, Inherited}}]}}, 
    PageHeaderLines -> {False, False}, PageFooterLines -> {False, False}, 
    PrintingOptions -> {
     "FacingPages" -> True, "FirstPageFace" -> Right, "FirstPageFooter" -> 
      True, "FirstPageHeader" -> False}], 
   Cell[
    StyleData["Title"], CellMargins -> {{27, Inherited}, {10, 30}}, 
    StyleKeyMapping -> {"Tab" -> "Subtitle"}, 
    CellGroupingRules -> {"TitleGrouping", 0}, PageBreakBelow -> False, 
    InputAutoReplacements -> {"TeX" -> FormBox[
        StyleBox[
         RowBox[{"T", 
           AdjustmentBox[
           "E", BoxMargins -> {{-0.3, 0}, {0, 0}}, BoxBaselineShift -> 0.5], 
           "X"}], SingleLetterItalics -> False], TraditionalForm], "LaTeX" -> 
      FormBox[
        StyleBox[
         RowBox[{"L", 
           StyleBox[
            AdjustmentBox[
            "A", BoxMargins -> {{-0.5, -0.3}, {0, 0}}, 
             BoxBaselineShift -> -0.4], FontSize -> Smaller], "T", 
           AdjustmentBox[
           "E", BoxMargins -> {{-0.3, 0}, {0, 0}}, BoxBaselineShift -> 0.5], 
           "X"}], SingleLetterItalics -> False], TraditionalForm], "mma" -> 
      "Mathematica", "Mma" -> "Mathematica", "MMA" -> "Mathematica", 
      "gridMathematica" -> FormBox[
        RowBox[{"grid", 
          AdjustmentBox[
           StyleBox["Mathematica", FontSlant -> "Italic"], 
           BoxMargins -> {{-0.175, 0}, {0, 0}}]}], TextForm], 
      "webMathematica" -> FormBox[
        RowBox[{"web", 
          AdjustmentBox[
           StyleBox["Mathematica", FontSlant -> "Italic"], 
           BoxMargins -> {{-0.175, 0}, {0, 0}}]}], TextForm], ParentList}, 
    LineSpacing -> {1, 4}, LanguageCategory -> "NaturalLanguage", 
    CounterIncrements -> "Title", 
    CounterAssignments -> {{"Section", 0}, {"Equation", 0}, {"Figure", 0}, {
      "Subtitle", 0}, {"Subsubtitle", 0}, {"Item", 0}, {"Subitem", 0}, {
      "Subsubitem", 0}, {"ItemNumbered", 0}, {"SubitemNumbered", 0}, {
      "SubsubitemNumbered", 0}}, MenuSortingValue -> 1100, MenuCommandKey -> 
    "1", FontFamily -> "Gill Sans", FontSize -> 44, FontColor -> 
    RGBColor[0.8, 0.043, 0.008]], 
   Cell[
    StyleData["Title", "Presentation"], 
    CellMargins -> {{67, Inherited}, {15, 45}}, LineSpacing -> {1, 18}, 
    FontSize -> 72], 
   Cell[
    StyleData["Title", "SlideShow"], 
    CellMargins -> {{
      0.135 FrontEnd`AbsoluteCurrentValue[{WindowSize, 1}], 0.04 
       FrontEnd`AbsoluteCurrentValue[{WindowSize, 1}]}, {
      15, 0.12 FrontEnd`AbsoluteCurrentValue[{WindowSize, 2}]}}, 
    LineSpacing -> {1, 2}, FontSize -> 72], 
   Cell[
    StyleData["Title", "Condensed"], CellMargins -> {{18, 10}, {4, 8}}, 
    FontSize -> 20], 
   Cell[
    StyleData["Title", "Printout"], 
    CellMargins -> {{10, Inherited}, {10, 30}}], 
   Cell[
    StyleData["Title", "PrintoutGray"], 
    CellMargins -> {{10, Inherited}, {10, 30}}, FontColor -> GrayLevel[0]], 
   Cell[
    StyleData["Subtitle"], CellMargins -> {{27, Inherited}, {20, 2}}, 
    StyleKeyMapping -> {
     "Tab" -> "Subsubtitle", "Backspace" -> 
      "Title", $CellContext`KeyEvent[
       "Tab", $CellContext`Modifiers -> {$CellContext`Shift}] -> "Title"}, 
    CellGroupingRules -> {"TitleGrouping", 10}, PageBreakBelow -> False, 
    InputAutoReplacements -> {"TeX" -> FormBox[
        StyleBox[
         RowBox[{"T", 
           AdjustmentBox[
           "E", BoxMargins -> {{-0.3, 0}, {0, 0}}, BoxBaselineShift -> 0.5], 
           "X"}], SingleLetterItalics -> False], TraditionalForm], "LaTeX" -> 
      FormBox[
        StyleBox[
         RowBox[{"L", 
           StyleBox[
            AdjustmentBox[
            "A", BoxMargins -> {{-0.5, -0.3}, {0, 0}}, 
             BoxBaselineShift -> -0.4], FontSize -> Smaller], "T", 
           AdjustmentBox[
           "E", BoxMargins -> {{-0.3, 0}, {0, 0}}, BoxBaselineShift -> 0.5], 
           "X"}], SingleLetterItalics -> False], TraditionalForm], "mma" -> 
      "Mathematica", "Mma" -> "Mathematica", "MMA" -> "Mathematica", 
      "gridMathematica" -> FormBox[
        RowBox[{"grid", 
          AdjustmentBox[
           StyleBox["Mathematica", FontSlant -> "Italic"], 
           BoxMargins -> {{-0.175, 0}, {0, 0}}]}], TextForm], 
      "webMathematica" -> FormBox[
        RowBox[{"web", 
          AdjustmentBox[
           StyleBox["Mathematica", FontSlant -> "Italic"], 
           BoxMargins -> {{-0.175, 0}, {0, 0}}]}], TextForm], ParentList}, 
    LanguageCategory -> "NaturalLanguage", CounterIncrements -> "Subtitle", 
    CounterAssignments -> {{"Section", 0}, {"Equation", 0}, {"Figure", 0}, {
      "Subsubtitle", 0}, {"Item", 0}, {"Subitem", 0}, {"Subsubitem", 0}, {
      "ItemNumbered", 0}, {"SubitemNumbered", 0}, {"SubsubitemNumbered", 0}}, 
    MenuSortingValue -> 1150, MenuCommandKey -> "2", FontFamily -> 
    "Gill Sans", FontSize -> 24, FontColor -> GrayLevel[0.3]], 
   Cell[
    StyleData["Subtitle", "Presentation"], 
    CellMargins -> {{67, Inherited}, {30, 3}}, LineSpacing -> {1, 16}, 
    FontSize -> 48], 
   Cell[
    StyleData["Subtitle", "SlideShow"], 
    CellMargins -> {{
      0.135 FrontEnd`AbsoluteCurrentValue[{WindowSize, 1}], 0.04 
       FrontEnd`AbsoluteCurrentValue[{WindowSize, 1}]}, {30, 12}}, 
    LineSpacing -> {1, 2}, FontSize -> 48], 
   Cell[
    StyleData["Subtitle", "Condensed"], CellMargins -> {{18, 10}, {4, 4}}, 
    FontSize -> 14], 
   Cell[
    StyleData["Subtitle", "Printout"], 
    CellMargins -> {{10, Inherited}, {20, 2}}], 
   Cell[
    StyleData["Subtitle", "PrintoutGray"], 
    CellMargins -> {{10, Inherited}, {20, 2}}], 
   Cell[
    StyleData["Subsubtitle"], CellMargins -> {{27, Inherited}, {8, 2}}, 
    StyleKeyMapping -> {
     "Backspace" -> 
      "Subtitle", $CellContext`KeyEvent[
       "Tab", $CellContext`Modifiers -> {$CellContext`Shift}] -> "Subtitle"}, 
    CellGroupingRules -> {"TitleGrouping", 20}, PageBreakBelow -> False, 
    InputAutoReplacements -> {"TeX" -> FormBox[
        StyleBox[
         RowBox[{"T", 
           AdjustmentBox[
           "E", BoxMargins -> {{-0.3, 0}, {0, 0}}, BoxBaselineShift -> 0.5], 
           "X"}], SingleLetterItalics -> False], TraditionalForm], "LaTeX" -> 
      FormBox[
        StyleBox[
         RowBox[{"L", 
           StyleBox[
            AdjustmentBox[
            "A", BoxMargins -> {{-0.5, -0.3}, {0, 0}}, 
             BoxBaselineShift -> -0.4], FontSize -> Smaller], "T", 
           AdjustmentBox[
           "E", BoxMargins -> {{-0.3, 0}, {0, 0}}, BoxBaselineShift -> 0.5], 
           "X"}], SingleLetterItalics -> False], TraditionalForm], "mma" -> 
      "Mathematica", "Mma" -> "Mathematica", "MMA" -> "Mathematica", 
      "gridMathematica" -> FormBox[
        RowBox[{"grid", 
          AdjustmentBox[
           StyleBox["Mathematica", FontSlant -> "Italic"], 
           BoxMargins -> {{-0.175, 0}, {0, 0}}]}], TextForm], 
      "webMathematica" -> FormBox[
        RowBox[{"web", 
          AdjustmentBox[
           StyleBox["Mathematica", FontSlant -> "Italic"], 
           BoxMargins -> {{-0.175, 0}, {0, 0}}]}], TextForm], ParentList}, 
    LanguageCategory -> "NaturalLanguage", CounterIncrements -> "Subsubtitle",
     CounterAssignments -> {{"Section", 0}, {"Equation", 0}, {"Figure", 0}, {
      "Item", 0}, {"Subitem", 0}, {"Subsubitem", 0}, {"ItemNumbered", 0}, {
      "SubitemNumbered", 0}, {"SubsubitemNumbered", 0}}, MenuSortingValue -> 
    1200, MenuCommandKey -> "3", FontFamily -> "Gill Sans", FontSize -> 16, 
    FontColor -> GrayLevel[0.3]], 
   Cell[
    StyleData["Subsubtitle", "Presentation"], 
    CellMargins -> {{67, Inherited}, {12, 3}}, LineSpacing -> {1, 14}, 
    FontSize -> 32], 
   Cell[
    StyleData["Subsubtitle", "SlideShow"], 
    CellMargins -> {{
      0.135 FrontEnd`AbsoluteCurrentValue[{WindowSize, 1}], 0.04 
       FrontEnd`AbsoluteCurrentValue[{WindowSize, 1}]}, {12, 12}}, 
    LineSpacing -> {1, 2}, FontSize -> 32], 
   Cell[
    StyleData["Subsubtitle", "Condensed"], CellMargins -> {{18, 10}, {8, 8}}, 
    FontSize -> 12], 
   Cell[
    StyleData["Subsubtitle", "Printout"], 
    CellMargins -> {{10, Inherited}, {8, 2}}], 
   Cell[
    StyleData["Subsubtitle", "PrintoutGray"], 
    CellMargins -> {{10, Inherited}, {8, 2}}], 
   Cell[
    StyleData["Section"], CellFrame -> {{0, 0}, {0, 1}}, 
    CellMargins -> {{27, Inherited}, {8, 34}}, 
    StyleKeyMapping -> {"Tab" -> "Subsection"}, 
    CellGroupingRules -> {"SectionGrouping", 30}, PageBreakBelow -> False, 
    CellFrameMargins -> 4, CellFrameColor -> GrayLevel[0.7], 
    InputAutoReplacements -> {"TeX" -> FormBox[
        StyleBox[
         RowBox[{"T", 
           AdjustmentBox[
           "E", BoxMargins -> {{-0.3, 0}, {0, 0}}, BoxBaselineShift -> 0.5], 
           "X"}], SingleLetterItalics -> False], TraditionalForm], "LaTeX" -> 
      FormBox[
        StyleBox[
         RowBox[{"L", 
           StyleBox[
            AdjustmentBox[
            "A", BoxMargins -> {{-0.5, -0.3}, {0, 0}}, 
             BoxBaselineShift -> -0.4], FontSize -> Smaller], "T", 
           AdjustmentBox[
           "E", BoxMargins -> {{-0.3, 0}, {0, 0}}, BoxBaselineShift -> 0.5], 
           "X"}], SingleLetterItalics -> False], TraditionalForm], "mma" -> 
      "Mathematica", "Mma" -> "Mathematica", "MMA" -> "Mathematica", 
      "gridMathematica" -> FormBox[
        RowBox[{"grid", 
          AdjustmentBox[
           StyleBox["Mathematica", FontSlant -> "Italic"], 
           BoxMargins -> {{-0.175, 0}, {0, 0}}]}], TextForm], 
      "webMathematica" -> FormBox[
        RowBox[{"web", 
          AdjustmentBox[
           StyleBox["Mathematica", FontSlant -> "Italic"], 
           BoxMargins -> {{-0.175, 0}, {0, 0}}]}], TextForm], ParentList}, 
    LineSpacing -> {1, 2}, LanguageCategory -> "NaturalLanguage", 
    CounterIncrements -> "Section", 
    CounterAssignments -> {{"Subsection", 0}, {"Subsubsection", 0}, {
      "Item", 0}, {"Subitem", 0}, {"Subsubitem", 0}, {"ItemNumbered", 0}, {
      "SubitemNumbered", 0}, {"SubsubitemNumbered", 0}}, MenuSortingValue -> 
    1250, MenuCommandKey -> "4", FontFamily -> "Gill Sans", FontSize -> 28, 
    FontColor -> 
    RGBColor[0.7612268253604944, 0.29576562142366675`, 0.08555733577477684]], 
   Cell[
    StyleData["Section", "Presentation"], CellFrame -> {{0, 0}, {0, 2}}, 
    CellMargins -> {{67, Inherited}, {12, 51}}, CellFrameMargins -> 8, 
    LineSpacing -> {1, 10}, FontSize -> 40], 
   Cell[
    StyleData["Section", "SlideShow"], 
    CellMargins -> {{
      0.06 FrontEnd`AbsoluteCurrentValue[{WindowSize, 1}], 0.04 
       FrontEnd`AbsoluteCurrentValue[{WindowSize, 1}]}, {
      12, 0.06 FrontEnd`AbsoluteCurrentValue[{WindowSize, 2}]}}, 
    LineSpacing -> {1, 2}, FontSize -> 40], 
   Cell[
    StyleData["Section", "Condensed"], 
    CellMargins -> {{18, Inherited}, {6, 12}}, FontSize -> 12], 
   Cell[
    StyleData["Section", "Printout"], 
    CellMargins -> {{10, Inherited}, {8, 34}}], 
   Cell[
    StyleData["Section", "PrintoutGray"], 
    CellMargins -> {{10, Inherited}, {8, 34}}, FontColor -> GrayLevel[0.2]], 
   Cell[
    StyleData["Subsection"], CellMargins -> {{50.34765625, 3.}, {8., 12.}}, 
    StyleKeyMapping -> {
     "Tab" -> "Subsubsection", "Backspace" -> 
      "Section", $CellContext`KeyEvent[
       "Tab", $CellContext`Modifiers -> {$CellContext`Shift}] -> "Section"}, 
    CellGroupingRules -> {"SectionGrouping", 40}, PageBreakBelow -> False, 
    InputAutoReplacements -> {"TeX" -> FormBox[
        StyleBox[
         RowBox[{"T", 
           AdjustmentBox[
           "E", BoxMargins -> {{-0.3, 0}, {0, 0}}, BoxBaselineShift -> 0.5], 
           "X"}], SingleLetterItalics -> False], TraditionalForm], "LaTeX" -> 
      FormBox[
        StyleBox[
         RowBox[{"L", 
           StyleBox[
            AdjustmentBox[
            "A", BoxMargins -> {{-0.5, -0.3}, {0, 0}}, 
             BoxBaselineShift -> -0.4], FontSize -> Smaller], "T", 
           AdjustmentBox[
           "E", BoxMargins -> {{-0.3, 0}, {0, 0}}, BoxBaselineShift -> 0.5], 
           "X"}], SingleLetterItalics -> False], TraditionalForm], "mma" -> 
      "Mathematica", "Mma" -> "Mathematica", "MMA" -> "Mathematica", 
      "gridMathematica" -> FormBox[
        RowBox[{"grid", 
          AdjustmentBox[
           StyleBox["Mathematica", FontSlant -> "Italic"], 
           BoxMargins -> {{-0.175, 0}, {0, 0}}]}], TextForm], 
      "webMathematica" -> FormBox[
        RowBox[{"web", 
          AdjustmentBox[
           StyleBox["Mathematica", FontSlant -> "Italic"], 
           BoxMargins -> {{-0.175, 0}, {0, 0}}]}], TextForm], ParentList}, 
    LanguageCategory -> "NaturalLanguage", CounterIncrements -> "Subsection", 
    CounterAssignments -> {{"Subsubsection", 0}, {"Item", 0}, {
      "Subitem", 0}, {"Subsubitem", 0}, {"ItemNumbered", 0}, {
      "SubitemNumbered", 0}, {"SubsubitemNumbered", 0}}, MenuSortingValue -> 
    1300, MenuCommandKey -> "5", FontFamily -> "Gill Sans", FontSize -> 20, 
    FontColor -> 
    RGBColor[0.778286411841001, 0.4230563820859083, 0.16115053025101092`]], 
   Cell[
    StyleData["Subsection", "Presentation"], 
    CellMargins -> {{100, Inherited}, {12, 18}}, LineSpacing -> {1, 10}, 
    FontSize -> 28], 
   Cell[
    StyleData["Subsection", "SlideShow"], 
    CellMargins -> {{
      0.1 FrontEnd`AbsoluteCurrentValue[{WindowSize, 1}], 0.02 
       FrontEnd`AbsoluteCurrentValue[{WindowSize, 1}]}, {
      12, 0.046 FrontEnd`AbsoluteCurrentValue[{WindowSize, 2}]}}, 
    LineSpacing -> {1, 2}, FontSize -> 32], 
   Cell[
    StyleData["Subsection", "Condensed"], 
    CellMargins -> {{18, Inherited}, {6, 12}}, FontSize -> 11], 
   Cell[
    StyleData["Subsection", "Printout"], 
    CellMargins -> {{30, Inherited}, {8., 16}}], 
   Cell[
    StyleData["Subsection", "PrintoutGray"], 
    CellMargins -> {{30, Inherited}, {8., 16}}, FontColor -> GrayLevel[0.3]], 
   Cell[
    StyleData["Subsubsection"], CellMargins -> {{66, Inherited}, {2, 10}}, 
    StyleKeyMapping -> {
     "Tab" -> "Subsubsubsection", "Backspace" -> 
      "Subsection", $CellContext`KeyEvent[
       "Tab", $CellContext`Modifiers -> {$CellContext`Shift}] -> 
      "Subsection"}, CellGroupingRules -> {"SectionGrouping", 50}, 
    PageBreakBelow -> False, InputAutoReplacements -> {"TeX" -> FormBox[
        StyleBox[
         RowBox[{"T", 
           AdjustmentBox[
           "E", BoxMargins -> {{-0.3, 0}, {0, 0}}, BoxBaselineShift -> 0.5], 
           "X"}], SingleLetterItalics -> False], TraditionalForm], "LaTeX" -> 
      FormBox[
        StyleBox[
         RowBox[{"L", 
           StyleBox[
            AdjustmentBox[
            "A", BoxMargins -> {{-0.5, -0.3}, {0, 0}}, 
             BoxBaselineShift -> -0.4], FontSize -> Smaller], "T", 
           AdjustmentBox[
           "E", BoxMargins -> {{-0.3, 0}, {0, 0}}, BoxBaselineShift -> 0.5], 
           "X"}], SingleLetterItalics -> False], TraditionalForm], "mma" -> 
      "Mathematica", "Mma" -> "Mathematica", "MMA" -> "Mathematica", 
      "gridMathematica" -> FormBox[
        RowBox[{"grid", 
          AdjustmentBox[
           StyleBox["Mathematica", FontSlant -> "Italic"], 
           BoxMargins -> {{-0.175, 0}, {0, 0}}]}], TextForm], 
      "webMathematica" -> FormBox[
        RowBox[{"web", 
          AdjustmentBox[
           StyleBox["Mathematica", FontSlant -> "Italic"], 
           BoxMargins -> {{-0.175, 0}, {0, 0}}]}], TextForm], ParentList}, 
    LanguageCategory -> "NaturalLanguage", CounterIncrements -> 
    "Subsubsection", 
    CounterAssignments -> {{"Subsubsubsection", 0}, {"Item", 0}, {
      "Subitem", 0}, {"Subsubitem", 0}, {"ItemNumbered", 0}, {
      "SubitemNumbered", 0}, {"SubsubitemNumbered", 0}}, MenuSortingValue -> 
    1350, MenuCommandKey -> "6", FontFamily -> "Gill Sans", FontSize -> 19, 
    FontColor -> 
    RGBColor[0.7143816281376364, 0.21776150148775464`, 0.03341725795376516]], 
   Cell[
    StyleData["Subsubsection", "Presentation"], 
    CellMargins -> {{100, Inherited}, {3, 15}}, LineSpacing -> {1, 6}, 
    FontSize -> 24], 
   Cell[
    StyleData["Subsubsection", "SlideShow"], 
    CellMargins -> {{
      0.135 FrontEnd`AbsoluteCurrentValue[{WindowSize, 1}], 0.03 
       FrontEnd`AbsoluteCurrentValue[{WindowSize, 1}]}, {3, 15}}, 
    LineSpacing -> {1, 2}, FontSize -> 28], 
   Cell[
    StyleData["Subsubsection", "Condensed"], 
    CellMargins -> {{18, Inherited}, {6, 12}}, FontSize -> 11], 
   Cell[
    StyleData["Subsubsection", "Printout"], 
    CellMargins -> {{49, Inherited}, {6, 16}}], 
   Cell[
    StyleData["Subsubsection", "PrintoutGray"], 
    CellMargins -> {{49, Inherited}, {6, 16}}, FontColor -> GrayLevel[0.3]], 
   Cell[
    StyleData["Subsubsubsection"], CellMargins -> {{66, Inherited}, {2, 10}}, 
    StyleKeyMapping -> {
     "Tab" -> "Subsubsubsubsection", "Backspace" -> 
      "Subsubsection", $CellContext`KeyEvent[
       "Tab", $CellContext`Modifiers -> {$CellContext`Shift}] -> 
      "Subsubsection"}, CellGroupingRules -> {"SectionGrouping", 60}, 
    PageBreakBelow -> False, InputAutoReplacements -> {"TeX" -> FormBox[
        StyleBox[
         RowBox[{"T", 
           AdjustmentBox[
           "E", BoxMargins -> {{-0.3, 0}, {0, 0}}, BoxBaselineShift -> 0.5], 
           "X"}], SingleLetterItalics -> False], TraditionalForm], "LaTeX" -> 
      FormBox[
        StyleBox[
         RowBox[{"L", 
           StyleBox[
            AdjustmentBox[
            "A", BoxMargins -> {{-0.5, -0.3}, {0, 0}}, 
             BoxBaselineShift -> -0.4], FontSize -> Smaller], "T", 
           AdjustmentBox[
           "E", BoxMargins -> {{-0.3, 0}, {0, 0}}, BoxBaselineShift -> 0.5], 
           "X"}], SingleLetterItalics -> False], TraditionalForm], "mma" -> 
      "Mathematica", "Mma" -> "Mathematica", "MMA" -> "Mathematica", 
      "gridMathematica" -> FormBox[
        RowBox[{"grid", 
          AdjustmentBox[
           StyleBox["Mathematica", FontSlant -> "Italic"], 
           BoxMargins -> {{-0.175, 0}, {0, 0}}]}], TextForm], 
      "webMathematica" -> FormBox[
        RowBox[{"web", 
          AdjustmentBox[
           StyleBox["Mathematica", FontSlant -> "Italic"], 
           BoxMargins -> {{-0.175, 0}, {0, 0}}]}], TextForm], ParentList}, 
    LanguageCategory -> "NaturalLanguage", CounterIncrements -> 
    "Subsubsubsection", 
    CounterAssignments -> {{"Subsubsubsubsection", 0}, {"Item", 0}, {
      "Subitem", 0}, {"Subsubitem", 0}, {"ItemNumbered", 0}, {
      "SubitemNumbered", 0}, {"SubsubitemNumbered", 0}}, MenuSortingValue -> 
    None, FontFamily -> "Arial", FontSize -> 14, FontWeight -> "Bold", 
    FontColor -> 
    RGBColor[0.778286411841001, 0.4230563820859083, 0.16115053025101092`]], 
   Cell[
    StyleData["Subsubsubsection", "Presentation"], 
    CellMargins -> {{100, Inherited}, {3, 15}}, LineSpacing -> {1, 7}, 
    FontSize -> 24], 
   Cell[
    StyleData["Subsubsubsection", "SlideShow"], 
    CellMargins -> {{
      0.135 FrontEnd`AbsoluteCurrentValue[{WindowSize, 1}], 0.03 
       FrontEnd`AbsoluteCurrentValue[{WindowSize, 1}]}, {3, 15}}, 
    LineSpacing -> {1, 2}, FontFamily -> "Arial", FontSize -> 22], 
   Cell[
    StyleData["Subsubsubsection", "Condensed"], 
    CellMargins -> {{18, Inherited}, {6, 12}}, FontSize -> 10], 
   Cell[
    StyleData["Subsubsubsection", "Printout"], 
    CellMargins -> {{49, Inherited}, {6, 14}}], 
   Cell[
    StyleData["Subsubsubsection", "PrintoutGray"], 
    CellMargins -> {{49, Inherited}, {6, 14}}, FontColor -> GrayLevel[0.4]], 
   Cell[
    StyleData["Subsubsubsubsection"], 
    CellMargins -> {{66, Inherited}, {2, 10}}, 
    StyleKeyMapping -> {
     "Backspace" -> 
      "Subsubsubsection", $CellContext`KeyEvent[
       "Tab", $CellContext`Modifiers -> {$CellContext`Shift}] -> 
      "Subsubsubsection"}, CellGroupingRules -> {"SectionGrouping", 70}, 
    PageBreakBelow -> False, InputAutoReplacements -> {"TeX" -> FormBox[
        StyleBox[
         RowBox[{"T", 
           AdjustmentBox[
           "E", BoxMargins -> {{-0.3, 0}, {0, 0}}, BoxBaselineShift -> 0.5], 
           "X"}], SingleLetterItalics -> False], TraditionalForm], "LaTeX" -> 
      FormBox[
        StyleBox[
         RowBox[{"L", 
           StyleBox[
            AdjustmentBox[
            "A", BoxMargins -> {{-0.5, -0.3}, {0, 0}}, 
             BoxBaselineShift -> -0.4], FontSize -> Smaller], "T", 
           AdjustmentBox[
           "E", BoxMargins -> {{-0.3, 0}, {0, 0}}, BoxBaselineShift -> 0.5], 
           "X"}], SingleLetterItalics -> False], TraditionalForm], "mma" -> 
      "Mathematica", "Mma" -> "Mathematica", "MMA" -> "Mathematica", 
      "gridMathematica" -> FormBox[
        RowBox[{"grid", 
          AdjustmentBox[
           StyleBox["Mathematica", FontSlant -> "Italic"], 
           BoxMargins -> {{-0.175, 0}, {0, 0}}]}], TextForm], 
      "webMathematica" -> FormBox[
        RowBox[{"web", 
          AdjustmentBox[
           StyleBox["Mathematica", FontSlant -> "Italic"], 
           BoxMargins -> {{-0.175, 0}, {0, 0}}]}], TextForm], ParentList}, 
    LanguageCategory -> "NaturalLanguage", CounterIncrements -> 
    "Subsubsubsubsection", 
    CounterAssignments -> {{"Item", 0}, {"Subitem", 0}, {"Subsubitem", 0}, {
      "ItemNumbered", 0}, {"SubitemNumbered", 0}, {"SubsubitemNumbered", 0}}, 
    MenuSortingValue -> None, FontFamily -> "Arial", FontSize -> 14, 
    FontColor -> RGBColor[0.5875944151979858, 0.053406576638437474`, 0.]], 
   Cell[
    StyleData["Subsubsubsubsection", "Presentation"], 
    CellMargins -> {{100, Inherited}, {3, 15}}, LineSpacing -> {1, 7}, 
    FontSize -> 24], 
   Cell[
    StyleData["Subsubsubsubsection", "SlideShow"], 
    CellMargins -> {{
      0.135 FrontEnd`AbsoluteCurrentValue[{WindowSize, 1}], 0.03 
       FrontEnd`AbsoluteCurrentValue[{WindowSize, 1}]}, {3, 15}}, 
    LineSpacing -> {1, 2}, FontSize -> 22], 
   Cell[
    StyleData["Subsubsubsubsection", "Condensed"], 
    CellMargins -> {{18, Inherited}, {6, 12}}, FontSize -> 10], 
   Cell[
    StyleData["Subsubsubsubsection", "Printout"], 
    CellMargins -> {{49, Inherited}, {6, 14}}], 
   Cell[
    StyleData["Subsubsubsubsection", "PrintoutGray"], 
    CellMargins -> {{49, Inherited}, {6, 14}}, FontColor -> GrayLevel[0.3]], 
   Cell[
    StyleData["Text"], CellMargins -> {{66, 10}, {7, 7}}, 
    InputAutoReplacements -> {"TeX" -> FormBox[
        StyleBox[
         RowBox[{"T", 
           AdjustmentBox[
           "E", BoxMargins -> {{-0.3, 0}, {0, 0}}, BoxBaselineShift -> 0.5], 
           "X"}], SingleLetterItalics -> False], TraditionalForm], "LaTeX" -> 
      FormBox[
        StyleBox[
         RowBox[{"L", 
           StyleBox[
            AdjustmentBox[
            "A", BoxMargins -> {{-0.5, -0.3}, {0, 0}}, 
             BoxBaselineShift -> -0.4], FontSize -> Smaller], "T", 
           AdjustmentBox[
           "E", BoxMargins -> {{-0.3, 0}, {0, 0}}, BoxBaselineShift -> 0.5], 
           "X"}], SingleLetterItalics -> False], TraditionalForm], "mma" -> 
      "Mathematica", "Mma" -> "Mathematica", "MMA" -> "Mathematica", 
      "gridMathematica" -> FormBox[
        RowBox[{"grid", 
          AdjustmentBox[
           StyleBox["Mathematica", FontSlant -> "Italic"], 
           BoxMargins -> {{-0.175, 0}, {0, 0}}]}], TextForm], 
      "webMathematica" -> FormBox[
        RowBox[{"web", 
          AdjustmentBox[
           StyleBox["Mathematica", FontSlant -> "Italic"], 
           BoxMargins -> {{-0.175, 0}, {0, 0}}]}], TextForm], ParentList}, 
    LineSpacing -> {1, 3}, CounterIncrements -> "Text", MenuSortingValue -> 
    1400, MenuCommandKey -> "7", FontFamily -> "Arial", FontSize -> 14], 
   Cell[
    StyleData["Text", "Presentation"], CellMargins -> {{100, 10}, {10, 10}}, 
    LineSpacing -> {1, 5}, FontSize -> 24], 
   Cell[
    StyleData["Text", "SlideShow"], 
    CellMargins -> {{
      0.135 FrontEnd`AbsoluteCurrentValue[{WindowSize, 1}], 0.03 
       FrontEnd`AbsoluteCurrentValue[{WindowSize, 1}]}, {10, 10}}, FontSize -> 
    22], 
   Cell[
    StyleData["Text", "Condensed"], CellMargins -> {{18, 10}, {6, 6}}, 
    LineSpacing -> {1, 1}, FontSize -> 11], 
   Cell[
    StyleData["Text", "Printout"], 
    CellMargins -> {{49, Inherited}, {Inherited, Inherited}}, Hyphenation -> 
    True], 
   Cell[
    StyleData["Text", "PrintoutGray"], 
    CellMargins -> {{49, Inherited}, {Inherited, Inherited}}, Hyphenation -> 
    True], 
   Cell[
    StyleData["SmallText"], CellMargins -> {{66, 10}, {6, 6}}, 
    LineSpacing -> {1, 3}, LanguageCategory -> "NaturalLanguage", 
    CounterIncrements -> "SmallText", MenuSortingValue -> 1750, 
    StyleMenuListing -> None, FontFamily -> "Arial", FontSize -> 13, 
    FontColor -> GrayLevel[0.2]], 
   Cell[
    StyleData["SmallText", "Presentation"], 
    CellMargins -> {{100, 10}, {9, 9}}, LineSpacing -> {1, 5}, FontSize -> 
    18], 
   Cell[
    StyleData["SmallText", "SlideShow"], 
    CellMargins -> {{
      0.135 FrontEnd`AbsoluteCurrentValue[{WindowSize, 1}], 0.03 
       FrontEnd`AbsoluteCurrentValue[{WindowSize, 1}]}, {9, 9}}, FontSize -> 
    18], 
   Cell[
    StyleData["SmallText", "Condensed"], CellMargins -> {{18, 10}, {5, 5}}, 
    LineSpacing -> {1, 2}, FontSize -> 9], 
   Cell[
    StyleData["SmallText", "Printout"], 
    CellMargins -> {{33, Inherited}, {Inherited, Inherited}}, Hyphenation -> 
    True], 
   Cell[
    StyleData["SmallText", "PrintoutGray"], 
    CellMargins -> {{33, Inherited}, {Inherited, Inherited}}, Hyphenation -> 
    True], 
   Cell[
    StyleData["Item"], CellDingbat -> 
    StyleBox["\[FilledSmallSquare]", Alignment -> Baseline, 
      RGBColor[0.8, 0.043, 0.008]], CellMargins -> {{81, 10}, {4, 8}}, 
    StyleKeyMapping -> {"Tab" -> "Subitem"}, 
    CellGroupingRules -> {"GroupTogetherNestedGrouping", 15000}, 
    CellFrameLabelMargins -> 4, CounterIncrements -> "Item", 
    CounterAssignments -> {{"Subitem", 0}, {"Subsubitem", 0}}, 
    MenuSortingValue -> 1600, FontFamily -> "Arial", FontSize -> 
    14, $CellContext`ReturnCreatesNewCell -> True], 
   Cell[
    StyleData["Item", "Presentation"], CellMargins -> {{140, 10}, {7, 7}}, 
    CellFrameLabelMargins -> 6, FontSize -> 24], 
   Cell[
    StyleData["Item", "SlideShow"], 
    CellMargins -> {{
      0.135 FrontEnd`AbsoluteCurrentValue[{WindowSize, 1}], 0.03 
       FrontEnd`AbsoluteCurrentValue[{WindowSize, 1}]}, {10, 10}}, 
    CellFrameLabelMargins -> 8, FontSize -> 22], 
   Cell[
    StyleData["Item", "Condensed"], CellMargins -> {{38, Inherited}, {2, 2}}, 
    FontSize -> 11], 
   Cell[
    StyleData["Item", "Printout"], CellDingbat -> 
    StyleBox["\[FilledSmallSquare]", Alignment -> Baseline, 
      GrayLevel[0.2]], 
    CellMargins -> {{65, Inherited}, {Inherited, Inherited}}], 
   Cell[
    StyleData["Item", "PrintoutGray"], CellDingbat -> 
    StyleBox["\[FilledSmallSquare]", Alignment -> Baseline, 
      GrayLevel[0.2]], 
    CellMargins -> {{65, Inherited}, {Inherited, Inherited}}], 
   Cell[
    StyleData["ItemParagraph"], CellMargins -> {{81, 10}, {4, 1}}, 
    StyleKeyMapping -> {"Tab" -> "SubitemParagraph"}, 
    CellGroupingRules -> {"GroupTogetherNestedGrouping", 15000}, 
    DefaultNewCellStyle -> "Item", MenuSortingValue -> 1600, FontFamily -> 
    "Arial", FontSize -> 14, FontColor -> 
    GrayLevel[0.2], $CellContext`ReturnCreatesNewCell -> True], 
   Cell[
    StyleData["ItemParagraph", "Presentation"], 
    CellMargins -> {{140, 10}, {7, 2}}, FontSize -> 24], 
   Cell[
    StyleData["ItemParagraph", "SlideShow"], ShowGroupOpener -> False, 
    CellMargins -> {{
      0.135 FrontEnd`AbsoluteCurrentValue[{WindowSize, 1}], 0.03 
       FrontEnd`AbsoluteCurrentValue[{WindowSize, 1}]}, {10, 2}}, FontSize -> 
    22], 
   Cell[
    StyleData["ItemParagraph", "Condensed"], 
    CellMargins -> {{38, Inherited}, {2, 1}}, FontSize -> 11], 
   Cell[
    StyleData["ItemParagraph", "Printout"], 
    CellMargins -> {{65, Inherited}, {Inherited, 0.5 Inherited}}], 
   Cell[
    StyleData["ItemParagraph", "PrintoutGray"], 
    CellMargins -> {{65, Inherited}, {Inherited, 0.5 Inherited}}], 
   Cell[
    StyleData["Subitem"], CellDingbat -> 
    StyleBox["\[FilledSmallSquare]", Alignment -> Baseline, 
      RGBColor[0.8, 0.043, 0.008]], CellMargins -> {{105, 12}, {4, 4}}, 
    StyleKeyMapping -> {
     "Tab" -> "Subsubitem", "Backspace" -> 
      "Item", $CellContext`KeyEvent[
       "Tab", $CellContext`Modifiers -> {$CellContext`Shift}] -> "Item"}, 
    CellGroupingRules -> {"GroupTogetherNestedGrouping", 15100}, 
    CellFrameLabelMargins -> 4, DefaultNewCellStyle -> "Item", 
    CounterIncrements -> "Subitem", CounterAssignments -> {{"Subsubitem", 0}},
     MenuSortingValue -> 1610, FontFamily -> "Arial", FontSize -> 
    13.5, $CellContext`ReturnCreatesNewCell -> True], 
   Cell[
    StyleData["Subitem", "Presentation"], CellMargins -> {{176, 12}, {7, 7}}, 
    CellFrameLabelMargins -> 6, FontSize -> 24], 
   Cell[
    StyleData["Subitem", "SlideShow"], 
    CellMargins -> {{
      0.155 FrontEnd`AbsoluteCurrentValue[{WindowSize, 1}], 0.03 
       FrontEnd`AbsoluteCurrentValue[{WindowSize, 1}]}, {10, 10}}, 
    CellFrameLabelMargins -> 8, FontSize -> 22], 
   Cell[
    StyleData["Subitem", "Condensed"], CellMargins -> {{60, 2}, {2, 2}}, 
    FontSize -> 11], 
   Cell[
    StyleData["Subitem", "Printout"], CellDingbat -> 
    StyleBox["\[FilledSmallSquare]", Alignment -> Baseline, 
      GrayLevel[0.3]], 
    CellMargins -> {{92, Inherited}, {Inherited, Inherited}}], 
   Cell[
    StyleData["Subitem", "PrintoutGray"], CellDingbat -> 
    StyleBox["\[FilledSmallSquare]", Alignment -> Baseline, 
      GrayLevel[0.3]], 
    CellMargins -> {{92, Inherited}, {Inherited, Inherited}}], 
   Cell[
    StyleData["SubitemParagraph"], CellMargins -> {{105, 12}, {4, 1}}, 
    StyleKeyMapping -> {
     "Tab" -> "SubsubitemParagraph", "Backspace" -> 
      "ItemParagraph", $CellContext`KeyEvent[
       "Tab", $CellContext`Modifiers -> {$CellContext`Shift}] -> 
      "ItemParagraph"}, 
    CellGroupingRules -> {"GroupTogetherNestedGrouping", 15100}, 
    CellFrameLabelMargins -> 4, DefaultNewCellStyle -> "Subitem", 
    MenuSortingValue -> 1610, FontFamily -> "Arial", FontSize -> 13.5, 
    FontColor -> GrayLevel[0.2], $CellContext`ReturnCreatesNewCell -> True], 
   Cell[
    StyleData["SubitemParagraph", "Presentation"], 
    CellMargins -> {{176, 12}, {7, 2}}, FontSize -> 24], 
   Cell[
    StyleData["SubitemParagraph", "SlideShow"], 
    CellMargins -> {{
      0.155 FrontEnd`AbsoluteCurrentValue[{WindowSize, 1}], 0.03 
       FrontEnd`AbsoluteCurrentValue[{WindowSize, 1}]}, {10, 2}}, FontSize -> 
    22], 
   Cell[
    StyleData["SubitemParagraph", "Condensed"], 
    CellMargins -> {{60, 2}, {2, 1}}, FontSize -> 11], 
   Cell[
    StyleData["SubitemParagraph", "Printout"], 
    CellMargins -> {{92, Inherited}, {Inherited, 0.1 Inherited}}], 
   Cell[
    StyleData["SubitemParagraph", "PrintoutGray"], 
    CellMargins -> {{92, Inherited}, {Inherited, 0.1 Inherited}}], 
   Cell[
    StyleData["Subsubitem"], CellDingbat -> 
    StyleBox["\[FilledSmallSquare]", Alignment -> Baseline, 
      RGBColor[0.6, 0.6, 0.6]], CellMargins -> {{129, 12}, {4, 4}}, 
    StyleKeyMapping -> {
     "Backspace" -> 
      "Subitem", $CellContext`KeyEvent[
       "Tab", $CellContext`Modifiers -> {$CellContext`Shift}] -> "Subitem"}, 
    CellGroupingRules -> {"GroupTogetherNestedGrouping", 15200}, 
    CellFrameLabelMargins -> 4, DefaultNewCellStyle -> "Subsubitem", 
    CounterIncrements -> "Subsubitem", MenuSortingValue -> 1620, FontFamily -> 
    "Arial", FontSize -> 13, $CellContext`ReturnCreatesNewCell -> True], 
   Cell[
    StyleData["Subsubitem", "Presentation"], 
    CellMargins -> {{212, 12}, {7, 7}}, CellFrameLabelMargins -> 6, FontSize -> 
    24], 
   Cell[
    StyleData["Subsubitem", "SlideShow"], 
    CellMargins -> {{
      0.176 FrontEnd`AbsoluteCurrentValue[{WindowSize, 1}], 0.03 
       FrontEnd`AbsoluteCurrentValue[{WindowSize, 1}]}, {10, 10}}, 
    CellFrameLabelMargins -> 8, FontSize -> 22], 
   Cell[
    StyleData["Subsubitem", "Condensed"], CellMargins -> {{84, 2}, {2, 2}}, 
    FontSize -> 11], 
   Cell[
    StyleData["Subsubitem", "Printout"], CellDingbat -> 
    StyleBox["\[FilledSmallSquare]", Alignment -> Baseline, 
      GrayLevel[0.4]], 
    CellMargins -> {{119, Inherited}, {Inherited, Inherited}}], 
   Cell[
    StyleData["Subsubitem", "PrintoutGray"], CellDingbat -> 
    StyleBox["\[FilledSmallSquare]", Alignment -> Baseline, 
      GrayLevel[0.4]], 
    CellMargins -> {{119, Inherited}, {Inherited, Inherited}}], 
   Cell[
    StyleData["SubsubitemParagraph"], CellMargins -> {{129, 12}, {4, 1}}, 
    StyleKeyMapping -> {
     "Backspace" -> 
      "SubitemParagraph", $CellContext`KeyEvent[
       "Tab", $CellContext`Modifiers -> {$CellContext`Shift}] -> 
      "SubitemParagraph"}, 
    CellGroupingRules -> {"GroupTogetherNestedGrouping", 15200}, 
    CellFrameLabelMargins -> 4, DefaultNewCellStyle -> "Subsubitem", 
    CounterIncrements -> "Subsubitem", MenuSortingValue -> 1625, FontFamily -> 
    "Arial", FontSize -> 13, FontColor -> 
    GrayLevel[0.2], $CellContext`ReturnCreatesNewCell -> True], 
   Cell[
    StyleData["SubsubitemParagraph", "Presentation"], 
    CellMargins -> {{212, 12}, {7, 2}}, FontSize -> 24], 
   Cell[
    StyleData["SubsubitemParagraph", "SlideShow"], 
    CellMargins -> {{
      0.176 FrontEnd`AbsoluteCurrentValue[{WindowSize, 1}], 0.03 
       FrontEnd`AbsoluteCurrentValue[{WindowSize, 1}]}, {10, 2}}, FontSize -> 
    22], 
   Cell[
    StyleData["SubsubitemParagraph", "Condensed"], 
    CellMargins -> {{84, 2}, {2, 1}}, FontSize -> 11], 
   Cell[
    StyleData["SubsubitemParagraph", "Printout"], 
    CellMargins -> {{119, Inherited}, {Inherited, 0.1 Inherited}}], 
   Cell[
    StyleData["SubsubitemParagraph", "PrintoutGray"], 
    CellMargins -> {{119, Inherited}, {Inherited, 0.1 Inherited}}], 
   Cell[
    StyleData["ItemNumbered"], CellDingbat -> Cell[
      TextData[{
        CounterBox["ItemNumbered"], "."}], FontWeight -> "Bold"], 
    CellMargins -> {{81, 10}, {4, 8}}, 
    StyleKeyMapping -> {"Tab" -> "SubitemNumbered"}, 
    CellGroupingRules -> {"GroupTogetherNestedGrouping", 15000}, 
    CellFrameLabelMargins -> 4, CounterIncrements -> "ItemNumbered", 
    CounterAssignments -> {{"SubitemNumbered", 0}, {"SubsubitemNumbered", 0}},
     MenuSortingValue -> 1630, FontFamily -> "Arial", FontSize -> 
    15, $CellContext`ReturnCreatesNewCell -> True], 
   Cell[
    StyleData["ItemNumbered", "Presentation"], 
    CellMargins -> {{140, 10}, {7, 7}}, CellFrameLabelMargins -> 6, FontSize -> 
    24], 
   Cell[
    StyleData["ItemNumbered", "SlideShow"], 
    CellMargins -> {{
      0.135 FrontEnd`AbsoluteCurrentValue[{WindowSize, 1}], 0.03 
       FrontEnd`AbsoluteCurrentValue[{WindowSize, 1}]}, {10, 10}}, 
    CellFrameLabelMargins -> 6, FontSize -> 22], 
   Cell[
    StyleData["ItemNumbered", "Condensed"], 
    CellMargins -> {{38, Inherited}, {2, 2}}, FontSize -> 11], 
   Cell[
    StyleData["ItemNumbered", "Printout"], 
    CellMargins -> {{65, Inherited}, {Inherited, Inherited}}], 
   Cell[
    StyleData["ItemNumbered", "PrintoutGray"], 
    CellMargins -> {{65, Inherited}, {Inherited, Inherited}}], 
   Cell[
    StyleData["SubitemNumbered"], CellDingbat -> Cell[
      TextData[{
        CounterBox["ItemNumbered"], ".", 
        CounterBox["SubitemNumbered"], "."}], FontWeight -> "Bold"], 
    CellMargins -> {{105, 12}, {4, 4}}, 
    StyleKeyMapping -> {
     "Tab" -> "SubsubitemNumbered", "Backspace" -> 
      "ItemNumbered", $CellContext`KeyEvent[
       "Tab", $CellContext`Modifiers -> {$CellContext`Shift}] -> 
      "ItemNumbered"}, 
    CellGroupingRules -> {"GroupTogetherNestedGrouping", 15100}, 
    CellFrameLabelMargins -> 4, DefaultNewCellStyle -> "Item", 
    CounterIncrements -> "SubitemNumbered", 
    CounterAssignments -> {{"SubsubitemNumbered", 0}}, MenuSortingValue -> 
    1640, FontFamily -> "Arial", FontSize -> 
    13.5, $CellContext`ReturnCreatesNewCell -> True], 
   Cell[
    StyleData["SubitemNumbered", "Presentation"], 
    CellMargins -> {{176, 12}, {7, 7}}, CellFrameLabelMargins -> 6, FontSize -> 
    24], 
   Cell[
    StyleData["SubitemNumbered", "SlideShow"], 
    CellMargins -> {{
      0.155 FrontEnd`AbsoluteCurrentValue[{WindowSize, 1}], 0.03 
       FrontEnd`AbsoluteCurrentValue[{WindowSize, 1}]}, {10, 10}}, 
    CellFrameLabelMargins -> 6, FontSize -> 22], 
   Cell[
    StyleData["SubitemNumbered", "Condensed"], 
    CellMargins -> {{60, 2}, {2, 2}}, FontSize -> 11], 
   Cell[
    StyleData["SubitemNumbered", "Printout"], 
    CellMargins -> {{92, Inherited}, {Inherited, Inherited}}], 
   Cell[
    StyleData["SubitemNumbered", "PrintoutGray"], 
    CellMargins -> {{92, Inherited}, {Inherited, Inherited}}], 
   Cell[
    StyleData["SubsubitemNumbered"], CellDingbat -> Cell[
      TextData[{
        CounterBox["ItemNumbered"], ".", 
        CounterBox["SubitemNumbered"], ".", 
        CounterBox["SubsubitemNumbered"], "."}], FontWeight -> "Bold"], 
    CellMargins -> {{129, 12}, {4, 4}}, 
    StyleKeyMapping -> {
     "Backspace" -> 
      "SubitemNumbered", $CellContext`KeyEvent[
       "Tab", $CellContext`Modifiers -> {$CellContext`Shift}] -> 
      "SubitemNumbered"}, 
    CellGroupingRules -> {"GroupTogetherNestedGrouping", 15200}, 
    CellFrameLabelMargins -> 4, DefaultNewCellStyle -> "SubitemNumbered", 
    CounterIncrements -> "SubsubitemNumbered", MenuSortingValue -> 1645, 
    FontFamily -> "Arial", FontSize -> 13, $CellContext`ReturnCreatesNewCell -> 
    True], 
   Cell[
    StyleData["SubsubitemNumbered", "Presentation"], 
    CellMargins -> {{212, 12}, {7, 7}}, CellFrameLabelMargins -> 6, FontSize -> 
    24], 
   Cell[
    StyleData["SubsubitemNumbered", "SlideShow"], 
    CellMargins -> {{
      0.176 FrontEnd`AbsoluteCurrentValue[{WindowSize, 1}], 0.03 
       FrontEnd`AbsoluteCurrentValue[{WindowSize, 1}]}, {10, 10}}, 
    CellFrameLabelMargins -> 6, FontSize -> 22], 
   Cell[
    StyleData["SubsubitemNumbered", "Condensed"], 
    CellMargins -> {{84, 2}, {2, 2}}, FontSize -> 11], 
   Cell[
    StyleData["SubsubitemNumbered", "Printout"], 
    CellMargins -> {{119, Inherited}, {Inherited, Inherited}}], 
   Cell[
    StyleData["SubsubitemNumbered", "PrintoutGray"], 
    CellMargins -> {{119, Inherited}, {Inherited, Inherited}}], 
   Cell[
    StyleData["SideCaptionArray", StyleDefinitions -> StyleData["Text"]], 
    GridBoxOptions -> {
     GridBoxAlignment -> {"Columns" -> {Left}, "Rows" -> {Center}}, 
      GridBoxItemSize -> {
       "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}}], 
   Cell[
    StyleData["SideCaptionArray", "Printout"], 
    CellMargins -> {{49, Inherited}, {Inherited, Inherited}}], 
   Cell[
    StyleData["SideCaptionArray", "PrintoutGray"], 
    CellMargins -> {{49, Inherited}, {Inherited, Inherited}}], 
   Cell[
    StyleData["Input"], FontSize -> 13], 
   Cell[
    StyleData["Input", "Presentation"], CellMargins -> {{100, 10}, {8, 15}}], 
   Cell[
    StyleData["Input", "SlideShow"], 
    CellMargins -> {{
      0.135 FrontEnd`AbsoluteCurrentValue[{WindowSize, 1}], 0.01 
       FrontEnd`AbsoluteCurrentValue[{WindowSize, 1}]}, {8, 15}}, 
    LinebreakAdjustments -> {1, 2., 12., 1., 1.}, FontSize -> 20], 
   Cell[
    StyleData["Input", "Condensed"], CellMargins -> {{50, 10}, {2, 3}}], 
   Cell[
    StyleData["Input", "Printout"], 
    CellMargins -> {{49, Inherited}, {Inherited, 8}}, 
    LinebreakAdjustments -> {0.85, 2, 10, 1, 1}], 
   Cell[
    StyleData["Input", "PrintoutGray"], 
    CellMargins -> {{49, Inherited}, {Inherited, 8}}, 
    LinebreakAdjustments -> {0.85, 2, 10, 1, 1}], 
   Cell[
    StyleData["InputOnly"], FontSize -> 13], 
   Cell[
    StyleData["InputOnly", "Presentation"], 
    CellMargins -> {{100, 10}, {8, 15}}], 
   Cell[
    StyleData["InputOnly", "SlideShow"], CellMargins -> {{100, 10}, {8, 15}}], 
   Cell[
    StyleData["InputOnly", "Condensed"], CellMargins -> {{50, 10}, {2, 3}}], 
   Cell[
    StyleData["InputOnly", "Printout"], 
    CellMargins -> {{49, Inherited}, {Inherited, Inherited}}, 
    LinebreakAdjustments -> {0.85, 2, 10, 1, 1}], 
   Cell[
    StyleData["InputOnly", "PrintoutGray"], 
    CellMargins -> {{49, Inherited}, {Inherited, Inherited}}, 
    LinebreakAdjustments -> {0.85, 2, 10, 1, 1}], 
   Cell[
    StyleData["Code", "Presentation"], CellMargins -> {{100, 10}, {8, 15}}], 
   Cell[
    StyleData["Code", "SlideShow"], 
    CellMargins -> {{
      0.135 FrontEnd`AbsoluteCurrentValue[{WindowSize, 1}], 0.01 
       FrontEnd`AbsoluteCurrentValue[{WindowSize, 1}]}, {8, 15}}, 
    LinebreakAdjustments -> {1, 2., 12., 1., 1.}, FontSize -> 20], 
   Cell[
    StyleData["Code", "Condensed"], CellMargins -> {{50, 10}, {2, 3}}], 
   Cell[
    StyleData["Code", "Printout"], 
    CellMargins -> {{49, Inherited}, {Inherited, Inherited}}], 
   Cell[
    StyleData["Code", "PrintoutGray"], 
    CellMargins -> {{49, Inherited}, {Inherited, Inherited}}], 
   Cell[
    StyleData["Output"], FontSize -> 13], 
   Cell[
    StyleData["Output", "Presentation"], CellMargins -> {{100, 10}, {15, 8}}], 
   Cell[
    StyleData["Output", "SlideShow"], 
    CellMargins -> {{
      0.135 FrontEnd`AbsoluteCurrentValue[{WindowSize, 1}], 0.01 
       FrontEnd`AbsoluteCurrentValue[{WindowSize, 1}]}, {15, 8}}, 
    LinebreakAdjustments -> {1, 2., 12., 1., 1.}, FontSize -> 20], 
   Cell[
    StyleData["Output", "Condensed"], 
    CellMargins -> {{50, Inherited}, {3, 2}}], 
   Cell[
    StyleData["Output", "Printout"], 
    CellMargins -> {{49, Inherited}, {9, 3}}], 
   Cell[
    StyleData["Output", "PrintoutGray"], 
    CellMargins -> {{49, Inherited}, {9, 3}}], 
   Cell[
    StyleData["Message", "Presentation"], 
    CellMargins -> {{100, Inherited}, {1.5 Inherited, 1.5 Inherited}}], 
   Cell[
    StyleData["Message", "SlideShow"], 
    CellMargins -> {{
      0.135 FrontEnd`AbsoluteCurrentValue[{WindowSize, 1}], 0.01 
       FrontEnd`AbsoluteCurrentValue[{WindowSize, 1}]}, {8, 15}}, FontSize -> 
    18], 
   Cell[
    StyleData["Message", "Condensed"], 
    CellMargins -> {{18, Inherited}, {Inherited, Inherited}}], 
   Cell[
    StyleData["Message", "Printout"], 
    CellMargins -> {{49, Inherited}, {Inherited, Inherited}}, 
    CellFrameLabels -> {{None, None}, {None, None}}], 
   Cell[
    StyleData["Message", "PrintoutGray"], 
    CellMargins -> {{49, Inherited}, {Inherited, Inherited}}, 
    CellFrameLabels -> {{None, None}, {None, None}}, FontColor -> 
    GrayLevel[0.5]], 
   Cell[
    StyleData["Print"], 
    CellMargins -> {{66, Inherited}, {Inherited, Inherited}}], 
   Cell[
    StyleData["Print", "Presentation"], 
    CellMargins -> {{100, Inherited}, {1.5 Inherited, 1.5 Inherited}}], 
   Cell[
    StyleData["Print", "SlideShow"], 
    CellMargins -> {{
      0.135 FrontEnd`AbsoluteCurrentValue[{WindowSize, 1}], 0.01 
       FrontEnd`AbsoluteCurrentValue[{WindowSize, 1}]}, {8, 15}}, FontSize -> 
    18], 
   Cell[
    StyleData["Print", "Condensed"], 
    CellMargins -> {{18, Inherited}, {Inherited, Inherited}}], 
   Cell[
    StyleData["Print", "Printout"], 
    CellMargins -> {{49, Inherited}, {Inherited, Inherited}}], 
   Cell[
    StyleData["Print", "PrintoutGray"], 
    CellMargins -> {{49, Inherited}, {Inherited, Inherited}}], 
   Cell[
    StyleData["InlineFormula"], 
    HyphenationOptions -> {"HyphenationCharacter" -> "\[Continuation]"}, 
    LanguageCategory -> "Formula", ScriptLevel -> 1, SingleLetterItalics -> 
    True, MenuSortingValue -> 1650, $CellContext`StripStyleOnPaste -> True], 
   Cell[
    StyleData["InlineFormula", "Presentation"], 
    CellMargins -> {{10, 4}, {0, 12}}, LineSpacing -> {1, 5}, FontSize -> 24], 
   Cell[
    StyleData["InlineFormula", "SlideShow"], FontSize -> 22], 
   Cell[
    StyleData["InlineFormula", "Condensed"], 
    CellMargins -> {{50, 10}, {6, 6}}, LineSpacing -> {1, 1}, FontSize -> 11], 
   Cell[
    StyleData["DisplayFormula"], 
    CellMargins -> {{66, Inherited}, {Inherited, Inherited}}, 
    DefaultFormatType -> DefaultInputFormatType, 
    HyphenationOptions -> {"HyphenationCharacter" -> "\[Continuation]"}, 
    LanguageCategory -> "Formula", ScriptLevel -> 0, SingleLetterItalics -> 
    True, MenuSortingValue -> 1700, FontFamily -> "Arial", FontSize -> 14, 
    FontColor -> GrayLevel[0.2], 
    UnderoverscriptBoxOptions -> {
     LimitsPositioning -> True}, $CellContext`StripStyleOnPaste -> True], 
   Cell[
    StyleData["DisplayFormula", "Presentation"], 
    CellMargins -> {{100, Inherited}, {1.5 Inherited, 1.5 Inherited}}, 
    LineSpacing -> {1, 5}, FontSize -> 24], 
   Cell[
    StyleData["DisplayFormula", "SlideShow"], 
    CellMargins -> {{
      0.135 FrontEnd`AbsoluteCurrentValue[{WindowSize, 1}], 0.03 
       FrontEnd`AbsoluteCurrentValue[{WindowSize, 1}]}, {
      1.3 Inherited, 1.3 Inherited}}, FontSize -> 22], 
   Cell[
    StyleData["DisplayFormula", "Condensed"], 
    CellMargins -> {{50, Inherited}, {Inherited, Inherited}}, 
    LineSpacing -> {1, 1}, FontSize -> 11], 
   Cell[
    StyleData["DisplayFormula", "Printout"], 
    CellMargins -> {{49, Inherited}, {Inherited, Inherited}}], 
   Cell[
    StyleData["DisplayFormula", "PrintoutGray"], 
    CellMargins -> {{49, Inherited}, {Inherited, Inherited}}], 
   Cell[
    StyleData[
    "DisplayFormulaNumbered", StyleDefinitions -> 
     StyleData["DisplayFormula"]], CellFrameLabels -> {{None, 
       Cell[
        TextData[{"(", 
          CounterBox["DisplayFormulaNumbered"], ")"}], 
        "DisplayFormulaEquationNumber"]}, {None, None}}, CounterIncrements -> 
    "DisplayFormulaNumbered", MenuSortingValue -> 1710], 
   Cell[
    StyleData["DisplayFormulaNumbered", "Presentation"], 
    CellMargins -> {{100, Inherited}, {1.5 Inherited, 1.5 Inherited}}, 
    LineSpacing -> {1, 5}, FontSize -> 24], 
   Cell[
    StyleData["DisplayFormulaNumbered", "SlideShow"], 
    CellMargins -> {{
      0.135 FrontEnd`AbsoluteCurrentValue[{WindowSize, 1}], 0.03 
       FrontEnd`AbsoluteCurrentValue[{WindowSize, 1}]}, {
      1.5 Inherited, 1.5 Inherited}}, FontSize -> 22], 
   Cell[
    StyleData["DisplayFormulaNumbered", "Condensed"], 
    CellMargins -> {{50, Inherited}, {Inherited, Inherited}}, 
    LineSpacing -> {1, 1}, FontSize -> 11], 
   Cell[
    StyleData["DisplayFormulaNumbered", "Printout"], 
    CellMargins -> {{49, Inherited}, {Inherited, Inherited}}], 
   Cell[
    StyleData["DisplayFormulaNumbered", "PrintoutGray"], 
    CellMargins -> {{49, Inherited}, {Inherited, Inherited}}], 
   Cell[
    StyleData["DisplayFormulaEquationNumber"], FontFamily -> "Arial", 
    FontSize -> -1 + Inherited], 
   Cell[
    StyleData["Program"], CellFrame -> {{0, 0}, {0.5, 0.5}}, 
    CellMargins -> {{66, 10}, {8, 8}}, Hyphenation -> False, 
    AutoQuoteCharacters -> {}, PasteAutoQuoteCharacters -> {}, 
    LanguageCategory -> "Formula", ScriptLevel -> 1, MenuSortingValue -> 1800,
     FontFamily -> "Courier", $CellContext`StripStyleOnPaste -> True], 
   Cell[
    StyleData["Program", "Presentation"], CellFrame -> {{0, 0}, {1, 1}}, 
    CellMargins -> {{100, 4}, {0, 12}}, LineSpacing -> {1, 5}, FontSize -> 
    24], 
   Cell[
    StyleData["Program", "SlideShow"], CellFrame -> {{0, 0}, {1, 1}}, 
    CellMargins -> {{
      0.135 FrontEnd`AbsoluteCurrentValue[{WindowSize, 1}], 0.03 
       FrontEnd`AbsoluteCurrentValue[{WindowSize, 1}]}, {12, 12}}, FontSize -> 
    22], 
   Cell[
    StyleData["Program", "Condensed"], CellMargins -> {{18, 10}, {6, 6}}, 
    LineSpacing -> {1, 1}, FontSize -> 11], 
   Cell[
    StyleData["Program", "Printout"], 
    CellMargins -> {{49, Inherited}, {Inherited, Inherited}}], 
   Cell[
    StyleData["Program", "PrintoutGray"], 
    CellMargins -> {{49, Inherited}, {Inherited, Inherited}}], 
   Cell[
    StyleData["Reference"], CellMargins -> {{66, 10}, {3, 3}}], 
   Cell[
    StyleData["Reference", "Presentation"], 
    CellMargins -> {{100, 10}, {5, 5}}], 
   Cell[
    StyleData["Reference", "SlideShow"], 
    CellMargins -> {{
      0.135 FrontEnd`AbsoluteCurrentValue[{WindowSize, 1}], 0.03 
       FrontEnd`AbsoluteCurrentValue[{WindowSize, 1}]}, {10, 10}}, FontSize -> 
    22], 
   Cell[
    StyleData["Reference", "Condensed"], CellMargins -> {{18, 10}, {3, 3}}], 
   Cell[
    StyleData["Reference", "Printout"], 
    CellMargins -> {{49, Inherited}, {Inherited, Inherited}}, 
    LineSpacing -> {1., 2.}], 
   Cell[
    StyleData["Reference", "PrintoutGray"], 
    CellMargins -> {{49, Inherited}, {Inherited, Inherited}}, 
    LineSpacing -> {1., 2.}], 
   Cell[
    StyleData["Header"], CellMargins -> {{0, 0}, {0, 0}}, 
    LineSpacing -> {1, 8}, MenuSortingValue -> None, FontFamily -> "Verdana", 
    FontSize -> 7, FontSlant -> "Italic"], 
   Cell[
    StyleData["Header", "Printout"], Magnification -> 1.], 
   Cell[
    StyleData["Header", "PrintoutGray"], Magnification -> 1.], 
   Cell[
    StyleData["HeaderSection"], StyleMenuListing -> None], 
   Cell[
    StyleData["HeaderSection", "Printout"], Magnification -> 1.], 
   Cell[
    StyleData["HeaderSection", "PrintoutGray"], Magnification -> 1.], 
   Cell[
    StyleData["HeaderSubsection"], StyleMenuListing -> None], 
   Cell[
    StyleData["HeaderSubsection", "Printout"], Magnification -> 1.], 
   Cell[
    StyleData["HeaderSubsection", "PrintoutGray"], Magnification -> 1.], 
   Cell[
    StyleData["HeaderTitle"], StyleMenuListing -> None], 
   Cell[
    StyleData["HeaderTitle", "Printout"], Magnification -> 1.], 
   Cell[
    StyleData["HeaderTitle", "PrintoutGray"], Magnification -> 1.], 
   Cell[
    StyleData["Footer"], CellMargins -> {{0, 0}, {0, 0}}, MenuSortingValue -> 
    None, FontFamily -> "Verdana", FontSize -> 6], 
   Cell[
    StyleData["Footer", "Printout"], Magnification -> 1.], 
   Cell[
    StyleData["Footer", "PrintoutGray"], Magnification -> 1.], 
   Cell[
    StyleData["FooterSection"], StyleMenuListing -> None], 
   Cell[
    StyleData["FooterSection", "Printout"], Magnification -> 1.], 
   Cell[
    StyleData["FooterSection", "PrintoutGray"], Magnification -> 1.], 
   Cell[
    StyleData["FooterSubsection"], StyleMenuListing -> None], 
   Cell[
    StyleData["FooterSubsection", "Printout"], Magnification -> 1.], 
   Cell[
    StyleData["FooterSubsection", "PrintoutGray"], Magnification -> 1.], 
   Cell[
    StyleData["FooterTitle"], StyleMenuListing -> None], 
   Cell[
    StyleData["FooterTitle", "Printout"], Magnification -> 1.], 
   Cell[
    StyleData["FooterTitle", "PrintoutGray"], Magnification -> 1.], 
   Cell[
    StyleData["PageNumber"], LineSpacing -> {1, 8}, MenuSortingValue -> None, 
    FontFamily -> "Verdana", FontSize -> 7, FontWeight -> "Bold"], 
   Cell[
    StyleData["PageNumber", "Printout"], Magnification -> 1.], 
   Cell[
    StyleData["PageNumber", "PrintoutGray"], Magnification -> 1.]}, Visible -> 
  False, FrontEndVersion -> 
  "11.1 for Microsoft Windows (64-bit) (April 18, 2017)", StyleDefinitions -> 
  "PrivateStylesheetFormatting.nb"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[558, 20, 289, 5, 66, "MyStyle - H1 Framed", "ExpressionUUID" -> \
"6380ec97-f160-4009-b377-069d23d369f7"],
Cell[850, 27, 295, 6, 38, "Input", "ExpressionUUID" -> \
"3a2b3c0e-dfed-451b-803a-a73492d8d8ad"],
Cell[1148, 35, 775, 15, 136, "MyStyle - H1 Framed", "ExpressionUUID" -> \
"0432d697-bf63-4b20-af3e-8bde967c5b37"],
Cell[1926, 52, 184, 3, 60, "MyStyle - H3", "ExpressionUUID" -> \
"21bdad40-4012-464c-95a5-7713dd59d54c"],
Cell[CellGroupData[{
Cell[2135, 59, 352, 8, 63, "Input", "ExpressionUUID" -> \
"a6e2b453-14ba-4cf7-8228-1d7e806d67a0"],
Cell[2490, 69, 2246, 53, 63, "Output", "ExpressionUUID" -> \
"db6dc349-9da1-483d-9239-c0c8f4514e25"],
Cell[4739, 124, 2689, 47, 175, "Output", "ExpressionUUID" -> \
"8c0f50c8-03ee-4cc2-98bf-aa1a18bea1ec"]
}, Open  ]],
Cell[7443, 174, 1254, 22, 206, "MyStyle - H1 Framed", "ExpressionUUID" -> \
"9e2d98ee-73f3-47a4-807b-af0965eef0ad"],
Cell[8700, 198, 344, 7, 60, "MyStyle - H3", "ExpressionUUID" -> \
"faa02d1a-a1e8-4a19-9f38-19ce878a8070"],
Cell[CellGroupData[{
Cell[9069, 209, 390, 9, 63, "Input", "ExpressionUUID" -> \
"dbfb5af4-3451-4f15-8af6-05df89e1432c"],
Cell[9462, 220, 34288, 1153, 717, "Output", "ExpressionUUID" -> \
"5b9c7301-23e6-4d46-b219-2ee409017841"],
Cell[43753, 1375, 29637, 579, 194, "Output", "ExpressionUUID" -> \
"040faea9-f012-495c-a342-b688bed0347d"]
}, Open  ]]
}
]
*)

